/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:_init.c 12.0$ */
/* $ACIS:_init.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_init.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_init.c 12.0$";
#endif

#include "whim.h";
#include <machinecons/screen_conf.h>
#ifdef DEBG
#define PRINTF if(1) printf
#else
#define PRINTF if(0) printf
#endif

#define LOADSTR(STR,LEN)					\
	    strncpy(STR,buf+ix,80);				\
	    ix += min((LEN=1+strlen(STR)),80);			\
	    if (ix >= got) break

char ucode_loc[40] = "/usr/lib/aed/whim.aed";
#define PTY "/dev/ptypf"
#define TTY "/dev/ttypf"
static init_redirect = 0;

VI_Init(wd,ht)
INT16 *wd,*ht;
{
#include "whimdcl.h"

    INT_PURE code;		   /* microcode load file descriptor */
    INT16 poll; 	   /* semaphore word */
    INT_PURE status;
    INT16 len;		   /* length of data read */
    INT16 loc;		   /* location in control store */
	INT16 i;
    char *microcode;	/*string for microcod filename */
#ifdef BUS
    int iaed = E_AED;	/* use to switch input emulator */
    int busres;		/* results from opening /dev/bus */
#endif BUS

    if ((init_yet == FALSE) && (saving == FALSE))
       {
#ifdef notdef /* disable copyright for 4.2 use */
     fprintf(stderr,"\nIBM ACIS Experimental Display Subroutine Interface\n");
     fprintf(stderr,"Version 1.00 (C)Copyright IBM Corp 1984,1985\n\n");
#endif notdef 
	     /* Load Viking control store */

		microcode = ucode_loc;/*set default to /usr/lib/aed/whim.aed */
		if (access("whim.aed")==0) strcpy(microcode,"whim.aed");

		code = open(microcode,0);
		if (code < 0) {fprintf(stderr,"Error opening %s\n\n",microcode);
				exit(); }
		v_cntl = open("/dev/aed",2);
		if (v_cntl < 0) { fprintf(stderr,"Error opening /dev/aed\n\n");
				exit(); }
#ifdef BUS
		if (ioctl(v_cntl,EOSETD,&iaed) < 0) {
				fprintf(stderr,"Error set output emulator\n");
				exit(); }
		busres = open("/dev/bus",2);
#endif BUS
		ioctl(v_cntl,AEDRESET);
PRINTF("VI_Init: device and ucode opened\n");

		do { len = read(code,vikint,4096);  /* read from code file */
		     write(v_cntl,vikint,4096);
PRINTF("VI_Init: %d write to ucode\n",len);
		   } while (len == 4096);
PRINTF("VI_Init: Ucode xferred\n");
	     close(code);
		ioctl(v_cntl,AEDRESET);
PRINTF("VI_Init: Viking loaded\n");
#ifdef DEBG
printf("please hit enter"); while (getchar() != '\n');
printf("Thank you\n");
#endif

	     /* send a null command to the Viking to start and wait for ready */
printf("VI_Init: microcode version check override\n");
		init_yet = TRUE;
PRINTF("Init: calling command(0)\n");
  		command(0);
PRINTF("Init: returning command(0)\n");
#ifdef DEBG
printf("please hit enter"); while (getchar() != '\n');
printf("Thank you\n");
#endif
	     /* initialize parameters */
	     parms.merge = 12;	      /* replace mode */
	     parms.fontid = 0;	      /* no font */
	     parms.width = 1;	      /* single pel vectors */
	     parms.dashpat = 0;       /* solid lines */
	     parms.dashlen = 0;       /* solid lines */
	     parms.xposn = 0;	      /* origin */
	     parms.yposn = 0;	      /* origin */
	     parms.color = 0;	      /* black on white */

	     parms.cliplx = 0;	      /* clipping window */
	     parms.cliply = 0;	      /* clipping window */
	     parms.cliphx = 1023;     /* whole screen */
	     parms.cliphy = 799;      /* whole screen */

	     parms.userclx = 0;       /* clipping window */
	     parms.usercly = 0;       /* clipping window */
	     parms.userchx = 1023;    /* whole screen */
	     parms.userchy = 799;     /* whole screen */

	     /* initially, no fonts */
	     fonts = NULL;
	     nextfontid = 1;

	     /* initially, no order command being built */
	     vikoff = 0;
	     savefn = NULL;
	     savefile = NULL;
	     nofault = TRUE;
       }
    /* return size of display */
    *wd = 1024;
    *ht = 800;

}  /* end vi_init */


VI_Term()
  {
#include "whimdcl.h"
    VI_Force(); /* force out any incomplete buffers */

    VI_Logout();
    close(v_cntl);
	
  } /* end v_term */
		  

