/* $Header:_read.c 12.0$ */
/* $ACIS:_read.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_read.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_read.c 12.0$";
#endif

#include "whim.h"
/*--------------------------------------------------------------*/
/*  Read rectangle into memory					*/
/*--------------------------------------------------------------*/

VI_MRead(x,y,wd,ht,data)
  INT16 x,y;			      /* source top-left */
  INT16 wd,ht;			      /* rectangle bounds */
  unsigned INT16 *data; 	      /* receiving area */

  begin
#include "whimdcl.h"
    INT16 nwords;		    /* number of words in scanline */
    INT16 inht; 		    /* height of slice */
    INT16 maxht;			    /* max height of slice */
    INT16 inlen;			    /* number of words in slice */

    /* read cannot handle rectangles that go out of bounds */
    if (x < 0 || y < 0 || (x+wd-1) > 1023 || (y+ht-1) > 799)
      return;

    /* clear out area for data transfer */
    VI_Force();

    /* figure height of a slice */
    nwords = (wd+15)/16;
    maxht = 2000/nwords;

    /* read back data in slices until done */
    while (ht > 0) begin
      /* figure height of slice */
      inht = min(ht,maxht);
      inlen = inht*nwords;

      /* read back the slice */
      vikint[1] = 4;	     /* read command */
      vikint[2] = x;	     /* source x */
      vikint[3] = y;	     /* source y */
      vikint[4] = wd;	     /* slice width */
      vikint[5] = inht;      /* slice height */
      vikint[6] = parms.color;	/* window color */

      /* send command to Viking */
      command(6);

      /* copy read-back data into user buffer */
      vread(data,inlen,0X4002);
      data+= inlen;

      /* advance to next slice */
      y = y+inht;
      ht = ht-inht;
    end;
  end

/*--------------------------------------------------------------*/
/*  Read rectangle into a file					*/
/*--------------------------------------------------------------*/

VI_FRead(x,y,wd,ht,name)
  INT16 x,y;			  /* source top-left */
  INT16 wd,ht;			  /* rectangle bounds */
  char *name;			  /* file name */

  begin
#include "whimdcl.h"
    INT16 rwd,rht;		  /* reversed dimensions for write */
    INT16 nwords;		  /* number of words in scanline */
    INT16 inht; 		  /* height of slice */
    INT16 maxht;			  /* max height of slice */
    INT16 inlen;			  /* number of words in slice */
    INT_PURE image;			  /* image file descriptor */

    /* read cannot handle rectangles that go out of bounds */
    if (x < 0 || y < 0 || (x+wd-1) > 1023 || (y+ht-1) > 799)
      return;

    if (saving) { JOURNL(V_FREAD);
		  JOURNL(x);
		  JOURNL(y);
		  JOURNL(wd);
		  JOURNL(ht);
		  strjour(name); }

    /* open the output file */
    image = creat(name,BWRITE);
    if (image == -1) { fprintf(stderr,"Error opening file %s.\n",name);
		       return;
		     }

    /* write dimensions to file */
    rwd = wd;
    write(image,&rwd,2);
    rht = ht;
    write(image,&rht,2);

    /* clear out area for data transfer */
    VI_Force();

    /* figure height of a slice */
    nwords = (wd+15)/16;
    maxht = 2000/nwords;

    /* read back data in slices until done */
    while (ht > 0) begin
      /* figure height of slice */
      inht = min(ht,maxht);
      inlen = inht*nwords;

      /* read back the slice */
      vikint[1] = 4;	     /* read command */
      vikint[2] = x;	     /* source x */
      vikint[3] = y;	     /* source y */
      vikint[4] = wd;	     /* slice width */
      vikint[5] = inht;      /* slice height */
      vikint[6] = parms.color;	/* window color */

      /* send command to Viking */
      command(6);

      /* read data back into buffer */
      vread(vikint,inlen,0X4002);

      /* write to the file */
      write(image,vikint,inlen*2);

      /* advance to next slice */
      y = y+inht;
      ht = ht-inht;
    end;

    /* close the output file */
    close(image);
  end
