/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:stats.c 12.0$ */
/* $ACIS:stats.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/sendmail/src/RCS/stats.c,v $ */

#ifndef lint
static char *rcsid = "$Header:stats.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/*
**  Sendmail
**  Copyright (c) 1983  Eric P. Allman
**  Berkeley, California
**
**  Copyright (c) 1983 Regents of the University of California.
**  All rights reserved.  The Berkeley software License Agreement
**  specifies the terms and conditions for redistribution.
*/

#ifndef lint
static char	SccsId[] = "@(#)stats.c	5.8 (Berkeley) 5/2/86";
#endif not lint

#ifdef YP
/* @(#)stats.c	1.1 87/09/21 3.2/4.3NFSSRC */
#endif YP

# include "sendmail.h"
# include "mailstats.h"

struct statistics	Stat;

#ifdef YP
/*
**  KBYTES -- given a number, returns the number of Kbytes.
**
**	Used in statistics gathering of message sizes to try to avoid
**	wraparound (at least for a while.....)
**
**  	Notes:
**		This function is actually a ceiling function to
**			the nearest K.
*/
#define KBYTES(bytes) (((bytes) + 1023) >> 10);

#else YP
#define ONE_K		1000		/* one thousand (twenty-four?) */
#define KBYTES(x)	(((x) + (ONE_K - 1)) / ONE_K)
#endif YP
/*
**  MARKSTATS -- mark statistics
*/

markstats(e, to)
	register ENVELOPE *e;
	register ADDRESS *to;
{
	if (to == NULL)
	{
		if (e->e_from.q_mailer != NULL)
		{
			Stat.stat_nf[e->e_from.q_mailer->m_mno]++;
			Stat.stat_bf[e->e_from.q_mailer->m_mno] +=
				KBYTES(CurEnv->e_msgsize);
		}
	}
	else
	{
		Stat.stat_nt[to->q_mailer->m_mno]++;
		Stat.stat_bt[to->q_mailer->m_mno] += KBYTES(CurEnv->e_msgsize);
	}
}
/*
**  POSTSTATS -- post statistics in the statistics file
**
**	Parameters:
#ifdef YP
**		sfile -- the name of the statistics file,
**			 or a pointer to an empty string if no statistics
**			 collection is desired.
#else YP
**		sfile -- the name of the statistics file.
#endif YP
**
**	Returns:
**		none.
**
**	Side Effects:
**		merges the Stat structure with the sfile file.
*/

poststats(sfile)
	char *sfile;
{
	register int fd;
	struct statistics stat;
	extern off_t lseek();
#ifdef YP
	int n;
#endif YP

#ifdef YP
	if (sfile == NULL || *sfile == '\0')
#else YP
	if (sfile == NULL)
#endif YP
		return;

#ifdef YP
	for (n=0; n<MAXMAILERS;n++)
	     if (Mailer[n] && Mailer[n]->m_name)
		strncpy(Stat.stat_names[n], Mailer[n]->m_name, NAMELEN);
	    else
		(void) strcpy(Stat.stat_names[n], "");

#endif YP
	(void) time(&Stat.stat_itime);
	Stat.stat_size = sizeof Stat;

	fd = open(sfile, 2);
	if (fd < 0)
	{
		errno = 0;
		return;
	}
	if (read(fd, (char *) &stat, sizeof stat) == sizeof stat &&
	    stat.stat_size == sizeof stat)
	{
		/* merge current statistics into statfile */
		register int i;

		for (i = 0; i < MAXMAILERS; i++)
		{
			stat.stat_nf[i] += Stat.stat_nf[i];
			stat.stat_bf[i] += Stat.stat_bf[i];
			stat.stat_nt[i] += Stat.stat_nt[i];
			stat.stat_bt[i] += Stat.stat_bt[i];
		}
	}
	else
		bcopy((char *) &Stat, (char *) &stat, sizeof stat);

	/* write out results */
	(void) lseek(fd, (off_t) 0, 0);
	(void) write(fd, (char *) &stat, sizeof stat);
	(void) close(fd);
}
