/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:conf.c 12.0$ */
/* $ACIS:conf.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/conf.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header:conf.c 12.0$";
#endif

/*     conf.c  6.1     83/07/29        */
#include "param.h"
#include "systm.h"
#include "buf.h"
#include "ioctl.h"
#include "tty.h"
#include "conf.h"

#include "debug.h"

int nulldev();
int nodev();
int minphys();

#include "hd.h"
#if NHD > 0
int hdinit(), hdstrategy(), hdread(), hdwrite(), hdopen(), hddump(), hdsize(), hdioctl(), hdminphys();
#else NHD
#define hdinit	nodev
#define hdstrategy	nodev
#define hdread	nodev
#define hdwrite	nodev
#define hdopen	nodev
#define hddump	nodev
#define hdsize	nodev
#define hdioctl	nodev
#define hdminphys	nodev
#endif NHD

#include "ud.h"
#if NUD > 0
int udinit(), udstrategy(), udread(), udwrite(), udopen();
#else NUD
#define udinit	nodev
#define udstrategy	nodev
#define udread	nodev
#define udwrite	nodev
#define udopen	nodev
#endif NUD

#include "fd.h"
#if NFD > 0
int fdinit(), fdstrategy(), fdread(), fdwrite(),fdioctl();
#ifdef	ATR
int fdopen(),fdclose(),fdsize();
#define	fdbopen	fdopen
#define	fdbclose	fdclose
#define	fdcopen	fdopen
#define	fdcclose	fdclose
#else	/* ATR */
#define fdsize	nodev		/* no fdsize on RT */
int fdbopen(),fdbclose(),fdcopen(),fdcclose();
#endif	/* ATR */
#define	fdminphys	minphys	/* XXX dma */
#else NFD
#define fdinit	nodev
#define fdstrategy	nodev
#define fdread	nodev
#define fdwrite	nodev
#define fdbopen	nodev
#define fdcopen	nodev
#define fdbclose	nodev
#define fdcclose	nodev
#define fdioctl	nodev
#define fdsize	nodev
#define	fdminphys	nodev
#endif NFD

int swstrategy(), swread(), swwrite(), swminphys();

#include "st.h"
#if NST > 0
int stinit(), ststrategy(), stread(), stwrite(), stopen(), stclose(), stsize(), stioctl();
#else NST
#define stinit	nodev
#define ststrategy	nodev
#define stread	nodev
#define stwrite	nodev
#define stopen	nodev
#define stclose	nodev
#define stsize	nodev
#define stioctl	nodev
#endif NST

#include "vd.h"
#if NVD > 0
int	vdopen(),vdstrategy(),vdread(),vdwrite(),vdsize(),vdioctl(),minvdphys();
#else
#define vdopen		nodev
#define	vdstrategy	nodev
#define	vdread		nodev
#define	vdwrite		nodev
#define	vdioctl		nodev
#define	vdsize		0
#define	minvdphys	nodev
#endif

#include "sc.h"
#if NSC > 0
int scsiinit(), scsistrategy(), scsiread(), scsiwrite(), scsiopen(), scsisize(), scsiminphys(), scsiioctl();
#else NSC
#define scsiinit	nodev
#define scsistrategy	nodev
#define scsiread	nodev
#define scsiwrite	nodev
#define scsiopen	nodev
#define scsisize	nodev
#define scsiioctl	nodev
#define scsiminphys	nodev
#endif NSC

#ifdef ATR
#include "op.h"

#if NOP > 0
int opstrategy(), opread(), opwrite(), opopen(), opclose(), opminphys(), opioctl(), opsize();
#else NOP
#define opclose	nodev
#define opstrategy	nodev
#define opread	nodev
#define opwrite	nodev
#define opopen	nodev
#define opioctl	nodev
#define opminphys	nodev
#define opsize	nodev
#endif NOP
int mmsize(), mmstrategy();
#endif ATR

int baddev();		/* which will panic */

struct bdevsw bdevsw[] = {
	/* open		close		strat		dump
	  size		flags */
/* 0-9 reserved to IBM */
	{ nodev,	nodev,		baddev,		nodev,	/*0*/
	  0,		0,	nodev },
	{ hdopen,	nulldev,	hdstrategy,	hddump,	/*1*/
	  hdsize,	0,	hdminphys },
	{ udopen,	nulldev,	udstrategy,	nodev,	/*2*/
	  0,		0,	minphys },
	{ fdbopen,	fdbclose,	fdstrategy,	nodev,	/*3*/
	  fdsize,	0,	fdminphys },
	{ nodev,	nodev,		swstrategy,	nodev,	/*4*/ 
	  0,		0,	swminphys },
	{ stopen,	stclose,	ststrategy,	nodev,	/*5*/
	  0,		B_TAPE,	minphys },
	{ vdopen,	nulldev,	vdstrategy,	nodev,	/*6*/
	  0,		0,	minvdphys },
	{ scsiopen,	nulldev,	scsistrategy,	nodev,	/*7*/
	  scsisize,	0,	scsiminphys },
#ifdef ATR
	{ opopen,	opclose,	opstrategy,	nodev,	/*8*/
	  opsize,	0,	opminphys },
	{ nulldev,	nulldev,	mmstrategy,	nodev,	/*9*/ 
	  mmsize,	0,	minphys },
#else
	{ nodev,	nodev,		nodev,		nodev,	/*8*/ 
	  0,		0,	nodev },
	{ nodev,	nodev,		nodev,		nodev,	/*9*/ 
	  0,		0,	nodev },
#endif ATR
/* 0-9 reserved to IBM */
/* 10-19 reserved to local sites */
};
int nblkdev = sizeof(bdevsw) / sizeof(bdevsw[0]);

int cnopen(), cnclose(), cnread(), cnwrite(), cnioctl(), cnselect();
struct tty cons;

#include "asy.h"
#if NASY > 0
int asyopen(), asyclose(), asyread(), asywrite(), asyioctl(), asyselect();
struct tty asy[];
#else
#define		asyopen		nodev
#define		asyclose	nodev
#define		asystrategy	nodev
#define		asyread		nodev
#define		asywrite	nodev
#define		asyioctl	nodev
#define		asyselect	nodev
#define		asy	0
#endif

int syopen(), syread(), sywrite(), syioctl(), syselect();

int mmread(), mmwrite();
#ifdef IBMRTPC
#define mmioctl nodev
#else
int mmioctl();
#endif
#define        mmselect        seltrue

#include "pty.h"
#if NPTY > 0
int ptsopen(), ptsclose(), ptsread(), ptswrite(), ptsstop();
int ptcopen(), ptcclose(), ptcread(), ptcwrite(), ptcselect();
int ptyioctl();
struct tty pt_tty[];
#else
#define ptsopen         nodev
#define ptsclose        nodev
#define ptsread         nodev
#define ptswrite        nodev
#define ptcopen         nodev
#define ptcclose        nodev
#define ptcread         nodev
#define ptcwrite        nodev
#define ptyioctl        nodev
#define pt_tty          0
#define ptcselect       nodev
#define ptsstop         nulldev
#endif

#include "lp.h"
#if NLP > 0
int lpopen(), lpclose(), lpwrite();
#else
#define lpopen nodev
#define lpclose nodev
#define lpwrite nodev
#endif

#include "psp.h"
#if NPSP > 0
int pspopen(), pspclose(), pspread(), pspwrite(), pspioctl(), pspselect();
struct tty psp[];
#else
#define		pspopen		nodev
#define		pspclose	nodev
#define		pspstrategy	nodev
#define		pspread		nodev
#define		pspwrite	nodev
#define		pspioctl	nodev
#define		pspselect	nodev
#define		psp	0
#endif

#include "ps.h"
#if NPS > 0
int psopen(), psclose(), psread(), pswrite(), psioctl(), psselect();
#else
#define		psopen		nodev
#define		psclose		nodev
#define		psstrategy	nodev
#define		psread		nodev
#define		pswrite		nodev
#define		psioctl		nodev
#define		psselect	nodev
#define		ps	0
#endif

int busopen(), busclose();

int spkopen(), spkwrite(), spkclose();
#ifdef notdef	/* in case some one wants to make this dev conditional */
#define 	spkopen		nodev
#define 	spkwrite	nodev
#define 	spkclose	nodev
#endif 

#include "ms.h"
#if NMS > 0
int msopen(), msclose(), msread(), msioctl(), msselect();
struct  tty ms_tty[];
#else
#define		msopen		nodev
#define		msclose		nodev
#define		msread		nodev
#define		msioctl		nodev
#define 	ms_tty		0
#define 	msselect	nodev
#endif

int	logopen(),logclose(),logread(),logioctl(),logselect();

#ifdef	VICE
#include	"rfs.h"
#if NRFS > 0
int	rmtopen(), rmtclose(), rmtread(), rmtwrite(), rmtselect();
#else
#define		rmtopen	nodev
#define		rmtclose	nodev
#define		rmtread	nodev
#define		rmtwrite	nodev
#define		rmtselect	nodev
#endif
#endif	VICE

#ifdef	ATR
#include	"pcbios.h"
#if NPCBIOS > 0
int	pcbiosopen(), pcbiosclose();
int	pcbiosioctl();
#else
#define 	pcbiosopen	nodev
#define 	pcbiosclose	nodev
#define 	pcbiosioctl	nodev
#endif
#endif	ATR

int ttselect(), seltrue();

struct cdevsw cdevsw[] = {
	/* open		close		read		write
	  ioctl		stop		reset		tty
	  select	mmap	*/
/* 0-24 reserved to IBM */
	{ cnopen,	cnclose,	cnread,		cnwrite,	/*0*/
	  cnioctl,	nulldev,	nulldev,	&cons,
	  cnselect,	nodev },
	{ asyopen,	asyclose,	asyread,	asywrite,	/*1*/
	  asyioctl,	nulldev,	nulldev,	asy,
	  asyselect,	nodev },
	{ syopen,	nulldev,	syread,		sywrite,	/*2*/
	  syioctl,	nulldev,	nulldev,	0,
	  syselect,	nodev },
	{ nulldev,	nulldev,	mmread,		mmwrite,	/*3*/
	  mmioctl,	nulldev,	nulldev,	0,
	  mmselect,	nodev },
	{ hdopen,	nulldev,	hdread,		hdwrite,	/*4*/
	  hdioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ udopen,	nulldev,	udread,		udwrite,	/*5*/
	  nulldev,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ ptsopen,	ptsclose,	ptsread,	ptswrite,	/*6*/
	  ptyioctl,	ptsstop,	nodev,		pt_tty,
	  ttselect,	nodev },
	{ ptcopen,	ptcclose,	ptcread,	ptcwrite,	/*7*/
	  ptyioctl,	nulldev,	nodev,		pt_tty,
	  ptcselect,	nodev },
	{ lpopen,	lpclose,	nodev,		lpwrite,	/*8*/
	  nodev,	nulldev,	nodev,		0,
	  seltrue,	nodev },
	{ nulldev,	nulldev,	swread,		swwrite,	/*9*/
	  nodev,	nodev,		nulldev,	0,
	  nodev,	nodev },
	{ fdcopen,	fdcclose,	fdread,		fdwrite,	/*10*/
	  fdioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ stopen,	stclose,	stread,		stwrite,	/*11*/
	  stioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ pspopen,	pspclose,	pspread,	pspwrite,	/*12*/
	  pspioctl,	nulldev,	nulldev,	psp,
	  pspselect,	nodev },
	{ busopen,	busclose,	nodev,		nodev,		/*13*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
	{ spkopen,	spkclose,	nulldev,	spkwrite,	/*14*/
	  nulldev,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ msopen,	msclose,	msread,		nodev,		/*15*/
	  msioctl,	nulldev,	nulldev,	ms_tty,
	  msselect,	nodev },
#ifdef	VICE
	{ rmtopen,	rmtclose,	rmtread,	rmtwrite,	/*16*/	
	  nodev,	nodev,		nodev,		0,
	  rmtselect,	nodev },
#else
	{ nodev,	nodev,		nodev,		nodev,		/*16*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
#endif	VICE
	{ vdopen,	nulldev,	vdread,		vdwrite,	/*17*/
	  vdioctl,	nodev,		nodev,		0,
	  seltrue,	nodev },
	{ scsiopen,	nulldev,	scsiread,	scsiwrite,	/*18*/
	  scsiioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
	{ logopen,	logclose,	logread,	nodev,		/*19*/
	  logioctl,	nodev,		nulldev,	0,
	  logselect,	nodev },
#ifdef ATR
	{ pcbiosopen,	pcbiosclose,	nodev,		nodev,		/*20*/
	  pcbiosioctl,	nodev,		nodev,		0,
	  seltrue,	nodev },
	{ opopen,	opclose,	opread,		opwrite,	/*10*/
	  opioctl,	nulldev,	nulldev,	0,
	  seltrue,	nodev },
#else
	{ nodev,	nodev,		nodev,		nodev,		/*20*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
	{ nodev,	nodev,		nodev,		nodev,		/*21*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
#endif ATR
	{ psopen,	psclose,	psread,		pswrite,	/*22*/
	  psioctl,	nulldev,	nulldev,	0,
	  psselect,	nodev },
	{ nodev,	nodev,		nodev,		nodev,		/*23*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
	{ nodev,	nodev,		nodev,		nodev,		/*24*/
	  nodev,	nodev,		nodev,		0,
	  nodev,	nodev },
/* 0-24 reserved to IBM */
/* 25-39 reserved to local sites */
};
int nchrdev = sizeof(cdevsw) / sizeof(cdevsw[0]);

int mem_no = 3;		/* major device number of memory special file */

/*
 * Swapdev is a fake device implemented
 * in sw.c used only internally to get to swstrategy.
 * It cannot be provided to the users, because the
 * swstrategy routine munches the b_dev and b_blkno entries
 * before calling the appropriate driver.  This would horribly
 * confuse, e.g. the hashing routines. Instead, /dev/drum is
 * provided as a character (raw) device.
 */
dev_t swapdev = makedev(4, 0);

/* Debugging switches -- may be patched during execution */

int
	aeddebug = 0,
	autodebug = 0,		  /* autoconfig debug */
	cndebug = 0,		  /* CONSOLE (mono/keybrd) debug */
	ecdebug = 0,
	fddebug = 0,	/* for floppy driver */
	fpadebug = 0,
	fsdebug = 0,		  /* Unix file system */
	hddebug = 0,
	indebug = 0,	/* interrupt system */
	iodebug = 0,		  /* low level i/o */
	mc881debug = 0,		  /* mc881 debugging flag */
	nfldebug = 0,
	padebug = 0,		  /* paging system */
	pspdebug = 0,		  /* psp ( planar async ) */
	svdebug = 0,		  /* svc traces */
	swdebug = 0,		  /* swapping system */
	sydebug = 0,		  /* syncronization */
	trdebug = 0,		  /* trap traces */
	ttydebug = 0,		  /* TTY (async) debug */
	vmdebug = 0,		  /* virtual memory */
#ifdef ATR
	pcdebug = 0,
	opdebug = 0,		  /* optical disk */
#endif ATR
	z = 0x01010101;	  /* end of debugging switches */

#ifdef ROROOT
dev_t rorootdev = ROROOT;  /* if root make it read-only */
#endif

#ifdef WAITFOR
int waitfor = 0;		/* normally wait for disk I/O to complete */
#else
int waitfor = 1;		/* normally wait for disk I/O to complete */
#endif WAITFOR
