/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:fpavar.h 12.0$ */
/* $ACIS:fpavar.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/fpavar.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidfpavar = "$Header:fpavar.h 12.0$";
#endif

/*
 * These are the variables the kernel keeps around internally
 * to deal with the mc68881.
 */

#if	!defined(LOCORE)

struct fpa_state {
    struct {
	u_int	data[64];		/* Floating point registers */
    } programmer;
    u_int	ioim_length_register;	/* Contents of the IOIM length reg */
    u_int	fpasr,			/* Status register */
		ier,			/* Exception register */
		rer;			/* AFPA only */
    u_int	flags;			/* Software flags */
};

#endif	/* !defined(LOCORE) */

/* Bits defined in the flags word */
#define	FPA_EIGHTH_REG	0x00000001	/* (fpa) eighth (software) reg saved */

#define FPA_COUNT	0	/* counter of all fpa exceptions */
#define FPA_ALLOC	1	/* counter of allocation exceptions */
#define FPA_RESUME	2	/* counter of exceptions in resume */
#define FPA_GRAB	3	/* counter of # registers grabbed */
#define FPA_FIXED	4	/* counter of # of times fixed */
#define FPA_SIGFPE	5	/* counter of # of times not fixed */
#define	FPA_BUMP	6

#define FPA_COUNTERS	8	/* sufficient room for counters */

#if	defined(KERNEL) && !defined(LOCORE)

extern int fpa_count[FPA_COUNTERS];

extern int fpa_curreg;			/* current register set in use */

#endif	/* defined(KERNEL) && !defined(LOCORE) */
