/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:machparam.h 12.0$ */
/* $ACIS:machparam.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/machparam.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidca_param = "$Header:machparam.h 12.0$";
#endif
/*
 * IMPORTANT NOTE:
 * the following ifdefs set up the 'standard' set of options
 * by default unless an option of the for NOxxx form is present
 * in the configuration file. 
 */

#if !defined(NOSHOW_LOAD) && !defined(SHOW_LOAD)
#define SHOW_LOAD	1	/* show load in lights */
#endif

#if !defined(NOFPA) && !defined(FPA)
#define FPA	1		/* assume FPA present */
#endif

#if !defined(NONFL) && !defined(NFL)
#define NFL	1		/* assume New Floating Linkage */
#endif

#if !defined(NOROMPC) && !defined(ROMPC)
#define ROMPC	1		/* assume ROMPC */
#endif

#if !defined(NOMC881) && !defined(MC881) && defined(ROMPC)
#define MC881	1		/* assume MC881 present */
#endif

#ifndef __STDC__
#define volatile
#endif _STDC_

/*
 * Machine dependent constants for ibm032.
 */
#define        NBPG    2048            /* bytes/page */
#define        PGOFSET (NBPG-1)        /* byte offset into page */
#define        PGSHIFT 11              /* LOG2(NBPG) */
#define        LOG2NBPG 11             /* LOG2(NBPG) */

#define        CLSIZE          1
#define        CLSIZELOG2      0

#define        SSIZE   1               /* initial stack size/NBPG */
#define        SINCR   1               /* increment of stack/NBPG */

#define		UPAGES  4			/* pages of uarea  */

#define SEGMENT_OFFSET 0x0FFFFFFF      /* ibm032 hardware segment offset */
#define DATABASE       0x10000000      /* virtual address of data origin */

#define SYSBASE  ((u_long)0xe0000000)  /* virt addr of system origin */
/*
 * Some macros for units conversion
 */
/* Core clicks (2048 bytes) to segments and vice versa */
#define        ctos(x) (x)
#define        stoc(x) (x)

/* Core clicks (2048 bytes) to disk blocks */
#define        ctod(x) (x<<2)
#define        dtoc(x) ((x+3)>>2)
#define        dtob(x) ((x)<<9)

/* clicks to bytes */
#define        ctob(x) ((x)<<11)

/* bytes to clicks */
#define        btoc(x) ((((unsigned)(x)+2047)>>11))

/*
 * Macros to decode interrupt control status.
 */
#define        USERMODE(icscs)   ((icscs) & ICSCS_PROBSTATE)
#define        BASEPRI(icscs)    (((icscs) & ICSCS_PRIORITY) == ICSCS_PRIORITY)

#ifdef IBMRTPC
#define DELAY_ADDR	0xf00080E0		/* IOCC delay location */
#else
#define DELAY_ADDR	&delay_addr
#endif IBMRTPC
#define DELAY(n)	{ register int N = (n); extern char delay_addr; \
				while (--N >= 0) \
					* (char volatile *) DELAY_ADDR = 0xff;	}

#ifdef KERNEL
#ifndef LOCORE
short rorootdev;		/* for read-only root device */
char	ccr_default;		/* default value for CCR */

#define splttl() spl4()
#define spltty() spl4()
#define splclock() spl6()
#define splbio()	_spl1()
#define splsoftclock() _spl6()

#define spl0()	_spl7()		/* use CPU priority level 7 */
#define spl1()	_spl6()		/* use CPU priority level 6 */
#define spl2()	_spl5()		/* use CPU priority level 5 */
#define spl3()	_spl4()		/* use CPU priority level 4 */
#define spl4()	_spl3()		/* use CPU priority level 3 */
#define spl5()	_spl2()		/* use CPU priority level 2 */
#define spl6()	_spl1()		/* use CPU priority level 1 */
#define spl7()	_spl0()		/* use CPU priority level 0 */

#define splhigh() _spl0()	/* inhibit everything */
#define fuibyte fubyte
#define fuiword fuword
#define suibyte subyte
#define suiword suword

#endif LOCORE
#define ovbcopy bcopy
#endif KERNEL

#ifdef NFL
/*
 * following probably should be in a machine/nfl.h but that would be
 * yet another header file to maintain.
 */
#define NFL_MASK	0xffff0000	/* mask for NFL_ADDR */
#define NFL_ADDR	0x00ff0000	/* fixed part of address */
#define BALA		0x8a000000	/* a BALA instruction base */
#define NFL_INSTN (BALA + NFL_ADDR) 	/* BALA */
#define BALI_R15	0x8cf00000	/* a BALI instruction */
#define BALI_MASK	0x000fffff	/* mask for BALI offset */
#endif NFL

#ifndef ATR
#define set_128_window(addr) (addr)	/* in case of side effects */
#endif ATR
