#$Header:codes.awk 12.0$
#$ACIS:codes.awk 12.0$
#$Source: /ibm/acis/usr/sys/cacons/RCS/codes.awk,v $
BEGIN { 

Q = "\"";
NAME="kbde_codes.h"
count = 0
functioncnt = 0
codes=2

hex["0"] = 0
hex["1"] = 1
hex["2"] = 2
hex["3"] = 3
hex["4"] = 4
hex["5"] = 5
hex["6"] = 6
hex["7"] = 7
hex["8"] = 8
hex["9"] = 9
hex["a"] = 10
hex["b"] = 11
hex["c"] = 12
hex["d"] = 13
hex["e"] = 14
hex["f"] = 15

print "/* $Header:codes.awk 12.0$ */" > NAME
print "/* $Source: /ibm/acis/usr/sys/cacons/RCS/codes.awk,v $ */" > NAME
print " " > NAME
print "#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)" > NAME
print "static char *rcsidkbde_codes = \"$Header:codes.awk 12.0$\";" > NAME
print "#endif" > NAME
print " " > NAME
}
/^#/ { print > NAME ; next }
/^\*/ { next } 		# ignore completely 
/^\/\*/ { print > NAME ; next }
# function name 	define a keyboard function
$1 == "codes" { codes = $2+0 ; next } 
$1 == "codelength" { codelength = $2+0 ; next } 
$1 == "type" { next } 
$1 == "function" {
	printf("#define %-10s (META+%d)\n",$2,functioncnt) > NAME
	functions[functioncnt] = $2
	++functioncnt;
	next
	}
NF < 3 { print "less than 3 fields",NR,$0 ; next }
length($1) != 2 { print $1,"not 2 hex characters"; next }
{
	d1 = hex[substr($1,1,1)]
	d2 = hex[substr($1,2,1)]
	if (d1 == "" || d2 == "")
		{ print "bad hex digit in ",$1,NR,$0 ; next }
	dec =  d1 * 16 + d2
	if (scan[dec] != "")
		printf("scan code %d (%x) duplicate %s : %s \n",dec,dec,scan[dec],$2)
	for (i=2; i<=NF; ++i)
		comment[dec] = comment[dec] " " $i
	if ($2 == "meta") {
		char = $3
		scan[dec] = char
	}
	else {
		for (i=1; i<=codes; ++i) {
			if ( $(i+1) ~ /".*/) {
				split($(i+1),array,"\"")
				if ( $(i+1) == "\"\\\"\"")
					chars[ i "@" count] = "\"\000\\\"\""
				else
					chars[ i "@" count ] = "\"\000" array[2]  "\""
			} else {
				split($(i+1),array,"{")
				chars[i "@" count] = "{META," array[2]
			}
		}
		scan[dec] = count
		for (i=codes+2; i<=NF; ++i)
			xcomment[count] = xcomment[count] " " $i
		++count
	}
#	print dec,$0
	if (dec > max)
		max = dec
}

END { 

print "#define MAX_CODES ",count+1 > NAME
print "#define MAX_TYPES ",codes > NAME

print "#ifdef KERNEL" > NAME
print "char code_map[256];	/* working code map */ " > NAME
print "char std_code_map[256]  = {	/* standard code map */" > NAME

delim = ","
for (i=0; i<256; ++i) {
	if (i == 255)
		delim = ""
	if (scan[i] == "")
		scan[i] =  functions[0]
	printf("%-20s	/* %3d 0x%02x %s */\n",scan[i] delim ,i,i,comment[i]) > NAME
	}
print "};" > NAME
print "char kbde_codes[MAX_CODES][MAX_TYPES][MAX_CODE_LENGTH];" > NAME
print "char std_codes[MAX_CODES][MAX_TYPES][MAX_CODE_LENGTH] = {" > NAME
for (i=0; i<count; ++i) {
	printf("{ ") > NAME
	delim = "," 
	for (j=1; j<=codes; ++j) {
		printf("%-11s", chars[j "@" i] delim) > NAME
		if (j == codes)
			delim = ""
	}
	printf(" },  /* %3d%s */\n",i,xcomment[i]) > NAME
}
print "};" >NAME
print "#endif KERNEL" > NAME
}
