/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:egatty.h 12.0$ */
/* $ACIS:egatty.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/cacons/RCS/egatty.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidegadefs = "$Header:egatty.h 12.0$";
#endif

/* Monocrome Console attribute byte definitions */
#define EGA_NORMAL_VIDEO	0x07	/* Normal Video */
#define EGA_REVERSE_VIDEO	0x70	/* Reverse Video */
#define EGA_UNDERLINE_VIDEO	0x01	/* under line */
#define EGA_HI_INTENSITY	0x08	/* High Intensity */
#define EGA_BLINK		0x80	/* blink bit */
#define EGA_FOREGROUND		0x07	/* ega foreground color entry */

/* Color Console attributes */
#define EGA_C_HI		0x08
#define EGA_C_RED		0x04
#define EGA_C_GREEN		0x02
#define EGA_C_BLUE		0x01

/* translate virtual color bits to real pallette entry */
char ega_get_color[] = {
/* Enhanced mode */
	0x00,		/* Black */
	0x01,		/* Blue */
	0x02,		/* Green */
	0x03,		/* Cyan */
	0x04,		/* Red */
	0x05,		/* Violet */
	0x14,		/* Yellow */
	0x07,		/* White */
	0x38,		/* Gray */
	0x39,		/* Hi Blue */
	0x3a,		/* Hi Green */
	0x3b,		/* Hi Cyan */
	0x3c,		/* Hi Red */
	0x3d,		/* Hi Violet */
	0x3e,		/* Hi Yellow */
	0x3f,		/* Hi White */
/* Color mode */
	0x00,		/* Black */
	0x01,		/* Blue */
	0x02,		/* Green */
	0x03,		/* Cyan */
	0x04,		/* Red */
	0x05,		/* Violet */
	0x06,		/* Yellow */
	0x07,		/* White */
	0x10,		/* Gray */
	0x11,		/* Hi Blue */
	0x12,		/* Hi Green */
	0x13,		/* Hi Cyan */
	0x14,		/* Hi Red */
	0x15,		/* Hi Violet */
	0x16,		/* Hi Yellow */
	0x17,		/* Hi White */
};

/* Set the color table entry */
#define SETCOLOR(entry,table)	{ \
	char tmp;	\
	/* reset attribute register */	\
	tmp = IN(ATTR_ADDR); \
\
	/* load entry */\
	OUT(ATTR_REG,(entry));\
	tmp = ega_get_color[(table) | ((mode == EGA_COLOR) << 4)];\
	OUT(ATTR_REG,tmp); \
\
	/* load HI_INTENSITY entry */\
	tmp = (entry) | EGA_HI_INTENSITY;\
	OUT(ATTR_REG,tmp); \
	tmp= ega_get_color[(table) | EGA_HI_INTENSITY | ((mode == EGA_COLOR) << 4)];\
	OUT(ATTR_REG,tmp); \
\
	OUT(ATTR_REG,0x20); \
}

/* Hardware Registers */
#define MISCELLANEOUS		((volatile char *)0xf00003c2)
#define GRAPHIX_I_POS		((volatile char *)0xf00003cc)
#define GRAPHIX_II_POS		((volatile char *)0xf00003ca)
#define SEQUENCE_ADDR		((volatile char *)0xf00003c4)
#define SEQUENCE_REG		((volatile char *)0xf00003c5)
#define CRT_ADDR		((volatile char *)0xf00003d4)
#define CRT_REG 		((volatile char *)0xf00003d5)
#define CRT_ADDR_M		((volatile char *)0xf00003b4)
#define CRT_REG_M 		((volatile char *)0xf00003b5)
#define GRAPHICS_ADDR		((volatile char *)0xf00003ce)
#define GRAPHICS_REG		((volatile char *)0xf00003cf)
#define ATTRIBUTE_ADDR		((volatile char *)0xf00003da)
#define ATTRIBUTE_ADDR_M	((volatile char *)0xf00003ba)
#define ATTRIBUTE_REG		((volatile char *)0xf00003c0)
#define ATTR_ADDR		0x03da
#define ATTR_REG		0x03c0

/* Screen memory defintions */
#define SCREEN_BUFFER ((volatile char *)0xf40b8000)

#define SCREEN_END	(SCREEN_BUFFER + SCREEN_SIZE)
#define EGA_SCREEN_LENGTH	25
#define EGA_SCREEN_WIDTH	80

/* sets Pointer where we are */
#define set_ptr(x, y) ega_screen_ptr = egalines[y] + (x<<1)
#define EGA_NSWITCH	4
#define	EGA_SWITCH_BIT	0x10
