/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:if_ecreg.h 12.0$ */
/* $ACIS:if_ecreg.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/caif/RCS/if_ecreg.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidif_ecreg = "$Header:if_ecreg.h 12.0$";
#endif

/*
 * Some sizes
 */
#define EC_BSIZE	2048	/* Size of controller buffer */
#define EC_RUNT		60	/* Smallest legal packet, no frame chksum err */
#define EC_GIANT	1514	/* Largest legal packet, no frame chksum err */
#define ETH_ADDR_SIZE   6   	/* Ethernet address size */
#define EC_ADDR         0x0C    /* Ethernet address offset in PROM */
 
/*
 * 3Com Ethernet adapter registers.
 */
struct ecdevice {
	char ec_saddr[ETH_ADDR_SIZE];  	/* Station (Ethernet) address */
	char ec_rcr;		/* Receiver control/status reg */
	char ec_xcr;		/* Transmitter control/status reg */
	char ec_gptr[2];	/* General buffer pointer (LSB/MSB) */
	char ec_rptr[2];	/* Receive buffer pointer (LSB/MSB) */
	char ec_saprom;		/* Station address PROM window */
	char ec_pad1;           /* Unused */
	char ec_acr;		/* Auxiliary control/status reg */
	char ec_bufbyte;	/* Packet buffer window (byte at gptr) */
};

/*
 * Control and status bits - receiver (rcsr)
 */
#define EC_STALE	0x80	/* Stale (old packet) receive status (R/O) */
#define EC_RCVNONE	0x00	/* Disable receiver (W/O) */
#define EC_RCVALL	0x40	/* Accept all packets (W/O) */
#define EC_RCVBROAD	0x80	/* Accept packets for us & broadcast (W/O) */
#define EC_RCVMULTI	0xC0	/* Accept packets for us & multicast (W/O) */
#define EC_RCVGOOD	0x20	/* W: accept good packets */
				/* R: received good packet */
#define EC_RCVANY	0x10	/* W: accept packets without EOF */
				/* R: received packet without EOF */
#define EC_SHORT	0x08	/* W: detect short frames */
				/* R: detected short frame */
#define EC_DRIBBLE	0x04	/* W: detect dribble errors */
				/* R: detected dribble error */
#define EC_FCSERR	0x02	/* W: detect FCS errors */
				/* R: detected short frame */
#define EC_OVERFLOW	0x01	/* W: detect data overflow error */
				/* R: lost packet due to buffer full */
#define EC_RCVNORMAL	(EC_RCVBROAD|EC_RCVGOOD|EC_SHORT)
#define EC_RCRBITS	"\20\10STALE\6GOOD\4SHORT\1OFLOW"

/*
 * Control and status bits - transmitter (xcsr)
 */
#define EC_XMTOK	0x08	/* R: transmission completed successfully */
				/* W: detect successful xmit */
#define EC_XMT16	0x04	/* R: packet experienced 16 collisions */
				/* W: detect collision 16 */
#define EC_XMTJAM	0x02	/* R: packet experienced a collision */
				/* W: detect collisions */
#define EC_UNDERFLOW	0x01	/* R: data underflow occurred */
				/* W: detect underflow condition */
#define EC_XMTNORMAL	(EC_XMTOK|EC_XMT16|EC_XMTJAM)
#define EC_XMITDONE	(EC_XMTOK|EC_XMT16|EC_XMTJAM)
#define EC_XCRBITS	"\20\4SUCCESS\3JAM16X\2JAM"

/*
 * Control and status bits - auxiliary (acsr)
 */
#define EC_RESET	0x80	/* Reset the controller (W/O) */
#define EC_XMTBUSY	0x80	/* Transmitter is busy (R/O) */
#define EC_RIDE		0x41	/* Request interrupt/DMA enable (R/W) */
#define EC_DMAREQ	0x20	/* DMA request (R/W) */
#define EC_DMADONE	0x10	/* DMA done (R/O) */
#define EC_LOOPGO	0x0C	/* Loopback, xmit & rcv simultaneously (R/W)*/
#define EC_RCVGO	0x08	/* Gives buffer to receiver (R/W) */
#define EC_XMTGO	0x04	/* Gives buffer to transmitter (R/W) */
#define EC_FCSTEST	0x02	/* Causes CRC error on transmit (R/W) */
#define EC_RCVBUSY	0x01	/* Receive in progress (R/O) */
#define EC_ACRBITS	"\20\10XBUSY\7RIDE\6DMA\5DMADONE\4RGO\3XGO\1RBUSY"

#define EC_CLEAR	0x00	/* Symbolically clear a register */
