#! /bin/sh
# $Header:df.sh 12.0$ 
# $ACIS:df.sh 12.0$ 
# $Source: /ibm/acis/usr/sys/dist/bin/RCS/df.sh,v $ 
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
#
# do a df on a filesystem
#
echo "Filesystem    kbytes    used   avail capacity  Mounted on"
#     /dev/hd0a       7445    6043    1030    85%    /
#
offset=8192	# offset from start of filesystem
dsize=40	# following are offsets from start of superblock
fsize=52
frag=56
nbfree=196
nifree=200
nffree=204
fsmnt=212
minfree=60

case "$1" in
"")
	set -$- ` IFS="$IFS:" ; while read device fs how dump ; do 
	case "$how" in ro|rw) echo $device ;; esac ; done </etc/fstab `
	;;
esac
for i
do
	case "$i" in
	-v)	arg=-v
		continue
		;;
	esac
# 99	total capacity
# 96	capacity after minfree
	/etc/syscall $arg lseek 0 $offset 0 \; read 0 \&0 1024 \; \
	printf %-8 $i \; \
	= \&$fsize ! 4 \; = \&$dsize ! 4 \; = \$ \* \$-2 \; = \$ / 1024 99 \; \
	printf " %10d" \$ \; \
	= \&$minfree ! 4 \; = 100 - \$ \; = \$ \* \$99 \; = \$ / 100 96 \; \
	= \&$nbfree ! 4 \; = \&$frag ! 4 \; = \$ \* \$-2 \; = \&$nffree ! 4 \; \
	= \$ '\+' \$-2 \; = \&$fsize ! 4 \; = \$ \* \$-2 \; = \$ / 1024 98 \; \
	= \$99 - \$98 95 \; printf " %7d" \$ \; \
	= \$96 - \$95 \; printf " %7d" \$ \; \
	= \$95 \* 100 \; = \$ / \$96 \; printf " %5d%%" \$ \; \
	printf "    %s" \&$fsmnt \; \
	printf %c 10 \
	< $i
done
