#!/bin/sh -
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
# $Header:install.driver.sh 12.1$ 
# $ACIS:install.driver.sh 12.1$ 
# $Source: /ibm/acis/usr/sys/dist/lib/RCS/install.driver.sh,v $ 
# perform installation

case $ATR in
0)	echo "
Do you wish to install from tape or over the network?

1 - tape
2 - network 
"
	while :
	do
		echo -n "Choice? "
		case "`onechar`" in
		[1tT])	tape=1; break;;

		[2nN])	tape=0; break;;

		"$ESC")	exit 1;;

		*)	echo "\
Press '1' to install system from tape,
      '2' to install system over the network, or
      '<ESC>' to return to the main menu.";;

		esac
	done;;

1)	tape=0;;
esac
export tape

# set default values
#  foo=x is the default value
#  ofoo=y is the other (non-default) value
root=0
output=verbose
ooutput=terse

case $ATR in
#0)	config=full;;
0|1)	# minimal is default configuration if hd0c is < 25Meg
	if sizeck /dev/rhd0c 50000
	then
	  # full is default configuration if hd0c > 65Meg
	  if sizeck /dev/rhd0c 130000
          then
            config=full
          else
            config=reduced
          fi
	else
          config=minimal
	fi;;
esac

case $tape in
0)	subsets=none;;
1)	subsets="utility man font learn notes";;
esac

net=ethernet
onet="token ring"
shost=master
thost=slave
ifconfig=

while :
do
	echo -n "Do you want an explanation of installation options? [y/n] "
	case "`onechar`" in
	[Yy])	install.options | page
		break;;

	[Nn])	break;;

	"$ESC")	exit 1;;

	*)	echo "\
Press 'y' to see an explanation of installation options,
      'n' to continue without the explanation, or
      '<ESC>' to return to the main menu.";;

	esac
done

while :
do
	echo -n "Do you want to change installation options? [y/n] "
	case "`onechar`" in
	[Yy])	change_defaults=1
		break;;

	[Nn])	change_defaults=0
		break;;

	"$ESC")	exit 1;;

	*)	echo '
Press "y" to change default parameters,
      "n" to use default parameters, or
      "<ESC>" to return to the main menu.';;

	esac
done

# specify option numbers
Ort=1
case $ATR in
#0)	Omn=XX
#	Ooc=2
#	case $tape in
#	0)	Osh=3
#		Oth=4
#		Onp=5
#		Oif=6
#		Oop=7
#		Opi=8;;
#	1)	Osh=XX
#		Oth=XX
#		Onp=XX
#		Oif=XX
#		Oop=3
#		Opi=4;;
#	esac;;
#
0|1)	Omn=2
	Ooc=3
	case $tape in
	0)	Osh=4
		Oth=5
		Onp=6
		Oif=7
		Oop=8
		Opi=9;;
	1)	Osh=XX
		Oth=XX
		Onp=XX
		Oif=XX
		Oop=4
		Opi=5;;
	esac;;
esac

# specify component numbers
case $ATR in
0)	Cks=1
	Cus=2
	Cds=3
	Cmp=4
	C38=5
	Cld=6
	Cnf=7
	case $tape in
		1) Cnx=XX
		   Caf=8;;
		0) Cnx=8
		   Caf=XX;;
	esac
	Caa=9
	Cna=0;;

1)	Cks=XX
	Cus=XX
	Cds=1
	Cmp=2
	C38=3
	Cld=4
	Cnf=5
	case $tape in
		1) Cnx=XX;;
		0) Cnx=6;;
	esac
	Caa=9
	Cna=0;;
esac

RefreshMenu=1
until (exit $change_defaults)
do
	case $RefreshMenu in

	1)	echo "${CLEAR}
Choice		Description				Current Value

`
	case $root in
	[0-2]) echo \"  $Ort	Select root device.				hd$root\";;
	[sS])  echo \"  $Ort	Select root device.				hd0/hd1\";;
	esac`
`
	case $ATR in
	0|1)	echo \"  $Omn	Change system configuration.			$config\";;
	esac`
  $Ooc	Select optional system components.		`

	set $subsets
	case $config in minimal|reduced|nfsminimal|nfsreduced) set 'N/A';; esac
	PRE=
	while :
	do
		case $# in
		#nothing left to print
		0)	break;;

		#print next line
		1) 	echo \"$PRE\"$1
			break;;
		2) 	echo \"$PRE\"$1 $2
			break;;
		*) 	echo \"$PRE\"$1 $2 $3
			shift;shift;shift;;
		esac
		PRE='							  '
	done

	case $tape in 0)	echo \"\
  $Osh	Select source host.				$shost
  $Oth	Select target host.				$thost
  $Onp	Change network preference to $onet.  	$net
  $Oif	Specify additional parameters for ifconfig.	$ifconfig
\";;
	esac`
  $Oop	Change output from $output to $ooutput.		$output
  $Opi	Proceed with installation.
  ?	Help.
 ESC	Abort installation.

Type the number of the menu choice desired."
		;;

	*)	RefreshMenu=1;;
	esac

	echo -n "Choice? "
	case "`onechar`" in

	$Opi)	break;;

	$Ort)	echo "
Select root device for $NAME:

Choice		Description

  0	hd0 (the normal root device)
  1	hd1\
`case $ATR in
0)	echo \"
  2	hd2 (prevents installation of the utility source in /usr/src)\";;
esac`
  s	Split root and usr between hd0 and hd1
"
		while :
		do
			echo -n "Choice? "
			newroot="`onechar`"

			case "$ATR:$newroot" in
			?:[01]) root=$newroot
				break;;

			?:[sS])	root=s
				break;;

			0:2)	root=$newroot
				case "$subsets" in
				*all* | *utility* )
					echo "
WARNING:  The utility source in /usr/src will not be installed.
"
				eval $MENU;;
				esac
				break;;

			?:"$ESC")
				break;;

			*)	echo "
Press '0' to use hd0 as the $NAME root device,
      '1' to use hd1 as the $NAME root device, \
`case $ATR in
0)	echo \"
      '2' to use hd2 as the $NAME root device,\";;
esac`
      's' to split root and usr between hd0 and hd1, or
      '<ESC>' to return to the menu.
"
				continue;;
			esac
		done;;

	$Omn)	echo "
Select configuration for $NAME:

Choice		Description

  1	minimal configuration
  2	nfs minimal configuration
  3	reduced configuration
  4	nfs reduced configuration
  5	full configuration
"
		while :
		do
			echo -n "Choice? "
			newconfig="`onechar`"

			case "$newconfig" in
			1)	config=minimal
				break;;
			2)	config=nfsminimal
				break;;
			3)	config=reduced
				break;;
			4)	config=nfsreduced
				break;;
			5)	config=full
				break;;
			"$ESC")	break;;

			*)	echo "
Press '1' to select a minimal configuration,
      '2' to select an nfs minimal configuration,
      '3' to select an nfs reduced configuration,
      '4' to select a reduced configuration,
      '5' to select a full configuration, or
      '<ESC>' to return to the menu.
"
				continue;;
			esac
		done
		;;

	$Oop)	swap="$output";output="$ooutput";ooutput="$swap"
		;;

	$Ooc)	case $config in 
		minimal|reduced|nfsminimal|nfsreduced)
			echo "
Installation of the minimal configuration does not allow installation
of any optional system components.
"
			eval $MENU
			continue;;
		esac

		while :
		do
			echo "${CLEAR}
Specify which of the following optional system components are to
be installed in addition to the base system.  Type the number(s),
separated by commas, of the desired optional system component(s)
and press Enter:

	Choice		Description
\
`case $ATR in
0)	echo \"
	  $Cks	The kernel source in /usr/sys.			  (kernel)
	  $Cus	The utility source in /usr/src.			  (utility)\";;
esac`
	  $Cds	The documentation source in /usr/doc.		  (doc)
	  $Cmp	The on-line man pages in /usr/man.		  (man)
	  $C38	The 3812 font libraries in /usr/lib/font.	  (font)
	  $Cld	The learn database library in /usr/lib/learn.	  (learn)
	  $Cnf	The notesfiles in /usr/spool/notes.		  (notes)\
`case $tape in
0)	echo \"
	  $Cnx	The X11 code in the user and source directories.  (x11)\";;
1)	echo \"
	  $Caf	The Andrew File System Client binaries.		  (afs)\";;
esac`
	  $Caa	All of the above.
	  $Cna	None of the above.

or press Enter to leave the component selection unchanged.
"
			echo -n "Choice(s)? "
			newsubsets=`IFS=",:;.$IFS";read x;echo $x`

			case "$newsubsets" in
			"")	break;;
			esac

			VALID=1
			KERNEL=0;AFS=0;UTIL=0;DOC=0;NOTES=0;MAN=0;FONT=0;LEARN=0;X11=0
			for i in $newsubsets
			do
				case "$i" in
				XX)	VALID=0;;
				$Cks)	KERNEL=1;;
				$Cus)	UTIL=1;;
				$Cds)	DOC=1;;
				$Cmp)	MAN=1;;
				$C38)	FONT=1;;
				$Cld)	LEARN=1;;
				$Cnf)	NOTES=1;;
				$Cnx)	X11=1;;
				$Caf)	AFS=1;;
				$Caa)	KERNEL=1;UTIL=1;DOC=1;NOTES=1
					MAN=1;FONT=1;LEARN=1;X11=1;AFS=1;;
				$Cna)	;;
				*)	VALID=0;;
				esac
			done

			case $VALID in
			1)	break;;
			esac
			continue
		done

		case "$newsubsets" in
		"")	continue;;
		esac

		case "$UTIL:$root" in
		1:2)
			# utility source is supposed to be installed,
			# but hd2 is the root device
			echo "
WARNING:  The utility source in /usr/src will not be installed,
	  since hd2 has been specified as the root device.
"
			eval $MENU;;
		esac

		case $tape$ATR:$KERNEL$UTIL$DOC$MAN$FONT$LEARN$NOTES$X11$AFS in

		??:000000000)
			subsets="none";;
#
#	Ignore kernel and utility on ATR.
#	Ignore X11 on tape since it's not
#	on the tape.  Ignore AFS on net
#	since it can't be controlled.  It's
#	either on the remote machine, or
#	it's not...
#
		11:??11111?1 | \
		10:1111111?1 | \
		01:??111111? | \
		00:11111111?)
			subsets="all";;

		*)	subsets=
			case $KERNEL in 1) subsets="$subsets kernel" ;; esac
			case $UTIL in 1)   subsets="$subsets utility";; esac
			case $DOC in 1)    subsets="$subsets doc";; esac
			case $MAN in 1)    subsets="$subsets man";; esac
			case $FONT in 1)   subsets="$subsets font";; esac
			case $LEARN in 1)  subsets="$subsets learn";; esac
			case $NOTES in 1)  subsets="$subsets notes";; esac
			case $X11 in 1)    subsets="$subsets x11";; esac
			case $AFS in 1)    subsets="$subsets afs";; esac
			subsets="`echo $subsets`"
			;;
		esac;;

	$Onp)	swap="$net"
		net="$onet"
		onet="$swap";;

	$Osh)	echo -n "Enter source hostname or address: "
		read newhost junk
		case "$newhost" in
		#null, contains space, contains tab
		"" | *' '* | *'	'* )
			echo "'$newhost' is an invalid hostname"
			eval $MENU
			continue;;
		esac
		shost=$newhost;;

	$Oth)	echo -n "Enter target hostname or address: "
		read newhost junk
		case "$newhost" in
		#null, contains space, contains tab
		"" | *' '* | *'	'* )
			echo "'$newhost' is an invalid hostname"
			eval $MENU
			continue;;
		esac
		thost=$newhost;;

	$Oif)	echo -n "
You may enter additional parameters to ifconfig, or enter nothing to
use the default network configuration.

Parameters to ifconfig: "
		read ifconfig;;

	'?')	install.options | page
		eval $MENU;;

	"$ESC")	exit 1;;

	"")	RefreshMenu=0;;

	*)	echo "Invalid option"
		RefreshMenu=0;;

	esac
done

while :
do
	echo -n "Perform installation? [y/n] "

	case "`onechar`" in
	[Yy])	break;;
	[Nn])	exit 1;;

	*)	echo "\
Press 'y' to perform installation, or
      'n' to abort installation.";;
	esac
done

# case $root in
# [0-2]) TEMP="-T hd${root}b";;
# [sS])  TEMP="-T hd0b";;
# esac

case $tape in
0)	PROMPT0=
	PROMPT1=
	;;
1)	PROMPT0='prompt=root/user'
	PROMPT1='prompt=source'
	;;
esac

case $root in
[0-2]) case $AFS:$tape in
       1:1) DISK0="$PROMPT0 hd${root}a=root hd${root}g=user hd${root}a,hd${root}g=afs";;
       *) DISK0="$PROMPT0 hd${root}a=root hd${root}g=user";;
       esac;;
[sS])  case $AFS:$tape in
       1:1) DISK0="$PROMPT0 hd0a=root hd1g=user hd0a,hd1g=afs";;
       *) DISK0="$PROMPT0 hd0a=root hd1g=user";;
       esac;;
esac

case $root in
0)	DISK1="$PROMPT1 hd1g=source";;
[sS1])	DISK1="$PROMPT1 hd2g=source";;
2)	DISK1=;;
esac

KERNEL=0;UTIL=0;DOC=0;NOTES=0;MAN=0;FONT=0;LEARN=0;X11=0;AFS=0
for i in $subsets
do
	case "$i" in
	kernel)	KERNEL=1;;
	utility)
		UTIL=1;;
	doc)	DOC=1;;
	man)	MAN=1;;
	font)	FONT=1;;
	learn)	LEARN=1;;
	notes)	NOTES=1;;
	x11)	X11=1;;
	afs)	AFS=1;;
	all)	KERNEL=1;UTIL=1;DOC=1;NOTES=1;MAN=1;FONT=1;LEARN=1;X11=1;AFS=1;;
	none)	;;
	esac
done

masks=

case $KERNEL:$ATR in
0:? | ?:1)
	masks="$masks -m nokernel";;
esac

case $UTIL:$ATR in
1:0)	;;
*)	DISK1=;;
esac

case $DOC in
0)	masks="$masks -m nodoc";;
esac

case $MAN in
0)	masks="$masks -m noman";;
esac

case $FONT in
0)	masks="$masks -m nofont";;
esac

case $LEARN in
0)	masks="$masks -m nolearn";;
esac

case $NOTES in
0)	masks="$masks -m nonotes";;
esac

case $X11:$tape in
0:0) masks="$masks -m nox11";;
esac

case $output in
terse)		OUTPUT=-q;;
verbose)	OUTPUT=;;
esac

case "$net" in
ether*)	NET=-un;;
token*)	NET=-lan;;
esac

case $ATR in
1)	MISC="-k vmunix.atr"
	NEWFS="-newfs '-n'"
	;;
0)	MISC=
	NEWFS=
	;;
esac

case $config in
minimal|nfsminimal)
	case "`type /dev/rhd${root}c`" in
		hdpses) NEWFS="-newfs '-n -m 0 -b 4096 -f 512 -c 12'";;
		*) NEWFS="-newfs '-n -m 0 -b 4096 -f 512'";;
	esac
	masks=
	DISK0="hd${root}a=minimal"
	DISK1=
	;;

reduced|nfsreduced)
	NEWFS="-newfs '-n'"
	masks="-m nosite"
	DISK0="hd${root}a=root hd${root}g=site"
	DISK1=
	;;

full)	;;
esac

case $tape in
0)	Command="restore.net -config $config -fstab"
	NetOptions="'$NET' -s '$shost' -d '$thost' -ifconfig '$ifconfig' -fsck"
	masks="$masks -m nosupport -m noserver -m nomailconf -m nolocal";;
1)	Command="restore.tape -config $config -fstab"
	NetOptions=;;
esac

case $ATR:$tape in
0:0)	masks="$masks -m noATR";;
1:0)	masks="$masks -m noRT";;
esac

if eval $Command $NetOptions $NEWFS $MISC $TEMP $OUTPUT $masks $DISK0 $DISK1
then
	echo "Installation was successful"
else
	echo "Installation was NOT successful"
fi
exit 0
