/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvd.h 12.0$ */
/* $ACIS:rvd.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/netinet/RCS/rvd.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidrvd = "$Header:rvd.h 12.0$";
#endif



/* Include (header) file for remote virtual disk protocol */
/* Written by M. Greenwald April 1982 */

/* RVD packet format */

#include "../netinet/rvdconst.h"
#ifdef KERBEROS
#include <krb.h>
#endif KERBEROS

/* We only have definitions for locally generated packets */
/* We use constants for the size of incoming types */

#define	RVDPSSACK	12		/* Size of spinack specifif part of */
					/* RVD Packet. i.e. */
					/* sizeof (struct rvd.pkt_dpnd.spinack) */
#define	RVDPSWACK	12		/* sizeof (struct rvd.pkt_dpnd.writeack) */

#define	RVDSACKSZ	sizeof(struct rvdhdr) + RVDPSSACK
#define	RVDBLCKSZ	sizeof(struct rvdb) + RVDDSIZE
#define	RVDWACKSZ	sizeof(struct rvdhdr) + RVDPSWACK

struct rvdhdr {		/* RVD header */
	u_char	rvd_type;		/* RVD packet type */
	u_char	padding[2];		/* Padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	};

struct rvd {
	union	{			/* packet type specific */

		struct	{		/* SPIN-UP packet */
			u_char spad1;	/* RVD packet type */
			u_char mode;	/* opening mode */
			u_char spad;	/* 8 bits of padding */
			u_char version;	/* RVD version */
			} spinhdr;
		struct	{		/* ERROR packet */
			u_char epad1;	/* RVD packet type */
			u_char etype;	/* error type */
			u_char epad;	/* 8 bits of padding */
			u_char version;	/* RVD version */
			} errhdr;
		struct	{		/* All other packet types */
			u_char rvd_type;/* RVD packet type */
			u_char padding[2];/* Padding */
			u_char version;	/* RVD version */
			} allpkt;
		} hdrun;
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	union	{
		u_long	vd_uid;		/* Virtual Disk Unique ID */
		u_long	reserved;	/* Reserved for future use */
	} res_un;
	union	{			/* packet specific definitions */

		struct	{		/* SPIN-UP packet */
			char pname[32];	/* Disk pack name */
			char cpblty[32];/* Capability */
			u_char	f_pad1[3];	/* Padding */
			u_char	br_factor;	/* Read Blocking factor */
			} spinup;
		struct	{		/* RESPIN-UP packet */
			char cpblty[32];/* Capability */
			u_char	f_pad1[3];	/* Padding */
			u_char	br_factor;	/* Read Blocking factor */
			} respinup;
		struct	{		/* SPIN-DOWN packet */
			char spdcpb[32];/* Capability */
			} spindown;
		struct	{		/* READ packet */
			u_long	blockn;	/* Starting block number */
			u_long	blockc;	/* Block count, number of blocks to read */
			} read;
		struct	{		/* WRITE packet */
			u_long	blockn;	/* Block number of this block */
			u_short	blockc;	/* Total number of blocks in this request */
			u_short	bindex;	/* Index of block in request */
			u_long	data[RVDDLONG];
					/* Data block (RVDDSIZE bytes) */
			} write;
		struct	{		/* SPINACK packet */
			u_long	nblocks;/* Number of blocks on drive */
			u_short	burst;	/* Max number of packets server will take in a single burst */
			u_short	qlen;	/* Max number of outstanding requests */
					/* server will handle for this drive */
			u_char	f_pad2[3];	/* Padding */
			u_char	wb_factor;	/* Write blocking factor */
			} spinack;
		struct	{		/* BLOCK packet */
			u_long	blockn;	/* Block number */
			u_long	status;	/* Status of disk */
			u_long	data[RVDDLONG];
					/* Data block (RVDDSIZE bytes) */
			} block;
		struct	{		/* WRITEACK packet */
			u_long	blockn;	/* block number */
			u_long	status;	/* status of drive */
			u_long	bcount; /* number of blocks we are acking */
			} writeack;
					/* Error packet */
		u_long	edata[RVDDLONG];	/* Error dependant data */
		} pkt_dpnd;
	};

struct rvdw {			/* WRITE packet */
	u_char	rvd_type;		/* RVD packet type = RVDWRITE */
	u_char	padding[2];		/* Padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	u_long	blockn;			/* Block number of THIS block */
	u_short	blockc;			/* Total blocks in request */
	u_short	bindex;			/* Index of this block in request */
	u_long	data[RVDDLONG];		/* Data block (RVDDSIZE bytes) */
	};

struct rvdr {			/* READ packet */
	u_char	rvd_type;		/* RVD packet type  = RVDREAD */
	u_char	padding[2];		/* Padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	u_long	blockn;			/* Starting block number */
	u_long	blockc;			/* Block count, number of blocks to read */
	};

struct rvdb {		/* BLOCK packet */
	u_char	rvd_type;		/* RVD packet type = RVDBLOCK */
	u_char	padding[2];		/* Padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	u_long	blockn;			/* Block number */
	u_long	status;			/* Status of disk */
/*	u_long	data[RVDDLONG];		  Data block (RVDDSIZE bytes) */
		/* We don't include data in the packet because we will have
		manually pull it out anyway. This way we can adjust mbuf to
		start of data */
	};

struct rvds {		/* SPINUP packet */
	u_char	rvd_type;		/* RVD packet type  = RVDSPIN */
	u_char	mode;			/* opening mode */
	u_char	padding;		/* 8 bits of padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	char	pname[32];		/* Disk pack name */
	char	cpblty[32];		/* Capability */
	u_char	pad2[3];		/* 24 bits of padding */
	u_char	br_factor;		/* Read blocking factor */
	};

struct rvdas {		/* AUTH-SPINUP packet */
	u_char	rvd_type;		/* RVD packet type  = RVDAUTHSPIN */
	u_char	mode;			/* opening mode */
	u_char	padding;		/* 8 bits of padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	char	pname[32];		/* Disk pack name */
	u_char	pad2[3];		/* 24 bits of padding */
	u_char	br_factor;		/* Read blocking factor */
	u_char	pad3[2];		/* 16 bits of padding */
#ifdef KERBEROS
	struct	ktext authent;		/* Kerberos authenticator */
#endif KERBEROS
	};
#define RVDAS_HDR_SIZE (sizeof(struct rvdas) - sizeof(struct ktext))

struct rvdrs {		/* RESPINUP packet */
	u_char	rvd_type;		/* RVD packet type  = RVDRESPIN */
	u_char	mode;			/* opening mode */
	u_char	padding;		/* 8 bits of padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	vd_uid;			/* Virtual Disk Unique ID */
	char	cpblty[32];		/* Capability */
	u_char	pad2[3];		/* 24 bits of padding */
	u_char	br_factor;		/* Read blocking factor */
	};

struct rvdsd {		/* SPIN-DOWN packet */
	u_char	rvd_type;		/* RVD packet type = RVDSDOWN */
	u_char	padding[2];		/* Padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	char	spdcpb[32];		/* Capability */
	};

struct rvde {		/* ERROR packet */
	u_char	rvd_type;		/* RVD packet type = RVDERROR */
	u_char	etype;			/* error type */
	u_char	epad;			/* 8 bits of padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
/*	u_long	data[RVDDLONG];		/* Error dependant data. Note that
					we don't include it in the packet
					definition so that we can compute the
					length of the received error packet.
*/
	};
