/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 * $Header:os2ioctl.h 12.1$
 * $ACIS:os2ioctl.h 12.1$
 * $Source: /ibm/acis/usr/sys/os2code/RCS/os2ioctl.h,v $
 * Copyright University of Southern California, 1988
 */

/* PCIF Device Driver Ioctl related definitions */

#define USER_CAT	0x80
#define SUB_FUNC	0x1f
#define	QUERY_DEV	0x20
#define PASS_DRIVER	0x40
#define IGNORE_ERROR	0x80

#define PCIF_CAT	USER_CAT + 1

#define PRFX		IGNORE_ERROR | PASS_DRIVER

/*
 * Ioctl commands accepted by the pcif device driver.
 */

/*
 * PCIF
 */
/*
 * Interrupt processing
 */

#define INT_POLL	PRFX | 15		/* wait for Token Ring int */
#define REG_TR_ADAPTERS PRFX | 16		/* register Token Ring
						 * Adapters
						 */
#define REG_UB_ADAPTERS PRFX | 17

/*
 * ROMP Memory Access
 */

#define PCIF_LOCK	PRFX | 19
#define PCIF_UNLOCK	PRFX | 20
#define PCIF_SET_ADDR	PRFX | 21		/* set pcif r_control addr */
#define PCIF_MAP	PRFX | 22		/* map in pcif to user space */
#define PCIF_WAIT	PRFX | 23		/* wait for interrupt */

/*
 * CBCB Access
 */

#define	GETPADDR	PRFX | 13


/* structure for translating a virtual address to a physical address */

struct	cbcb_paddr {
	u_long	    paddr;
};

struct	map_vaddr {
	u_long	    paddr;
	u_short	    size;
};

struct get_pcif_addr {
	u_short	   pcif_addr;
	u_short	   pcif_flag;
};
#define PCIF_MASTER	0x1

/* structure used to register a set of memory mapped token ring adapter
 * card addresses and their interrupt level -- all have to use the
 * same level.
 */
struct reg_tr_adapters {
	u_short	status;		/* result */
	u_short	no_adapters;	/* number of adapters registered */
	struct adap_params {
		u_short	intr_level;	/* interrupt used */
		u_short high;
		u_short low;
	} tr_adap_params[2];
};

/* structure to register UB cards. */
struct reg_ub_adapters {
	u_short	status;
	u_short no_adapters;
	struct ub_adap_params {
		u_short	rom_high;
		u_short	rom_low;
		u_short	rom_size;
		u_short	ram_high;
		u_short	ram_low;
		u_short	ram_size;
	} ub_adap_params[2];
};

