/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:pmap_getmaps.c 12.0$ */
/* $ACIS:pmap_getmaps.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/rpc/RCS/pmap_getmaps.c,v $ */

#ifndef lint
static char *rcsid = "$Header:pmap_getmaps.c 12.0$";
#endif

#if !defined(KERNEL) && !defined(STANDALONE)
#include <sys/nfs_defines.h>
#endif

#ifdef NFS

/* @(#)pmap_getmaps.c	1.3 87/09/02 3.2/4.3NFSSRC */
/* @(#)pmap_getmaps.c	1.2 86/10/28 NFSSRC */
#ifndef lint
static char sccsid[] = "@(#)pmap_getmaps.c 1.1 86/09/24 Copyr 1984 Sun Micro";
#endif

/*
 * pmap_getmap.c
 * Client interface to pmap rpc service.
 * contains pmap_getmaps, which is only tcp service involved
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <rpc/pmap_clnt.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <syslog.h>
#define NAMELEN 255
#define MAX_BROADCAST_SIZE 1400

extern int errno;

/*
 * Get a copy of the current port maps.
 * Calls the pmap service remotely to do get the maps.
 */
struct pmaplist *
pmap_getmaps(address)
	 struct sockaddr_in *address;
{
	struct pmaplist *head = (struct pmaplist *)NULL;
	int socket = -1;
	struct timeval minutetimeout;
	register CLIENT *client;

	minutetimeout.tv_sec = 60;
	minutetimeout.tv_usec = 0;
	address->sin_port = htons(PMAPPORT);
	client = clnttcp_create(address, PMAPPROG,
	    PMAPVERS, &socket, 50, 500);
	if (client != (CLIENT *)NULL) {
		if (CLNT_CALL(client, PMAPPROC_DUMP, xdr_void, NULL, xdr_pmaplist,
		    &head, minutetimeout) != RPC_SUCCESS) {
			openlog("pmap_getmaps", LOG_PID);
			clnt_syslog(client, "pmap_getmaps rpc problem");
			closelog();
		}
		CLNT_DESTROY(client);
	}
	(void)close(socket);
	address->sin_port = 0;
	return (head);
}

#endif
