/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:screen_conf.h 11.1$ */
/* $ACIS:screen_conf.h 11.1$ */
/* $Source: /ibm/acis/usr/sys/standatr/RCS/screen_conf.h,v $ */

#if !defined(lint) && !defined(LOCORE)	&& defined(RCS_HDRS)
static char *rcsidscreen_conf = "$Header:screen_conf.h 11.1$";
#endif

#ifdef NVGA
#include  "ioctl.h"
#include  "tty.h"
#else  /* assume RTPC */
struct tty {
short t_dev;
};				/* dummy tty definition for standalone */
#endif ATR

#define C (char *)

#define SCREEN_SWITCH		-1	/* switch to next routine */
#define SCREEN_SWITCH_RELOAD	-2	/* switch screen and reload */
#define SINGLE_HEAD		-3	/* switching not possible */
#define SAME_CONS		-4	/* switching not necessary */
#define SCREEN_SEARCH		-5	/* check for next w/o initiation */

#ifdef ROUND
#undef ROUND
#endif ROUND
#define ROUND(v,m)	m += ((v % m) ? (m - (v % m)) : 0)
#define E_SLOT(u,v)	for (u = 0; (v & (1<<u)); u++)
#define SET_SLOT(u,v)	(v |= (1<<u))
#define CLEAR_SLOT(u,v) (v &= ~(1<<u))

struct screen_sw {
	char	name[12];
	int	(*probe)();		/* Probe for Screen */
	int	(*init)();		/* Initialize Screen */
	int	(*s_putc)();		/* Put character on Screen */
	int	(*pos_cur)();		/* Position Cursor on Screen */
	int	(*blank)();		/* Blank A section of Screen */
	int	(*move)();		/* Move Some lines on Screen */
	int	(*printscreen)();	/* routine to print screen */
	char	*rwaddr;		/* Read & writeable addr on screen */
	short	lines;			/* Number of lines on screen */
	short	width;			/* Width of screen in characters */
	short	vbits;			/* Vertical number of screen pixels */
	short	hbits;			/* Horizontal number of screen pixels */
	int	flags;			/* some flags about the screen */
	int	def_oute;		/* Default output emulator */
	int	(*init_loc)();		/* Initial Locator on Screen */
	int	(*pos_loc)();		/* Position Locator on Screen */
	int	(*load_loc)();		/* Load the Locator Image */
	int	(*fgbg)();		/* change foreground/background */
	char	*addr;			/* screen base address */
	int	(*restore)();		/* restore the screen after a hot key*/
	short	screenx;		/* screen position */
	short	screeny;
};

/* Character Attributes */
#define NORMAL_VIDEO	0x01
#define REVERSE_VIDEO	0x02
#define UNDERLINE_VIDEO 0x04
#define HI_INTENSITY	0x08
#define BLINK		0x10

/* Color Character Attributes */
#define FOREGROUND_COLOR	0x20
#define BACKGROUND_COLOR	0x40

#ifdef ATR
/* color table values */
#define COLOR_SET		0x00	/* set the color table entry to color */
#define COLOR_FG_INC		0x01	/* increment the fg color table entry */
#define COLOR_FG_DEC		0x02	/* decrement the fg color table entry */
#define COLOR_BG_INC		0x03	/* increment the bg color table entry */
#define COLOR_BG_DEC		0x04	/* decrement the bg color table entry */
#define REVERSE_COLOR		0x05	/* reverse the fg and bg color entries*/
#define CHANGE_DISPLAY_MODE	0x06	/* change display mode		      */
#define ENABLE_BLINK		0x07	/* enable possibility of blink	      */
#define ENABLE_BG_INTENSITY	0x08	/* enable possibility of fg hi intense*/
#define ENABLE_FG_INTENSITY	0x09	/* enable possibility of bg hi intense*/
#endif ATR

/* Define to simplify access to screen-dependent position */
#define screen_x	screen_sw[WS].screenx
#define screen_y	screen_sw[WS].screeny

/* Real hardware addresses for the displays */
#define screen_addr(n) screen_sw[n].addr

/* Defines for calling console screen dependent switched routines */

/* Put character 'c' with attribute 'screen_attr' on console */
#ifdef ATR
/* For the ATR version: save the current PC window
 *			set the window for the screen
 *			call the screen specific putc routine
 *			restore previous window
 */
#define screen_putc(c, screen_attr)				\
		{						\
		char *bndary;					\
								\
		bndary = (char *)get_128_window();		\
		set_128_window(screen_addr(WS));		\
		(*screen_sw[WS].s_putc)(c, screen_attr);	\
		set_128_window(bndary); 			\
		}

#else
#ifdef IBMRTPC
#define screen_putc(c, screen_attr) (*screen_sw[WS].s_putc) (c, screen_attr)
#endif IBMRTPC
#endif ATR

/* Move cursor to x,y position */
#define pos_cursor(x, y) (*screen_sw[WS].pos_cur) (x, y)

/* blank with screen_attribute from start coordinates to end coordinates */
#define screen_blank(s_a, sy, sx, ey, ex) (*screen_sw[WS].blank) (s_a, sy, sx, ey, ex)

/* Macro for blanking a line */
#define blank_line(s_a, line) screen_blank(s_a, line, 0, line, SCREEN_WIDTH-1)

/* move line1 ... line2 to dest */
#define screen_move(l1, l2, dest) (*screen_sw[WS].move) (l1, l2, dest)

/* Initialize screen locator */
#define init_locator() (*screen_sw[WS].init_loc) ()

/* Position screen locator on screen at x,y position */
#define pos_locator(x, y) (*screen_sw[WS].pos_loc) (x, y)

/* Load a new screen locator discription */
#define load_locator(c) (*screen_sw[WS].load_loc) (c)

/* Set FOREGROUND or BACKGROUND color */
#define fg_bg(attr, type) (*screen_sw[WS].fgbg) (attr, type)

/* put_status and print_screen are procedures in ../machine/screen_conf.c */

#define NO_ENTRY	CONS_DUMMY
struct emul_info {
	int emulator;		/* Which Emulator is currently in use */
	int unit;		/* Emulator info unit */
	struct proc *rsel;	/* Process waiting for select */
	short flag;		/* Emulator Flags */
	short intr_reason;	/* Reason for interrupt to emulator */
};
typedef struct emul_info EMUL_INFO;


struct screen_info {
	int screen_inited;	/* Is screen initialized */
	int which_screen;	/* Which screen is currently in use */
	int moved_screen;	/* Which, if any, screen was moved */
	struct emul_info ine;	/* Input Emulator */
	struct emul_info oute;	/* Output Emulator */
	struct emul_info mse;	/* Mouse Emulator */
};
typedef struct screen_info SCREEN_INFO;

/* General Defines for emulators to use with the screen_sw structure */
#define WS		si->which_screen
#define MS		si->moved_screen
#define SCREEN_LENGTH	(screen_sw[WS].lines)
#define SCREEN_WIDTH	(screen_sw[WS].width)
#ifdef SCREEN_SIZE
#undef SCREEN_SIZE
#endif SCREEN_SIZE
#define SCREEN_SIZE	(SCREEN_LENGTH * SCREEN_WIDTH)
#define STATUS_LINE	(SCREEN_LENGTH - 1)

#define CON_SELECT_SCREEN	_IOWR(c,0,int)
#define CON_GET_SCREEN		_IOR(c,1,int)
#define EIGETD			_IOR(c,2,int) /* get input emul discipline number */
#define EOGETD			_IOR(c,3,int) /* get output emul discipline number */
#define EMGETD			_IOR(c,4,int) /* get Mouse emulator discipline number */
#define EISETD			_IOWR(c,5,int) /* set input emulator line discipline */
#define EOSETD			_IOWR(c,6,int) /* set output emulator line discipline */
#define EMSETD			_IOWR(c,7,int) /* set mouse emulator line discipline */
#define CON_INIT_SCREEN 	_IOW(c,8,int)

/*
 * color defines (keeps the vga happy)
 */
#define	SCREEN_RED	2
#define	SCREEN_TYPE_NONE	0
#define	SCREEN_TYPE_MONO	1
#define	SCREEN_TYPE_COLOR	2
/* Emulator structures and Definitions */
/*
 * Emulator line control switch.
 */
struct emulsw
{
	int	(*e_open)();
	int	(*e_close)();
	int	(*e_read)();
	int	(*e_write)();
	int	(*e_ioctl)();
	int	(*e_rint)();
	int	(*e_putc)();
	int	(*e_select)();
	int	(*e_putstatus)();	/* to put up status information */
};

typedef struct
{
	short	data[16];
	short	mask[16];
	struct {
		short v, h;
	} hotSpot;
} QIOLocator;

/* Defines for EMUL_INFO structure intr_reason flag */
#define E_INT_KBD	1		/* Keyboard data */
#define E_INT_MOUSE	2		/* Mouse data */

/* Defines for Emulator indexes */
#define E_STDINPUT	0
#define E_STDOUTPUT	1
#define E_IBMOUTPUT	2
#define E_MSINPUT	3
#define E_BUFFER	4
#define E_FORWARD	5
#define E_WMOUTPUT	6


/* Defines for symbolic minor devices on consoles for emulator(s) selection */
#define CE_DEFAULT	0	/* Must be 0 for standard configuration */
#define CE_WM		1	/* Generic window manager emulators */

#define NCONSEMULS	2	/* Must be the number of symbolic devices */

#if defined(KERNEL) || defined(STANDALONE)
struct screen_sw screen_sw[];
#endif

/* hardware access switch table */
struct screendev_sw
{
	int	(*h_open)();
	int	(*h_close)();
	int	(*h_read)();
	int	(*h_write)();
	int	(*h_ioctl)();
};

#define lp_pos_cursor(col,line,dev)	(((line)*screen_sw[(dev)].width)+(col))
#include "consio.h"
