/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:aedtty.h 12.0$ */
/* $ACIS:aedtty.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/aedtty.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidaed_tty = "$Header:aedtty.h 12.0$";
#endif

#ifdef ATR
/*
 * since the AED is at a fixed address we can optimize the aedrd
 * macros (once the 128k window is set we just use the offset)
 */
#define AED_MMAP	0x0a0000
#define AED_ENTER(xxx)	int window = get_128_window(); \
	xxx set_128_window(AED_MMAP);
#define AED_EXIT()	set_128_window(window)
#define aedrd(X,Y,Z) aed_rd(Z, X, Y)
#define aedwr(X,Y,Z) aed_wr(X, (Z), Y)
#define MASK_128K	0x1ffff
char *aedbase = (char *) (AED_MMAP & MASK_128K);

#else

#define AED_MMAP	0xf40a0000
#define AED_ENTER(xxx)
#define AED_EXIT()
#define aedrd(X,Y,Z) bcopy(AED_MMAP+Z, X, Y+Y)
#define aedwr(X,Y,Z) bcopy(X, (AED_MMAP+Z), Y+Y)
char *aedbase = (char *)AED_MMAP;
#endif ATR

#define AED_DELAY	DELAY(2)


#define term_mode	0x0200
#define setup_mode	0x0300
#define data_port	0x4000
#define status_port	0x4002

short *aed_data;
short *aed_status;
extern int delay_count;

#define AEDTMO (delay_count*256)
static  aed_to = 0;

#define vinit() aed_data = (short *)(aedbase + data_port);

#define vwait()	{register int tmo = aed_to ? 1: AEDTMO;\
			while (GET_PC2B(*aed_data)) {\
				if(tmo-- < 0) {\
					if(aed_screen_init()) {\
						aed_to = 1; \
						break;\
					}\
					tmo = AEDTMO;\
					aed_to = 0; \
				}\
				AED_DELAY; \
			} }
#define vterm(c)	{ \
			vwait(); \
			AED_DELAY;\
			PUT_PC2B(*aed_data, (term_mode | c)); \
			AED_DELAY;}

#define vsetup(c)	{ vwait();\
			AED_DELAY;\
			PUT_PC2B(*aed_data, (setup_mode | c)); \
			AED_DELAY; }
