/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:init_main.c 12.0$ */
/* $ACIS:init_main.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/sys/RCS/init_main.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header:init_main.c 12.0$";
#endif

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)init_main.c	7.1 (Berkeley) 6/5/86
 */

#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "dir.h"
#include "user.h"
#include "kernel.h"
#ifndef VFS
#include "fs.h"
#include "mount.h"
#else !VFS
#include "../h/vfs.h"
#endif !VFS
#include "map.h"
#include "proc.h"
#ifndef VFS
#include "inode.h"
#endif !VFS
#include "seg.h"
#include "conf.h"
#include "buf.h"
#include "vm.h"
#include "cmap.h"
#include "text.h"
#include "clist.h"
#ifdef VFS
#include "vnode.h"
#endif VFS
#include "protosw.h"
#ifndef VFS
#include "../h/quota.h"
#else !VFS
#ifdef QUOTA
#include "../ufs/quota.h"
#endif QUOTA
#endif !VFS
#include "../machine/reg.h"
#include "../machine/cpu.h"

#if	defined(ibm370)

#include	"../ibm370/kdebug.h"
#include	"../qm/service_calls.h"
#include	"../qm/qmparms.h"
#include	"../qm/qmm.h"

/* was defined in systm.h, but is only referenced here */
extern int icode[];		/* user init code */
extern int szicode;		/* its size */

#endif	/* defined(ibm370) */

int	cmask = CMASK;

/*
 * Initialization code.
 * Called from cold start routine as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	turn on clock
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	     - process 1 execute bootstrap
 *	     - process 2 to page out
 */
main(firstaddr)
	int firstaddr;
{
	register int i;
	register struct proc *p;
#ifndef VFS
	struct fs *fs;
#endif !VFS
	int s;

	rqinit();
#include "loop.h"
	startup(firstaddr);

	/*
	 * set up system process 0 (swapper)
	 */
	p = &proc[0];
	p->p_p0br = u.u_pcb.pcb_p0br;
	p->p_szpt = 1;
#if	!defined(ibm370)
	p->p_addr = uaddr(p);
#else	/* !defined(ibm370) */
	p->p_addr = 0;
#endif	/* !defined(ibm370) */
	p->p_stat = SRUN;
	p->p_flag |= SLOAD|SSYS;
	p->p_nice = NZERO;
#if	!defined(ibm370)
	setredzone(p->p_addr, (caddr_t)&u);
#endif	/* !defined(ibm370) */
#ifdef ibm032
	dumpsave();		/* save registers for online debugger */
#endif ibm032
	u.u_procp = p;
#if defined(vax) || defined(ibm032) || defined(ibm370)
	/*
	 * These assume that the u. area is always mapped 
	 * to the same virtual address. Otherwise must be
	 * handled when copying the u. area in newproc().
	 */
#ifndef VFS
	u.u_nd.ni_iov = &u.u_nd.ni_iovec;
#endif !VFS
	u.u_ap = u.u_arg;
#endif
#ifndef VFS
	u.u_nd.ni_iovcnt = 1;
#endif !VFS
	u.u_cmask = cmask;
	u.u_lastfile = -1;
#ifdef VFS
	/*
	 * initialize kernel memory allocator
	 */
	kmem_init();

	/*
	 * get vnodes for swapdev and argdev
	 */
	swapdev_vp = bdevvp(swapdev);
	argdev_vp = bdevvp(argdev);
	rootvp = bdevvp(rootdev);

	/*
	 * Setup credentials
	 */
	u.u_cred = crget();
#endif VFS
	for (i = 1; i < NGROUPS; i++)
		u.u_groups[i] = NOGROUP;
	for (i = 0; i < sizeof(u.u_rlimit)/sizeof(u.u_rlimit[0]); i++)
		u.u_rlimit[i].rlim_cur = u.u_rlimit[i].rlim_max =
		    RLIM_INFINITY;
	/*
	 * configure virtual memory system,
	 * set vm rlimits
	 */
	vminit();
#if	!defined(ibm370)
#if defined(QUOTA)
	qtinit();
#ifndef VFS
	p->p_quota = u.u_quota = getquota(0, 0, Q_NDQ);
#endif !VFS
#endif
	startrtclock();
#endif	/* !defined(ibm370) */
#if	!(defined(ibm032) || defined(ibm370))
#include "kg.h"
#if NKG > 0
	startkgclock();
#endif
#endif /* !(defined(ibm032) || defined(ibm370)) */

	/*
	 * Initialize tables, protocols, and set up well-known inodes.
	 */
	mbinit();
	cinit();
#if	defined(ibm370)
	configure();			/* After mbinit, we may configure */
#endif	/* defined(ibm370) */
#include "sl.h"
#if NSL > 0
	slattach();			/* XXX */
#endif
#if NLOOP > 0
	loattach();			/* XXX */
#endif
	/*
	 * Block reception of incoming packets
	 * until protocols have been initialized.
	 */
	s = splimp();
	ifinit();
	domaininit();
	splx(s);
	pqinit();
	xinit();
	ihinit();
	bhinit();
	binit();
#if	!defined(ibm370)
	bswinit();
#endif	/* !defined(ibm370) */
#ifndef VFS
	nchinit();
#else !VFS
	dnlc_init();
#endif !VFS
#ifdef GPROF
	kmstartup();
#endif

#ifndef VFS
#ifdef ROROOT		/* if root might be read-only */
	fs = mountfs(rootdev, rootdev == rorootdev, (struct inode *)0);
#else
	fs = mountfs(rootdev, 0, (struct inode *)0);
#endif ROROOT
	if (fs == 0)
		panic("iinit");
	bcopy("/", fs->fs_fsmnt, 2);

	inittodr(fs->fs_time);
#else !VFS
	/*
	 * mount the root, gets rootdir
	 */
	vfs_mountroot();
#endif !VFS
	boottime = time;

/* kick off timeout driven events by calling first time */
	roundrobin();
	schedcpu();
#if	!defined(ibm370)
	schedpaging();
#endif	/* !defined(ibm370) */

#ifndef VFS
/* set up the root file system */
	rootdir = iget(rootdev, fs, (ino_t)ROOTINO);
	iunlock(rootdir);
	u.u_cdir = iget(rootdev, fs, (ino_t)ROOTINO);
	iunlock(u.u_cdir);
	u.u_rdir = NULL;
#endif !VFS

#ifdef VICE
	u.u_rmtWd.dev = NODEV;
#endif

#if	!defined(ibm370)
	u.u_dmap = zdmap;
	u.u_smap = zdmap;

	/*
	 * make init process
	 */

	proc[0].p_szpt = CLSIZE;
	if (newproc(0)) {
		expand(clrnd((int)btoc(szicode)), 0);
		(void) swpexpand(u.u_dsize, (size_t)0, &u.u_dmap, &u.u_smap);
		(void) copyout((caddr_t)icode, (caddr_t)0, (unsigned)szicode);
		/*
		 * Return goes to loc. 0 of user init
		 * code just copied out.
		 */
		return(0);
	}
	/*
	 * make page-out daemon (process 2)
	 * the daemon has ctopt(nswbuf*CLSIZE*KLMAX) pages of page
	 * table so that it can map dirty pages into
	 * its address space during asychronous pushes.
	 */
#ifdef ibm032
	proc[0].p_szpt = clrnd(ctopt(nswbuf*CLSIZE*KLMAX + HIGHPAGES));
#else
  	proc[0].p_szpt = clrnd(ctopt(nswbuf*CLSIZE*KLMAX + UPAGES));
#endif
	if (newproc(0)) {
		proc[2].p_flag |= SLOAD|SSYS;
		proc[2].p_dsize = u.u_dsize = nswbuf*CLSIZE*KLMAX; 
		pageout();
		/*NOTREACHED*/
	}

	/*
	 * enter scheduling loop
	 */
	proc[0].p_szpt = 1;
	sched();
#else
	/*
	 * make page-out daemon (process 2)
	 * the daemon has ctopt(nswbuf*CLSIZE*KLMAX) pages of page
	 * table so that it can map dirty pages into
	 * its address space during asychronous pushes.
	 */
	mpid = 1;
  	proc[0].p_szpt = clrnd(ctopt(nswbuf*CLSIZE*KLMAX + UPAGES));
	proc[1].p_stat = SZOMB;		/* force it to be in proc slot 2 */
	if (newproc(0)) {
		proc[2].p_flag |= SLOAD|SSYS;
		proc[2].p_dsize = u.u_dsize = nswbuf*CLSIZE*KLMAX;
		QMERRCHECK("qmm_release proc 2",
		    qmm_release (USRTEXT, USRCXAEND - USRTEXT));

		startrtclock();		/* Start up clock interrupts */

		proc[2].p_stat = SSLEEP;	/* force us to sleep */

		(void)spl0();
		swtch();	/* A-P1 for now */
		/*
		 * swtch calls qmp_block
		 * so there should be no return for now
		 */
		panic("init_main: qmp_block");
		/*NOTREACHED*/
	}

	/*
	 * make init process and
	 * enter scheduling loop
	 */

	mpid = 0;
	proc[1].p_stat = 0;
	proc[0].p_szpt = CLSIZE;
	if (newproc(0)) {
		/* release space occuppied by captain and pry */
		QMERRCHECK("qmm_release proc 1",
		    qmm_release (USRTEXT, USRCXAEND - USRTEXT));
		expand(clrnd((int)btoc(szicode)), 0);
		/*
		 * copy icode from kernel to user space
		 */
		(void) copyout ( (caddr_t)icode,
				 (caddr_t)USRTEXT,
				 (unsigned)szicode );
		expand(clrnd((int)btoc(1)), 1);
		/*
		 * copy cxa from kernel to user space
		 */
		cxacopy();
		
		return(1);	/* A-P1 returns process number */
	}
	proc[0].p_szpt = 1;
	return(0);			/* A-P1 returns process number */
#endif	/* defined(ibm370) */
}

/*
 * Initialize hash links for buffers.
 */
bhinit()
{
	register int i;
	register struct bufhd *bp;

	for (bp = bufhash, i = 0; i < BUFHSZ; i++, bp++)
		bp->b_forw = bp->b_back = (struct buf *)bp;
}

/*
 * Initialize the buffer I/O system by freeing
 * all buffers and setting all device buffer lists to empty.
 */
binit()
{
	register struct buf *bp, *dp;
	register int i;
#if	!defined(ibm370)
	struct swdevt *swp;
	int base, residual;
#endif	/* !defined(ibm370) */

	for (dp = bfreelist; dp < &bfreelist[BQUEUES]; dp++) {
		dp->b_forw = dp->b_back = dp->av_forw = dp->av_back = dp;
		dp->b_flags = B_HEAD;
	}
#if	!defined(ibm370)
	base = bufpages / nbuf;
	residual = bufpages % nbuf;
#endif	/* !defined(ibm370) */
	for (i = 0; i < nbuf; i++) {
		bp = &buf[i];
		bp->b_dev = NODEV;
		bp->b_bcount = 0;
		bp->b_un.b_addr = buffers + i * MAXBSIZE;
#if	!defined(ibm370)
		if (i < residual)
			bp->b_bufsize = (base + 1) * CLBYTES;
		else
			bp->b_bufsize = base * CLBYTES;
#else	/* !defined(ibm370) */
		bp->b_bufsize = MAXBSIZE;	/* Everything in real memory */
#endif	/* !defined(ibm370) */
		binshash(bp, &bfreelist[BQ_AGE]);
		bp->b_flags = B_BUSY|B_INVAL;
		brelse(bp);
	}
#if	!defined(ibm370)
	/*
	 * Count swap devices, and adjust total swap space available.
	 * Some of this space will not be available until a vswapon()
	 * system is issued, usually when the system goes multi-user.
	 */
#ifdef VFS
	swapconf();
#endif VFS
	nswdev = 0;
	nswap = 0;
	for (swp = swdevt; swp->sw_dev; swp++) {
		nswdev++;
		if (swp->sw_nblks > nswap)
			nswap = swp->sw_nblks;
	}
	if (nswdev == 0)
		panic("binit");
	if (nswdev > 1)
		nswap = ((nswap + dmmax - 1) / dmmax) * dmmax;
	nswap *= nswdev;
	/*
	 * If there are multiple swap areas,
	 * allow more paging operations per second.
	 */
	if (nswdev > 1)
		maxpgio = (maxpgio * (2 * nswdev - 1)) / 2;
	swfree(0);
#endif	/* !defined(ibm370) */
}

#if	!defined(ibm370)
/*
 * Initialize linked list of free swap
 * headers. These do not actually point
 * to buffers, but rather to pages that
 * are being swapped in and out.
 */
bswinit()
{
	register int i;
	register struct buf *sp = swbuf;

	bswlist.av_forw = sp;
	for (i=0; i<nswbuf-1; i++, sp++)
		sp->av_forw = sp+1;
	sp->av_forw = NULL;
}
#endif	/* !defined(ibm370) */

/*
 * Initialize clist by freeing all character blocks, then count
 * number of character devices. (Once-only routine)
 */
cinit()
{
	register int ccp;
	register struct cblock *cp;

	ccp = (int)cfree;
	ccp = (ccp+CROUND) & ~CROUND;
	for(cp=(struct cblock *)ccp; cp < &cfree[nclist-1]; cp++) {
		cp->c_next = cfreelist;
		cfreelist = cp;
		cfreecount += CBSIZE;
	}
}
