# Filename: cat.awk
#
# Input file 
# 	sorted and generated by devinfo.awk
#
#   CABINET <cabNum> BP <A|B|C|D> S <slotNum> <DeviceDescription>
#   Sample entries:
#
#  			 Fields
#	   1      2    3    4   5   6     7        8
# 
#	CABINET   00   BP   A   S   00   RAID5 
#	CABINET   00   BP   A   S   02   MIO      I04
#	CABINET   00   BP   A   S   07   ENET 
#	CABINET   00   BP   D   S   03   DISK      MAXTOR1240
#	CABINET   00   BP   D   S   03   RAID5 
#	CABINET   00   BP   D   S   03   TAPE      DAT
#
# Output file format
#	Concatenates multiple device names for a given slot on a bp
#	and outputs them one per cabinet
#
# Modification History:
#
# $Log: cat.awk,v $
# Revision 1.4  1994/07/27  21:13:07  mouli
# Added support for 2 row.
#
# Revision 1.3  1993/12/20  19:41:20  mouli
# Added support for NOPAGER and PAGE_TO keywords.
#
# Revision 1.2  1993/03/18  21:23:36  mouli
# 1. Modified to output cable label numbers instead of backplane numbers.
# 2. Added outputting the 8th field of the input file which could be one of
#    {device brand name, fab-rev, symbolic name}
#
# Revision 1.1  1993/03/12  01:31:18  mouli
# Initial revision
#
# 	03/09/93	mouli	Initial version
#
BEGIN {
	lastcab = -1
	lastbp = ""
	lasts = -1
	first = 1
}
{
	if ($1 == "CABINET")
	{
		curcab = int($2)
		curbp = $4
		curs = int($6)
		if ((curcab == lastcab) && (curbp  == lastbp)  && (curs   == lasts))
		{
#			printf " %s %s", $7, $8
			for (f = 7; f <= NF; f++)
				printf " %s", $f
			printf " "
		}
		else 
		{
			if (first != 1)
			{
				printf "\n"
			}
			else first = 0
			for (f = 1; f <= NF; f++)
				printf "%s ", $f
		}
		lastcab = curcab
		lastbp = curbp
		lasts = curs
	}
	else if ($1 == "CAB_ROWS")
	{
		printf "\nCABINET 00 %s\n",$0
	}
}
END {
	printf "\n"
}
