/*
 * iRMX86vlab.h
 *	iRMX 86 Volume Label Definitions for Xenix.
 *
 * This is used to keep a Xenix Volume close enough to RMX 86 to
 * allow use of various RMX 86 technology (ie, PROM bootstrap drivers).
 *
 * Written by Paul Pierce, 9-21-79.
 * Modified from ivlab.lit by Bob Beck, 2-24-82.
 */

struct	vlabRMX86 {
	char	v_name[10];		/* volume name, blank padded */
	char	v_flags;		/* flags byte -- see below */
	char	v_fdriver;		/* file-driver number */
	int	v_gran;			/* volume-gran (bytes) */
	long	v_size;			/* size (bytes) of volume */
	int	v_maxfnode;		/* max fnode # (0 on Xenix) */
	long	v_stfnode;		/* start byte # of fnodes (0 on xenix) */
	int	v_szfnode;		/* size (bytes) of fnode (0 on xenix) */
	int	v_rfnode;		/* root fnode # (0 on xenix) */
	int	v_devgran;		/* sector size (bytes) */
	int	v_intl;			/* interleave; 0 ==> unknown */
	int	v_trskew;		/* track skew; 0 ==> none */
	int	v_sysid;		/* OS id for OS that formatted volume */
	char	v_sysname[12];		/* OS name (as above), blank filled */
	char	v_dspecial[8];		/* device-special info (for 215, a drtab entry) */
};

#define	VLAB_START	384		/* byte # of volume label */
#define	VLAB_FLOFF	10		/* flags field offset (for boot) */

/*
 * Flags byte definitions.
 */

#define	VF_AUTO		0x01		/* 1 ==> byte is valid */
#define	VF_DENSITY	0x02		/* 0 = FM, 1 = MFM */
#define	VF_SIDES	0x04		/* 1 = double-sided */
#define	VF_MINI		0x08		/* 0 = 8", 1 = 5.25" */
#define	VF_NOT_FLOPPY	0x10		/* 0 = floppy track 0 is 128 SD, 1 = not floppy */

/*
 * Misc. other defintions.
 */

#define	XENIX_FD	5		/* Xenix "file-driver" number; just to be different from RMX86 */
#define	XENIX_SID	0x0030		/* Xenix "system-id" (as above) */

/*
 * The bootstrap 2nd stage is split across the RMX volume label.
 * These constants define where the break occurs and where it resumes.
 * The 2nd stage is unaware of the split (ie, it must compress itself).
 */

#define	BOOT_BREAK	VLAB_START		/* where split occurs */
#define	SZRMXLAB	128			/* how big is it? */
#define	BOOT_RESUME	VLAB_START+SZRMXLAB	/* where boot code resumes */

/*
 * Sector offsets to start of file-system for bootstrap.
 * These cause the boot to skip track 0, other than for the bootstrap.
 * Note that only 256-byte boot floppy is supported until after RMX 86 Release 5
 * boot-proms are available.
 */

#define	FSS_WINI	12		/* wini skips 12 1K sectors */
#define	FSS_FLOPPY	13		/* floppy skips 13 256-byte sectors */
