.nr H1 0
.H 1 "Introduction"
.PH ''XENIX~Operations~Guide''
This guide is intended to help you get the \*(x1* 
.FS *
\*(x2 is a Trademark of Microsoft Corporation.
.FE
system running on your computer, 
and keep the system healthy. 
Even if you have never used the \*(x1 system, or for that matter, any other 
computer operating system before,
it will give you enough information x1 to give you confidence in your
role as system manager.  
Each section provides directions for carrying out the procedures
for which you will be responsible, along with an overview of \*(x1 system 
concepts. 
These procedures have been designed to make your job as easy as possible.
If you read the instructions carefully, you should have little difficulty
in maintaining your \*(x1 system.
This introduction defines the role of the system manager
and describes what you get in your \*(x1 distribution package.
.P
Since the system manager's job is a crucial one with many aspects, 
you should learn as much as you can about the \*(x1 system.
By the time you have finished this guide and feel comfortable with the
tasks described here, you should be able to use a number of basic \*(x1
commands successfully. 
This guide is designed to get you going with your \*(x1 system without
any prior experience, and without needing to refer to other, more detailed
documentation.
Ideally, however, 
you should begin to develop an understanding of the 
following, in order to make you more efficient in your work:
.BL
.LI
the \*(x1 file structure--the way in which the \*(x1 programs, as well as the 
data and programs you and other users add, are organized on the system.
.LI
the command language of the \*(x1 \*`shell\*', 
which you will be using to communicate with \*(x1,
a powerful tool for increasing your productivity on the system.
.LI
at least one of the \*(x1 text editors, so that you can make additions and
changes to important system files.
.LE
.sp
Some basic information about these \*(x1 features is provided in the next
chapter.
However, as you gain more experience with \*(x1, you will want to read
the
.I
\*(x1 Fundamentals
.R
manual so that you will be able to use the features of the \*(x1 system
more fully. 
To do this, there is no substitute for reading the documentation carefully,
and trying out the examples given in the tutorials. 
You may also want to refer to the
.I
\*(x1 System Reference
.R
manual when you have questions about how to use particular \*(x1 commands.
.H 2 "The Role of the System Manager"
You may have heard the term \*`system manager\*' or \*`system administrator\*'
used to describe the person who has the overall responsibility for 
the health and welfare of a computer system.
On a large computer this is often a full time job for one or more people.
On your system, of course, you may have only a few users, or you may
even be your own system manager. 
This will make your job considerably less time-consuming, but no less critical.
Your tasks will include 
.BL
.LI
the initial installation of the \*(x1 system 
.LI
adding and removing user accounts, passwords, and file systems
.LI
ensuring that system resources are efficiently distributed 
.LI
\*`backing up\*' or making copies of all files on the system
to guard against the loss of programs and data, in case of user 
or hardware errors. 
.LE
.P
You will need to manage a library of floppy disks and other 
storage media containing system backups, user files, and application
programs. 
In addition, you may also be called upon to give training and support to 
new users and
deal with hardware and software suppliers if problems develop.
.P
Sometimes your job may make you unpopular with your users. 
For example, you may have to interrupt users for scheduled backups or keep 
reminding them to remove their little-used files from an overcrowded disk. 
On the other hand, doing your job well will result in an efficiently 
running system with productive, rather than frustrated, users. 
You will also be minimizing potentially time-consuming and 
expensive losses of programs, data, and text.
.H 2 "The XENIX System"
Like any other operating system, the \*(x1 system is a collection of programs 
which are 
resident in a computer at all times and are designed to control its resources.
These programs make possible communication between the central processor, 
input/output devices (such as line printers and terminals), and storage devices 
(including hard and floppy disk drives).  
These programs also control the user's access to the files on the system, 
and determine what share of processing time each program will get.
An operating system ensures processing time and disk space will be fairly
distributed among users. 
.H 2 "Hard Disk vs. Floppy-Only Systems"
The \*(x2 system is derived from \*(u1* 
.FS *
\*(u2 is a Trademark of Bell Laboratories, Inc.
.FE
operating system software developed by Bell
Laboratories a number of years ago and widely used on larger computer systems.
The \*(x2 system is a multi-user and multi-tasking system.  
That is, it allows more than one user simultaneous access to the computer's 
resources, and allows more than one process or program to run at the same time.
In most respects, your \*(x1 system is identical to those on
much larger and more expensive systems. 
However, the extent to which you are able to utilize its features will
depend somewhat on the size and characteristics of your hardware components.
Naturally, several users will be unable to work simultaneously unless
you have several terminals attached to your system. However, with \*(x1
you will still be able to create separate accounts and file storage areas for 
different users to access at different times.
More important from the system's point of view, however, is the total 
size of the disk resources available to you. 
If your system is equipped with a hard disk as well as 
one or more floppy disk drives, you will experience few limitations. 
.P
In the chapters which follow, it is generally assumed that you are working
with a system equipped with a hard disk and that you have several users,
although many of the same procedures also apply to single-user environments.
If you are using a \*(x1 system without a hard disk, you should turn 
immediately to the special instructions provided with your floppy-disk
based system. 
.H 2 "Outline of This Guide"
Since the
.I
\*(x1 Operations Guide
.R
is directed at the user who is responsible for maintaining a healthy
\*(x1 system, the chapters are organized by the type of maintenance
task the system manager will need to perform:
.VL 10
.LI "Chapter 1: Introduction"
.br
The chapter you are now reading.
.LI "Chapter 2: A First Look at Your \*(x1 System"
.br
Although by no means an exhaustive introduction to the \*(x1 system, this
chapter is intended to provide you with sufficient information 
in order to get you started as a \*(x1 system manager.
.LI "Chapter 3: Getting the System Ready for Your Users"
.br
This chapter explains how to create, change, and remove user accounts
on your \*(x1 system. 
.LI "Chapter 4: Controlling Access to Files and Directories"
.br
This chapter explains how the \*(x1 system restricts the use of particular files
and directories on your system with \*`permissions\*' settings.
It also explains the following system maintenance tasks:
.DL
.LI
how to establish and change permission settings
.LI
how to create and change group ID's
.LI
how to determine file ownership and change it
.LI 
how to deal with system security
.LE
.LI "Chapter 5: Keeping Your System Healthy"
.br
This chapter explains some of the system's self-checking processes, and tells 
you how to manage the critical resource of disk space with some routine 
maintenance procedures.
.LI "Chapter 6: Backing Up Your System"
.br
This chapter explains one of the system manager's most critical tasks: 
periodically making copies of everything on the system, to guard against
the accidental loss of important programs and data.
It also explains how to format and copy floppy disks, and how to make
copies of user files from the hard disk to a floppy disk. 
.LI "Chapter 7: Common System Problems"
.br
This chapter explains what to do if things do not run smoothly.
Instructions are provided for solving some common system problems.  
.LI "Glossary"
.br
The glossary contains definitions of some common terms relating to
\*(x1 system operation.
.LI "Appendix A: \*(x1 Files and Directories"
.br
This appendix provides a roadmap to \*(x1 system files and directories.
.LI "Appendix B: The Multi-user System"
.br
This appendix explains some of the special problems of an environment
with multiple users or several \*(x1 systems. 
.LI "Appendix D: Maintenance Command Summary"
.br
This appendix provides you with a handy summary of those commands you
will be using often as system manager.
.LE 
.TC
