.nr H1 1
.H 1 "A First Look at XENIX"
.PH ''XENIX~Operations~Guide''
Once you have installed \*(x1 on your system, you are ready to begin
working.
If you have never used a \*(x1 system before, this chaper will introduce
you to some essential \*(x1 concepts, and teach you a few basic commands.  
This information should be sufficient to get you started as a system
manager, but if you are planning to use \*(x1 extensively, you should
turn to the
.I
\*(x1 Fundamentals
.R
manual for a full description of \*(x1 commands and utilities.
This chapter contains information about:
.BL
.LI
the use of your terminal keyboard
.LI
the \*(x1 file and directory naming conventions and structure
.LI
the \*(x1 shell and how to use \*(x1 commands
.LI
the most commonly used \*(x1 commands
.LI
the \*(x1 text editor, 
.B ed.
.LE
.H 2 "A Word About Your XENIX System"
This chapter will provide you with an overall introduction to the use
of the \*(x1 system. 
Even if you have some experience working with microcomputer operating
systems, there are some aspects of \*(x1 you may find unique. 
If you are a newcomer to the \*(x1 System, or the \*(u1
operating system software from which \*(x1 is derived,
there are several special features of the system you will
want to become familiar with before you begin working.
.P
In many respects, using the \*(x1 system is like working with a much
larger computer. 
Although you have the illusion that you are the only one
working with the system, 
\*(x1 is, in fact, a multi-user operating system. 
That is, if your computer is equipped with extra terminals and at
least one hard disk drive, it will support several users simultaneously.
Normally, unless you specify otherwise, you will not see any evidence of
other users' work at your terminal.
On the other hand,
if you have only one terminal, the \*(x1 system still provides
individual user accounts and a facility for restricting access to different
users' files, to allow for privacy and security.
Procedures for creating user accounts and setting permissions
are described in Chapter 4, \*`System Access and Security\*'. 
Techniques for using these \*(x1 features to your advantage are also presented. 
.P
The way in which the \*(x1 system orders
the information that you keep on the system is introduced in this chapter. 
Your data is organized into files, which are arranged hierarchically in
system directories.
This gives the user great flexibility in organizing information logically
and efficiently.	 
.P
Another way in which the \*(x1 system is unusual is its capacity to allow
you to do several things at once--compile programs, run application
programs, edit and process text files.
This feature, refered to as multi-tasking, can be a powerful enhancement
to your productivity.
In order to take full advantage of it, you will want to learn as much
as possible about the \*(x1 shell, a command language which allows you
to run several processes simultaneously, write \*`scripts\*' for
doing complex sequences of tasks, and run programs while leaving your
terminal free for other work.  
An introduction to \*(x1 shell features is provided later on in this chapter
.P
Besides being an environment in which to run your own application software,
The \*(x1 system also offers a wide range of system utilities, and specialized
software development and text processing software.
This chapter will only introduce you to a few of the most commonly used
\*(x1 commands, just to get you started with the system.
To learn more about your \*(x1 system, read the
.I
\*(x1 Fundamentals 
.R
manual.
.H 2 "Some Preliminaries"
Before you can work successfully with your \*(x1 system, there are a
few things you will have to know about how to communicate with it.
In particular, you will have to know how to use the keys on your terminal
keyboard, a few rules about \*(x1 file naming conventions, and how to
correctly enter commands on the system so that you can get \*(x1 to do
what you want. 
.H 3 "Your Keyboard"
First, let's
take a brief look at your terminal keyboard.
In most respects, the keyboard of your terminal is exactly like that
of a typewriter.
Most of the letters, numerals, and punctuation marks are in the same place,
and you will quickly discover that the \*`spacebar\*', \*`backspace\*', 
\*`repeat\*',
and \*`shift\*' keys behave in much the same way as they would on any 
typewriter. 
However, there are a few differences you should be aware of before you begin
working.
You may not use keys that \*`look alike\*' interchangeably--the uppercase 
letter \*`O\*' and zero, for example, or the lowercase \*`l\*'
and the number one (1). 
All computers will recognize these as separate characters, so be sure you
always type the correct one.
.P
You should note that some of the keys on your keyboard have a special
meaning when you are using \*(x1.
These include control-characters used to produce \*(x1 characters that don't  
appear on your keyboard, and various \*`escape\*' keys or sequences used
to exit from programs, terminate activities, log out, or stop the movement
of text on your screen. 
.P
Angle brackets (< >) are used in this guide to represent keys.
Note that whenever you are asked to type the <CONTROL> key along with
some other key that you should always press the <CONTROL> key first, and
hold it down while you type the second key, just as you would hold down
the shift key on a typewriter while typing the letter you want to capitalize.
Here is a list of the most commonly used characters and sequences:
.VL 20
.LI "backslash (\e\)"
The \*(x1 backslash (\e\)character can be obtained by 
typing <CONTROL-/>.
.LI "pipe (\&|)"
You will frequently have use for the \*(x1 pipe (\&|) character, and you will
certainly see it often in \*(x1 documentation, although it does not appear
on your keyboard. 
It can be entered by typing <CONTROL-1>.
.LI "<CONTROL-S>"
Typing the \*`control\*' and \*`s\*' keys simultaneously will stop text from 
\*`scrolling\*',
that is, moving up and off the screen. 
To start scrolling again, type <CONTROL-Q>.
.LI "<CONTROL-D>"
You will have several important uses for the <CONTROL-D> sequence:
.DL
.LI
to log out 
.LI
to bring the system up from maintenance mode
.LI
to exit from certain \*(x1 programs
.LE
.LI "<BREAK>"
In addition to special uses it may have in specific \*(x1 programs,
the <BREAK> key will interrupt any command you have entered and return
you to the system prompt ($).
.LI "<ENTER>"
In some documentation you may also see this key named <RETURN>, for
\*`carriage return\*'.
You must type the <ENTER> or <RETURN> key after a command for \*(x1 to
receive the instructions.
.LE
.H 3 "XENIX File and Directory Naming Conventions"
As we will see later, all information on your system is organized into
files and directories.
First, it is important to learn
a few rules about what you can name these files and directories.
All \*(x1 files and directories may have names up to fourteen characters long, 
including any combination of uppercase and lowercase letters and numbers. 
You may not use the slash (/) character, and you should also avoid using 
all punctuation marks except the period (.) and special characters, because 
they often have unexpected meanings for \*(x1.
.HU "Wild Card Characters"
.br
Be especially cautious in your use of the two \*`wild card\*'
characters, question mark (?) and star (*).
Wild card characters are used to replace filenames or parts of
filenames. The question mark replaces a single character; the star
can replace several characters, or even an entire name.
.P
For example, to save typing you might refer to your file 
.I chap2.s 
as any of the following:
.DS I
.nf
chap?.s	      	*2.s 		*2*   
.fi
.DE 
If you wish to invoke a command involving several files, 
you can use the \*`wild card\*' capability to process all of them at once.
So, if you wish to refer to all of your chapters (e.g., chap1.s, chap2.s, 
etc.), you can just type
.DS I
*.s
.DE
to tell \*(x1 that you mean \*`all the files ending in .s\*' or even 
use \*`*\*' alone to mean \*`every file\*'.
Of course, if you are giving \*(x1 some command like \*`remove files\*', you 
should be extremely careful about using these wild card characters. 
The star can be used anywhere in a filename, 
and can occur several times.
.HU "Matching a Pattern Range"
.br
If you have used a consistent convention for naming files--let's say
with consecutive letters or numbers,
\*(x1 offers you the ability to name a group of files by specifying  
a range.
For example,
suppose you want to print only chapters 1 through 4, and 9.
Then you can say
.DS I
pr chap[12349]*
.DE
The brackets ([\0and\0])
mean \*`match any of the characters inside the brackets\*'.
A range of consecutive letters or digits can be abbreviated,
so you can also do this with
.DS I
pr chap[1-49]*
.DE
(This does not match forty-nine filenames, but only five.)
Letters can also be used within brackets:
\*`[a\-z]\*'
matches any character in the range \*`a\*' through \*`z\*'.
.HU "Absolute and Relative Pathnames"
.br
\*(x1 files are grouped in directories and arranged hierarchically. 
That is, a directory, which contains a collection of files, 
may be a member of yet another directory, and so forth.
This results in the formation of a tree with branches:
.DS I
.nf
                      / (root directory)
                      |
            --------------------------
            |       |       |        | 
           etc     bin     dev      usr
            |                        | 
           file1                   fred
                                     |
                                   file1
                                   file2
.fi
.DE
The \*`root\*' of this tree is the 
.I root
directory, by convention called \*`slash\*'(/).
\*(x1 identifies files by their \*`pathnames\*', the path you take along the
branches of this tree to arrive at the named file. 
The steps along the way are separated by slashes (/).
In the diagram, for example, there are two files called
.I file1.
One of these is, in fact,
.I /etc/file1.
The other file is
.I /usr/fred/file1. 
.P
The \*(x1 file structure is discussed at greater length in the
next section.
For now, however, it is sufficient that you understand the \*`pathname\*'
concept when you work with directories and files.
Every single \*(x1 file and directory has both a filename
and an absolute \*`pathname\*', the route you would have to take
to reach the file from the root directory.
The absolute pathname is unique for each file in the  
system; filenames are unique only within directories
and need not be unique system-wide.
This is similar to someone whose \*`absolute\*' name is 
John Robert Smith, but whom everyone calls John.
The name John need not be unique, although it will
greatly simplify life if John Robert Smith is a unique name.
.P
A pathname is a sequence of directory names followed by a simple filename,
each separated from the previous one by a slash.
If a pathname begins with a slash it is an absolute pathname, that is,
the search for the file begins at the 
.I root 
of the entire tree.
Otherwise, it begins at the user's current, or \*`working\*' directory,
and is called a \*`relative\*' pathname,
because it specifies a path relative to the current directory.
.P
In most cases, a filename and its corresponding pathname
may be used interchangeably.
.HU "Sample Names"
.br
Here are some samples of legitimate \*(x1 file and directory names:
.VL 18 3
.LI /
The absolute pathname of the root directory 
of the entire file system.
.LI /bin
The directory containing most of the frequently used \*(x1 commands.
.LI /usr
The directory containing each user's personal directory.
The subdirectory,
.I /usr/bin
contains frequently used \*(x1 commands not in 
.I /bin .
.LI /dev
The directory containing files corresponding to each
available physical device (e.g., terminals,
lineprinters, and disks).
.LI /lib
The directory containing special data files used by
some standard commands.
.LI /tmp
This directory contains
temporary scratch files.
.LI /usr/joe/project/A
.br
This is a typical full pathname.
This one happens to be a file named 
.I A
in the directory named
.I project
belonging to the user named
.I joe .
.LI bin/x
A relative pathname;
it names the file
.I x
in subdirectory
.I bin
of the current working directory.
If the current directory is
.I / ,
it names
.I /bin/x .
If the current directory is
.I /usr/joe ,
it names
.I /usr/joe/bin/x .
.LI file1
Name of an ordinary file in the current directory.
.LE
.HU "Two Special Shorthand Names"
.br
Each user resides \*`in\*' a directory called the
current directory.
All files and directories have a
\*`parent\*' directory, 
which is the one immediately above and \*`containing\*' 
the given file or directory.
The \*(x1 file system provides special shorthand
notations for this directory and for the current directory:
.VL 6 3
.LI . 
The shorthand name of the current directory.
Thus
.I ./filexxx
names the same file as
.I filexxx ,
if such a file exists in the current directory.
.LI ..
The shorthand name of the current directory's parent directory.
For example, if you use the \*(x1 command,
.B cd ,
which changes your directory to the one you name:
.DS I
cd ..
.DE
you would be changing to the directory called \*`..\*', the parent
of the directory you were in before.
.LE 
.bp
.H 3 "How to Use XENIX Commands"
A \*(x1 command may be typed whenever the prompt appears, indicating that
you are in the \*`shell\*', the command level of the system.
This prompt will either be a dollar sign ($) or a number sign (#). 
\*(x1 commands generally consist of single lowercase words, which may
be followed by one or more \*`switches\*' and \*`arguments\*'.
Most often the argument will be a filename.
Every command must be followed by typing <ENTER>, even though this is
not noted specifically in most text examples.
.P
To take a simple example, you can use the command
.B cat
to look at the contents of a file. 
If you type
.DS I
$ cat file1
.DE
the contents of 
.I file1
will appear on your screen.
.P
To use another example, the command
.B lc
lists the contents of whatever directory you name.
Therefore,
.DS I
$ lc /usr/fred
.DE 
will give you a list of files and directories in the directory
.I /usr/fred.
One thing to note: When you type \*(x1 commands, be sure to include
or omit spaces exactly as indicated; it is best to think of the \*`space\*'
as a character like any other. 
.P
Whether you are typing at the terminal, or executing
commands from a file, \*(x1 always reads commands
from command lines.
The command line is a line of characters that is 
scanned and read by the shell command interpreter to
determine what to do next.
You must type <ENTER> at the end of every command--the
command will not be submitted until you do.
If you make a mistake while typing a line, you can use either
the <BKSP> or <CONTROL-U> keys.
The \*(x1 shell then reads the command line and executes
the appropriate command.
If you type <INTERRUPT> before you have typed <ENTER>,
the command is aborted.
.P
When you type a command, you are actually invoking a program.
In \*(x1, a program is a file, which has an executable status.
The \*(x1 shell looks for a program with the command name 
and executes it.
Some commands may also contain \*`switches\*'--these specify
options or other arguments as needed by the program.
Multiple commands can be entered on a single command
line so long as they are separated by a semicolon (;).
For example, the following prints out the current
date and the name of the current working directory:
.DS I
date ; pwd
.DE
Two \*(x1 commands
.B date ,
and
.B pwd ,
are joined on a single line with the semicolon.
.P
Commands can be submitted for processing in the
background by putting an ampersand (&) at the end of the command.
This leaves your terminal free.
You can execute other commands from your terminal
while the 
first command executes in the background.
This is a special feature of the \*(x1 shell to facilitate
multi-tasking--the capacity to do more than one task at once.
.P
Commands have the following general syntax:
.DS I
.B
cmd  [ \fIswitches\fP ][ \fIarguments\fP ] [ \fIfilenames\fP ]
.R
.DE
.P
In practically all cases, command names are all lowercase.
Switches are added options available when executing the command.
They always precede
other arguments and filenames.
Switches consist of a dash prefix (\-)
and an identifying letter or number.
Some switches are also prefixed by a plus sign (+).
Switches can often be grouped as a single switch
as in:
.DS I
ls \-arl
.DE
which invokes the \-a, \-r. and \-l switches simultaneously.
Sometimes, however, switches must be invoked separately.
.P
There are various types of arguments.
An argument may be a string of text, as in:
.DS I
grep \'string of text\' outfile
.DE
In the above example, 
\*`string\ of\ text\*' is an argument; 
it is the string of text that the 
.B grep
command searches for in the file
.I outfile .
.I Outfile 
is a filename argument that specifies the name of a file required
by the command.  
.bp
.H 2 "Files and Directories"
\*(x1 stores information on the computer in \*`files\*', in much the same way
as you might store an important memo or record in a file folder. 
Computer files may contain various types of information, such as the 
text of a document, a program, or lines of data, but they are all treated
in the same way.
Furthermore, \*(x1 gives you the option of collecting groups of files in
\*`directories\*', much as you might organize file folders into categories
and put them in labeled file drawers so that they can be found easily.
The organization of \*(x1 files and directories is quite flexible. 
You will soon find that your decisions about what to name files and 
where you decide to put them can make your work on the system more efficient,
just as you would expect to be able to do your work faster in an office
where you could find all your important records quickly.
.H 3 "The Hierarchy of Files and Directories"
It is important to emphasize here that \*(x1 files and directories can
be organized hierarchically.
That is, each \*(x1 directory can contain other directories, as well as
files, and those directories can also contain directories. 
Therefore, you can create a pyramid of directories within directories.
.P
To take a simple example, in the preceding chapter John Doe was added
to the system with the 
.B mkuser
program.
As you remember, one of the things that the
.B mkuser
program did was to give John a work space of his own, a \*`home\*' directory,
called 
.I /usr/johnd.
Now you can see that the directory 
.I johnd 
is, in fact, a subdirectory of another directory called 
.I usr, 
which contains the home directories of all the users on the system.
Undoubtedly, as soon as John logs in to the system for the first time
he will begin to create new files and directories to store his work in.
.P
Let's say he creates a directory called 
.I payroll 
in which to put 
various payroll programs and data files, and another called 
.I memos
in which to store important pieces of electronic mail he receives from
other users on the system. 
Perhaps he will also create a simple file for himself right in his home 
directory called 
.I list, 
which contains a list of things to do.
The results would look like this (directories are indicated in brackets):
.DS I
.nf
                          [/]
                           |
                         [usr]
                           | 
                        [johnd]
                           |
         ------------------------------------
         |                 |                |
       [memos]          [payroll]         list 
        file1            file1
        file2            file2
                         program
.fi
.DE
.H 3 "File Manipulation Commands"
At this point, you will need to learn a few \*(x1 commands for creating,
moving, copying and deleting files and directories. 
To create the 
.I memos
directory, for example, John Doe had to type
.DS I
$ mkdir memos 
.DE
Now, in order to make the 
.I memos 
directory his \*`current\*' or working directory,
he would need to type:
.DS I
$ cd /usr/johnd/memos 
.DE
The command
.B cd
stands for \*`change directory\*'.
He is now in the directory 
.I memos  
or, to give its full pathname, or location,
.I /usr/johnd/memos.
To create a new file, type the character \*`>\*', followed by the filename:
Let's say John wants to create a new file in his 
.I memos 
directory called
.I newproject:
.DS I
 >newproject
.DE
There is now a file in the 
.I memos 
directory called 
.I newproject.
The 
.B lc
command lists the contents of the current directory:
.DS I
.nf
file1  newproject
file2 	
.fil
.DE
.P
Files can be moved and copied from one directory to another. 
Suppose John wishes to move the file 
.I newproject 
to a new directory created for his new project,
.I acct.project.
First, he can create
.I acct.proj
with the
.B mkdir
command, and then
he can move the 
.I newproject 
file from the 
.I memos
directory to the
.I acct.proj
directory with the
.B mv
command,
as in:
.DS I
mv newproject /usr/johnd/acct.proj 
.DE
If he uses 
.DS I
cd /usr/johnd/acct.proj 
.DE
to move himself into the 
.I acct.proj
directory, and uses the
.B lc 
command, the 
.I newproject 
file will appear in the list of files in the 
.I acct.proj
directory.
When \*(x1 moves a file, it removes it from the old directory and
puts the file in the new one. 
If John wished to keep a copy of 
.I newproject 
in the old
.I memos
directory,
thus making 
.I newproject
a file in both directories, he could use the 
.B cp
command to create another identical 
.I newproject 
file in the other directory.
Note that \*(x1 allows you to have two files of the same name, as long as
they are in different directories.
.P
If you no longer need a file, just use the
.B rm
command to remove it.
The command
.DS I
$ rm newproject
.DE
removes the file
.I newproject
from the directory.
Once again, this can be verified with the
.B lc
command.
Similarly, you can remove an entire directory by using the command
.B rmdir
as in 
.DS I
$ rmdir memos
.DE
However, \*(x1 will not allow you to remove a directory without first
removing all of the files in it.
You can type either
.DS I
$ rm file1 file2 newproject 
.DE
or, using a special \*(x1 character, the star (*), which stands for
everything, enter
.DS I
$ rm *
.DE
Be cautious about using the star; it really will remove everything.
Also, you cannot be in the directory you are removing, so move back 
to the directory above it.
\*(x1 even lets you type two commands together, if you separate them with
a semicolon (;).
.DS I
$ cd /usr/johnd;rmdir memos 
.DE
As you work more with the \*(x1 system, you will want to know a great
deal more about these and other commands to manipulate files and directories.
Read whatever \*(x1 documentation you have available for a more detailed
discussion of the \*(x1 file structure, and practice using these commands
until you are comfortable with them. 
.bp
.H 2 "The \*(x1 Shell"
The \*(x1 shell is your interface with the system. 
Every time you log in to \*(x1 you are, in fact, invoking a
\*`shell\*'--this shell speaks a command language which allows you to
specify input and output,
run several processes simultaneously by placing them in the background,
or link two processes together, by connecting the output of one 
process to the input of another.
.P
The \*(x1 shell has many of the features of a programming language, and
allows you to prepare complex scripts to run long sequences of 
processes.
Techniques for using the shell as a powerful aid to your productivity
on the system are introduced in detail in the
.I
\*(x1 Fundamentals
.R
manual.
.H 3 "Controlling Input and Output"
\*(x2 handles input and output from commands in a unique
way: it assumes that input and output are
associated with the terminal from which the command originates.
That is, input comes from the keyboard and output goes
to the terminal screen.
To illustrate typical command input and output,
type:
.DS I
cat
.DE
This command now expects input from your keyboard.
It will accept as many lines of text as you can type
as input, until you type a 
.SM <CONTROL-D>
as an end-of-file indicator.
For example, type:
.DS I
this is two lines
of input
.SM <CONTROL-D>
.DE
When you type the
.SM <CONTROL-D> ,
input ends and output begins.
The
.B cat 
command then immediately outputs the two lines 
that you typed.
Since output is sent to the terminal screen by
default, that is where the two lines are sent.
Thus, the complete session will look like this on your terminal screen:
.DS I
$ cat
this is two lines
of input
this is two lines
of input
$
.DE
.P
However, you can specify that input and/or output be 
\*`redirected\*'. 
Input may come from a file instead
of from the terminal keyboard, and output may be 
directed to a file or to a lineprinter, instead of to the terminal
screen.
Also, you can create \*`pipes\*' to allow
the output from one command to become the input to another.
.H 3 "Redirection"
.br
Instead of having your input come directly from the terminal, or
watching the output of some process come to your screen, you
can ask \*(x1 to take a file you specify as input, and output
the results of the process into another file.
In \*(x1, a file can replace the terminal
for either input or output.
For example, the command 
.DS I
ls
.DE
displays a list of files in your current directory on your terminal 
screen.
But if you say
.DS I
ls >filelist
.DE
a list of your files is placed in the file
.I filelist .
If a file called
.I filelist
does not exist, \*(x1 will create it.
The output redirection symbol (>) means 
\*`put the output from the command into the following file,
rather than display it on the terminal screen.\*'
.P
You can also combine several files into one, using the 
.B cat
command:
.DS I
cat f1 f2 f3 >temp
.DE
This command says \*`take the contents of these three files and put
them all into a file called 
.I temp \*'.
.P
The output append symbol (>>) works in much the same way as output 
redirection, except that it means \&\*`add to the end of\*'. 
That is
.DS I
cat file1 file2 file3 >>temp
.DE
means to concatenate
.I file1 ,
.I file2 ,
and
.I file3
to the end of whatever is already in
.I temp .
Thus, if you already had information in the file called
.I temp ,
instead of 
replacing the old contents of 
.I temp
with the contents of
.I file1 ,
.I file2 ,
and
.I file3 ,
these three files will be placed at the end of the old file
called
.I temp
instead.
As with normal output redirection, if
.I temp
doesn't exist, it is created for you.
.P
The input redirection symbol (<) means to take the input
for a program from the following file,
instead of from the terminal.
This allows you to make up a script of
editing commands and put them into a file called
.I script .
Then you could execute the commands in the script 
on a file using the \*(x1 editor by typing:
.DS I
ed file <script
.DE
As another example, you could use
.B ed
to prepare a letter in file
.I letter.txt ,
then send it to several people with
.DS I
mail adam eve mary joe <letter.txt
.DE
.H 3 "Pipes"
.br
Pipes are a unique feature of the \*(x1 system.
A pipe is simply a way to connect the output of one command
to the input of another command,
so that the two run as a sequence of commands called a pipeline.
.P
For example
.DS I
pr memo1 memo2 memo3 
.DE
prints the files named
.I memo1 ,
.I memo2 ,
and
.I memo3 ,
beginning each on a new page.
Suppose you want them run together instead.
You could type:
.DS I
cat memo1 memo2 memo3>temp
pr <temp
rm temp
.DE
to put the contents of the three memo files into a new file
called 
.I temp ,
print it,
then remove.
However, it is quite a bit simpler to take the output of
.B cat
and connect it to the input of
.B pr ,
using a pipe:
.DS I
cat memo1 memo2 memo3| pr
.DE
The vertical bar (\||\|) means to take the output from
.B cat ,
which would normally have gone to the terminal, and put it into
.B pr
to be formatted.
.P
There are many other examples of pipes.
For example,
.DS I
ls | pr -3
.DE
prints a list of your files in three columns.
The program
.B wc
counts the number of lines, words, and characters in
its input, and 
.B who
prints a list of all the users currently logged in, one per line.
Thus,
.DS I
who | wc
.DE
tells how many people are logged in.
And of course
.DS I
ls | wc
.DE
counts your files.
.P
Any program that reads from the terminal keyboard
can read from a pipe instead.
Any program that displays output to the terminal screen
can send input to a pipe.
You can have as many elements in a pipeline as you wish.
.P
Many \*(x1 programs are written so that they
take their input from one or more files,
if file arguments are given.
If no arguments are given, they read from the terminal keyboard,
and thus can be used in pipelines.
For example
.DS I
pr 3 albert.txt bernard.txt carl.txt
.DE
prints, in order, the files
.I albert.txt ,
.I bernard.txt ,
and
.I carl.txt .
But in
.DS I
cat albert.txt bernard.txt carl.txt | pr
.DE
.B pr
prints the concatenation of these files coming down the pipeline.
The difference is that here, 
.I albert.txt ,
.I bernard.txt ,
and
.I carl.txt
are run together and then treated as one file rather than three.
.bp
.H 2 "Frequently Used Commands"
In this section, some common \*(x1 commands are summarized.
You will find these descriptions of immediate use to you
while you are just getting started using your \*(x1 system.
However, as you learn more about the system, you should read the
.I
\*(x1 Fundamentals
.R
manual, which is a complete introduction to the use of the \*(x1 system.
The commands listed here represent three types of activities:
.BL
.LI
logging in and out, using your terminal and lineprinter, and
dealing with processes running on the system
.LI
manipulating files, directories, and your position in the file hierarchy
.LI
using some basic system utilities
.LE
.sp
Where possible, try each of these commands out as you read about them.
There is no substitute for practice.
.HU "Logging In"
.br
.in +5
To gain access to the system,
respond to the
\*`login:\*' prompt by typing your account name followed by <ENTER>.
Then respond to the
.I password:
prompt with your password.
For example, a login for the user
.I joe
might look like this:
.DS I
login:joe
password:abracadabra
.DE
The password will not appear on the terminal screen as you type it.
.H 3 "Commands For Using Your Terminal and Lineprinter"
.HU "Logging Out"
.br
.in +5
The logout procedure is simple--all you need to do is type:
.DS I
<CONTROL-D>
.DE 
Since within other programs, <CONTROL-D>
signifies the end-of-file to the system, at times it may be necessary to type 
<CONTROL-D> several times before you can log yourself out.
.HU "Changing Your Password"
.br
.in +5
To change your password, use the
.B passwd
command.
The
.B passwd
command will prompt you twice for the answer.
For the user joe, a session might go like this:
.DS I
Changing password for joe
Old password:abracadabra 
New password: Bazookah
Retype new password: Bazookah
.DE
To maintain security, none of your responses are shown on the screen.
It is best to mix uppercase and lowercase letters and make the 
password greater than five characters in length.
.HU "Setting Terminal Options"
.br
.in +5
There are a number of terminal options that can be set
with the command
.B stty .
When entered without parameters,
.B stty
displays the current terminal settings.
For example, typical output might look like this:
.DS I
speed 9600 baud
erase '^h' ; kill '^u'
even -nl
.DE
This says that the rate of data transmission
to and from the terminal is 9600 baud, that the
backspace character (erase) is <CONTROL-H>, 
that the line kill character is <CONTROL-U>,
that even parity is set, and that <ENTER> signifies the beginning
of a new line.
Each of the above characteristics can be set by using the 
.B stty 
command, or with entries in a special file called
.I .profile .
(See Chapter 3, \*`Getting the System Ready for Your Users\*'.)
.HU "Changing Terminals"
.br
.in +5
If you have to log in to \*(x1 on a terminal
of a type different than the terminal you normally use,
you may need to change the shell TERM variable.
This is normally set to the proper default terminal
when you log in, but if you switch terminals, you'll
need to type something like:
.DS I
TERM=\fItermname\fP; export TERM
.DE
where 
.I termname
is the name of a known terminal.
A wide variety of terminals are supported; 
terminal names are listed in the system file named
.I /etc/termcap.
(See Appendix B, \*`Notes on the Multi-user System\*'.)
.HU "Erasing A Command Line"
.br
.in +5
If you make a mistake while typing a command line,
you can erase the current line and retype a new one. 
Enter a <CONTROL-U>, as shown below:
.DS I
kat file2<CONTROL-U>
cat file1
.DE
.P
In this case, the first line is aborted
and a newline is generated automatically so that
typing may resume.
You then can enter the correct command line.
.HU "Halting Screen Output"
.br
.in +5
If you are examining the contents of a file on the terminal screen, 
you can keep the contents from scrolling off the screen faster than you
can read them.
To temporarily halt a program's output to the
terminal screen, type <CONTROL-S>.
To resume output, type any key except <INTERRUPT>.
.HU "Sending a File to the Lineprinter"
.br
.in +5
To print files on the lineprinter, type:
.DS I
lpr file1
.DE
for one file, or
.DS I
lpr file1 file2 file3
.DE
for several files.
.P
You can also paginate and print a file of raw text,
by typing:
.DS I
pr textfile | lpr
.DE
The
.B pr
and
.B lpr
commands are very often used together, connected by a pipe.
.P
As another example, to sort, paginate, and print a file, type:
.DS I
sort datafile | pr | lpr
.DE
.HU "Getting Line Printer Queue Information"
.br
.in +5
More than one file may be waiting to be printed at the
lineprinter. \*(x1 does not require that the
file be printed before the
.B lpr
command finishes.
Instead,
.B lpr
makes sure only that the file is placed in a special
directory where it will wait its turn to be printed.
If you have problems with your lineprinter, or want to
see how many files are waiting in the queue, type:
.DS I
ls \-l /usr/spool/lpd
.DE
.HU "Finding out What Processes are Running"
.br
.in +5
Because you may have several processes running simultaneously, 
you may want to check what is currently running.
The
.B ps
command stands for \*`process status\*' and
lists information about all the processes associated
with your terminal.
For instance, the output from a
.B ps
command might look like this:
.DS I
 PID TTY TIME CMD
10308 38  1:36 ed chap02.man
   49 38  0:29 -sh
11267 38  0:00 sh -c ps
.DE
The \*`PID\*' column gives a unique process identification
number that can be used to kill a particular process.
The \*`TTY\*' column gives the terminal that the process is
associated with.
The \*`TIME\*' column gives the cumulative execution time
for the process.
.HU "Killing a Process"
.br
.in +5
To stop execution of a process, you can type <INTERRUPT>.
However, to kill all of your processes 
executing in the background, you will need to use the 
.B kill
command.
Type:
.DS I
kill 0
.DE
to kill all of your processes.
To kill only a specified process executing in the background,
first use the
.B ps
command to find out which processes are running and what their
process ID numbers are:
.DS I
   PID TTY TIME CMD
  3459 03  0:15 -sh 
  4831 03  1:52 ed chap01.s 
  5185 03  0:00 sh -c ps 
.DE
Next, you might type
.DS I
kill 4831
.DE
where 4831
is the PID of the process that you want killed.
.H 3 "File Manipulation Commands"
.HU "Creating Files"
.br
.in +5
To create a new file, simply type:
.DS I
>filename
.DE
Here,
.I filename
is the name of the newly created file.
The greater-than sign (>) is used to redirect output from the
terminal to a file.
In general, new files are created automatically by commands
as needed.
.HU "Displaying File Contents"
.br
.in +5
To display the contents of a file, use the
.B cat
command.
.B Cat
displays the contents of a file on the default
standard output file which is the terminal screen.
For example, the following command displays the contents of
.I file1
on the screen:
.DS I
cat file1
.DE
.B Cat
can also display the contents of more than one file as in
.DS I
cat file1 file2
.DE
.HU "Combining Files"
.br
.in +5
The
.B cat 
command stands for \*`concatenate\*'.
It can be used to
combine several files into one new file.
Thus, to combine the two files named
.I file1
and
.I file2 ,
and to create a new file named
.I bigfile ,
type:
.DS I
cat file1 file2 >bigfile
.DE
The greater-than sign (\|>\|) is used to
redirect normal output of the
.B cat
command from the terminal screen to the new file.
.HU "Moving a File"
.br
.in +5
You can use the
.B mv
command in two different ways.
First, you can
move a file so that it has a new name.
For instance, to move a file named 
.I text
to a new file named 
.I book,
type:
.DS I
mv text book
.DE
After this move completes, no file named
.I text
will exist in the working directory.
In effect, you are actually renaming the file called
.I text .
You can also move a file into a specified directory.
You must give the name of the destination directory 
after the name of the file you are moving. 
For instance, to move
.I file1
and 
.I file2
into
the directory named
.I /tmp ,
type:
.DS I
mv file1 file2 /tmp
.DE
The two files you have moved will disappear from  
your working directory, and be added 
to the directory
.I /tmp .
The above command has exactly the same 
effect as typing the following two commands:
.DS I
mv file1 /tmp/file1
mv file2 /tmp/file2
.DE
Remember that the
.B mv
command always checks to see if the last argument is
the name of a directory, and if so, all files
designated by filename arguments are moved into that
directory.
.DS I
mv  anon johndoe
.DE
.HU "Copying a File"
.br
.in +5
There are two ways in which you can use the 
.B cp
command. 
First, you can copy one file to another file.
You can also copy one or more files into a directory.
To create two copies of a file in your own working directory,
you must rename the new copy.
To do this, type:
.DS I
cp file clone-of-file
.DE
You will now have two files with
identical contents in your working directory.
.P
To copy three files into a directory named
.I filedir ,
type:
.DS I
cp file1 file2 file3 filedir
.DE
In the above command, three files are copied into the
directory 
.I filedir ; 
the original versions still reside
in your working directory. 
There is a one-to-one correspondence
between the names in the two directories.
.HU "Deleting A File"
.br
.in +5
To delete or remove files, simply type:
.DS I
rm file1 file2	
.DE
In the above command, the files
.I file1
and
.I file2
are removed from your working directory.
.HU "Printing Your Working Directory"
.br
.in +5
The
.B pwd
command stands for
\&\*`print working directory\*'.
For instance, if your current working directory is
.I /usr/joe ,
then when you type
.DS I
pwd
.DE
you will get the output:
.DS I
/usr/joe
.DE
You should always think of yourself as residing
\*`in\*' your working directory.
.HU "Listing Directory Contents"
.br
.in +5
The most basic directory command is
.B ls .
The
.B ls
command
sorts and lists the names of the files and directories
that reside in a given directory.
Unless you specify otherwise,
the contents of your working directory are listed.
If arguments are given,
then for each directory argument
.B ls
lists the contents of the given directory;
for each file argument,
.B ls
repeats its name.
For instance, if you type
.DS I
ls
.DE
the output from the command might typically look like this:
.DS I
dir1
dir2
dir3
file1
file2
file3
.DE
Using the same directory, the command
.DS I
ls d* 
.DE
would list the files within each of the directories
.I dir1 ,
.I dir2 ,
and
.I dir3 .
.P
The
.B lc
command, 
which stands for 
\*`list in columns\*', prints names in columns, 
so more information can fit on the screen at once
than with 
.B ls.
A sample listing follows:
.DS I
atfile      help        oem         size        v0
bin         lib         papers      src         v1
calendar    maketape    po          termcap     v2
cmds        memos       port        termnames   v5
convert     mgr         probs       test.s
doem        mkfs        rand        testdir
errs        msg         rand.c      ttc
errs.sh     nroff       sco         typeset
.DE
.B Lc
also lets you recursively list a directory and all
of its subdirectories by typing
.DS I
lc -R 
.DE
where the 
.B \-R
stands for recursive.
.P
A command very similar to 
.B ls
and 
.B lc
is 
.B l .
.B L
gives an expanded \*`long\*' listing of a directory,
producing an output that might look something like this:
.DS I
total 501
drwxr-x--- 2 boris     272 Apr  5 14:33 dir1
drwxr-x--- 2 enid      272 Apr  5 14:33 dir2
drwxr-x--- 2 iris      592 Apr  6 11:12 dir3
-rw-r----- 1 olaf      282 Apr  7 15:11 file1
-rw-r----- 1 olaf       72 Apr  7 13:50 file2
-rw-r----- 1 olaf     1403 Apr  1 13:22 file3
.DE
Reading from left to right, 
the information given for each file or directory includes:
.AL 1
.LI
Permissions
.LI
Number of links
.LI
Owner
.LI
Size in bytes
.LI
Time of last modification
.LI
Filename
.LE 1
The information in this listing and 
how to change permissions are discussed below. 
.HU "Changing Your Working Directory"
.br
.in +5
Your working directory represents your location in
the file system: it is \*`where you are\*' in \*(x1.
To alter your location in the \*(x1 file system,
you need only type:
.DS I
cd
.DE
This changes your working directory to that of
your home directory.
To move to any other directory, simply specify that
directory as an argument to
.B cd .
For instance
.DS I
cd /usr
.DE
moves you to the
.I /usr
directory. 
Because you are always \*`in\*' your
working directory, changing working directories is
much like \*`traveling\*' from directory to directory.
.HU "Creating a Directory"
.br
.in +5
To create a subdirectory in your working directory,
use the
.B mkdir
command.
For instance, to create a new directory named
.I phonenumbers , 
simply type:
.DS I
mkdir phonenumbers
.DE
Now you will have a new, empty directory in your home directory.
.HU "Removing a Directory"
.br
.in +5
To remove a directory located in your working directory, use the
.B rmdir
command.
For instance, to remove the directory named
.I phonenumbers 
from the current directory, simply type:
.DS I
rmdir phonenumbers
.DE
The directory 
.I phonenumbers 
must be empty before it can be removed. 
This prevents you from accidentally 
deleting files and directories.
.HU "Renaming a Directory"
.br
.in +5
To rename a directory, use the
.B mv
command,
just as you would if you were moving a file.
Note that directories and their contents cannot be
moved with the
.B mv
command; they can only be renamed.
For instance, to rename the directory
.I little.dir
to
.I big.dir ,
type:
.DS I
mv little.dir big.dir
.DE
This is a simple renaming operation;
no files are moved.
.H 3 "Basic System Utilities"
.HU "Finding Out Who is on the System"
.br
.in +5
The
.B who
command lists the names, terminal line numbers, and login
times of all users currently logged on the system.
For example, type:
.DS I
who
.DE
This command should produce something like
the following output on your terminal screen:
.DS I
arnold   tty02   Apr  7 10:02
daphne   tty21   Apr  7 07:47
elliot   tty23   Apr  7 14:21
ellen    tty25   Apr  7 08:36
gus      tty26   Apr  7 09:55
adrian   tty28   Apr  7 14:21
.DE
.HU "Sorting A File"
.br
.in +5
The
.B sort 
command is one of the most useful \*(x1 file processing commands.
By default,
.B sort
sorts the lines of a file according to the ASCII collating sequence.
For example, to sort a file named
.I phonelist ,
type:
.DS I
sort phonelist
.DE
In the above case, the sorted contents of the
file are displayed on the screen.
To create a sorted version of
.I phonelist
named
.I phonesort ,
type:
.DS I
sort phonelist >phonesort
.DE
Note that
.B sort
is useful in sorting the output from other commands.
For example, to sort the output from execution of a
.B who
command, type:
.DS I
who | sort >whosort
.DE
A wide variety of other sorting options are available
for
.B sort .
.HU "Searching for a Pattern in a File"
.br
.in +5
The
.B grep
command selects and extracts lines from a file,
printing only those lines that match a given pattern.
.P
For example, to print out all lines in a file containing the
word \*`tty38\*', type:
.DS I
grep \'tty38\' file
.DE
In general, you should always enclose the pattern
you are searching for in single quotation marks (\'),
so that special metacharacters are not expanded
unexpectedly by the shell command interpreter.
.HU "Finding Out the Time and Date"
.br
.in +5
To get the current time and date simply type
.DS I
date
.DE
You will get a simple answer in the following form:
.DS I
Tue Feb 18 19:02:19 PST 1983
.DE
.bp
.H 2 "Text Editing with Ed"
Text editing--the capacity to manipulate the contents of any file,
whether it contains written text, data, or program code--is essential 
for using any computer system. 
\*(x1 offers several editors, and related pattern recognition, and
file comparison utilities of use both in text processing and 
programming.
These tools are discussed at length in the
.I
\*(x1 Fundamentals
.R
manual.
In your role as system manager you have already been introduced to 
several important \*(x1 files--
.I /etc/passwd ,
.I .profile , 
and
.I /etc/rc ,
to name a few.
You will soon find that you need to add or change these, and other files on 
the system. 
.P
This is a brief summary of some of the many functions of the \*(x1 text editor,
.B ed .
It does not contain an exhaustive list of 
.B ed
commands, nor does it even begin to demonstrate the wide range
of editing functions possible on your \*(x1 system.
However, it should help you to get you started 
using a text editor with sufficient dexterity to do your routine
system management tasks. 
.H 3 "Invoking the Editor"
To invoke 
.B ed ,
type:
.DS I
ed \fIfilename\fR
.DE
where 
.I filename
is the name of the file you want to edit.
If no name is given, a question mark (?) is printed.
This is not an error.
You are simply creating a new file to edit.
The text in the new file 
is kept in a special buffer file while you are working on it.
Think of the buffer as a work space--a kind of scratch pad with a temporary 
copy of the file you are editing.
You tell 
.B ed 
what to do to your text by typing instructions called \*`commands\*'.
Most commands consist of a single letter,
which must be typed in lowercase.
Each command is typed on a separate line
and followed by <ENTER>, just like typing a \*(x1 system command.
.B Ed 
will respond to your commands without giving you any prompts or messages.
If you make an error typing commands in 
.B ed ,
it will answer you with:
.DS I
?
.DE
.H 3 "Adding Text to a File"
.br
To add lines of text to the file you are editing,
just type an \*`a\*' for append, followed by <ENTER>.
Next, enter the lines of text you want, like this:
.DS I
a
Now is the time
for all good men
to come to the aid of their party.
\&.
.DE
.P
To stop appending, type a
line that contains only a period on a line by itself.
A period (\|.\|) is used to tell
.B ed
that you have finished appending.
.H 3 "Saving Your File"
It's likely that you will want to save your text for later use.
To save the contents of your file, 
use the write command,
.B w ,
followed by the name of the file that you want to write to.
This copies the temporary buffer's contents
to the file you name,
replacing any previous contents of this file.
For example, to save the text in a file named
.I text ,
type:
.DS I
w text
.DE
Leave a space between
.B w
and the filename.
Writing a file just makes a permanent copy of your text,
so you can go on adding lines to the copy you are editing.
If you use the
.B w
command without naming a file,
.B ed 
writes back out to the file that you named when you invoked 
.B ed . 
Because
.B ed
always works on a copy of a file, not the file itself,
no change in the contents of a file takes place until you give a
.B w
command.
.H 3 "Exiting The Editor"
To terminate a session with 
.B ed ,
save the text you're working on by writing it to a file using the
.B w
command, and then type:
.DS I
q
.DE
.P
The system responds with the \*(x1 prompt character.
At this point your buffer vanishes, along with the text you have been working 
on, which is why you want to write it out before quitting--unless you have
made a mistake, and do not want to keep your new file.
Actually,
.B ed 
will print \*`?\*', if you try to quit without writing.
At that point, write out the text if you want;
if not, type another
.B q .
.P
It's good practice to name your file when you first
start using
.B ed:
.DS I
ed file
.DE
then just type
.B w
or 
.B q .
This way, you can type
.B w
from time to time
and be secure in the knowledge that if you got the filename right in the 
beginning, you are writing out to the proper file each time.
.H 3 "Printing The Contents of Your File"
.br
To see the contents of the buffer (or parts
of it) on the terminal screen, use the \*`print\*' command,
.B p .
To do this, specify the lines where
you want printing to begin and where you want it to end,
separated by a comma, and followed by the letter \*`p\*'.
Thus, to print the first two lines, (that is, lines 1 through 2) type:
.DS I
1,2p
.DE
.P
Suppose you want to print all the lines in the buffer.
Then you can use the dollar sign ($), which stands for 
\*`the line number of the last line in the buffer\*'. 
Use it this way:
.DS I
1,$p
.DE
This will print all the lines in the file (from line 1 to the last line).
.P
To print the last line, type:
.DS I
$p
.DE
You can print any single line by typing the line number, followed by a
.B p .
Thus
.DS I
1p
.DE
prints the first line of text.
.P
In fact, you can print any single line by typing just
the line number; there's no need to type the letter
.B p .
So if you type
.DS I
$
.DE
.B ed 
prints the last line of the buffer.
.P
You can also save effort 
in specifying lines by using plus and minus as line numbers by themselves.
For example
.DS I
\-
.DE
by itself is a command to move back up one line in the file.
.P
.B Ed
maintains a record of the last line
that you did anything to (in this case, line 3, which you
just printed) so that it can be used instead of an explicit
line number.
The line most recently acted on is referred to with a period (\|.\|)
and is called \*`dot\*'.
Dot is a line number in the same way that dollar ($) is; 
it means \*`the current line\*', or loosely,
\&\*`the line you most recently did something to\*'.
You can find out the value of dot at any time by typing:
.DS I
\&.=
.DE
.P
.H 3 "Deleting Text"
To delete text from the 
file you are editing, use the \*`delete\*' command,
.B d .
The lines to be deleted are specified for
.B d
exactly as they are for
.B p :
.DS I
\fIstarting-line,ending-line\fBd\fR
.DE
Thus, the command
.DS I
4,$d
.DE
deletes lines 4 through the end.
There are now three lines left in our example,
as you can check by typing:
.DS I
1,$p
.DE
Notice that
.B $
now is line 3!
Dot is set to the next line after the last line deleted,
unless the last line deleted is the last line of your file.
In that case, dot is set to
.B $ .
.H 3 "Substituting Text"
The \*`substitute\*' command,
.B s ,
is used to replace one string of characters 
with another.
You can use this command to change individual
words or letters within a line or group of lines.
For example, suppose that, due to a typing error, line 1 says:
.DS I
Now is th time
.DE
The letter \&\*`e\*'
has been left off of the word \&\*`the\*'.
You can use
.B s
to fix this up:
.DS I
1s/th/the/
.DE
This substitutes the characters \*`the\*' in line 1
for the characters \*`th\*'.
To verify that the substitution has worked, type
.DS I
p
.DE
to get
.DS I
Now is the time
.DE
which is what you wanted.
Notice that dot must have been set to the line
where the substitution took place, since the
.B p
command
printed that line.
Dot is always set this way with the
.B s
command.
.P
The syntax for the substitute command is:
.DS I
\fIstarting-line,ending-line\fBs/\|\fIpattern\fB/\|\fIreplacement\fB/\fR
.DE
The string of characters between the first pair of
slashes is replaced by whatever is between the second pair, in
all the lines between
.I starting-line
and
.I ending-line.
Only the first occurrence on each line is changed, however.
The rules for line numbers are the same as those for
.B p ,
except that dot is set to the last line changed.
However, if no substitution takes place, dot is
not changed.
This causes printing of a question mark (?) as a warning.
.P
Thus, you can type
.DS I
1,$s/speling/spelling/
.DE
and correct the first spelling mistake on each line in the text.
.P
If no line numbers are given, the
.B s
command assumes we mean
\&\*`make the substitution on line dot\*', so it changes things only
on the current line.
This leads to the very common sequence
.DS I
s/something/something else/p
.DE
which makes some correction on the
current line, and then prints it, to make sure it worked out right.
(Notice that there is a
.B p
on the same line as the
.B s
command.
With few exceptions,
.B p
can follow any command;
no other multi-command lines are legal.)
To change all occurrences on the current line, you should type:
.DS I
s/something/something else/g
.DE
where 
.B g
stands for a global substitution of all occurrences on the line.
.P
It's also legal to type
.DS I
s/string//
.DE
which means \*`change the first string of characters to nothing\*',
or in other words, remove them.
.H 3 "Searching"
.br
Suppose you have the following three lines of text:
.DS I
Now is the time
for all good men
to come to the aid of their party.
.DE
Now, suppose you want to find the line that contains
the word \*`their\*',
so that you can change it to the word \*`the\*'.
With a file only three lines long, it's pretty easy
to keep track of which line the word \&\*`their\*' is on.
But if the file contained several hundred lines,
and you'd been making changes, deleting and rearranging lines,
and so on, you would no longer really know what this line
number would be.
Instead, you would use context searching.
Context searching is simply a method of specifying the desired line,
regardless of what its number is,
by specifying some textual pattern contained in the line.
.P
The way to say \*`search for a line
that contains this particular string of characters\*'
is to type:
.DS I
/string of characters we want to find/
.DE
For example, the
.B ed 
command
.DS I
/their/
.DE
is a context search which is sufficient to find the desired line.
It will locate the next occurrence of
the characters between slashes (\*`their\*').
It also sets dot to that line
and prints the line for verification:
.DS I
to come to the aid of their party.
.DE
\&\*`Next occurrence\*' means that
.B ed
starts looking for the string at line
.B .+1 ,
searches to the end of the buffer,
then continues at line 1 and searches to line dot.
(That is, the search \*`wraps around\*' from
.B $
to 1.)
It scans all the lines in the buffer 
until it either finds the desired line or gets back to dot again.
If the given string of characters can't be found in any line,
.B ed 
prints an error message:
.DS I
?
.DE
Otherwise,
.B ed
prints the line it found.
.TC
