.nr H1 3
.H 1 "Controlling Access to Files and Directories"
.PH ''XENIX~Operations~Guide''
In this chapter, you will learn about one of your most important
responsibilities as system manager--controlling your users'
control your users' access to the files and directories on your
system.
Because \*(x1 offers several different tools for controlling access,
you will have a great deal of flexibility in restricting system usage
for both efficiency and security. 
In the previous two chapters you have been introduced to the 
way that \*(x1 organizes the information on the system with files and
directories, and the way in which user accounts are added and removed
from the system. 
In this chapter the following concepts are introduced:
.BL
.LI
the definition of users, groups, and others 
.LI
the assignment of permissions to restrict file access 
.LI
the creation, mounting and unmounting of file systems
.LI
the need for system security
.LE
.P
You will learn the following procedures:
.BL
.LI
how to determine the permission of files and directories
.LI
how to set and change permissions to files and directories
.LI
how to create and mount a file system
.LE
.H 2 "Setting Permissions: Users, Groups, and Others"
As system manager you will be responsible for adding and removing user 
accounts on the system.
Each user is given a unique password to ensure privacy, and optionally,
a group affiliation that allows a number of users to share access to files. 
You will also need to know something about how permission to access files
on the system is assigned to users, groups, and others on the 
system.
.H 3 "Users"
Any user who has a valid login name and and password recognized by the system 
may log in, and proceed to access files, edit text, or run programs. 
But not every user should have access to every file on the system.
.P
For example, John Doe would probably not want every user to be able to read or 
change the payroll files he created in the previous section.
So \*(x1 provides a method of strictly controlling access to each individual
file and directory with permission or protection settings. 
Naturally, every user has acesss to all the files and directories
which are in his home directory. 
When the user logs in, this is where he is initially positioned.
Ordinarily, a user cannot access other files and directories, 
unless the necessary permissions have been set.
.P
Only the super-user has unlimited power to access files on the system,
which makes logging in as \*`root\*' temptingly convenient.
But since the \*(x1 file protection mechanism does not apply to the super-user,
a single mistake made by the super-user can cause massive damage to other 
users' programs and data, and possibly even bring down the entire system.
.H 3 "Groups"
Generally, a user will restrict access to the files and directories he owns
by setting the permission for that file. 
This can prevent other users from changing, or perhaps even reading, 
his files.
However, some directories and files need to be shared by several users, 
while still remaining restricted from everyone else.
Thus \*(x1 offers a group ID which allows more than one user the same
access.
In practice, you may decide not to use this feature on a small system.
\*(x1 will automatically set the group ID as if every user belonged
to the same group; you may change this as desired.
.H 3 "Permissions"
In order to get a look at the permission settings for all the files in
a directory, we can use a variant of the
.B lc
command, \fBl\fR.
Here is a sample output:
.DS I
-rw-rw---- 1 johnd 11515  Nov 17  14:21 file1 
-rw-rw---- 1 johnd 12337  Nov 16  10:15 file2
-rwxrwx--x 1 freds  7712  Oct 10  09:02 program
.DE
The \l\fR
command gives you quite a lot of information. 
Just to the right of the name of the user who created the file, 
you will see the size of the file (information which will be of special
interest to you when you are short on disk space and are trying to decide
what files to remove), the date and time when that file was either
created or last changed, and the name of the file or directory. 
.P
Now look carefully at the pattern of ten letters and dashes on the left.
The first space is easily explained. 
A \*`d\*' indicates a directory, a \*`-\*' means an ordinary file.
The other nine characters are a representation of the nine possible
combinations of permission which can be assigned to any file.
These nine can be divided into three groups of three,  read (r), write (w), 
and execute (x) permissions for each of the following categories:
the \*`user\*' who is the owner of the file,
the \*`group\*' whose members have been defined by the system manager, 
and \*`other\*' which includes everyone else.
In each case a dash (-) denies permission, and the letters \*`r,\*' 
\*`w,\*' and \*`x\*' allow it.
The entry
.DS I  
-rwxrwxrwx 1 johnd 32 Oct 19 10:00  public  
.DE
indicates that everyone, owner, group, and other, has full access
rights to a file called 
.I public 
created by John Doe. 
.P
Of course there are some files which John might want to keep private.
For example, the 
.I list 
file in his home 
directory, which contains his personal \*`to do\*' list.
So, the permission setting on this file would look like this:
.DS I 
-rw------- 1 johnd    3 Nov 18 07:31 list
.DE 
.P
Permissions are set for directories in the same way as files, but you should 
note these differences.
No user, even the super-user, can write on a directory.  
The \*`x\*' permission is taken to mean \*`search,\*' rather than execute
in the case of directories.
Search (x) permission is required to 
.B cd 
to a directory or 
.B cat 
a file in it.
.P
Read (r) permission is required to use the
.B lc
command.
Write (w) permission is required to use
.B mkdir
or
.B rmdir,
or create a file in a directory.
Thus, if a directory's permission is set \*`r-x\*', you can access all 
of its files, subject to any permissions that might be set for any 
individual files.
If the directory is \*`rwx\*', you can do anything in it.
If a directory is \*`--x\*', you can only access a file if you know
its name.
.H 3 "How to Change Permission Settings"
When you add a file or directory, your \*(x1 system will automatically set 
some default permissions for you.
These are read (r) and write (w) permission for the user, read-only (r) 
for group and other permission setting:
.DS I 
-rw-r--r--
.DE
If you decide to change a setting you will need to learn the
.B chmod 
or \*`change mode\*' command.
To enter the command, you will have to say whose permission is to change (
\*`u\*', \*`g\*', or \*`o\*' for user, group and other respectively), and you 
will also have to
indicate whether you are adding (+) or removing (-) permission. 
After this, give the type of permission (r, w, or x), then the file or 
directory name.
So, for example, to change the file \*`program\*' from a permission setting
of read and write for user, group, and other (-rw-rw-rw-)
to also allow everyone to execute the file you would need to type:
.DS I
$ chmod ugo+x program
.DE
Or, instead of \*`ugo\*' you could type the letter \*`a\*' for all:
.DS I
$ chmod a+x program
.DE
Now, to take read and write permission away from everyone else besides
you and the members of your group, you can use:
.DS I
$ chmod o-rw program
.DE
If you get the order, or syntax, of this command wrong, \*(x1 will
sometimes answer with a bit of help:
.DS I
Usage: chmod [ugoa] [+-=] [rwxtugo] file
.DE
The items in brackets are \*`options\*'.
You will not need the other options besides \*`rwx\*' in the last set 
of brackets.
After using
.B chmod
alwasy try the \fBl\fR to check the results.
If you make a mistake, no harm is done; just change the permissions again.
.H 2 "The File System"
\*(x2 performs the task of disk storage management for all users of 
the system.  
It allocates disk space upon demand, keeps track of where on the disk the
data is written and retrieves any part of it when given the "pathname" of the 
file.  
When a file is no longer needed, it can be deleted and
\*(x1 returns the space it occupied to the pool of available free space.
A disk device contains not only the files themselves, but also
the information needed to locate the files on the disk and manage them. 
Together, these are called the "file system".
A simple \*(x1 system contains one disk device which is set up as a single 
file system, with the exception of a small area reserved for swapping, 
the process of switching data back and forth from the disk to the main
memory of the computer.
Instead of being used as a single storage area, however, the disk may be
partitioned into several distinct areas.  
Each partition may be a separate file system.  
.H 2 "Creating File Systems"
You may find it convenient to set the system up so that a file system is
resident on a floppy disk. 
To do this, you must create the file system on the floppy with the
.B mkfs
command. 
Be sure you have a formatted floppy disk available, with nothing
of value on it; it must have a write-enable tab.
(For directions on how to format a new disk, see Chapter 6.)
If a file system already exists on disk, it will be destroyed
by this procedure.
Remember, each of the devices on your system has a name, and each
device has a corresponding file by the same name in the
.I /dev
directory. 
The floppy disk drives are called \*`fd0\*', \*`fd1\*', and so forth. 
(Hard disk drives are named \*`hd0\*', \*`hd1\*', etc.)
Insert a floppy disk in one of the floppy drives, and enter one of
the following command lines.
Be sure to give \*(x1 the correct drive name and note whether you
have a single-sided or double-sided floppy disk. 
.P
If you have a double-sided disk, you will need to enter the command 
line:
.DS I
$ /etc/mkfs /dev/rfd0 2448 2 16
.DE
If you have a single-sided disk, use:
.DS I
$ /etc/mkfs /dev/rfd0 1216 2 16
.DE
The numbers \*`2448\*' and \*`1216\*' represent the total number of
disk blocks on the floppy disk for double- and single-sided disks
respectively.
The numbers \*`2\*' and \*`16\*' are magic numbers which tell \*(x1 how
to arrange information on the disk.
.H 2 "Mounted File Systems"
Once you have created file systems on floppy disks, you will have
to use the 
.B mount
command in order to access them. 
\*(x1 must be told about any file systems other than the 
.I root 
system, which is always present on the system.  
If you have several often used floppy-based file systems,
you can place the 
.B mount 
command and the names of the file systems in the
.I /etc/rc
file, which is read by the system when it is first booted. 
.P
To mount a file system on the floppy in drive 0 onto the directory
called 
.I /acct.records
type:
.DS I
$ /etc/mount /dev/fd0 /acct.records 
.DE
The directory you are mounting must be empty and not your current,
working directory. 
Once you have typed this, 
.I acct.records
becomes the top level directory on the floppy disk. 
Any new directories you create in
.I acct.records
are resident on the floppy disk.
The mounted file system is attached to the root system.
.P
Before removing the mounted floppy, type:
.DS I
$ /etc/umount /dev/fd0
.DE
This \*`unmounts\*' the file system and leaves it in a consistent state.
.H 2 "XENIX System Security"
Although security is more of an issue on larger systems, every
system manager must take into consideration the protection of data
and programs from unauthorized inspection or change.
This concern may be present no matter how many regular users you have.
Even if you have only one terminal attached to your \*(x1 system,
you may have different users authorized to access the system
for different tasks at different times.
The key to system secuirty is to use \*(x1 tools to maximum advantage.  
Intelligent decisions about the following can make a big difference in 
overall system security: 
.BL
.LI
the establishment of user accounts and group ID 
.LI
initial password selection and changing of passwords
.LI
the assignment of permissions to maximize file protection, while still
allowing convenient access to user files and directories.
.LE
.P
In addition, you should consider taking physical security precautions:
.BL
.LI
removing the key from the hard disk 
.LI
organizing and locking up floppies
.LI
making sure all your users log out when they are finished working
.LI
protecting the work area from intrusion
.LI
protecting the computer and disks from physical damage through exposure
to cigarette smoke, spilled coffee, or the use of ball point pens to make
notations on disk labels, etc.
.LI 
keeping some backups off-site, in case of disaster in the computer area.
.LE
.sp
Once again, be sure that you limit the use of the super-user login, to 
minimize the risk of accidentally damaging system files and programs.
.H 3 "Protection and Permission"
When considering the assignment of permissions,
note the special case of access permissions for directories.
Remember that the execute permission bit for directories grants 
permission to search the directory for a given file
during the scanning of a pathname. 
If a user has execute permission, but not read permission, to a given 
directory, he may access files in that directory,
even though he is unable to read the contents of the directory.
Write permission on a directory means that the user may 
create and delete files in that directory.
.P
The capacity of the
\*`super-user\*' to read and write to any file in any directory, 
and change any permission settings can present serious security
problems.
The root password can only be given to individuals who are authorized to
read and change any file in the system.
Also, the use of the root login should be severely
restricted because of potential damage to the system.
Even the system manager must be extremely cautious 
about operations undertaken while logged in as root.
.P
To ensure both data privacy and integrity, it is usually sufficient
to set the permission on your files so that they are inaccessible to others.
However, if you have some special reason to protect a text file, you can
use the
.B crypt
command to \*`encode\*' document text.
This should not normally be required on a system where \*`read\*' access
has been limited.
.P
Needless to say, the system manager must be careful to assign the correct
protection to the files under his control.
In particular, it is necessary that special device files be protected
from writing, and probably reading, by ordinary users when
sensitive files belonging to other users are stored on the system.
It is easy to write programs that examine and change files by accessing the 
device on which the files are resident.
.H 3 "Password Security"
You should discourage users from choosing passwords that
are easily remembered, and hence readily guessed:
these tend to be short, from a limited alphabet, often found in the
dictionary, and frequently something obvious like the user's own nickname or 
license plate number.
They should be reminded that this defeats the idea of having passwords.
Passwords should be at least six characters long and randomly chosen from an 
alphabet which includes digits and special characters.
.H 3 "Restating the Obvious"
The most obvious but often neglected security problem results
from users failing to log out of the system when they finish their work, 
leaving all the files to which they have access vulnerable to unauthorized 
use.
Inexperienced users should be repeatededly reminded to log out.
Restricting access to the work area, locking up archives of floppy-based
data and programs, and removing the key to the hard disk are simple
protective measures that can be taken if a high level of security is
required.
.TC
