.nr H1 4
.H 1 "Keeping Your \*(x1 System Healthy" 
.PH ''XENIX~Operations~Guide''
Keeping your \*(x1 system running smoothly depends largely on two factors:
.BL
.LI
maintaining file system integrity, that is, having \*`clean\*' file systems 
.LI
ensuring that adequate free disk space is available to the users
.LE
.P
In this chapter you will learn about \*(x1 processes--what \*(x1 does with 
the programs and other tasks on the system.
Some automatic system-checking programs called \*`daemons\*' are introduced,
along with an important \*(x1 system file called
.I /etc/rc.
Then,
you will be introduce you to a number of \*(x1 tools which will aid you, 
the system manager, in performing system maintenance tasks.
These programs help you clean up files and file systems 
by reporting how much disk space is being used and helping you locate little 
used files.
Finally, you will learn how to communicate with the other
users on the system, so that you can enlist their cooperation in preserving
the health of the system.
.H 2 "Processes"
All functions running on the system--including system and user programs,  
editing, etc.--are \*`processes\*'.
Several users may each have several processes running simultaneously
and it is often necessary to check whether certain processes are
running, in order to stop or \*`kill\*' them. 
The
.B ps
or \*`process status\*', command can be used to list the processes
currently running. 
The output of 
.B ps 
is the list of processes running from the terminal at which 
you typed the command.
When, however, you add the switch \*`-a\*':
.DS I
ps -a
.DE
your output will be all the processes running on the system:
.DS I
.nf
PID  TTY  TIME  CMD
167  co   0:04 
603  01   1:01  vi file.c
.fi
.DE
The first column is the process ID, the name by which the process
is identified if, for example, you need to kill it.
The second column is the number of the terminal from which the
process is running; note that several processes may be running
from a single terminal. 
The next column is the total time for which the process has been
running.
Finally, the name of the command or program is given.
You will often have use for the
.B ps
command while doing system maintenance.
.H 3 "Daemon Processes"
In addition to those programs which you yourself will use in the course 
of your system maintenance work, you should be aware that there are also a 
few other programs that run automatically whenever you use your \*(x1 
system.
These are called \*`daemons\*' (pronounced like \*`demons\*'). 
These daemon programs periodically check the system or perform basic 
system functions.  
Some examples of daemons are:
.BL
.LI
.B update 
\*`updates\*' the disk by automatically writing information from memory back 
to your disk every thirty seconds. 
This ensures that in the unlikely event that your system \*`crashes\*' or halts
abnormally, the information recorded on disk will be as current as possible. 
.LI
.B lpd
superintends the operation of the lineprinter.
.LI
.B cron
acts like an alarm clock, allowing you to execute commands and jobs
at times you specify in advance.
It repeatedly looks in a file called
.I /usr/lib/crontab
for instructions to perform these functions.
.LE
.H 3 "The \fI/etc/rc\fR file"
Ordinarily, the commands to start these daemons running is put in the
.I /etc/rc
file, which runs automatically at the time you boot \*(x1. 
The
.I /etc/rc
file also contains directions to the system to perform other functions. 
For example, it may contain a message that greets you when you log in,
or direct the system to ask you for the time. 
If you have file systems which need to be mounted 
the mount commands can also be placed in 
.I /etc/rc, 
so that these file systems are automatically mounted when the system
is booted.
If you are logged in as root, you may edit 
the
.I /etc/rc
file, to add the names of file systems which need to be mounted or change
the system greeting message.
You can also add commands to perform any functions you decide must be
repeated whenever the system is rebooted. 
.H 2 "The Importance of Disk Space" 
Available disk space rapidly becomes a precious commodity on any computer
system.
As users compile programs, edit files, or perform other tasks,
they are competing for this valuable resource.  
On a typical system, the potential for running out of free disk space 
is very high, and when this actually occurs, no new
files can be created, nor can any existing files expand.
If possible, each file system should contain approximately 15% free space,
more if usage of the file system fluctuates, less if it is relatively 
stable.
It is extremely important that you anticipate the risk of running out of space.
Regard the task of monitoring disk space as an essential part of preventive 
maintenance.
.P
\*(x2 offers some techniques for finding out how much free space exists in a 
particular file system, and determining which files might be candidates for
deletion if there is a shortage of space .
The \*(x1 commands that will help you determine the status of disk space on a 
file system and help you remove unwanted files are:
.VL 15 
.LI "\fBdf\fR"
disk free
.LI "\fBdu\fR"
disk usage
.LI "\fBfind\fR"
find files
.LE
.sp
Each of these is introduced briefly in the following sections. 
However, you will probably also want to refer to the
.I
\*(x1 System Reference
.R
volume for more information.
.H 3 "The df Command"
This command prints out the number of free blocks available in whatever
file system is specified.  
If no file system is specified, the
free space in all normally mounted file systems is printed.
You can just type in
.DS I
df
.DE
or you can specify a file system:
.DS I
df /dev/root
.DE
The output will look something like:
.DS I
/dev/root 7008 
.DE
This indicates that the root file system has 7008 free disk blocks. 
.P
Naturally, you must know the size of your hard or floppy disk in blocks
to determine what percentage of the total disk these numbers represent.
The table below summarizes the sizes of typical floppy and hard disks
in both blocks and kilobytes:
.DS
.TS
center allbox;
c s s 
l l l 
l n n 
l n n 
l n n 
l n n.
DISK STATISTICS
Media	Blocks	Kbytes	
8" single floppy	1216	608	
8" double floppy	2448	1224    
8-meg. hard	14,909	7454.5  	
12-meg. hard	20,961	10480.5	
.TE
.DE
With experience, you will come to know your system usage well enough to
know whether disk space is critical.
.H 3 "The du Command"
Let's suppose that you discover when you use the
.B df
command that you have a shortage of disk space.
Now you have to do some detective work to find out where space may be
wasted on your system.
The command
.B du 
gives the number of blocks that are used by files in the 
specified directory and each of its subdirectories.
If you use 
.B du
with no filename specified, it will report the size in blocks, of
every directory and file, starting at the current directory.
Or, you can give it a file or directory name.
In this case, you would probably search the entire 
.I /usr
directory for excessively large files and directories.
Part of the output might look like this:
.DS I 
du /usr
...
208     /usr/anthonys/admin
378     /usr/anthonys/mp 
999     /usr/anthonys/junk
1585    /usr/anthonys 
26      /usr/johnd/memos
235     /usr/johnd/payroll
261     /usr/johnd
...
.DE
.H 3 "The find Command"
The 
.B find 
command is an extremely useful tool for finding files by size, 
date, owner, and date of last access.  
It will help you locate old files that the user rarely or never accesses but
has neglected to remove, or files that seem excessively large.
Incidentally, you can also use the
.B find
command to locate a file if you have forgotten where it is in your
directory hierarchy.
.P
In the preceding example we used the
.B du
command to search 
.I /usr
for possible wasted space, and discovered a suspicious file named
.I /usr/anthonys/junk 
with a size of 999 blocks. 
You could also use the 
.B find
command
with the \*`-atime\*' specification followed by a number of days within which 
a file hasn't been accessed. 
You may discover that the file
.I /usr/anthonys/junk 
has not been accessed for a month. 
It is probably safe to remove it.
.P
Occasionally, while you are working on the system you may inexplicably get the 
message: 
.DS I
memory fault -- core dumped
.DE
This does not mean that there is something wrong with your system.
An error in a program causes
\*(x1 to automatically store output in a binary file
called 
.I core 
in your current directory.
Most users will not bother to access this file, but will often forget
to delete it; this is often a good place to look for wasted disk space.
(Files named
.I tmp
are other likely candidates.)
.P
In the following example, the 
.B find 
command can be used to search for all the files named 
.I core 
which have not been acced for a week.
.DS I 
find /usr/anthonys -name core -atime +7 -print 
.DE
The specification  \*`-name\*' means you want the
.B find
command to look for a file by the name which follows.
The specification \*`-atime\*' means you want to search for files which have not
been accessed within the number of days which follow.
Be sure to specify \*`-print\*', or the
.B find
command will not let you know what it found.
Because the various forms of the 
.B find
command are rather complicated, it is a good idea to consult the
.I
\*(x1 System Reference
.R
volume for more details.
.H 3 "The quot Command"
The
.B quot
command is another useful reporting tool. 
It prints the number of blocks currently owned by each user in the named
file system.
If you type
.DS I
quot -n /filesys
.DE
will give you a list of all files and their owners in the 
file system called
.I filesys .
.H 2 "Communicating With Other Users"
Enlisting the cooperation of your users is, in a way, one of your
most powerful maintenance tools.
Communication with the other system users can be a tactic to aid you in your 
quest for free disk space.
For example, the 
.I /etc/motd 
file, which contains the \*`message of the day\*', can be edited to gently remind 
users that space is low and that old files should be deleted.  
If, in using the tools described above, you discover that one particular
user has more than his fair share of disk space, try a message directed
at the offender, using the 
.B mail 
command, if the mail program is available on your system.
.DS I
mail anthonys
It's time to clean up your files! <CONTROL-D>
.DE
You can also reach all the users who are logged in immediately with the
.B wall
(write all) command, if it is available on your system.
.DS I
wall
There is a shortage of free disk space.
Clean up your unused files.<CONTROL-D> 
.DE
Try to reserve the use of 
.B wall
for emergencies, however, because it disrupts other users.
Also, remember to edit your
.I /etc/motd
file daily, so that the users don't come to expect old and unreliable 
information.
.H 2 "File System Integrity"
In addition to the problem of maintaining adequate disk space, 
there is the possibility that a file system may develop inconsistencies.
A file system consists of files, and these files, in turn, 
consist of blocks of bytes.
If a block of information is bad, then the file, and potentially   
the entire file system,  is compromised. 
A file system's integrity is compromised when it is internally inconsistent.  
This occurs either when the system has not been shut down properly or if
there is a hardware error due to faulty disk drives or floppy disks.
.P
A program called
.B fsck
or file system check, is the tool \*(x1 uses to check the consistency
of file systems and, if necessary, repair them.  
If the system has not been shut down normally, the next time you attempt to 
boot the system you will be asked if the system should proceed with 
\*`cleaning\*'.
You should always answer yes to this question.
If your file system is \*`dirty\*', that is, inconsistent, all of your files 
are at risk.
.P
The 
.B fsck
program is responsible for file system cleaning.  
If you have reason to suspect that file system inconsistency is responsible
for any abnormal behavior, you should invoke
.B fsck,
followed by the name of the questionable file system.
However, you should not use 
.B fsck 
indiscriminately,
because it will occasionally delete damaged files during its cleanup process. 
.P
Here is an example: 
.DS I
.nf
fsck /dev/hd0 
.sp
** Phase 1 - Check Blocks
** Phase 2 - Check Pathnames
** Phase 3 - Check Connectivity
** Phase 4 - Check Reference Counts
** Phase 5 - Check Free List
 426 files 6753 blocks 7008 free
.DE
.TC
