.nr H1 5
.H 1 "Backing Up Your System"
.PH ''XENIX~Operations~Guide''
The importance of \*`backing up\*' or making copies of all the files on
your system cannot be overemphasized.
Backups are the only insurance your users have against time-consuming
and costly losses of their programs and data.
You should no more consider skipping a scheduled backup because you
think you won't be needing it, than you would consider skipping an insurance 
payment.
In addition to inevitable, everyday user mistakes--deleting, 
changing, or writing over files, there are more catastrophic possibilities: 
accidental damage to \*(x1 system software or hardware failure.
If you are lucky, you will rarely need to use your backup copies, but 
nonetheless you must have a systematic plan for scheduling backups. 
You must also determine how often a full backup is required, and decide 
where, and for how long, you will store your backups.  
Some suggestions are provided here, but you will have to assess the needs 
of the users on your own system.
.P
The \*(x1 system offers several ways to make copies of
system and user files.  
Which method or methods you choose will depend on several factors:
whether you have a hard disk or floppy-only system, how often the
contents of your disks change significantly, and the total size of
your system. 
The following procedures are discussed in this chapter:
.BL
.LI
formatting and copying disks with the standalone 
.B diskutil
program
.LI
using the
.B tar
program to copy the contents of a file system
.LI
using the
.B sysadmin
program to simplify backup and restore functions
.LE
.H 2 "Formatting Floppy Disks"
You must format and copy floppy disks with the same standalone 
.B diskutil
program which you used to install \*(x1 on the hard disk. 
Therefore, it is necessary to bring your \*(x1 system down, then 
logging in as root and using either the
.B shutdown
or
.B haltsys
commands.
Of course, you will want to minimize the need for shutting down the system,
especially if you have several users.
The system manager should plan to format spare floppy disks in advance,
and perhaps copy disks for other users when the system is not in use. 
Every disk you format or copy must have a write-enable tab.
You should also note the following sizes, so you can determine
how much data will fit on a floppy disk:
.ne 4
.TS
allbox;
c s s 
l n n
l n n.
Disk Sizes
Disk	#blocks	#kbytes
8" single-sided	1216	608
8" double-sided	2448	1224
.TE
.P
The 
.B df ,
.B du ,
and \fBl\fR 
commands all give file sizes in disk blocks.
When you create a file system, the
.B mkfs
program requires the number of blocks as an argument.
Both the
.B tar
program and
.B sysadmin,
the two programs for copying disks we will discuss in this chapter 
will expect you to indicate the number of kbytes on your disks.
.P
You will be using the
.B diskutil
program in much the same way you did when you first installed \*(x1 on your 
hard disk. (See your 
.I 
\*(x1 Installation Guide)
.R
The
.B diskutil
program will prompt you during either of the following procedures:
.BL
.LI
formatting hard (8-or 12-megabyte) or floppy (single-sided or double-sided) 
disks
.LI
copying single-sided or double-sided XENIX disks 
.LE
.P
Here is what you would see on your screen during a sample 
.B diskutil 
run to format floppy disks.
(Your responses are indicated in boldface and explained in brackets.)
.DS
.TS
box expand;
L.
.sp 2
XENIX Boot
: \fBdiskutil\fR
.sp
Copy or format (c or f)? \fBf\fR [for format]
.sp
Hard or floppy disk (h or f)? \fBf\fR [f for floppy disk]
.sp
Floppy drive number (0..3)? \fB0\fR [drive 0]
.sp
XENIX format, IBM single-density
  or IBM double density format (x or I)? \fBx\fR 
                            [xenix]
.sp
About to format floppy disk in XENIX format.
Insert disk in drive 0.
Type <ENTER> to proceed or <BREAK> to abort:\fB<ENTER>\fR
.sp
This will take about 77 seconds.
.sp 2
.TE
.DE
You will see the cylinder and side numbers changing
while the formatting is in progress.
If for some reason your disk is defective, you will see this message
instead:
.DS
.TS
box expand;
L.
.sp 2
**Format verify failed**
.sp 2
.TE
.DE
The location of the bad spot on the floppy disk will be given, followed
by the warning \*`Disk is unusable\*'.
.P
If you attempt to format a floppy which already has data on it, your
\*(x1 system will tell you:
.DS
.TS 
box expand;
L.
.sp 2
**Destination disk is not blank**
Any data on it will now be lost if you proceed.
.sp 
Type <ENTER> to proceed or <BREAK> to abort:\fB<ENTER>\fR
.sp
Floppy disk in drive 0 successfully formatted.
.sp 2
.TE
.DE
At this point you will be given the opportunity to repeat the formatting
process on another floppy.
Type <BREAK> if you have no more floppies to format, then flip the RESET
switch to
exit from
.B diskutil ,
and reboot the system.
.H 2 "Copying Floppy Disks"
Of course you may have many reasons to make copies of your programs and
data on floppy disks besides routine backups.
Once again, however, remember that since you will be using the
.B diskutil
program, you will have to shut down the
system to make floppy disk copies. 
Try to plan copying activity at a time which will not inconvenience other
system users.
The procedure for copying data from one floppy disk to another with the
.B diskutil 
program is quite similar--the same script will appear on your screen.
The
.B diskutil
program will automatically format disks before it copies data to them.
This time, when you type
.DS I
diskutil
.DE
after the boot prompt,
simply type \*`c\*' for copy instead of \*`f\*' for format:
.DS
.TS
box expand;
L.
.sp 2
Copy or format (c or f)?  
.sp 2
.TE
.DE
You will be asked for the number of the \*`source\*' and \*`destination\*'
drives:
.DS
.TS
box expand;
L.
.sp 2
Source drive number (0..3)?
Destination drive number (0..)?
.sp 2
.TE
.DE
The \*`source\*' drive contains the floppy from which you are copying the
data, and the \*`destination\*' drive should contain the disk to which you wish
the data to be copied.
Respond with the correct drive numbers.
.P
The 
.B diskutil
program will tell you exactly what you need to do:
.DS
.TS
box expand;
L.
.sp 2
Insert source disk in drive 0.
Insert source disk in drive 1.
Type <ENTER> to proceed or <break> to abort.
.sp 2
.TE
.DE
If you are copying data to a disk which has already been formatted, or
one which already contains other data, you will receive a warning message:
.DS
.TS
box expand;
L.
.sp 2
**Destination disk is not blank**
Any data on it now will be lost if you proceed.
.sp 
Type <ENTER> to proceed or <BREAK> to abort.
.sp 2
.TE
.DE
If you type <ENTER>, you will see
.DS
.TS
box expand;
L.
.sp 2
This will take about 154 seconds.
  Copying cylinder 4, side 1.
.sp 2
.TE
.DE
The cylinder and side numbers change as the copying takes place.
When the copy is finished you will see the message:
.DS
.TS 
box expand;
L.
.sp 2
Disk copy and verify complete
.sp 2
.TE
.DE
.P
Note that if you are working on a system equipped with only one floppy
disk drive, you will be unable to copy floppy disks.
In fact, if you give the same number for the source and destination
disk drives, you will get this message:
.DS
.TS
box expand;
L.
.sp 2
Copying a disk to itself is of questionable value.
.sp 2
.TE
.DE
You cannot make a copy by inserting one disk in drive 0, then pulling it
out and quickly inserting another.
.B Diskutil 
will go through the motions of copying the disk to itself, however.
.H 2 "When to Make Backups: Daily and Periodic Backups"
A \*(x1 program called
.B sysadmin
allows you to perform two levels of backup.
For simplicity, these are called \*`daily\*' and \*`periodic\*'.
Although a suggested schedule might include a \*`daily\*' backup every
day and a \*`periodic\*' backup once a week,
you will have to decide what is appropriate for your system; 
this will normally depend on how heavily the system is used, and how often
the majority of files are changed.
A periodic backup should be done at least once a month.
.P
It is probably a good idea to keep other users off the system while you
are doing backups, if this is at all possible.
At the very least, there should be little or no activity on the system--
to avoid changes to a file while it is being copied.
Needless to say,
backups should be scheduled so that they have the least possible impact on 
users.
.P
When you do the periodic backup you will be copying the entire 
.I root
file system to floppy disks. 
Since a relatively small number of the files in a file system change 
frequently, however, it is possible to supplement your periodic backups
with \*`daily\*' backups.
The daily backup is incremental; that is, it only makes a copy of those 
files which have changed since the last periodic backup.
.H 2 "Archiving and Taking Care of Your Disks"
You will rapidly accumulate a great number of floppy disks.
These will include:
.BL
.LI
\*(x1 distribution disks
.LI
application packages
.LI
user file systems
.LI
backups
.LE
.sp
Each full, or \*`periodic\*', backup of the \*(x1 system may require a large
number of floppy disks (e.g., seven or eight double-sided disks to back up
a \*(x1 system with an 8-megabyte hard disk).
You must have enough disks on hand to keep the backup disks in reserve
for several weeks, as well as sufficient spares on hand for your users.
In addition, you should develop a simple but logical method for organizing,
labeling, and storing your disks.
Since your floppy disks will contain valuable, and in some cases, irreplaceable
data, a high priority should be given to safety and security.
You should consider designating an off-site storage area in which to keep
alternate backups, to enable recovery from a disaster which damages your
computer area.
.P
You should develop a consistent policy for saving your backups; 
resist the temptation to immediately reuse the backup disks. 
Anticipate that
users will occasionally ask for the restoration of relatively old files.
One approach is to save the full or \*`periodic\*' backup disks for an 
indefinite period after they are made,  and the incremental backups for
at least two weeks.
You can easily rotate these disks back into use for new backups.
.H 2 "Using the tar Command"
The
.B tar
program
is one convenient way to copy a small number of files or directories to floppy 
disks.
Although it is a more complicated command, you may wish to use
.B tar , 
because it allows you to copy files to floppy disks without 
shutting down the system.
To use
.B tar,
make sure you are logged in as root,
insert a formatted floppy disk in the drive, and type the command in the 
following form:
.DS I
tar cvf /dev/fd0 file1 file2 file3
.DE
Note that you must follow
.B tar
and the switches
.B cvf
with the name of the device to which you want the files copied.
In the above example, 
.I file1 ,
.I file2 ,
and
.I file3
are being copied to floppy drive 0.
Note that you need not use either
.B mkfs
or the
.B mount
command to copy to this disk.
If you are copying directories, the whole directory tree starting from
the directory or directories you name will be copied.
To get your copies back onto the hard disk, position yourself in the 
directory into which you
need to copy the files or directories and type:
.DS I
# tar xvf /dev/rfd0
.DE
(Consult the 
.I
\*(x1 System Reference
.R
manual for more information about using the
.B tar
command.
.H 2 "Using the sysadmin Program"
The
.B sysadmin
program will work on any hard disk \*(x1 system.
Logged in as root, just type the command:
.DS I
sysadmin
.DE
.B Sysadmin
is a script for performing file system backups and for restoring
files from backup disks. 
It can do either a \*`daily\*' backup or \*`periodic\*' backup. 
It also has an option to provide a listing of the files backed up, and a 
facility for restoring individual files from backup disks.
.P
.B Sysadmin
will work with either single-sided or double-sided
\*(x1 formatted disks.
By default, it backs up the 
.I root
file system. 
The script can also be edited to back up additional file systems, if required.
Optionally, you can list the names of the files which have been backed up
and store them in a file called
.I /tmp/backup.list.
.H 3 "How to Do a Backup With Sysadmin"
If you are doing either a daily or periodic backup, first be sure that
you are logged in as root.
Be sure you have on hand a sufficient number of blank, or reusable, formatted
floppy disks with write-enable tabs.
In response to the prompt, type:
.DS I
sysadmin
.DE
The 
.B sysadmin
program will produce a menu of \*`File System Maintenance\*' tasks for you:
.DS 
.TS
box expand;
L.
.sp 2
     File System Maintenance 
     ----------------------
Type 1 to do daily backup
     2 to do a periodic backup
     3 to get a backup listing
     4 to restore a file
     5 to quit 
.sp 2
.TE
.DE
Respond with either \*`1\*' or \*`2\*', depending on which type of backup
you want.
You will be asked to indicate whether you are using single-sided (1) or 
double-sided (2) disks.
Then insert your disk in drive 0 and type <ENTER>.
The system will respond with the current date, followed by the date of
the last system backup.
If the system has never been backed up, you will see the phrase \*`the
epoch\*'; in this case, everything on your \*(x1 system will be backed up,
even if you chose the \*`daily backup\*' (number 1) from the 
.B sysadmin
menu.
.P
As the backup proceeds, the red disk drive light will be on, you
should hear the sound of the floppy disk drive.
A series of messages will come to your terminal.
The only one that need concern you is the instruction to \*`change 
volumes\*'.
When you see this message, remove the first disk and replace it with a second.  
Type <ENTER> after the new disk has been inserted.
You will probably need to repeat this process several times before the
backup is complete.
Do NOT remove any disk until you see the \*`change volumes\*' instruction.
Since the backup process may require several floppy disks, be sure to label
each volume of the backup correctly as you change disks.
.P
If you make a mistake at any time in the process, you will have to begin
the backup again.
You may receive a message like:
.DS 
.TS
box expand;
L.
.sp 2
dump: write failure on /dev/rfd0
.sp 2
.TE
.DE
This will occur if you are using a disk which has not been correctly formatted,
or if your floppy disk drive has malfunctioned during the backup process.
You will be returned to the super-user system prompt. 
Type
.DS I
sysadmin
.DE
again, to reenter the
.B sysadmin
program. 
.H 3 "Getting a Backup Listing"
You will find it useful to keep a record of the files you have backed up.
To do this, return to the
.B sysadmin
program after the daily or periodic backup and type \*`3\*' to receive a
backup listing.
You will be prompted to reinsert the backup disks in the same order that
they were used to do the backup.
.B Sysadmin
will read the filenames off the backup disks and place them in a file
called
.I /tmp/backup.list.
You should print this list on your lineprinter, then delete the file, using
the command:
.DS I
$ rm /tmp/backup.list
.DE
.H 3 "Restoring a File"
If you need to restore a file from a backup, enter 
.B sysadmin
and choose option \*`4\*' from the menu.
Unless you have experienced a widespread disaster, you should plan to
restore files one at a time.
When you restore a \*(x1 file, it will be assigned 
a number rather than its original name. 
This number, called the \*`inode\*' number, is unique to a single \*(x1
file. 
The 
.B sysadmin
program cannot recognize the difference between files of the same name
in different directories because it does not know about pathnames. 
The file you restore will be placed in your current working directory.
To avoid possible confusion, you must rename it back to its original
name and move it into its correct position in the directory 
hierarchy.
.TC
