 .nr Ej 0
 .tr ~ 
 .ds x1 \s-2XENIX\s+2\"
 .ds x2 X\s-2ENIX\s+2\"
 .ds u1 \s-2UNIX\s+2\"
 .ds u2 U\s-2NIX\s+2\"
 .if n .po 1.25i
 .if n .ds ` ""\"
 .if t .ds ` ``\"
 .if n .ds ' ""\"
 .if t .ds ' ''\"
 .SA 1
 .de FN
 .if n .I \\$1 \\$2
 .if t .I \\$1 \\$2
 ..
 .de Q
\\*`\\$1\\*'\\$2
 ..
 .PH ''''
 .ce
 .B "INSTALLATION GUIDE"
 .sp 2
 .nr Hu 2
 .H 1 "Introduction: Your XENIX System Distribution"
 .PH ''XENIX\0Installation''
 .PF "''- \\\\nP -''"
 .sp
Before you can begin to use the \*(x1(TM)* 
 .FS * 
\*(x1 is a trademark of Microsoft Corporation.
 .FE
system on your computer, you will need to transfer
the \*(x1 system programs from the floppy disks 
in your distribution package
to your hard disk.  
This is a fairly straight forward procedure 
which should take about an hour,
and which you should not need to repeat, 
except in the unlikely case that
your computer hardware is damaged, 
or essential \*(x1 programs are accidentally
removed or changed.
Nonetheless, it is recommended that once 
you complete the installation 
you keep your distribution package and your
 .I "Installation Guide"
together in a safe place, so that 
you will be able to install your \*(x1 
system again, if necessary. 
 .P
Like any other operating system, 
\*(x1 is a collection of programs which
are always running on your computer to control its resources. 
An operating system provides a way 
for user programs to communicate with
the physical components of the computer--its hardware. 
These programs
make possible communication 
between the central processing unit (CPU), 
input/output (I/O) devices, 
such as lineprinters and terminals, and storage
devices, including hard and 
floppy disk drives. 
These programs also control the user's access 
to the files on the system,
and determine what share of processing time each program will get.
An operating system ensures that processing time and disk space will be
fairly distributed among users. 
 .P
What is unique to \*(x1 is its capacity to serve multiple users 
and to allow several programs, or processes, to run simultaneously.
In this respect, \*(x1 is similiar to much larger and more expensive
computer systems.
However, the extent to which you will be able to make effective use of
its powerful features will depend somewhat 
on the characteristics of your hardware components.
In this guide we will assume that you are either adding \*(x1 to your 
existing computer system, 
or have at least unpacked and assembled your system,
if it is new.
It will be your responsibility to read the hardware manuals provided
with your computer and 
get it properly connected before you begin installation. 
 .ne 6i
 .H 1 "Some Things to Know Before You Start"
Because you may feel a bit apprehensive about 
using your \*(x1 system
for the first time, some basic information is included here 
to make you feel more comfortable about its operation.
If you read this chapter before beginning to install and use \*(x1,  
you may spare yourself some worry and confusion about the following:
 .BL
 .LI
How to start and stop your system safely and what to do if the
system halts accidentally
 .LI
What you will need to begin the installation procedure
 .LE 1
 .HU "Stopping the System Safely During Installation"
 .sp
You should 
 .I not 
ordinarily hit the RESET or POWER switches 
or unplug your computer while \*(x1 is running.
However, during the installation process 
you may use the reset switch to
terminate the program if you think you have made an error.
You cannot damage either \*(x1 or your computer 
if you make a mistake, as
long as you stop the installation and 
begin the entire procedure again. 
Just use the RESET switch to stop the procedure, and 
repeat the entire installation from the beginning.
Admittedly, this takes some extra time, 
but it should be well worth it--
you will be ensuring that 
you have a correctly installed \*(x1 system.
If you do accidentally stop the system during the installation--
by flipping the POWER or RESET switch, or unplugging the system--
just turn the system on again and repeat the installation.
 .P
Once you have sucessfully installed \*(x1, 
that is, once you have reached the point 
where you can log in and begin work,
you must take care 
to follow the directions 
for bringing down your system correctly.
You will be using a \*(x1 command 
to shut down the system safely.
(This is described in detail in Section 3.)
Using the POWER or RESET switches or 
unplugging your computer may actually damage your files and programs.
 .HU "What You Will Need"
 .sp
There are a few things you will need in order 
to complete your installation successfully. 
These are:
 .AL 1
 .LI
Your System 86/3XX.
 .LI
Your \*(x1 distribution package, including your \*`Boot Disk\*' and the
set of \*`Install\*' disks.
 .LI
Your 
 .I "Installation Guide"
(which you are now reading) and access to the 
 .I "\*(x1 Operations Guide"
and the hardware manuals which came with your System 86/3XX
 .LI
Finally, a bit of your patience and time. 
 .LE 1
 .HU "Roadmap of the \*(x1 Installation Process"
 .sp
Before you can use your \*(x1 system, you will have to format the hard 
disk, and then transfer the information from the floppy disks 
in your \*(x1 distribution package to this disk.
This guide will give you straightforward instructions for getting
the installation job done.
Ordinarily, installation is a one-time-only operation,
but you will need to save your distribution disks in case of accidental
damage to either your hardware or \*(x1 programs. 
Then, if disaster does strike, you will be able to reconstruct the \*(x1 
system, along with the programs and data you have created, by
repeating the installation procedure, and then recovering your own files
from your backup floppies. (See the
 .I "\*(x1 Operations Guide"
Chapter 7, \*`Backups\*'.)
 .P
You should have little difficulty with installation,
even if you have never worked with a computer system before. 
The \*(x1 installation programs are designed to guide you step-by-step 
through the procedure.
The text on your screen will tell you exactly what you need to do, 
and prompt you for answers to some key questions.
Later on, if you are the user who is permanently responsible for
maintaining the system, or are just curious about how the system
works, you will want to read the 
 .I "\*(x1 Operations Guide,"
 .R
and 
 .I "\*(x1 Fundamentals"
 .R
for more detailed information.
The
 .I "\*(x1 System Reference"
manual also contains reference material 
about the programs you will be using during installation.    
 .P
Be sure that you allow plenty of time 
to complete the installation--at least an hour. 
The first, or formatting, phase of the installation is the longest; 
this will take approximately twenty to thirty minutes.
You should also allow half an hour for the initialization of the 
system and the transfer of all \*(x1 system files
to the system hard disk. 
This will vary somewhat with the version of \*(x1 you are installing.  
In addition,
you should take the time to read over this guide before you begin,
so that you will be familiar with the procedure in advance.
 .P
Before we begin, let's take a look at the two
phases of the installation process:
 .VL 10 
 .LI "Phase 1"
\*`Booting\*', or starting, your system running from the 
\*(x1 distribution \*`Boot\*' floppy disk.
A program called
 .B /etc/mksys
(that is, \*`make system\*')
formats your hard disk 
so that it will be ready for the \*(x1 system software.
 .LI "Phase 2"
Booting \*(x1 a second time, from the hard
disk, and
copying the contents of the boot floppy disk to the hard disk. 
This is done by running 
 .B /etc/mksys
again (this time it is a different mksys, but the command is the
same).
 .LE
 .bp
 .H 1 "Installing Your \*(x1 System"
 .sp
\*(x1 system installation is described here step-by-step.
Read the instructions carefully before you begin. 
Then follow the procedures exactly as they are written. 
Once again,
if you make a mistake at any time during the installation process, 
hit the <RESET> button and repeat the procedures from the beginning.
 .HU "Formatting the Hard Disk"
In order to install \*(x1, you must first format the hard disk.
You will begin by \*`booting\*' or starting your computer
using the \*(x1 \*`Boot\*' disk in your distribution package, and 
running a program called
 .B /etc/mksys.
 .P
To make your work easier, the
 .B /etc/mksys
program will tell you what it is doing and prompt you for
answers to some simple questions.
During installation 
 .B /etc/mksys
will do two things for you:
 .AL 1
 .LI
Format the hard disk
 .LI
Copy a small \*(x1 system onto the hard disk
 .LE
 .HU "Installation Diskettes"
If you ordered your \*(x1 Operating System on 8 inch media,
you received 9 diskettes with your \*(x1 System.  
The diskettes consist
of the following:
 .sp
 .DS I
Bootstrap Program -- 1 Diskette
Root Files        -- 3 Diskettes
User Files        -- 2 Diskettes
Manual Files      -- 1 Diskette
User Documents    -- 2 Diskettes
 .DE
 .sp 1
 .P
If you ordered your \*(x1 Operating System on 5.25 inch media,
you received the same groupings of diskettes, but more diskettes
within each group (with the exception of the Bootstrap Program
diskette).
 .P
You will need these diskettes 
in the following steps, so you should locate
them and have them ready for use.
 .sp
 .HU "Installation"
 .AL 1
First, power up your System 86/3XX.
You will see the green \*`active\*' light go on.
 .LI
Place the Bootstrap Program diskette into the flexible 
diskette drive and close the door.
 .LI
Press the RESET button on the System 86/3XX front panel.
 .LI
Wait for the asterisks to appear across the screen, 
then enter an uppercase "U".  
This stops the display of the asterisks and invokes the System 
Confidence Test (SCT).
 .LI
When the PIC (Programmable Interrupt Controller) 
test of the SCT prompts you 
for an input character, press the
INTRPT (interrupt) pushbutton on the System 86/3XX front panel.
 .P
The following will appear on the screen:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
*BREAK* at xxxx.yyyy   
\&.
 .R
 .sp 2
 .TE
 .DE
 .LI
Enter:
 .DS
 .TS
box expand;
L.
 .sp 1
 .B 
b :wf0:xenix.gen<CR>
 .R
 .sp 1
 .TE
 .DE
 .P
This tells the System 86/3XX to boot 
the small \*(x1 Operating System from
the flexible diskette.  
Note typing the wrong characters can be corrected
by using the delete or RUBOUT key.
 .P
The \*(x1 Operating System will check 
the base address of several devices
and display results similar to the following:
 .DS
 .TS
box expand;
L.
 .B
 .sp 2
iSBC 215 @ WUA 0100 Level 5 found
iSBC 544 Based 000E000 board 0 found
iSBC 544 Based 000E400 board 1 not found
iSBC 544 Based 000E800 board 2 not found
iSBC 544 Based 000EC00 board 3 not found
Console Data   00D8 Timer 2 found
LP Based       00C8 Level 4 found
   
mem = 284K
 .R
 .sp 2
 .TE
 .DE
 .P
Or, if your system 
has an iSBC 534 Serial Communications Board, you may find
the following display:
 .DS
 .B
 .TS
box expand;
L.
 .sp 2
iSBC 215 @ WUA 0100 Level 5 found
iSBC 534 Based 00030 board 0 found
iSBC 534 Based 00040 board 1 not found
Console Data   00D8 Timer 2 found
LP Based       00C8 Level 4 found
   
mem = 284K
 .R
 .sp 2
 .TE
 .DE
 .P
Note in both cases the "mem" refers 
to the memory available to users.  
The amount will vary depending 
on the actual system memory and the configuration of the system.
 .P
The prompt "<bootsys>" will appear.  
The erase character is the backspace
character (value 08 Hex).  
To stop and restart the output on your terminal,
you can use Control-S (value 03 Hex) and Control-Q 
(value 11 Hex) respectively.
The interrupt character, typically Control-C, 
is the delete character (value 7F Hex).  
 .LI
Enter the following to format 
and initialize the Winchester disk and install
a copy of the \*(x1 Operating System 
onto the Winchester disk:
 .DS
 .B
/etc/mksys
 .R
 .DE
 .P
In this command, 
etc is a directory on the flexible diskette and mksys is a
command to format and initialize the Winchester disk.
 .LI
The following prompt will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
About to initialize wini. Ok?
 .R
 .sp 2
 .TE
 .DE
 .LI
Enter a 
 .Q "y"
or 
 .Q "Y".  
If you enter any character except a 
 .Q "y" 
or
 .Q "Y" ,
the initialization sequence will 
abort and you will have to enter the
command /etc/mksys to restart the sequence.
Please note the initialization sequence will overwrite any
files existing on the Winchester disk.  Thus, if this is not
the first initialization of your system, you must back up any
files you wish to save from a previous system initialization.
 .LI
At this point, no further input is required.
The screen will display 
of status information as the Winchester 
drive is formatted.  
After about 5 minutes, the screen displays something like the following
(the actual numbers are dependent on the Winchester disk in your system):
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Formatted 2550 tracks: 0 thru 2549, interleave 4
Making root file - system ...
 .R
 .sp 2
 .TE
 .DE
Several parameters are then displayed, followed by:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Making remainder file-system ...
 .R
 .sp 2
 .TE
 .DE
 .P
Several more parameters are displayed, followed by:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Mounting /dev/w0a on /mng ...
Copying ...
/\*(x1 ...
/bin ...
 .R
 .sp 2
 .TE
 .DE
 .P
All the utilities needed to install the remainder of the \*(x1
system are automatically copied onto the Winchester drive.
 .P
When the following display appears, the nodes (which are the standard
device entry points into the \*(x1 Operating System) are created:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Making /dev ...
 .R
 .sp 2
 .TE
 .DE
 .P
About 3 minutes are required 
to make the device directory on the Winchester disk.  
This is followed by a message:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Installing mksys routines on wini ...
 .R
 .sp 2
 .TE
 .DE
 .LI
When the disk initialization is complete, the following message will appear
and the HALT LED on the system front panel will light:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
**  NORMAL SYSTEM SHUTDOWN **
 .R
 .sp 2
 .TE
 .DE
 .LI
Open the flexible disk drive door and press the RESET pushbutton.
 .DS I
\fBNOTE\fR
 .sp
Read the next step carefully before proceeding.  
You have 6 seconds after entering an uppercase
U to respond to the PIC test prompt by entering
an I.  If you do not respond within 6 seconds,
the PIC test will fail and the system will not
boot automatically.
 .DE
 .sp
 .LI
Enter an uppercase U when the asterisks start appearing on the CRT
terminal (about 10 seconds after you press the RESET pushbutton).
This will stop the display 
of asterisks and invoke the System Confidence Test (SCT).  
The SCT continues and will bootstrap 
the \*(x1 Operating System from the Winchester disk 
if no critical errors are encountered
during the SCT.
 .P
IF an error occurs during SCT, 
refer to the SYSTEM 86/3XX SERIES
DIAGNOSTIC MAINTENANCE MANUAL 
to determine the probable cause.  
After solving the problem, 
repeat the installation procedure from step 1.
 .LI
Upon bootstrap loading, the \*(x1 Operating System checks the base
address of several devices and displays the results as follows:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
iSBC 215 @ WUA 0100 Level 5 found
iSBC 544 Based 000E000 board 0 found
iSBC 544 Based 000E400 board 1 not found
iSBC 544 Based 000E800 board 2 not found
iSBC 544 Based 000EC00 board 3 not found
Console Data   00D8 Timer 2 found
LP Based       00C8 Level 4 found

mem = 284K
 .R
 .sp 2
 .TE
 .DE
 .P
Or, if your system has 
an iSBC 534 Serial Communications Board, you may find
the following display:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
iSBC 215 @ WUA 0100 Level 5 found
iSBC 534 Based 00030 board 0 found
iSBC 534 Based 00040 board 1 not found
Console Data   00D8 Timer 2 found
LP Based       00C8 Level 4 found
  
mem = 284K
 .R
 .sp 2
 .TE
 .DE
 .LI
After bootstrap loading the \*(x1 Operating System from the Winchester
drive, a "#" prompt will appear.  
Install the rest of the \*(x1 Operating
System to the Winchester drive by entering the following:
 .DS I
 .B
/etc/mksys
 .R
 .DE
 .LI
The following message will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Checking previously installed filesystem ...
 .R
 .sp 2
 .TE
 .DE
 .P
The \*(x1 Operating System performs a file system check and reports the
results as follows:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
** PHASE 1 - Check Blocks and Sizes
** PHASE 2 - Check Pathnames
** PHASE 3 - Check Connectivity
** PHASE 4 - Check Reference Counts
** PHASE 5 - Check Free List
 .R
 .sp 2
 .TE
 .DE
The screen also displays the number of file blocks that are free.
 .LI
If any file system problem is reported, 
repeat all steps up to this point.
If the problem persists, 
call your local Intel Field Service Representative or
Intel Field Applications Engineer (FAE).
 .LI
The following message will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Creating standard directories
 .R
 .sp 2
 .TE
 .DE
This is followed by a list of created 
standard directories 
which are preceded by a slash.
 .P
When you are prompted to insert a diskette 
and you make a mistake (such as
typing a carriage return before inserting the diskette), 
there is no reason to be alarmed.  
The /etc/mksys routine may be re-invoked 
as many times as necessary to finish installation.  
The error message
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
tar: cannot create /dev/rdf0
 .R
 .sp 2
 .TE
 .DE
may appear if you leave the door open 
on the diskette drive, or if you 
insert the diskette upside down.
 .LI
The following prompt will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Insert diskette labeled Root 1 of X and type a <CR>
 .R
 .sp 2
 .TE
 .DE
 .sp
 .LI
Remove the bootstrap diskette and 
insert the diskette labeled Root 1 of X
(where the value of X depends on whether you have 8 inch media
or 5.25 inch media) and enter a <CR>.
 .P
The contents of the diskette 
are copied onto the Winchester disk.  The name
of each file copied will be displayed.  
Ignore messages such as those listed
below.  
There is no problem:  these files were placed 
on the Winchester disk
by the previous steps and 
cannot be copied over because they are currently
being executed by \*(x1.
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
/bin/sh - cannot create
/bin/tar - cannot create
/etc/init - cannot create
 .R
 .sp 2
 .TE
 .DE
 .LI
When the copying operating stops, 
the following prompt will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Insert diskette labeled Root 2 of X and type a <CR>
 .R
 .sp 2
 .TE
 .DE
 .LI
Remove the diskette installed 
in the flexible disk drive and install the
diskette labeled Root 2 of X (note the value of X depends on whether
you are using 8 inch media or 5.25 inch media).  
After each diskette is inserted, type a
<CR> to copy the contents from 
the diskette onto the Winchester disk.
 .LI
After all diskettes labeled Root 
have been copied onto the Winchester
disk, copy the diskettes labeled USER onto the Winchester diskette,
followed by the diskette labeled User Manual (may not be required by your
system or application if storage space is limited) and then the 
diskettes labeled User Documents (may not be required by your system or 
application if storage space is limited).
 .LI
After all the diskettes have been copied, 
the following prompt will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Is there an upgrade yet?
 .R
 .sp 2
 .TE
 .DE
If there is an upgrade diskette, 
enter a 
 .Q Y 
or 
 .Q yes .  
A message will appear
asking you to insert the diskette and 
enter a <CR>. 
Otherwise enter an 
 .Q N 
or 
 .Q no .
 .LI
After the previous step has been completed, 
the following prompt will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Do you wish to setup Learn scripts?
 .sp 2
 .TE
 .DE
 .LI
Enter a 
 .Q y 
or 
 .Q yes 
if you want the learn scripts.  
If not, enter an 
 .Q n .
 .sp
If you entered a 
 .Q y 
or 
 .Q yes , 
the learn scripts are formatted and several messages
are displayed.
 .LI
The following prompt will appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Do you want the iSBC 534 setup for Login?
 .R
 .sp 2
 .TE
 .DE
 .sp
Enter a 
 .Q y 
or 
 .Q yes 
if you have an iSBC 534 installed in your system and want
the Login capability.  
If not, enter an 
 .Q n 
or 
 .Q no .  
The following prompt will
appear:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Do you want the iSBC 544 setup for Login?
 .R
 .sp 2
 .TE
 .DE
 .sp
Enter a 
 .Q y 
or 
 .Q yes 
if you have an iSBC 544 installed in 
your system and want
the Login capability.  
If not, enter an 
 .Q n 
or 
 .Q no .
 .sp
In either of the above cases, a 
 .Q y 
or 
 .Q yes 
response activates the appropriate
entries in the /etc/ttys file 
and turns on the login lines for the first
534 or 544 board at 9600 baud.  
If you do not have a 534 or 544 board 
installed in your system, do not answer 
 .Q y 
or 
 .Q yes 
to the 534 or 544 question
as the system will obediently attempt 
to initialize non-existent lines during
multi-user initialization.  
This will keep the central processor busy and
result in slow system response in multi-user mode.
 .sp
You now have the \*(x1 Operating System installed and a message highlighting
this will appear, followed by a screen of system information.
 .LI
To find out what your control parameters are, enter the following:
 .DS I
 .B
stty<CR>
 .R
 .DE
 .LI
Refer to the \*(x1 manuals supplied with the software for any additional
information required to create your libraries, files, directories, etc.
 .lp
Perform the following steps to enable multiuser mode:
 .sp
Turn on any additional terminals connected to your system and set them
for 9600 Baud, full duplex, no parity.
 .sp
Enter a Control D to exit the \*(x1 single user mode and bring the
\*(x1 Operating System up in multiuser mode.
 .LI
The system will prompt with:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
login:
 .R
 .sp 2
 .TE
 .DE
 .LI
Enter characters xxx followed by a <CR>.  
The characters entered should be
echoed on the screen.
 .LI
The system will respond with the following:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
password:
 .R
 .sp 2
 .TE
 .DE
 .LI
Enter characters xxx followed by a <CR>.  
The characters entered should not
be echoed on the screen.
 .LI
The system will respond with:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
login:
 .R
 .sp 2
 .TE
 .DE
 .LI
Repeat the login/password steps 
for each terminal attached to the
terminal communications board.
This verifies that all terminals are responding to the \*(x1 Operating
System.
 .LE
 .P
This completes initialization of the \*(x1 software on your system.
 .bp
 .H 1 "Using \*(x1 For the First Time"
In this section, you will learn how to log in to \*(x1, create a user
account for yourself, and begin using \*(x1 to do your work.
You will also learn how 
to shut \*(x1 down correctly when you are finished
working.
 .HU "Booting the System"
If you have successfully completed 
the installation procedures described in
the previous section, you are now ready to 
 .Q "boot the system" 
and log in.
In fact, this is the same procedure 
you will be using every time you want
to start up \*(x1 in the future.
If your system is not already turned on, you will start by:
 .AL 1
 .LI
Powering up the system by pressing the POWER switch, then
pressing a U in response to the asterisks, followed by an I in response
to the PIC test prompt.  The system will boot automatically if the System
Confidence Test tests pass.
 .LI
After the system has completed its initial checks and has responded with
the "#" prompt, type control-D to proceed with normal startup,
(or give root password for System Maintenance):
 .LE
 .P
 .HU "Entering the Date and Time"
If you type <CONTROL-D>, 
you will see more copyright information, followed
by a time message:
 .ne 6
 .TS
box expand;
L.
 .sp 2
 .B
I think it's Tues Jan 18 17:57:20 EST 1983
Enter time ([yymmdd]hhmm[.ss]):
 .R
 .sp 2
 .TE
If you are in a hurry, 
you can type <CR> and \*(x1 will automatically
assume that that the time it has given to you is correct. 
This is not recommended.
It is important that you give \*(x1 the correct date and time when you 
boot the system, so that any files you create while you are working will
be stamped with the correct time, to help you identify them later.
 .P
Entering the correct date is simple.
For example, if the date is actually \*`Tues Mar 8 14:30:00 EST 1983\*', you
would enter:
 .DS I
8303081430
 .DE
Remember, the year, month, and day must each be a two-digit number.
Also, the \*(x1 clock doesn't understand \*`AM\*' and \*`PM\*', so if it is
\*`2:30 pm\*', you'll have to enter the number \*`14:30\*'.
Note that year (yy), month (mm), day (dd), and seconds (ss), are optional;
hour (hh) and minute (mm) are required.
 .P
Be sure to enter these numbers carefully.
You can use the backspace key, if necessary, to change incorrect digits
if you have not yet typed <CR>. 
If you enter numbers in the wrong format--for example, give the wrong total
number of digits, or an implausible number, like \*`13\*' for the month--\*(x1
will prompt you to repeat the date.
However,
if you enter the wrong date, you will have to finish the booting procedure,
then bring the system down correctly as described below. 
Do NOT use the RESET switch to terminate the boot.
 .HU "Logging in as Root"
Now you are ready to log in. You will see the single word
 .DS L
 .TS
box expand;
L.
 .sp 2
 .B
login:
 .R
 .sp 2
 .TE
 .DE
on your screen.
Logging in is the process of identifying yourself to the system. 
Later on in this section you 
will create a user account for yourself and
a special secret password to let the system 
know you are really authorized to use \*(x1.
For now, you will log in with a special 
system ID, as a user named \*`root\*'.
Type
 .DS I
root<CR>
 .DE
after the \*`login:\*' prompt.
 .P
Root is actually a very powerful user, 
aptly called the \*`super-user\*'.
The super-user is the only user who 
can perform most of the system 
maintenance tasks described in the
 .I "\*(x1 Operations Guide."
 .R
Because the super-user, or root, 
is the only user with access to everything
on your \*(x1 system, 
whoever is logged in as root is in a position to
look at, change, or remove anything on the system.  
Mistakes made by the super-user 
can be particularly disasterous.
 .HU "Creating a Root Password"
You will want to reserve the powers of the super-user for
only  a limited number of users, perhaps solely to your system manager,
if you have one.
(See the
 .I "\*(x1 Operations Guide"
for more information about the role of the system manager.)
You can do this by giving \*`root\*' a password, known to only those users
to whom super-user powers will be granted.
Do not forget this password under any circumstances.
 .P
Now let's create a super-user password.
You will be using the same procedure later to change ordinary
user passwords. Just type:
 .DS I
passwd<CR>
 .DE
after the # prompt.
The response of \*(x1 will be
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Changing password for root.
 .R
 .sp 2
 .TE
 .DE
Of course, in this case you will be changing the password from none to
one of your choice. 
Suppose you wanted to use the password \*`oshKosh\*'.
Type
 .DS I
oshKosh<CR>
 .DE
when \*(x1 asks you for the new password. 
Naturally, you will be choosing a different password--it should be at
least five characters long, consist of a mixture of lowercase and uppercase
letters, numbers, and special characters, not something in the dictionary,
on the map, or the number on your social security card.
It should be complicated enough so that it is impossible to guess,
but still relatively easy for you to remember.
 .P
The word \*`oshKosh\*' will not appear on your screen as you type it. 
You will be asked to type it a second time, however, to double-check that
you have typed it correctly.
Simply type \*`oshKosh<CR>\*' again.
If you do not type it correctly, you will get the message:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
mismatch-password unchanged.
 .R
 .sp 2
 .TE
 .DE
You will have to type the 
 .B passwd
command again, and go through the process a second time.
In the future, every time you try to log in as \*`root\*' you will be asked
for this password.
 .HU "Creating Your First User Account"
Now, because being \*`root\*' is such a powerful identity, you will only
want to remain logged in as root when you are doing some system
maintenance task for which super-user powers are actually required.
So, you are now going to create an ordinary user account for yourself.
To do this, type
 .DS I
mkuser<CR> 
 .DE
after the # prompt.
Later on, you may be responsible for creating a number of user accounts.
The 
 .B mkuser
program is described in detail in the
 .I "\*(x1 Operations Guide" .
For now, let's go through it quickly.
You will see
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
            Newuser
      Add a user to the system
 .sp
Do you require detailed instructions? (y/n/q):
 .R
 .sp 2    
 .TE
 .DE
Answer \*`n\*' for no--you can learn more about the
 .B mkuser
program some other time.
 .P
The next message will be:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Enter new user's login name:
 .R
 .sp 2
 .TE
 .DE
Enter the name by which you wish to be known to \*(x1.
Use lowercase letters for your login name.
Your first name and last initial is a good choice.
So, if your name were Fred Smith, you might enter
 .DS I
freds<CR>
 .DE
 .P
Now you will need your own personal password.
Once again, make sure it is reasonably long and hard to guess.
You will be asked for it twice.
Now you will be given a chance to further identify yourself with a comment
line.
You have twenty spaces to enter any useful information you might want to
record, like your department and phone extension:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
   Please Enter Comment:>--------------------
                        >
 .R
 .sp 2
 .TE
 .DE
So you might want to add:
 .DS I
Sales Dept. #408
 .DE
You will a message something like this:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
User name is freds
Comment field is: Sales Dept. #408
Password file entry is:
 .sp
freds:j9vRV:201:50:Sales Dept. #408:/usr/freds:/bin/sh:
 .sp
Do you want to change anything? (y/n/q):
 .R
 .sp 2
 .TE
 .DE
 .P
Don't let this message--particularly the line with the strange numbers--
frighten you.
This line contains a scrambled version of your password and some other
information \*(x1 will need.
Just check to see if your name and comment are added correctly.
If you answer \*`n\*', your account will be created.
If you answer \*`q\*' for quit, you will exit from the
 .B mkuser
program
without recording any information.
If you answer \*`y\*', you will be given the opportunity to change your
account entry.
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
You can change any of the following items:
 .sp
     username
     password
     comment
 .sp
Which of these do you want to change?
 .R
 .sp 2
 .TE
 .DE
For example, if you gave the wrong phone extension, you could type
 .DS I
comment<CR>
 .DE
You would then have a chance to change your comment line:
 .DS I
Sales Dept. #418
 .DE
 .B Mkuser
will now give you an opportunity to recheck your entry.
Answer \*`n\*' if you do not need to make any more changes.
The screen will look something like this:
 .DS
 .TS 
box expand;
L.
 .sp 2
 .B
You have 5 seconds to press BREAK if you have erred
Password file updated
Home directory /usr/freds created
/usr/freds/.profile created
User freds added to this system
 .sp 
Do you wish to add another user? (y/n/q):
 .R
 .sp 2
 .TE
 .DE
 .B Mkuser 
is letting you know that it has done everything necessary to 
create your account.
For now, you will not want to add any more users. Answer \*`n\*'.
 .HU "Logging in as an Ordinary User"
You are ready to log in as an ordinary user.
You will see the # prompt.
Type a <CONTROL-D>  
to log \*`root\*' out of the system.
\*(x1 will wait for another user to log in with the \*`login:\*'
prompt.
Type in your new username and password, and you should see:
 .DS I
$
 .DE
 .P
The dollar sign ($) is the prompt 
you will normally see unless you are
logged in as root, when you see the number sign (#) prompt instead.
If you have any doubts about 
whether you are logged in as yourself or as
root, you should be able to tell 
immediately by which system prompt appears
on the screen.
 .HU "Shutting Down the System"
The last thing you will need to know is how to log out and shut the system
down correctly.
Once again, if you are running \*(x1 on your system it is extremely important
to use the correct procedure to shut down the system.
Do not panic and use the RESET or POWER switch
or the electrical plug to stop your system.
If you feel you have made a mistake, this may only compound the problem.
Because there may be several users working on \*(x1 simultaneously, the system
is set up so that only a user with super-user powers may shut the system down.
So, you will have to log out of your ordinary user account--by typing 
<CONTROL-D> once again, 
and logging back in as \*`root\*', using the new
root password.
When you see the # prompt, type:
 .DS I
shutdown<CR>
 .DE
You will be asked:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
Minutes till shutdown? (0-15):
 .R
 .sp 2
 .TE
 .DE
Since you have no other users right now, you can answer \*`0\*'.
Later, you can give the other users some warning; you even have the
opportunity to broadcast a message, 
perhaps saying how long the system will be down.
Once you have entered the time until shutdown, 
you will see something like:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
System Shutdown in 0 minutes.
Clean up and log off.
All logged off now.
Broadcast Message...
 .sp
\*(x1 will now terminate.
Kill -15 25 21 23
**NORMAL SYSTEM SHUTDOWN**
 .R
 .sp 2
 .TE
 .DE
Do not turn off the computer until you see a \*`Normal System Shutdown\*'
message.
 .HU "Booting the System After an Abnormal Shutdown"
If you do shut down the system abnormally--let's say a user panics and
flips the RESET switch or the system is accidentally disconnected, the
next time you attempt to boot the system you will see
a warning message the next time you attempt to \*`boot\*' or start the system:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
The system was not shut down properly, and the
root filesystem should be cleaned.
 .sp
Proceed with cleaning (y/n)?
 .R
 .sp 2
 .TE
 .DE
Probably very little, if any, harm will be done to the system.
Always answer \*`y\*' to this question and \*(x1 will automatically run
a five-phase system checking program called
 .B fsck
to check for system inconsistencies and repair them. 
(For more information on
 .B fsck
and other system-checking programs, see the 
 .I "\*(x1 Operations Guide,"
Chapter 5, \*`System Maintenance\*'.)
As the
 .B fsck
program runs, 
you should see a series of messages like this on your screen:
 .DS
 .TS
box expand;
L.
 .sp 2
 .B
/dev/root
**Phase 1 - Check Blocks and Sizes
**Phase 2 - Check Pathnames
**Phase 3 - Check Connectivity
**Phase 4 - Check Reference Counts
**Phase 5 - Check Free Lists
206 files 2162 blocks 12149 free
 .sp
root structure was ok--proceeding with bootup 
 .R
 .sp 2
 .TE
 .DE
You will now see the familiar
system message.
Type control-d to proceed with normal startup,
(or give the root password for system maintenance).
 .sp 1
 .P
Occasionally, while 
 .B fsck 
is running, you will get a message saying that the filesystem is
inconsistent and asking you if you wish to \*`salvage.\*'
Answer 
 .Q yes 
to this question.
\*(x1 may have to remove a small amount 
of information from the system in
order to restore consistency. This loss will be worthwhile if it
ensures the safety of the rest of the system.
 .P
You are now ready to use \*(x1. 
Turn to the 
 .I "\*(x1 Operations Guide"
for an overview of the \*(x1 system and 
detailed information about system maintenance procedures.
You will also want to read the 
 .I "\*(x1 Fundamentals"
manual for an in-depth introduction to \*(x1's many features.
 .TC


