.aX
.nr H1 1
.H 1 "Appendix B: The Multi-user System"
If you have a \*(x1 system with a hard disk and several terminals, you
will be able to use a number of \*(x1 commands intended for systems
with several simultaneous users.
These include commands which allow you to determine which other users
are presently on the system, such as
.B who.
You will also be able to communicate with other users on the system with
.B wall,
which broadcasts any message you type after the prompt, as well as with the 
.B mail
program, if it is available on your system.
Of course, even if you are alone on the system, it is often convenient
to mail information to other users; they will receive it when they log in. 
You may even use 
.B mail
to send helpful reminders to yourself. 
.P
However, there are several special cautions that apply to 
multi-user system environments.  
These are described here.
.HU "Shutting Down the System"
.sp
As you have been warned in the
.I
\*(x1 Installation Guide,
.R
it is extremely important to log out and shut the system
down correctly.
You should be especially cautious if you have several users on your
system, so that you do not accidentally terminate any processes
they may have running.
Because there may be several users working on \*(x1 simultaneously, the system
is set up so that only a user with super-user powers may shut the system down.
So, you will have to log out of your ordinary user account by typing 
<CONTROL-D> once again, and logging back in as \*`root\*'. 
When you see the # prompt, type:
.DS I
shutdown<ENTER>
.DE
You will be asked:
.DS
.TS
box expand;
L.
.sp 2
Minutes till shutdown? (0-15):
.sp 2
.TE
.DE
Be sure you
give the other users adequate warning to finish what they are doing
and log off the system. 
You will even have the opportunity to broadcast a message, perhaps saying how long the system will 
be down.
.P
Once you have entered the time until shutdown, you will see something like:
.DS
.TS
box expand;
L.
.sp 2
Xenix 68000 Shutdown in 0 minutes.
Clean up and log off.
All logged off now.
Broadcast Message...
.sp
Xenix-68000 will now terminate.
Kill -15 25 21 23
**NORMAL SYSTEM SHUTDOWN**
.sp 2
.TE
.DE
Do not turn off the computer until you see a \*`Normal System Shutdown\*'
message.
.P
You can also use the
.B haltsys 
command, but you will have to 
be careful that all your users are off the system.
Use the 
.B who
command to find out if anyone else is logged in.
Even if no one is actually still logged in, processes may still be 
running on the system. 
The output of the command
.DS I
ps -a
.DE
should be checked carefully to determine whether this is the case.
Users can be alerted that you are about to bring down the system
with the
.B wall
command.
.H 2 "Setting Up Multiple Terminals"
In order to use your system, you must tell \*(x1 what type of terminal
you are using.  
The characteristics of all commonly used terminals are stored in 
a system file called
.I /etc/termcap,
which is called by the user's 
.I .profile
file at login time.
If you look at any user's 
.I .profile
you will see an entry like:
.DS I
TERM=trs16; export TERM
TERMCAP=/etc/termcap; export TERMCAP
.DE
In this example the \*`TERM\*' variable is set to 
.I trs16, 
or in other words, tells the system to look in the
.I /etc/termcap
file for the 
.I trs16 
entry.
In this example \*`trs16\*' is an abbreviated name of the terminal
model which you are using.
The entry contains information about the special characteristics of
the keyboard.
.P
Of course, if you have several different types of terminals attached to
your system, or facilities for dialing up from other locations,
users may be logging in from different terminals at different times.
As system manager, you must make your users aware that if they log in from a
terminal  than  the  one  specified  in their 
.I .profile  
file,  they will have to reset the terminal type by typing a command after 
they log in, or they may be unable to use the system.  
If you log in from a terminal other than the one specified  in your 
.I .profile 
file, reset the terminal type by typing the abbreviated name of the
terminal they are using after you log in. 
For example:
.DS I
TERM=vt100
export TERM
.DE
Naturally, the users will have to know which terminal type they are using 
and the way in which that terminal name is abbreviated in the 
.I /etc/termcap
file. 
This information can be found in the
.I
\*(x1 System Reference
.R
manual.
It is a good idea to print a copy of the 
.I /etc/termcap
file on your system to determine which terminals are supported.
.H 2 "Setting User ID For Multiple Systems"
If you are working in an environment with several \*(x1 systems, and users
wish to work on more than one computer, moving their files back and forth on
floppy disks, they will need to have valid logins and \*`home\*' directories 
on each system. 
Please note, however, that the user must be assigned the same user ID
number on each system if he wishes to transfer file systems between computers.
If you customarily add user accounts with the
.B mkuser
program,
be aware that the assignment of a user ID number is done automatically and
arbitrarily.
.P
Therefore, you must edit the
.I /etc/passwd
file to supply identical user ID numbers for each of your systems.
The password file entry will look something like this:
.DS
.TS
L.
.sp 2
johnd:j9djf:204:50:Accounting #333:/usr/johnd:/bin/sh:
.TE
.DE
The user ID number is the one immediately following the encrypted
password.
You may use any number over 200, as long as it does not belong
to another user. 
Check to make sure the entries are identical for all the \*(x1
systems you are working with. 
