'\"	@(#)Document: V1-00-1
'\"	@(#)Subject: V3.0 Programmer's Intro: introduction
'\"	@(#)Writer: Stewart Konzen
'\"	@(#)Copyright 1982  Microsoft Corporation
'\"	@(#)Work: 2 weeks
'\"	@(#)Target: 1/1
'\"	@(#)Notes: includes software overview
'\"	@(#)Mods: none
.ds :? INTRODUCTION
.nr H1 1
.hw hexa-decimal tuto-rial
.nr b \n(.ou\"
.nr c \w'\fB\s-1\0.~~\s+1\fP'u\"
.if n .ds x x\"
.if t .ds x \(mu\"
.PH "'Introduction''Introduction'"
.H 2 "Overview"
This manual introduces the basic \*(x1(TM)
.FS *
\*(x2 is a trademark of Microsoft Corporation.
.br
\*(u2 is a trademark of Bell Telephone Laboratories, Inc.
.FE
system, explaining
the fundamental concepts and software needed to make
effective use of the system.
The \*(x1 system is an improved and enhanced version
of the popular \*(u1(TM) Time-Sharing System,
Seventh Editon.
The \*(x1 system consists of a general-purpose multiuser, 
operating system and over one hundred utilities 
and application programs. 
In addition to the basic \*(x1 package described in
this manual, 
two other \*(x1 packages are also available:
the \*(x2 Software Development Package and 
the \*(x2 Text Processing Package.
Other Microsoft software is also available.
.P
Among the outstanding characteristics of the 
\*(x1 system are the following:
.BL "" 1
.LI
A hierarchical, tree-structured file system 
that permits organization of files 
and directories in a logical and flexible way.
.LI
A powerful, easy-to-use command language.
Unlike other interactive command languages, 
the \*(x1 shell is a full programming language.
The shell provides a user environment 
that can be tailored to 
both individual and group needs.
.LI
Simple and consistent naming conventions.
Names can be absolute 
or relative to any directory 
in the file system.
.LI
Device independent input and output:
each physical device, 
from interactive terminals to main memory, is treated
like a file, allowing uniform file and device input
and output.
.LI
A set of related text editors including a line
editor, a screen editor, and a stream editor.
.LI
Flexible text processing facilities.
In \*(x1, commands exist to find and extract
patterns of text from files, to compare and find
differences between files, and to search through
and compare directories.
Also available, in the \*(x2\0Text\0Processing\0Package, 
are text formatting, typesetting, and
spelling error-detection facilities,
as well as a facility for formatting and 
typesetting complex tables and equations.
.LI
A sophisticated 
.Q "desk-calculator"
package.
.LI
Mountable and dismountable file systems and volumes.
.LI
A complete set of flexible
directory and file protection modes that
allow all combinations of read, write, and execute
access for the owner of each file or directory,
as well as for groups of users.
.LI
Facilities for creating, accessing, moving, 
and processing files, directories, or sets
of these in a simple and uniform way.
.LE 1
.bp
.H 2 "Documentation Roadmap"
This manual is organized as follows:
.VL 12 
.LI "Chapter~1:~~Introduction"
.br
The chapter you are now reading 
gives an overview of the \*(x1 system 
and discusses the notational conventions used
throughout the manual.
.LI "Chapter~2:~~Demonstration~Run"
.br 
This chapter gives you hands-on experience in
using the \*(x1 system.
.LI "Chapter~3:~~Basic Concepts"
.br
This chapter explains the fundamental concepts needed
to understand how to use the system.
Included here are sections on the file system,
naming conventions, commands, and input and output.
.LI "Chapter~4:~~Frequently~Used~Procedures"
.br
This chapter explains how to perform everyday
procedures using appropriate \*(x1 commands.
In this chapter, these frequently used commands are separated 
from the much larger set of all commands.
.LI "Chapter~5:~~Ed"
.br
This chapter describes how to use the line-oriented editor, 
.I ed .
.LI "Chapter~6:~~Vi"
.br
This chapter shows how to use the screen editor, 
.I vi .
Vi is the most sophisticated interactive editor available on \*(x1.
.LI "Chapter~7:~~The Shell"
.br
This chapter describes the shell command language
and how to write procedures that can be executed by
the shell interpreter. 
.LI "Chapter~8:~~Sed"
.br
This chapter describes the noninteractive
.Q "stream"
editor named
.I sed ,
similar in many ways to the \*(x1 editors
.I ed 
and 
.I vi .
.LI "Chapter~9:~~BC"
.br
This chapter describes the use of BC,
a sophisticated calculator program.
.LI "Appendix A:~Glossary"
.br
This appendix contains a glossary of commonly used \*(x1 terms.
.LE 
.rm Li
.P
This manual makes no 
attempt to give information about installing,
managing, and maintaining the system, 
nor does it discuss 
document preparation,
software development,
or many of the specialized utilities 
available in other \*(x1 packages. 
These subjects are covered in the following manuals:
.VL 5 5
.LI "\fIThe~XENIX~Installation~Guide\fP"
.br
This guide describes how to install and set up the
\*(x1 system on your computer.
.LI "\fIThe~XENIX~Operations~Guide\fP"
.br
This manual is a guide to managing, and
maintaining the whole system.
.LI "\fIThe~XENIX~Reference~Manual\fP"
.br
This manual is a comprehensive reference.
A concise but complete description of each
command is available here.
.LI "\fIThe~XENIX~Software~Development~Manual\fP"
.br
This manual explains how to write programs that
interface to the \*(x1 operating system and how to
use some of the powerful tools available in the 
\*(x1 programming environment.
This manual is part of the optional 
\*(x2\0Software\0Development\0Package.
.LI "\fIThe~\*(x2~Text~Processing~Manual\fP"
.br
This manual explains how to use text processing and
text formatting tools.
It is a part of the optional 
\*(x2\0Text\0Processing\0Package.
.LE
.bp
.H 2 "Notational Conventions"
.XX "notational conventions
Throughout this manual, the following notational 
conventions are used:
.VL 20
.LI "\fBboldface\fR"
.XX "boldface"
Command names are given in boldface
in the text of this manual;
no boldface occurs in displays, except in syntax specifications
for literal text.
For example, 
.B ls ,
.B date ,
and
.B cd
are all the names of commands that you might type at
the keyboard, and therefore all are in bold.
An exception to this rule occurs for long chapters
about a single command.
In this case, the command name is made less conspicuous
by either underlining or capitalization.
.LI "\fIunderlining\fR"
.XX "underlining"
All filenames and pathnames are underlined.
For example, 
.FN text.file
is a filename
.XX "filenames"
and
.FN /usr/mary
is a pathname.
.XX "pathnames"
Most command arguments are underlined as well,
although in some cases these are in boldface.
Words and phrases also may be underlined for emphasis.
References to entries in the 
.I "\*(x2 Reference Manual"
are underlined and include a section number in parentheses.
For example, 
.IR ls (1)
refers to the entry for the
.B ls 
command in Section 1, 
.Q "Commands" .
.LI "[brackets]
.XX "brackets"
Brackets enclose optional arguments in syntax
specifications.
.LI "<angle brackets>"
.XX "angle brackets"
Angle brackets enclose the names of control characters
and special function keys.
Examples are 
.SM <CONTROL-D>,
.SM <CONTROL-S>,
.SM <RETURN>,
.SM <INTERRUPT>,
and
.SM <BKSP>.
.LI "ellipses\^.\^.\^."
.XX "ellipses"
Ellipses are used to indicate one or more entries of
an argument in a syntax specification.
For example, in the following syntax for the 
.B mail 
command, the ellipses indicate that
one or more persons can be sent mail:
.DS I
\fBmail\fP \fIperson\fP \fI.\^.\^.\fP
.DE
.LI "quotation marks"
.XX "quotation marks"
Quotation marks are used to set off multiple keystroke input. 
For example, 
.Q "ls \-la ; date"
is an example of a command line appearing in the body of the text.
.LE
.P
Common abbreviations for ASCII characters are listed below:
.XX "ASCII characters"
.VL 15 5
.LI "<ESC>"
Escape, Control-[
.LI "<RETURN>"
Carriage return, Control-M
.LI <LF>
Newline, Linefeed, Control-J
.LI <BKSP>
Backspace, Control-H
.LI <TAB>
Tab, Control-I
.LI <BELL>
Bell, Control-G
.LI <FF>
Formfeed, Control-L
.LI <SPACE>
Space, 20 hexadecimal 
.LI <DEL>
Delete, 7F hexadecimal
.LE
.rm Li 
.bp
.xp
.TC 2 1 5 0
