.H 2 "Context and Regular Expressions"
You may have noticed that things don't work right 
when you use characters such as the period (\|.\|), 
the asterisk (*), the dollar sign ($), and others in
context searches and the substitute command.
The reason is rather complex, although the solution to
the problem is simple.
Ed treats these characters as special.
For instance, in a context search or the first string
of the substitute command,
the period (\|.\|)
means 
.Q "any character" ,
not a period, so
.DS I
/x.y/
.DE
means a line with an 
.Q "x" ,
any character, and a 
.Q "y" ,
not just a line with an 
.Q "x" ,
a period, and a 
.Q "y" .
A complete list of the special characters
that can cause trouble follows:
.DS I
 ^    .    $    [    *    \e
.DE
.P
The next few subsections will discuss
how to use these characters to describe patterns
of text in search and substitute commands. 
These patterns are called 
.Q "regular expressions" ,
and occur in several other important \*(x1 commands
and utilities, including 
.IR grep (1),
.IR fgrep (1),
.IR egrep (1),
.IR sed (1),
.IR sh (1),
.IR ex (1),
and 
.IR vi (1).
.P
As the simplest place to begin,
recall the meaning of a trailing
.B g
after a substitute command.
With
.DS I
s/this/that/
.DE
and
.DS I
s/this/that/g
.DE
the
first
one replaces the
.I first
.Q "this"
on the line with 
.Q "that" .
If there is more than one 
.Q "this"
on the line,
the second form with the trailing
.B g
changes
.I all
of them.
.P
Either form of the
.B s
command can be followed by
.B p
or
.B l
to print or list the contents of the line.
For example, all of the following are legal and
mean slightly different things:
.DS I
s/this/that/p
s/this/that/l
s/this/that/gp
s/this/that/gl
.DE
Make sure you know what the differences are.
.P
Of course, any
.B s
command can be preceded by one or two line numbers
to specify that the substitution is to take place
on a group of lines. 
Thus
.DS I
1,$s/mispell/misspell/
.DE
changes the 
.I first
occurrence of
.Q "mispell"
to 
.Q "misspell"
in each line of the file.
But
.DS I
1,$s/mispell/misspell/g
.DE
changes 
.I every
occurrence in each line
(and this is more likely to be what you wanted).
.P
You should also notice that if you add a
.B p
or
.B l
to the end of any of these substitute commands,
only the last line changed is printed,
not all the lines.
We will talk later about how to print all the lines
that were modified.
.H 3 "Period \- (.)\0"
The first metacharacter that we will discuss is the
period (\|.\|).
On the left side of a substitute command,
or in a search,
a period (\|.\|) stands for
.I any
single character.
Thus the search
.DS I
/x.y/
.DE
finds any line where 
.Q "x"
and 
.Q "y"
occur separated by
a single character, as in
.DS I
x+y
x-y
x y
xzy
.DE
and so on.
.P
Since a period matches a single character,
it gives you a way to deal with funny characters
printed by
.B l .
Suppose you have a line
that appears as
.DS I
th\e07is
.DE
when printed with the
.B l
command,
and that you want to get rid of the 
\e07,
which represents an 
.SM ASCII 
bell character.
.P
The most obvious solution is to try
.DS I
s/\e07//
.DE
but this will fail. 
The common solution, which most people would now take,
is to retype the entire line.
This is guaranteed, and is actually quite a reasonable tactic
if the line in question isn't too big.
But for a very long line,
retyping is not the best solution.
This is where the metacharacter 
.Q "."
comes in handy.
Since \e07 really represents a single character,
if we type
.DS I
s/th.is/this/
.DE
the job is done.
The period
matches the mysterious character 
between the 
.Q "h"
and the 
.Q "i" ,
whatever it is.
.P
Bear in mind that since the period
matches any single character, the command
.DS I
s/./,/
.DE
converts the first character on a line into a comma (,),
which very often is not what you intended.
.P
As is true of many characters in ed,
the period (\|.\|) has several meanings, depending
on its context.
This line shows all three:
.DS I
\&.s/././
.DE
The first period is the line number of
the line we are editing,
which is called 
.Q "dot" .
The second period is a metacharacter
that matches any single character on that line.
The third period is the only one that really is
an honest, literal period.
(Remember also that a period is also used to terminate
input from the 
.B a 
and 
.B i
commands.)
On the
.I right
side of a substitution, the period (\|.\|) is not special.
If you apply this command to the line
.DS I
Now is the time.
.DE
the result is
.DS I
\&.ow is the time.
.DE
which is probably not what you intended.
.H 3 "Backslash \- \|\e"
Since a period means 
.Q "any character" ,
the question naturally arises: what do you do
when you really want a period?
For example, how do you convert the line
.DS I
Now is the time.
.DE
into
.DS I
Now is the time?
.DE
The backslash (\|\e\|) does the job.
A backslash turns off any special meaning that the next character
might have; in particular,
.Q "\|\e." 
converts the 
.Q "."
from a 
.ne 1i
.Q "match anything"
.ne 1i
into a literal period, so
you can use it to replace
the period in 
.Q "Now is the time."
like this:
.DS I
s/\e./?/
.DE
The pair of characters 
.Q "\e."
is considered by
ed to be a single real period.
.P
The backslash can also be used when searching for lines
that contain a special character.
Suppose you are looking for a line that contains
.DS I
 .DE
.DE
at the start of a line.
The search
.DS I
/.DE/
.DE
isn't adequate, for it will find lines like
.DS I
JADE 
FADE 
MADE 
.DE
because the 
.Q "."
matches the letter 
.Q "A"
on each of the lines in question.
But if you type
.DS I
/\e.DE/
.DE
only lines that contain 
.Q ".DE"
are found.
.P
The backslash can be used to turn off special meanings for
characters other than the period.
For example, consider finding a line that contains a backslash.
The search
.DS I
/\e/
.DE
won't work,
because the backslash (\|\e\|) isn't a literal backslash, 
but instead means that the second slash (/)
no longer delimits the search.
But by preceding a backslash with another one,
you can search for a literal backslash.
Thus, this works: 
.DS I
/\e\e/
.DE
Similarly, you can search for a forward slash (/) with
.DS I
/\e//
.DE
The backslash turns off the special meaning of the immediately 
following slash
so that it doesn't terminate 
the slash-slash construction prematurely.
.P
As an exercise, 
find two substitute commands each of which convert the line
.DS I
\ex\e.\ey
.DE
into the line
.DS I
\ex\ey
.DE
.P
Here are several solutions;
you should verify that each works:
.DS I
s/\e\e\e.//
s/x../x/
s/..y/y/
.DE
.P
A couple of miscellaneous notes about
backslashes and special characters.
First, you can use any character to delimit the pieces
of an
.B s
command; there is nothing sacred about slashes.
(But you must use slashes for context searching.)
For instance, in a line that contains a lot of slashes already, 
such as
.DS I
//exec //sys.fort.go // etc...
.DE
you could use a colon as the delimiter.
To delete all the slashes, type
.DS I
s:/::g
.DE
.P
Second, if 
.Q "#"
and 
.Q "@"
are your character erase and line kill characters,
you have to type \e# and \e@;
this is true whether you're talking 
to ed or to any other program.
.P
When you are adding text with
.B a
or
.B i
or
.B c ,
backslash is not special, and you should only put in
one backslash for each one you really want.
.H 3 "Dollar Sign \- $"
The next metacharacter, the 
.Q "$" ,
stands 
for 
.Q "the end of the line" .
As its most obvious use, suppose you have the line
.DS I
Now is the
.DE
and you wish to add the word 
.Q "time"
to the end.
Use the dollar sign ($) like this
.DS I
s/$/ time/
.DE
to get:
.DS I
Now is the time
.DE
Notice that a space is needed before 
.Q "time"
in the substitute command,
or you will get:
.DS I
Now is thetime
.DE
.P
As another example, replace the second comma in
the following line with a period without altering the first:
.DS I
Now is the time, for all good men,
.DE
The command needed is:
.DS I
s/,$/./
.DE
The dollar sign ($) here provides context 
to make specific which comma we mean.
Without it, of course, the
.B s
command would operate on the first comma to produce:
.DS I
Now is the time. for all good men,
.DE
.P
To convert:
.DS I
Now is the time.
.DE
into
.DS I
Now is the time?
.DE
as we did earlier, we can use:
.DS I
s/.$/?/
.DE
.P
Like the period (\|.\|), the dollar sign ($)
has multiple meanings depending on context.
In the line
.DS I
$s/$/$/
.DE
the first 
.Q "$"
refers to the
last line of the file,
the second refers to the end of that line,
and the third is a literal dollar sign to be added to that line.
.H 3 "Caret \- ^"
The caret (\|^\|)
stands for the beginning of the line.
For example, suppose you are looking for a line that begins
with 
.Q "the" .
If you simply type 
.DS I
/the/
.DE
you will in all likelihood find several lines 
that contain 
.Q "the"
in the middle before
arriving at the one you want.
But with
.DS I
/^the/
.DE
you narrow the context, and thus arrive at the desired line
more easily.
.P
The other use of the caret (\|^\|) 
enables you to insert something at the beginning of a line.
For example
.DS I
s/^/ /
.DE
places a space at the beginning of the current line.
.P
Metacharacters can be combined. 
To search for a line that contains 
.I only 
the characters
.DS I
\&.P
.DE
you can use the command
.DS I
/^\e.P$/
.DE
.H 3 "Star \- *"
.br
Suppose you have a line that looks like this:
.DS I
text x     y text 
.DE
where 
.Q "text" 
stands for lots of text,
and there are an indeterminate number of spaces between the
.Q "x"
and the 
.Q "y" .
Suppose the job is to replace all the spaces between
.Q "x"
and 
.Q "y"
by a single space.
The line is too long to retype, and there are too many spaces
to count.
What now?
.P
This is where the metacharacter 
.Q "star"
(*)
comes in handy.
A character followed by a star
stands for as many consecutive occurrences of that
character as possible.
To refer to all the spaces at once, type:
.DS I
s/x *y/x y/
.DE
The construction 
.Q " *"
means
.Q "as many spaces as possible" .
Thus 
.Q "x\0*y"
means an 
.Q "x" ,
as many spaces as possible, then a 
.Q "y" .
.P
The star can be used with any character, not just a space.
If the original example was 
.DS I
text x--------y text
.DE
then all minus signs (\-) can be replaced by a single space
with the command:
.DS I
s/x-*y/x y/
.DE
.P
Finally, suppose that the line was:
.DS I
text x..................y text 
.DE
Can you see what trap lies in wait for the unwary?
If you blindly type
.DS I
s/x.*y/x y/
.DE
what happens?
The answer, naturally, is that it depends.
If there are no other x's or y's on the line,
then everything works, but it's blind luck, not good thinking.
Remember that 
the period
matches
.I any
single character?
Then 
.Q ".*"
matches as many single characters as possible,
and unless you are careful, it can eat up a lot more of the line
than you expected.
For example, if the line was like this
.DS I
x text x.........y text y
.DE
then typing
.DS I
s/x.*y/x y/
.DE
takes everything from the
.I first
.Q "x"
to the
.I last
.Q "y" ,
which, in this example, is undoubtedly more than you wanted.
.P
The solution is to turn off the special meaning of
the period (\|.\|) with the backslash (\e):
.DS I
s/x\e.*y/x y/
.DE
Now everything works, for 
.Q "\e.*"
means 
.Q "as many periods as possible" .
.P
There are times when the pattern 
.Q ".*"
is exactly what you want.
For example, to change
.DS I
Now is the time for all good men ....
.DE
into
.DS I
Now is the time.
.DE
use 
.Q ".*"
to eat up everything after the 
.Q "for" :
.DS I
s/ for.*/./
.DE
.P
There are a couple of additional pitfalls 
associated with star (*) that you should be aware of.
Most notable is the fact that 
.Q "as many as possible"
means
.I zero
or more.
The fact that zero is a legitimate possibility is
sometimes rather surprising.
For example, if our line contained
.DS I
xy text x  y text
.DE
and we said
.DS I
s/x *y/x y/
.DE
the
first
.Q "xy"
matches this pattern, for it consists of an 
.Q "x" ,
zero spaces, and a 
.Q "y" .
The result is that the substitute acts on the first 
.Q "xy" ,
and does not touch the later 
one that actually contains some intervening spaces.
.P
The way around this is to specify a pattern like
.DS I
/x  *y/
.DE
which says an 
.Q "x" ,
a space, 
then as many more spaces as possible, 
then a 
.Q "y" ,
in other words, one or more spaces.
.P
The other startling behavior of star (*) 
again relates to the fact that zero 
is a legitimate number of occurrences 
of something followed by a star. 
The command
.DS I
s/x*/y/g
.DE
when applied to the line
.DS I
abcdef
.DE
produces
.DS I
yaybycydyeyfy
.DE
which is almost certainly not what was intended.
The reason for this behavior is that zero 
is a legitimate number of matches,
and there are no x's at the beginning of the line
(so that gets converted into a 
.Q "y" ),
nor between the 
.Q "a"
and the 
.Q "b"
(so that gets converted into a 
.Q "y" ), 
and so on.
Make sure you really want zero matches;
if not, in this case write
.DS I
s/xx*/y/g
.DE
since
.Q "xx*"
is one or more x's.
.H 3 "Brackets \- [ and ]"
Suppose that you want to delete any numbers
that appear at the beginning of all lines of a file.
You might first think of trying a series of commands like
.DS I
1,$s/^1*//
1,$s/^2*//
1,$s/^3*//
.DE
and so on,
but this is clearly going to take forever 
if the numbers are at all long.
Unless you want to repeat the commands over and over until
finally all numbers are gone,
you must get all the digits on one pass.
That is the purpose of brackets ([ and ]).
.P
The construction
.DS I
[0123456789]
.DE
matches any single digit\*(EMthe whole thing 
is called a 
.Q "character class" .
With a character class, the job is easy.
The pattern 
.Q "[0123456789]*"
matches zero 
or more digits (an entire number), so
.DS I
1,$s/^[0123456789]*//
.DE
deletes all digits from the beginning of all lines.
.P
Any characters can appear within a character class,
and there are only three special characters (^, ], and \-)
inside the brackets;
even the backslash doesn't have a special meaning.
To search for special characters, for example, you can type:
.DS I
/[.\e$^[]/
.DE
.P
It's a nuisance to have to spell out the digits,
so you can abbreviate them as [0\-9];
similarly, [a\-z] stands for the lowercase letters,
and [A\-Z] for uppercase.
.P
Within [...], the 
.Q "["
is not special.
To get a 
.Q "]"
(or a 
.Q "\-" )
into a character class,
make it the first character.
.P
As a final note on character classes, you can specify a class
that means 
.Q "none of the following characters."
This is done by beginning the class with a caret
(\|^\|).
For example
.DS I
[^0-9]
.DE
stands for 
.Q "any character \fIexcept\fP a digit" .
Thus, you might find the first line 
that doesn't begin with a tab or space
with a search like:
.DS I
/^[^(space)(tab)]/
.DE
.P
Within a character class,
the caret has a special meaning 
only if it occurs at the beginning.
Just to convince yourself, verify that
.DS I
/^[^^]/
.DE
finds a line that doesn't begin with a caret.
.H 3 "Ampersand \- &"
To save typing,
the ampersand symbol is used in substitutions.
Suppose you have the line
.DS I
Now is the time
.DE
and you want to make it:
.DS I
Now is the best time
.DE
Of course you can always type:
.DS I
s/the/the best/
.DE
It's unnecessary to repeat the word 
.Q "the" .
The ampersand (&) is used to eliminate this repetition.
On the
.I right
side of a substitute, the ampersand means 
.Q "whatever was just matched" , 
so you can type
.DS I
s/the/& best/
.DE
and the ampersand will stand for 
.Q "the" .
Of course this isn't much of a saving if the thing
matched is just 
.Q "the" ,
but if it is something very long,
or if it is something like 
.Q ".*"
which matches a lot of text,
you can save some tedious typing.
There is also much less chance of making a typing error
in the replacement text.
For example, to parenthesize a line,
regardless of its length, type:
.DS I
s/.*/(&)/
.DE
.P
The ampersand can occur more than once on the right side.
For example
.DS I
s/the/& best and & worst/
.DE
makes
.DS I
Now is the best and the worst time
.DE
and
.DS I
s/.*/&? &!!/
.DE
converts the original line into
.DS I
Now is the time? Now is the time!!
.DE
.P
To get a literal ampersand, the backslash is used to turn off 
the special meaning.
For example
.DS I
s/ampersand/\e&/
.DE
converts the word into the symbol.
The ampersand is not special on the left side
of a substitute command, only on the
.I right 
side.
.H 3 "Substituting New Lines"
Ed provides a facility for splitting a single line 
into two or more shorter lines by 
.Q "substituting in a newline" .
As the simplest example, suppose a line has become unmanageably long
because of editing. 
If it looks like
.DS I
text xy text
.DE
you can break it between the 
.Q "x"
and the 
.Q "y"
like this:
.DS I
s/xy/x\e
y/
.DE
This is actually a single command,
although it is typed on two lines.
Because the backslash (\e) 
turns off special meanings,
a backslash at the end of
a line makes the newline there
no longer special.
.P
You can in fact make a single line into several lines
with this same mechanism.
As an example, consider underlining the word 
.Q "very"
in a long line by splitting 
.Q "very"
onto a separate line,
and preceding it by the
formatting command 
.Q ".I" :
.DS I
text a very big text
.DE
The command
.DS I
s/ very /\e
\&.I\e
very\e
/
.DE
converts the line into four shorter lines,
preceding the word 
.Q "very"
with the
line 
.Q ".I" ,
and eliminating the spaces around the 
.Q "very" ,
all at the same time.
.P
When a new line is substituted in a string, 
dot is left at the last line created.
.H 3 "Joining Lines"
Lines may also be joined together,
but this is done with the
.B j
command
instead of
.B s .
Given the lines
.DS I
Now is
 the time
.DE
suppose that dot is set to the first of them.
Then the command
.DS I
j
.DE
joins them together.
No blanks are added,
which is why we carefully showed a blank 
at the beginning of the second line.
.ne 2i
.P
All by itself, a
.B j
command joins the lines signified by dot and dot~+~1,
but any contiguous set of lines can be joined.
Just specify the starting and ending line numbers.
For example
.DS I
1,$jp
.DE
joins all the lines into one big one
and prints it.
.H 3 "Rearranging a Line \- \e(\ and\ \e)"
Recall that 
.Q "&"
is a shorthand for whatever
was matched by the left side of an
.B s
command.
In much the same way, you can capture separate pieces
of what was matched.
The only difference is that you have to specify
on the left side just what pieces you're interested in.
.P
Suppose that you have a file of lines 
that consist of names in the form
.DS I
Smith, A. B.
Jones, C.
.DE
and so on, and you want the initials to precede the name, as in:
.DS I
A. B. Smith
C. Jones
.DE
It is possible to do this with a series of editing commands,
but it is tedious and error-prone.
.P
The alternative
is to 
.Q "tag"
the pieces of the pattern (in this case,
the last name, and the initials),
and then rearrange the pieces.
On the left side of a substitution,
if part of the pattern is enclosed between
\e( and \e),
whatever matched that part is remembered,
and available for use on the right side.
On the right side,
the symbol, 
.Q "\e1" ,
refers to whatever
matched the first \e(...\e) pair;
.Q "\e2" ,
to the second \e(...\e), and so on.
.P
The command
.DS I
1,$s/^\e([.*]\e), *\e(.*\e)/\e2 \e1/
.DE
although hard to read, does the job.
The first \e(...\e) matches the last name,
which is any string up to the comma;
this is referred to on the right side with 
.Q "\e1" .
The second \e(...\e) is whatever follows
the comma and any spaces,
and is referred to as 
.Q "\e2" .
.P
Of course, with any editing sequence this complicated,
it's foolhardy to simply run it and hope.
The global commands 
.B g
and 
.B v
provide a way for you to print exactly those
lines which were affected by the
substitute command,
and thus verify that it did what you wanted
in all cases.
.H 2 "Default Line Numbers and the Value of Dot"
One of the most effective ways to speed up your editing
is always to know what lines will be affected
by a command if you don't specify the lines it is to act on,
and on what line you 
will be positioned (i.e., the value of dot) when a command finishes.
If you can edit without specifying unnecessary
line numbers, you can save a lot of typing.
.P
As the most obvious example, 
if you issue a search command like
.DS I
/thing/
.DE
you are left pointing at the next line that contains 
.Q "thing" .
Then no address is required with commands like
.B s
to make a substitution on that line,
or
.B p
to print it,
or
.B l
to list it,
or
.B d
to delete it,
or
.B a
to append text after it,
or
.B c
to change it,
or
.B i
to insert text before it.
.P
What happens if there is no 
.Q "thing" ?
Then you are left right where you were:
dot is unchanged.
This is also true if you were sitting
on the only 
.Q "thing"
when you issued the command.
The same rules hold for searches that use
?...?; the only difference is the direction in which you search.
.P
The delete command,
.B d ,
leaves dot pointing
at the line that followed the last deleted line.
When the line dollar ($) gets deleted,
however, dot points at the
.I new
line 
.Q "$" .
.P
The line-changing commands
.B a ,
.B c ,
and
.B i ,
by default, all affect the current line.
If you give no line number with them,
.B a
appends text after the current line,
.B c
changes the current line,
and
.B i
inserts text before the current line.
.P
The 
.B a ,
.B c ,
and
.B i
commands behave identically in one respect \*(EM
when you stop appending, changing or inserting,
dot points at the last line entered.
This is exactly what you want for typing and editing on the fly.
.ne 2i
For example, you can type
.DS I
a
text 
botch   (minor error)
\&.
s/botch/correct/  (fix botched line)
a
more text 
\&.
.DE
without specifying any line number 
for the substitute command or for the second append command.
Or you can type:
.DS I
a
text 
horrible botch  (major error)
\&.
c	(replace entire line)
fixed up line 
\&.
.DE
.P
You should experiment to determine what happens if you add
.I no
lines with
.B a ,
.B c ,
or
.B i .
.P
The
.B r
command will read a file into the text being edited,
either at the end if you give no address,
or after the specified line if you do.
In either case, dot points at the last line read in.
Remember that you can even type
.DS I
0r
.DE
to read a file in at the beginning of the text.
(You can also type
.I 0a
or
.I 1i
to start adding text at the beginning.)
.P
The
.B w
command writes out the entire file.
If you precede the command by one line number,
that line is written.
If you precede it by two line numbers,
that range of lines is written.
The 
.B w
command does
.I not
change dot:
the current line remains the same,
regardless of what lines are written.
This is true even if you type something like
.DS I
/^\e.AB/,/^\e.AE/w abstract
.DE
which involves a context search.
.P
(Since the
.B w
command is so easy to use,
you should save what you are editing regularly
as you go along
just in case the system crashes, 
or in case you accidentally delete what you're editing.)
.P
The general rule is simple:
you are left sitting on the last line changed;
if there were no changes, then dot is unchanged.
.P
To illustrate, suppose 
that there are three lines in the buffer, 
and the line given by dot is the middle one:
.DS I
x1
x2
x3
.DE
Then the command
.DS I
\-,+s/x/y/p
.DE
prints the third line, which is the last one changed.
But if the three lines had been
.DS I
x1
y2
y3
.DE
and the same command had been issued while
dot pointed
at the second line, then the result
would be to change and print only the first line,
and that is where dot would be set.
.H 3 "Semicolon \- ;"
Searches with /.../ and ?...? start
at the current line and move
forward or backward, respectively,
until they either find the pattern 
or get back to the current line.
Sometimes this is not what you want.
Suppose, for example, that the buffer contains lines like this:
.DS I
  .
  .
  .
ab
  .
  .
  .
bc
  .
  .
  .
.DE
Starting at line 1, you would expect the command
.DS I
/a/,/b/p
.DE
to print all the lines from the 
.Q "ab"
to the 
.Q "bc"
inclusive.
This is not what happens.
.I Both
searches
(for 
.Q "a"
and for 
.Q "b" )
start from the same point, and thus they both find the line
that contains 
.Q "ab" .
The result is to print a single line.
Worse, if there had been a line with a 
.Q "b"
in it
before the 
.Q "ab"
line, then the print command
would be in error, since the second line number
would be less than the first, and it is illegal to
try to print lines in reverse order.
.P
This is because the comma separator
for line numbers doesn't set dot as each address is processed;
each search starts from the same place.
In ed, the semicolon 
.Q ";"
can be used just like the comma,
with the single difference that use of a semicolon
forces dot to be set at the time the semicolon is
encountered, as the line numbers are being evaluated.
In effect, the semicolon 
.Q "moves"
dot.
Thus, in our example above, the command
.DS I
/a/;/b/p
.DE
prints the range of lines from 
.Q "ab"
to 
.Q "bc" ,
because after the 
.Q "a"
is found, dot is set to that line,
and then 
.Q "b"
is searched for, starting beyond that line.
.P
This property is most often useful in a very simple situation.
Suppose you want to find the 
.I second
occurrence of 
.Q "thing" .
You could type
.DS I
/thing/
//
.DE
but this prints the first occurrence as well as the second,
and is a nuisance when you know very well that it is only
the second one you're interested in.
The solution is to type:
.DS I
/thing/;//
.DE
This says to find the first occurrence 
of 
.Q "thing" ,
set dot to that line, then find the second
and print only that.
.P
Closely related is searching for the second to last
occurrence of something, as in:
.DS I
?something?;??
.DE
.ne 1i
.P
Finally, bear in mind that if you want to find the first occurrence of
something in a file, starting at an arbitrary place within the file,
it is not sufficient to type
.DS I
1;/thing/
.DE
because this fails if 
.Q "thing"
occurs on line 1.
But it is possible to type
.DS I
0;/thing/
.DE
because this starts the search at line 1.
This is one of the few places where 0 is a legal line number.
.H 3 "Interrupting the Editor"
As a final note on what dot gets set to,
you should be aware that if you press the 
.SM <INTERRUPT> 
key while ed is executing a command, 
your state is restored as much as possible 
to what it was before the command began.
Naturally, some changes are irrevocable \*(EM
if you are reading or writing a file 
or making substitutions or deleting lines. 
These will be stopped
in some unpredictable state in the middle
(which is why it is not usually wise to stop them).
Dot may or may not be changed.
.P
Printing is more clear cut.
Dot is not changed until the printing is done.
Thus, if you decide to print until you see an interesting line,
and then press
.SM <INTERRUPT> ,
dot will not 
.I not
be set to that line or even near it.
Dot is left where it was when the
.B p
command was started.
.H 2 "Cutting and Pasting with the Editor"
Now we move on to manipulating pieces of files,
individual lines or groups of lines.
Time spent mastering these techniques is time well spent.
.H 3 "Inserting One File Into Another"
Suppose you have a file called
.FN memo ,
and you want the file called
.FN table
to be inserted just after the reference to Table 1.
That is, in
.FN memo
somewhere is a line that says
.DS I
Table 1 shows that ...
.DE
and the data contained in
.FN table
has to go there,
probably so it will be formatted properly by
either of the text formatters
.B nroff
or
.B troff .
Now what?
.P
This one is easy.
Edit 
.FN memo ,
find
.Q "Table 1" ,
and add the file
.FN table
right there:
.DS I
ed  memo
/Table 1/
Table 1 shows that ... \fIresponse from ed\fP
\&.r  table
.DE
The critical line is the last one.
The
.B r
command reads a file;
here you asked for it to be read in right after line dot.
An
.B r
command, without any address, adds lines at the end,
so it is the same as
.Q "$r" .
.H 3 "Writing Out Part of a File"
The other side of the coin is writing out part of
the document you're editing.
For example, maybe you want to split out into a separate file
that table from the previous example,
so it can be formatted and tested separately.
Suppose that in the file being edited 
we have
.DS I
\&.TS
[lots of stuff]
\&.TE
.DE
which is the way a table is set up for the
.B tbl
program.
To isolate the table in a separate file called
.FN table ,
first find the start of the table
(the 
.Q ".TS"
line), then write out the interesting part:
.DS I
/^\e.TS/
\&.TS  [ed prints the line it found]
\&.,/^\e.TE/w table
.DE
and the job is done.
If you are confident, you can do it all at once with
.DS I
/^\e.TS/;/^\e.TE/w table
.DE
.P
The point is that the
.B w
command can
write out a group of lines, instead of the whole file.
In fact, you can write out a single line if you like;
just give one line number instead of two.
If you have just typed a horribly complicated line
and you know that it (or something like it) 
is going to be needed later,
then save it\*(EM don't retype it.
.ne 2.5i
For example,
in the editor, type:
.DS I
a
lots of stuff
horrible line
\&.
\&.w  temp
a
more stuff
\&.
\&.r temp
a
more stuff
\&.
.DE
.H 2 "Editing Scripts"
If a fairly complicated set of editing operations 
is to be done on a whole set of files,
the easiest thing to do is to make up a 
.Q "script" ,
i.e., a file that contains the operations you want to perform,
then apply this script to each file in turn.
.P
For example, suppose you want to change every
.Q "Xenix"
to 
.Q "XENIX"
and every 
.Q "USA"
to 
.Q "America" 
in a large number of files.
Put into the file 
.FN script 
the lines:
.DS I
g/Xenix/s//XENIX/g
g/USA/s//America/g
w
q
.DE
Now you can type:
.DS I
ed file1 <script
ed file2 <script
\&...
.DE
This causes ed to take its commands from the prepared script.
Notice that the whole job has to be planned in advance,
and that
by using the \*(x1 shell command interpreter, 
you can cycle through a set of files automatically.
.P
In preparing editing scripts, you will need to place
a period as the only character on a line
to indicate termination of input from an
.B a
or 
.B i
command.
This is difficult to do in ed,
because the period you input will terminate input rather 
than be inserted.
Nor will it do to escape the period with a backslash.
One workable solution is to create the script using
a character such as the at-sign (@) to indicate end
of input. 
Then, later, use the following command to replace
the at-sign with a period:
.DS I
s/^@$/./
.DE
This will replace the at-sign with the needed period.
.tr **
.bp
.H 2 "Summary of Commands and Line Numbers"
This following is a list of all ed commands and line
numbers.
The general form of ed commands is the command name,
preceded by one or two optional line numbers and,
in the case of
.B e , 
.B f ,
.B r ,
and
.B w ,
followed by a filename.
Only one command is allowed per line, but a
.B p
command may follow any other command
(except for
.B e , 
.B f ,
.B r , 
.B w ,
and
.B q ).
.P
.VL 8 3
.LI \fBa\fR
Append, that is,
add lines to the buffer (at line dot, unless
a different line is specified). 
Appending continues until a period 
is typed on a new line.
The value of dot is set to the last line appended.
.LI \fBc\fR
Change the specified lines to the new text which follows.
The new lines are terminated by a
period on a new line,
as with
.B a .
If no lines are specified,
replace line dot.
Dot is set to the last line changed.
.LI \fBd\fR
Delete the lines specified.
If none are specified, delete line dot.
Dot is set to the first undeleted line,
unless
.B $
is deleted,
in which case dot is set to
.B $ .
.LI \fBe\fR
Edit new file.
Any previous
contents of the buffer are thrown away,
so issue a
.B w
first.
.LI \fBf\fR
Print remembered filename.
If a name follows
.B f ,
then the remembered name is set to it.
.LI \fBg\fR
The command g/\|\fIstring\fP\|/\fIcommands\fR
executes 
.I commands 
on those lines that contain 
.I string ,
which can be any context search expression.
.LI \fBi\fR
Insert lines before specified line (or dot)
until a single period is typed on a new line.
Dot is set to the last line inserted.
.LI \fBl\fR
List lines, making visible nonprinting ASCII characters and tabs.
Otherwise similar to 
.B p .
.LI \fBm\fR
Move lines specified to after the line
named after
.B m .
Dot is set to the last line moved.
.LI \fBp\fR
Print specified lines.
If none are specified, print
the line specified by dot.
A single line number is equivalent to a
.IB line-number p
command.
A single
.SM <RETURN>
prints 
.Q ".+1" ,
the next line.
.P
.LI \fBq\fR
Quit ed.
Your work is not saved unless you first give a 
.B w
command.
Give it twice in a row to abort edit.
.LI \fBr\fR
Read a file into buffer (at end unless specified
elsewhere.) Dot is set to the last line read.
.LI \fBs\fR
The command 
.Q "s/\fI\|string1\|/\|string2\|/\fP"
substitutes the pattern matched by 
.I string1
with the string specified by 
.I string2
in the specified lines.
If no lines are specified, the substitution takes place
only on the line specified by dot.
Dot is set to the last line in which a
substitution took place.
which means that if no substitution takes place,
dot remains unchanged.
The 
.B s
command changes only the first occurrence of
.I string1
on a line; to change multiple occurrences on a line, type a
.B g
after the final slash.
.LI \fBt\fR
Transfer specified lines to the line
named after
.B t .
Dot is set to the last line moved.
.LI \fBv\fR
The command
.I v/\|string\|/\|\fIcommands\fP
executes
.I commands
on those lines that
.I do~not
contain 
.I string.
.LI \fBu\fR
Undo the last substitute command.
.LI \fBw\fR
Write out the editing buffer to a file.
Dot remains unchanged.
.LI \fB.=\fR
Print value of dot.
(An equal sign by itself prints the value of
.B $ .)
.LI \fB!\fR
The line !\fIcommand\(hyline\fR
causes
.I command-line
to be executed as a
\*(x1
command.
.LI \fB/\|\fIstring\fB\|/\fR
.br
Context search.
Search for next line which contains
this string of characters.
Print it.
Dot is set to the line where string
was found.
Search starts at
\&.+1,
wraps around from
.B $
to 1, and continues to dot, if necessary.
.LI \fB?\|\fIstring\fB\|?\fR
.br
Context search in reverse direction.
Start search at
\&.\-1 ,
scan to 1, wrap around to
.B $ .
.LE
