.de Li
.LI "\\fB\\$1\0\\fI\\$2\\fR"
..
.ne 5i
.H 2 "Ex Commands"
Typing the colon (:) escape command when in
command mode, produces a colon prompt
on the status line. 
This prompt is for a command available in the 
line-oriented editor, Ex.
In general, Ex commands let you write out or read in files, 
escape to the shell, or switch editing files.
.P
Many of these commands perform actions that affect the
.Q "current"
file by default.
The current file is normally the file that you named
when you invoked Vi, although the current file can
be changed with the 
.Q "file"
command,
.B f ,
or with the 
.Q "next"
command,
.B n .
In most respects, these commands are identical to
similar commands for the editor,
.B ed .
All such Ex commands are aborted by either a 
.SM <RETURN>  
or an
.SM <ESC> .
We shall use a
.SM <RETURN> 
in our examples.
Command entry is terminated by typing an 
.SM <INTERRUPT> .
.H 3 "Command Structure"
Most Ex command names are English words,
and initial prefixes of the words are acceptable abbreviations.
In descriptions, only the abbreviation is
discussed, since this is the most frequently used
form of the command.
The ambiguity of abbreviations is resolved 
in favor of the more commonly used commands.
As an example, the command 
.B substitute
can be abbreviated 
.B s
while the shortest available abbreviation for the 
.B set
command is 
.B se.
.P
Most commands accept prefix addresses 
specifying the lines in the file
that they are to affect.
A number of commands also may take a trailing
.I count
specifying the number of lines to be involved in the command.
Counts are rounded down if necessary.
Thus, the command 
.Q "10p"
will print the 
tenth line in the buffer while
.Q "move 5"
will move the current line after line 5.
.P
Some commands take other information or parameters,
stated after the command name.
Examples might be option names in a
.B set
command, such as 
.Q "set number" ,
a filename in an
.B edit
command, a regular expression in a
.B substitute
command, or a target address for a
.B copy
command, such as
.DS I
1,5 copy 25
.DE
.P
Also, a number of commands have two distinct variants.
The variant form of the command is invoked by placing an
exclamation mark (!) immediately after the command name.
Some of the default variants may be controlled by options;
in this case, the exclamation mark turns off the
meaning of the default.
.P
In addition, many commands take flags, including
the characters 
.Q "p"
and 
.Q "l" .
A 
.Q "p"
or 
.Q "l"
must be preceded by a blank or tab.
In this case, the command abbreviated by these characters
is executed after the command completes.
Since Ex normally prints the new current 
line after each change, 
.B p
is rarely necessary.
Any number of plus (+) or minus (\-) characters may also 
be given with these flags.
If they appear, the specified offset 
is applied to the current line
value before the printing command is executed.
.P
Most commands that change the contents of the editor buffer give
feedback if the scope of the change exceeds a threshold given by the
.B report
option.
This feedback helps to detect 
undesirably large changes so that they may
be quickly and easily reversed with the undo
command.
After commands with global effect,
you will be informed if the net change in the number of lines
in the buffer during this command exceeds this threshold.
.H 3 "Command Addressing"
The following specifies the line addressing  syntax
for Ex commands:
.VL 20 1
.LI "\fB.\fR"
The current line.
Most commands leave the current line 
as the last line which they affect.
The default address for most commands 
is the current line,
thus 
.Q "\fB.\fR"
is rarely used alone as an address.
.LI "\fIn\fR"
The 
.I n th 
line in the editor's buffer, 
lines being numbered
sequentially from 1.
.LI "\fB$\fR"
The last line in the buffer.
.LI "\fB%\fR"
An abbreviation for 
.Q "1,$" ,
the entire buffer.
.LI "\fI+n\fR\ or \fI\-n\fR"
An offset, 
.I n
relative to the current buffer line.
The forms 
.Q ".+3" 
.Q "+3"
and 
.Q "+++"
are all equivalent.
If the current line is line 100 they all address line 103.
.LI "\fB/\fIpattern\fR\fB/\fR\ or \fB?\fIpattern\fR\fB?\fR"
.br
Scan forward and backward respectively for a text matching
the regular expression given by
.I pattern .
Scans normally wrap around the end of the buffer.
If all that is desired is to print the next 
line containing 
.I pattern , 
then the trailing slash (/)
or question mark (?)
may be omitted.
If 
.I pattern
is omitted or explicitly empty, then the string
matching the last specified regular expression is located.
The forms 
.Q "/\s-2<RETURN>\s0"
and 
.Q "?\s-2<RETURN>\s0"
scan using the last named regular expression. 
After a substitute,
.Q "//\s-2<RETURN>\s0"
and 
.Q "??\s-2<RETURN>\s0"
would scan using that substitute's regular expression.
.LI "\fB\'\'\fR\ or \fB\'\fP\fIx\fR"
Before each nonrelative motion of the current line dot (.),
the previous current line is marked with a label, 
subsequently referred to with two single quotation
marks (\'\').
This makes it easy to refer or return to this previous context.
Marks are established with the Vi
.B m
command, using a single lowercase letter
as the name of the mark.
Marked lines are later
referred to with the notation 
.DS I
\'\fIx\fR.
.DE
where
.I x
is the name of a mark.
.LE 
.P
Addresses to commands consist of a series of addresses,
separated by a colon (,) or a semicolon (;).
Such address lists are evaluated left to right.
When addresses are separated by 
a semicolon (;) the current line (\|.\|)
is set to the value of the previous addressing expression
before the next address is interpreted.
If more addresses are given than the command requires,
then all but the last one or two are ignored.
If the command takes two addresses, the first addressed line must
precede the second in the buffer.
Null address specifications are permitted in a list of addresses,
the default in this case is the current line 
.Q "." ;
thus 
.Q ",100"
is equivalent to 
.Q "\fB.\fR,100" .
It is an error to give a prefix address 
to a command which expects none.
.H 3 "Command Format"
The following is the format for all Ex commands:
.DS I
.B
[\fIaddress\fP] [\fIcommand\fP] [!] [\fIparameters\fP] [\fIcount\fP] [\fIflags\fP]
.R
.DE
All parts are optional depending on the particular
command and its options. 
Command descriptions follow.
.H 3 "Argument List Commands"
The argument list commands allow you to easily work
on a set of files.
This is done by remembering the list of filenames
that are specified when you invoke Vi.
The 
.B args
command lets you examine this list of filenames.
The 
.B file
command gives you information about the current file.
The 
.B n
(next)
command lets you either edit the next file in the argument
list or change the list.
And the 
.B rewind
command lets you restart editing the files in the list.
All of these commands are described below:
.VL 10
.Li args
The members of the argument list are printed, 
with the current argument delimited by brackets.
For example, a list might look like this:
.DS I
file1 file2 [file3] file4 file5
.DE
Here, the current file is 
.FN file3 .
.Li "f" ""
Prints the current filename,
whether it has been modified since the last
.B write 
command,
whether it is readonly,
the current linenumber,
the number of lines in the buffer,
and the percentage of the
buffer that you have edited.
In the rare case that the current file is 
.Q "[Not edited]"
this is noted also; 
in this case you have to use the form 
.Q "w!"
to write to
the file, since the editor is not sure that a 
.B w
command
will not destroy a file unrelated 
to the current contents of the buffer.
.Li f file
The current filename is changed to
.I file
which is considered 
.Q "[Not edited]" .
.Li n
The next file in the command line argument list is edited.
.Li n!
This variant suppresses warnings 
about the modifications to the buffer not
having been written out, discarding irretrievably any changes 
that may have been made.
.Li \fBn\fR \fB[+\fIcommand\fR\fB]\fR \fIfilelist\fR
.br
The specified
.I filelist
is expanded and the resulting list replaces the
current argument list;
the first file in the new list is then edited.
If
.I command
is given (it must contain no spaces), then it is executed after 
editing the first such file.
.Li rew ""
The argument list is rewound, and the 
first file in the list is edited.
.Li rew!
Rewinds the argument list discarding 
any changes made to the current buffer.
.LE
.H 3 "Edit Commands"
To edit a file other than the one you are currently
editing, you will often use one of the variations of
the 
.B e
command.
.P
In the following discussions, note that
the name of the current file is always remembered by
Vi and is specified by a percent sign (%).
The name of the
.I previous
file in the editing buffer is specified by a number sign (#).
.P
The edit commands are described below:
.VL 10
.Li "e" "file"  
Used to begin an editing session on a new file.
The editor first checks to see 
if the buffer has been modified since the last
.B w
command was issued.
If it has been, a warning is issued and the command is aborted.
The command otherwise deletes the entire contents of the editor buffer,
makes the named file the current file and prints the new filename.
After ensuring that this file is sensible,
(i.e., that it is not a binary file, directory, or a
device),
the editor reads the file into its buffer.
If the read of the file completes without error,
the number of lines and characters read is printed
on the status line.
If there were any non\-ASCII characters
in the file they are stripped of their non\-ASCII high bits,
and any null characters in the file are discarded.
If none of these errors occurred, the file is considered edited.
If the last line of the input file is missing the trailing
newline character, it is supplied and a complaint issued.
The current line is initially the first line of the file.
.Li "e!" "file"
This variant form suppresses the complaint about modifications having
been made and not written from the editor buffer, thus
discarding all changes that have been made 
before editing the new file.
.Li "e" "+n file"
.br
Causes the editor to begin editing at line
.I n
rather than at the first line.
The argument \fIn\fR may also be an editor command 
containing no spaces; for example, 
.Q "+/pattern" .
.Li "\s-2<CONTROL-^>\s0"
.br
This is a shorthand equivalent for 
.Q ":e\0#\s-2<RETURN>\s0" , 
which returns to the previous position in the last edited file.
If you do not want to write the file you should
use 
.Q ":e!\ #\s-2<RETURN>\s0"
instead.
.LE
.H 3 "Write Commands"
The write commands let you write out all or part of
your editing buffer to either the current file or to
some other file.
These commands are described below:
.VL 10
.Li w file
Writes changes made back to 
.I file , 
printing the number of lines and characters written.
Normally, 
.I file
is omitted and the buffer is written to the name of
the current file.
If 
.I file
is specified, then text will be written to that file.
The editor writes to a file only 
if it is the current file and is edited,
or if the file does not exist.
Otherwise, you must give the variant form 
.B w!
to force the write.
If the file does not exist it is created.
The current filename is changed only 
if there is no current filename; 
the current line is never changed.
.P
If an error occurs while writing the current and
.I edited
file, the editor
prints
.DS I
No write since last change
.DE
even if the buffer had not previously been modified.
.Li w>> file
Appends the buffer contents at the end of
an existing file.
Previous file contents are not destroyed.
.Li w! name
Overrides the checking of the normal 
.B write
command, and writes to any file that the system permits.
.Li  w \fB!\fIcommand
.br
Writes the specified lines into 
.I command .
Note the difference between 
.DS I
w! \fIfile\fP
.DE
which overrides checks and
.DS I
w !\fIcmd\fP
.DE
which writes to a command.
The output of this command is displayed on the
screen and not inserted in the editing buffer.
.LE
.H 3 "Read Commands"
The read commands let you read text into your
editing buffer at any location you specify.
The text you read in must be at least one line
long, and can be either a file or the output from a
command.
.VL 10
.Li r file
Places a copy of the text of the given file in the
editing buffer after the specified line.
If no file is given then the current filename is used.
The current filename is not changed unless 
there is none, in which
case the file becomes the current name.
If the file buffer is empty and there is no current name then
this is treated as an
.B e
command.
.P
Address 0 is legal for this command 
and causes the file to be read at
the beginning of the buffer.
Statistics are given as for the 
.B e
command when the 
.B r
successfully terminates.
After an
.B r
the current line is the last line read.
.Li r \fB!\fPcommand
.br
Reads the output of 
.I command
into the buffer after the specified line.
A blank or tab before the exclamation mark (!) is mandatory.
.LE
.H 3 "Quit Commands"
There are several ways to exit Vi.
Some abort the editing session, some write out the
editing buffer before exiting, and some warn you if
you decide to exit without writing out the buffer.
All of these ways of exiting are described below:
.VL 10
.Li q
Causes Vi to terminate.
No automatic write of the editor buffer to a file is performed.
However, Vi issues a warning message 
if the file has changed since the last
.B w
command was issued, and does not
quit.
Vi will also issue a diagnostic 
if there are more files in the argument list left to
edit.
Normally, you will wish to save your changes, and you 
should give a 
.B w
command.
If you wish to discard them, use the 
.Q "q!"
command variant.
.Li q!
Quits from the editor, discarding changes 
to the buffer without complaint.
.Li wq name
Like a 
.B w
and then a 
.B q
command.
.Li wq! name
This variant overrides checking of the 
.B w
command so that you can write to file that the
system allows.
.Li x name
If any changes have been made and not written, 
writes the buffer out and then quits.
Otherwise, it just quits.
.LE
.H 3 "Global and Substitute Commands"
The global and substitute commands allow you to
perform complex changes to a file in a single command.
Learning how to use these commands is a must
for the serious user of Vi.
See also Section 6.8, 
.Q "Regular Expressions" .
.VL 10 
.Li  g/\fIpattern\fB/\fIcmds 
.br
The 
.B g
command has two distinct phases.
In the first phase, 
each line matching 
.I pattern
in the editing buffer is marked.
Next, the given command list is executed with the
current line,
dot (\|.\|),
initially set to each marked line.
.P
The command list consists of the remaining commands on the current
input line and may continue to multiple lines by ending all but the
last such line with a backslash (\|\e\|).
This multiple-line option will not work from within
Vi, you must switch to Ex to do it.
If
.I cmds
(or the trailing slash (/) delimiter) 
is omitted, then each line matching
.I pattern
is printed.
.P
The
.B g
command itself may not appear in
.I cmds.
The options
.I autoprint
and
.I autoindent
are inhibited during a
global command
and the value of the
.I report
option is temporarily infinite,
in deference to a 
.I report
for the entire global.
Finally, the context mark (\|\'\|) or (\|\`\|) is set 
to the value of the current line (\|.\|)
before the global command begins 
and is not changed during a global command.
.P
The following global commands, most of them
substitutions, cover the most frequent uses of 
the global command.
.P
.VL 10
.LI "g/s1/p"
This command simply prints all lines that
contain the string 
.Q "s1" .
.LI "g/s1/s//s2/"
.br
This command substitutes the 
.I first
occurrence of 
.Q "s1"
on all lines that contain it
with the string 
.Q "s2" .
.LI "g/s1/s//s2/g"
.br
This command substitutes all occurrences 
of 
.Q "s1" 
with the string 
.Q "s2" .
This includes multiple occurrences of 
.Q "s1"
on a line. 
.LI "g/s1/s//s2/gp"
.br
This command works the same as the preceding example,
except that in addition, all changed lines are
printed on the screen.
.LI "g/s1/s//s2/gc"
.br
This command asks you to confirm that you want to
make each
substitution of the string 
.Q "s1"
with
the string 
.Q "s2" .
If you type a 
.Q "y"
then the given substitution is made,
otherwise it is not.
.LI "g/s0/s/s1/s2/g
.br
This command marks all those lines that contain the
string 
.Q "s0" ,
and then for those lines only, it 
substitutes all occurrences of the string 
.Q "s1"
with 
.Q "s2" .
.LE
.Li g!/\fIpattern\fB/\fIcmds
.br
This variant form of 
.I g
runs 
.I cmds
at each line not matching 
.I pattern .
.Li "s/\fIpattern\fB/\fIrepl\fB/\fIoptions"
.br
On each specified line, the first instance of text
matching the regular expression
.I pattern
is replaced by the replacement text
.I repl.
If the
.I global
indicator option character 
.Q "g"
appears, then all instances on a line are substituted.
If the
.I confirm
indication character 
.Q "c"
appears,
then before each substitution the line to be substituted
is printed on the screen with the string to be substituted marked
with caret (\|^\|) characters.
By typing a 
.Q "y" ,
you cause the substitution to be performed;
any other input causes no change to take place.
After an
.B s
command
the current line is the last line substituted.
.Li v/\fIpattern\fB/\fIcmds
.br
A synonym for the
.B global
command variant 
.B g! , 
running the specified 
.I cmds 
on each line that does not match 
.I pattern .
.LE
.H 3 "Text Movement Commands"
The text movement commands are largely superseded by
commands available in Vi command mode.
However, the following two commands are still quite useful.
.VL 10
.Li  co "addr flags"
.br
A copy of the specified lines is placed after
.I addr,
which may be 
.Q "0" .
The current line
.Q "\fB.\fR"
addresses the last line of the copy.
.Li [\fIrange\fB]m\fIaddr\fR 
.br
The
.B m
command moves
the lines specified by
.I range
after the line given by
.I addr .
For example,
.Q "m+"
swaps the current line and the following line,
since the default range is just the current line.
The first of the moved lines becomes the current line (dot).
.LE
.H 3 "Shell Escape Commands"
You will often want to escape from the editor to
execute normal \*(x1 commands. 
You may also want to change your working directory
so that your editing can be done with respect to a
different working directory.
These operations are described below:
.VL 10
.Li cd directory
.br
The specified 
.I directory
becomes the current directory.
If no directory is specified, the current value of the
.I home
option is used as the target directory.
After a
.B cd
the current file is not considered to have been
edited so that write restrictions on preexisting files 
still apply.
.Li sh ""
A new shell is created.
You  may invoke as many commands as you like in this shell.
To return to Vi, type a 
.SM <CONTROL-D> 
to terminate the shell.
.Li !\fIcommand\fI
The remainder of the line after the exclamation (!) 
is sent to a shell to be executed.
Within the text of
.I command
the characters 
.Q "%"
and 
.Q "#"
are expanded as the filenames 
of the current file and the last edited file and the character
.Q "!"
is replaced with the text of the previous command.
Thus, in particular,
.Q "!!"
repeats the last such shell escape.
If any such expansion is performed, the expanded line is echoed.
The current line is unchanged by this command.
.P
If there has been 
.Q "[No\ write]"
of the buffer contents 
since the last
change to the editing buffer, then a diagnostic is printed
before the command is executed as a warning.
A single exclamation (!) is printed when the command completes.
.LE
.H 3 "Other Commands"
The following command descriptions explain how to
use miscellaneous Ex commands that do not fit into
the above categories:
.VL 10
.Li  nu
Prints each specified line preceded by its buffer line number.
The current line is left at the last line printed.
To get automatic line numbering of lines in the
buffer, set the 
.I number 
option.
.Li preserve
The current editor buffer is saved 
as though the system had just crashed.
This command is for use only in emergencies when a
.B w
command has resulted in an error 
and you don't know how to save your work.
.Li  =
Prints the line number of the
addressed line.
The current line is unchanged.
.Li recover file
.br
Recovers  
.I file
from the system save area.
The system saves a copy of the 
editing buffer only if you
have made changes to the file,
the system crashes, or
you execute a
.B preserve
command.
Except when you use
.B preserve
you will be notified by mail when a file is saved.
.Li set argument
.br
With no arguments, 
.B set
prints those options whose values have been
changed from their defaults;
with the argument
.I all
it prints all of the option values.
.P
Giving an option name followed by a question mark (?)
causes the current value of that option to be printed.
The 
.Q "?"
is unnecessary unless the option is Boolean valued.
Switch options are given values either with
.DS I
set \fIoption\fR
.DE
to turn them on or
.DS I
set \fnooption\fR
.DE
to turn them off.
String and numeric options are assigned with
.DS I
set \fIoption\fR=value
.DE
.P
More than one parameter may be given to 
.I set \|;
all are interpreted from left to right.
For more information, see Section 6.7, 
.Q "Start-Up Files and Options" .
.Li tag label
.br
The focus of editing switches to the location of
.I label .
If Vi has to, it will switch to a different file in
the current directory to find 
.I label .
If you have modified the current file before giving a
.B tag
command, you must first write it out. 
If you give another
.B tag
command with no argument, then the previous
.I label 
is used.
.P
Similarly, if you type only a
.SM <CONTROL-]> ,
Vi searches for the word immediately after the cursor as a tag.
This is equivalent to typing 
.Q ":tag" ,
this word, and then a 
.SM <RETURN> .
.P
The tags file is normally created by a program such as
.B ctags,
and consists of a number of lines 
with three fields separated by blanks or tabs.  
The first field gives the name of the tag,
the second the name of the file where the tag resides, 
and the third gives an addressing 
form which can be used by the editor to find the tag.
This field is usually a contextual scan using 
/\|\fIpattern\fR\|/
to be immune to minor changes in the file.  
Such scans are always performed as if the
.I nomagic
option was set.
The tag names in the tags file must be sorted alphabetically.
.LE
