.H 2 "Start-Up Files and Options"
There are a number of options that can be set
to affect the Vi environment. 
These can be set with the Ex
.B set 
command
either while editing 
or immediately after Vi is invoked in the 
Vi start-up file,
.FN \&.exrc .
.P
The first thing that must be done 
before you can use Vi, is to set the terminal
type so that Vi understands how to talk to the 
particular terminal you are using.
This is the subject of the next subsection.
.H 3 "Setting the Terminal Type"
To run Vi, the shell variable TERM
must be defined and exported to your shell environment.
How you do this depends on which shell you are using.
You can usually determine which shell you are using by examining
the prompt character.
The regular shell prompts with a dollar sign ($); the C-shell 
prompts with a percent sign (%).
.P
Once you have determined which shell you are using,
you need to find the name of your terminal type.
For these examples, we will suppose
that you are using an HP 2621 terminal. 
In the file 
.FN /etc/termcap
is a description of the capabilities of this terminal.
Each terminal capability description 
has a unique name that corresponds to the
type of a terminal supported by Vi.
For the HP 2621, this 
.Q "termcap"
name is 
.Q "2621" .
.H 4 "The Regular Shell"
To set your terminal type to 2621, for example, 
you would place
the following commands in the file 
.FN .profile :
.DS I
TERM=2621
export TERM
.DE
.P
There is a way to have this done
automatically when you log in.
Suppose you usually dial in on a 2621.
You want to tell this to the machine, but still have it
work when you use another hardwired terminal.
One way is to place the following sequence of commands
in your
.FN \&.profile 
file:
.DS I
tset \-s \-d 2621 > tset$$
\&. tset$$
rm tset$$
.DE
This says that if you are dialing in you are on a 2621,
but if you are on a hardwired terminal 
it figures out your terminal
type from an on-line list.
For the above sequence of commands to work, be sure that 
in your 
.FN \&.profile
file you have first set your PATH variable 
so that it includes the current directory 
.H 4 "The C Shell"
To set your terminal type to 2621 for the C shell,
you would place the following commands in the file
.FN .login :
.DS I
setenv TERM 2621
.DE
.P
To specify your terminal type dynamically when you
log in, you could use a procedure parallel to that discussed above for
the normal shell:
.DS I
tset \-s \-d 2621 > tset$$
source tset$$
rm tset$$
.DE
Remember that you place these commands in the file
.FN \&.login .
.H 3 "The .exrc File"
Each time Vi is invoked, it reads commands from the
file named
.FN \&.exrc
in your home directory.
This file normally sets the user's preferred options
so that they need not be set manually each time 
you invoke Vi.
A sample 
.FN \&.exrc
file follows:
.DS I
set number
set wrapmargin=20
set errorbells
set ignorecase 
set autoindent
.DE
Each of the above options is described in more
detail below.
.H 3 "Options"
There are only two kinds of options: switch
options and string options.
A switch option is either on or off.
A switch is turned off by prefixing the word
.I no
to the name of the switch within a 
.B set 
command.
String options are strings of characters that
are assigned values with the syntax 
.I option=string.
Multiple options may be specified on a line.
.I Vi
options are listed below:
.VL 10
.de Li
.ta 3.0iL
.LI "\\fB\\$1\\fR\\t\\$2\\fR"
.ta
..
.Li "autoindent, ai" "default: noai"
.br
Can be used to ease the preparation of structured program text.
For each line created by an
append, change, insert, open,
or substitute operation,
Vi looks at the preceding line to determine and
insert an
appropriate amount of indentation.
To back the cursor up to the preceding tab stop, you can type
.SM <CONTROL-D> .
The tab stops going backwards 
are defined as multiples of the
.I shiftwidth
option.
You cannot backspace over the indent,
except by typing a
.SM <CONTROL-D> .
.P
Specially processed in this mode is a line 
with no characters added
to it, which turns into a completely blank line (the whitespace 
provided for the
.I autoindent
is discarded.)
Also specially processed in this mode are lines beginning with
a caret (\|^\|) and immediately followed by a 
.SM <CONTROL-D>.
This causes the input 
to be repositioned at the beginning of the line,
but retains the previous indent for the next line.
Similarly, a 
.Q "0"
followed by a 
.SM <CONTROL-D>
repositions the cursor at the beginning but without
retaining the previous indent.
.I Autoindent
doesn't happen in global
commands.
.Li "autoprint ap" "default: ap"
.br
Causes the current line to be printed after each
Ex copy, move, or substitute command.
This has the same effect as supplying a trailing 
.Q "p" 
to each such command.
.I Autoprint
is suppressed in globals,
and only applies to the last of many commands on a line.
.Li "autowrite, aw" "default: noaw"
.br
Causes the contents of the buffer to be automatically
written to the current file if you have modified it when
you give a
.B next ,
.B rewind ,
.B tag ,
or
.B !
command, or a 
.SM <CONTROL-^>
(switch files) 
or 
.SM <CONTROL-]>
(tag go to) command.
.Li "beautify, bf" "default: nobeautify"
.br
Causes all control characters except tab, new line and formfeed
to be discarded from the input.
A complaint is registered the first time a
backspace character is discarded.
.I Beautify
does not apply to command input.
.Li "directory, dir" "default: dir=/tmp"
.br
Specifies the directory in which Vi
places the editing buffer file.
If this directory is not
writable, then the editor will exit abruptly when it fails 
to write to the buffer file.
.Li "edcompatible" "default: noedcompatible"
.br
Causes the presence or absence of
.B g
and
.B c
suffixes on substitute commands to be remembered, 
and to be toggled on and off
by repeating the suffixes.  
The suffix
.B r
cause the substitution to be like the
.tr ~~
.B "~"
.tr ~ 
command, instead of like
.B &.
.Li "hardtabs, ht" "default: ht=8"
.br
Gives the boundaries on which terminal hardware tabs are set or
on which the system expands tabs.
.Li "ignorecase, ic" "default: noic"
.br
All uppercase characters in the text are mapped to 
lowercase in regular expression matching.
In addition, all uppercase characters 
in regular expressions are mapped
to lowercase except in character class specifications
enclosed in brackets.
.Li "lisp" "default: nolisp"
.br
.I Autoindent
indents appropriately for
LISP code, and the \fB( ) { } [[\fR and \fB]]\fR commands 
are modified to have meaning for LISP.
.Li "list" "default: nolist"
.br
All printed lines will be displayed unambiguously,
showing tabs and end-of-lines.
.Li "magic" "default: magic"
.br
If
.I nomagic
is set, the number of regular expression metacharacters is 
greatly reduced, 
with only up-arrow (^) and  dollar sign ($) having special effects.
.tr ~~
In addition the metacharacters 
.Q "~"
and 
.Q "&" 
in replacement patterns are treated as normal characters.
All the normal metacharacters may be made
.tr ~ 
.I magic
when
.I nomagic
is set by preceding them with a backslash (\e).
.Li "mesg" "default: nomesg"
.br
Causes write permission to be turned off to the terminal
while you are in visual mode, if
.I nomesg
is set.
This prevents people writing to your screen with the \*(x1 
.B write 
command and scrambling your screen as you edit.
.Li "number, n" "default: nonumber"
.br
Causes all output lines to be printed with their line numbers.
.Li "optimize, opt" "default: optimize"
.br
Output of text to the screen is expedited 
by setting the terminal
so that it does not perform automatic carriage returns
when printing more than one line of output,
thus greatly speeding output on terminals without addressable
cursors when text with leading whitespace is printed.
.Li "paragraphs, para" "default: para=IPLPPPQPP\0LIbp"
.br
Specifies paragraph delimiters 
for the \fB{\fR and \fB}\fR operations.
The pairs of characters in the option's value are the names
of the nroff macros that start paragraphs.
.Li redraw "default: noredraw"
.br
The editor simulates (using great amounts of output), 
an intelligent
terminal on a dumb terminal.
Useful only at very high speed.
.Li report "default: report=5"
.br
Specifies a threshold for feedback from commands.
Any command that modifies more than the specified number of lines
will provide feedback as to the scope of its changes.
For global commands and the undo command,
which have potentially far reaching scope,
the net change in the number of lines in the buffer is
presented at the end of the command, subject to this same threshold.
Thus notification is suppressed during a
.B g
command on the individual commands performed.
.Li scroll "default: scroll=\(12 window"
.br
Determines the number of logical lines scrolled when
.DS I
.SM <CONTROL-D>
.DE
is received from a terminal input in command mode,
and the number of lines printed by a command mode
.B z
command (double the value of
.I scroll ).
.Li sections "default: sections=SHNHH\0HU"
.br
Specifies the section macros for the \fB[[\fR and \fB]]\fR operations.
The pairs of characters in the option's value are the names
of the nroff macros that start paragraphs.
.Li "shell, sh" "default: sh=/bin/sh"
.br
Gives the pathname of the shell forked for 
the shell escape command 
.Q "!" ,
and by the
.B shell
command.
The default is taken from SHELL in the environment, if present.
.Li "shiftwidth, sw" "default: sw=8"
.br
Gives the width of a software tab stop,
used in reverse tabbing with 
.SM <CONTROL-D>
when using
.I autoindent
to append text,
and by the shift commands.
.Li "showmatch, sm" "default: nosm"
.br
When a \fB)\fR or \fB}\fR is typed, 
moves the cursor to the matching
\fB(\fR or \fB{\fR for one second 
if this matching character is on the screen.  
.Li "tabstop, ts" "default: ts=8"
.br
The editor expands tabs in the input file to be on
.I tabstop
boundaries for the purposes of display.
.Li "taglength, tl" "default: tl=0"
.br
The first 
.I taglength 
characters in a tag name are significant,
but all others are ignored.
A value of zero (the default) means 
that all characters are significant.
.Li "tags" "default: tags=tags /usr/lib/tags"
.br
A path of files to be used as tag files for the
.B tag
command.
A requested tag is searched for in the specified files, sequentially.
By default files named
.FN tag
are searched for in the current directory and in /usr/lib. 
.Li "term" "default=value of shell TERM variable"
.br
The terminal type of the output device.
.Li "terse" "default: noterse"
.br
Shorter error diagnostics are produced for the experienced user.
.Li "warn"   "default: warn"
.br
Warn if there has been 
.Q "[No write since last change]"  
before a shell escape command (!).
.Li "window" "default: window=speed dependent"
.br
This specifies the number of lines in a text window.
The default is 8 at slow speeds (600 baud or less),
16 at medium speed (1200 baud),
and the full screen (minus one line) at higher speeds.
.Li "w300, w1200, w9600"
.br
These are not true options but set
.I window
(above)
only if the speed is slow (300), medium (1200), or high (9600),
respectively.
.Li "wrapscan, ws" "default: ws"
.br
Searches using the regular expressions in addressing
will wrap around past the end of the file.
.Li "wrapmargin, wm" "default: wm=0"
.br
Defines the margin for automatic insertion
of newlines during text input.
A value of zero specifies no wrap margin.
.Li "writeany, wa"  "default: nowa"
.br
Inhibits the checks normally made before
.B write
commands, allowing a write to any file that the system protection
mechanism will allow.
.LE
.ne 4i
.H 2 "Regular Expressions"
A regular expression specifies a set of strings of characters.
A member of this set of strings is said to be matched
by the regular expression.
Vi remembers two previous regular expressions:
the previous regular expression used in a
substitute
command and the previous regular expression used elsewhere,
referred to as the previous 
.I scanning
regular expression.
The previous regular expression
can always be referred 
to by a null regular expression:
e.g., 
.Q "//"
or 
.Q "??" .
.P
The regular expressions allowed by
Vi are constructed in one of two ways 
depending on the setting of the
.I magic
option.
The Ex and Vi default setting of
.I magic
gives quick access to a powerful set of regular expression
metacharacters.
The disadvantage of
.I magic
is that the user must remember that these metacharacters are
.I magic
and precede them with the backslash (\e) 
to use them as 
.Q "ordinary"
characters.
With
.I nomagic
set,
regular expressions are much simpler,
there being only two metacharacters.
The power of the other metacharacters is still available by preceding
the now ordinary character with a 
.Q "\e" .
Note that 
.Q "\e"
is thus always a metacharacter.
In this discussion the magic option is assumed. 
With
.I nomagic
the only special characters are 
the caret (^)
at the beginning
of a regular expression,
the dollar sign ($) at the end of a regular expression,
and the backslash (\e).
.tr ~~
The tilde (\|~\|) and the ampersand (&) also lose 
their special meanings
related to the replacement pattern of a substitute.
.P
The following basic constructs are used to construct
.I magic
mode regular expressions.
.VL 15
.LI "\fIchar\fR"
An ordinary character matches itself.
Ordinary characters are any characters except
a caret (\|^\|) at the beginning of a line,
a dollar sign ($) at the end of line,
a star (*) as any character other than the first,
and any of the following characters:
.DS I
\&.  \e  [  ~
.DE
These characters
must be escaped (i.e., preceded) by a backslash (\e)
if they are to be treated as ordinary characters.
.tr ~ 
.LI "\fB^\fR"
At the beginning of a pattern
this forces the match to succeed only at the beginning of a line.
.LI "\fB$\fR"
At the end of a regular expression this forces the match to
succeed only at the end of the line.
.LI "\&\fB.\fR"
Matches any single character except
the new-line character.
.LI "\fB\e<\fR"
Forces the match
to occur only at the beginning of a 
.Q "word" ; 
that is, either at the beginning of a line, or just before
a letter, digit, or underline and after a character not one of
these.
.LI "\fB\e>\fR"
Similar to 
.Q "\e<" ,
but matching the end of a 
.Q "word" , 
i.e. either the end of the line or before a character
which is not a letter, a digit, or the underline character.
.LI "\fB[\fIstring\fB]\fR"
Matches any single character in the class defined by
.I string.
Most characters in
.I string
define themselves.
A pair of characters separated by a dash (\-) in
.I string
defines the set of characters between 
the specified lower and upper
bounds, thus 
.Q "[a\-z]"
as a regular expression matches
any single lowercase letter.
If the first character of
.I string
is a caret (\|^\|) then the construct
matches those characters which it otherwise would not.
Thus 
.Q "[^a\-z]"
matches anything but a lowercase letter 
or a newline.
To place any of the characters caret, left bracket,
or dash in
.I string
they must be escaped with a preceding backslash (\e).
.LE
.P
The concatenation of two regular expressions first matches 
the leftmost regular expression 
and then the longest string that can be recognized
as a regular expression.
The first part of this new regular expression matches the 
first regular expression and the second part matches the second.
Any of the single character matching regular expressions mentioned
above may be followed by a
.Q "star"
(*) to form a regular expression
that matches zero or more 
adjacent occurrences of the characters
matched by the prefixing regular expression.
.tr ~~
The tilde (~) may be used in a regular expression
to match the text that defined the replacement part
of the last
.B s
command.
A regular expression may be enclosed between the sequences
.Q "\e("
and 
.Q "\e)"
to remember the text matched by the enclosed regular
expression.
This text can later be interpolated into the
replacement text using the notation
.DS I
\e\fIdigit\fR
.DE
where 
.I digit 
enumerates the set of remembered regular expressions.
is the number of the matched string
substitute replacement patterns.
.P
The basic metacharacters for the replacement pattern are
the ampersand (&) and the tilde (~)
these are given as 
.Q "\e&"
and 
.Q "\e~"
when
.I nomagic
is set.
Each instance of the ampersand is replaced by the characters
matched by the regular expression.
In the replacement pattern the tilde stands
for the text of the previous replacement pattern.
.P
Other metasequences possible in the replacement pattern
are always introduced by a backslash (\e).
The sequence 
.Q "\e\fIn\fR"
is replaced by the text matched
by the \fIn\fRth regular subexpression enclosed between
.Q "\e("
and 
.Q "\e)" .
When nested, parenthesized subexpressions are present,
\fIn\fR is determined by counting occurrences of 
.Q "\e("  
starting from the left.
The sequences 
.Q "\eu"
and 
.Q "\el"
cause the immediately 
following character in
the replacement to be converted to uppercase or lowercase, 
respectively, if this character is a letter.
The sequences 
.Q "\eU"
and 
.Q "\eL"
turn such 
conversion on, either until
.Q "\eE"
or 
.Q "\ee"
is encountered, 
or until the end of the replacement pattern.
.tr ~ 
.H 2 "Speeding Things Up"
At times, getting in and out of Vi can take much
more time than you'd like.
To increase the speed of invocation and to keep
the number of invocations to a minimum, the
following hints are offered:
.BL
.LI
If possible keep files around 30,000 characters in size, or smaller.
Files larger than 100,000 characters are intractable.
.LI
Invoke Vi with a list of filename arguments.
You can then use the next 
.RB ( :n ) 
command to cycle
through the named files.
This is faster and more efficient than using a series of edit
.RB ( :e ) 
commands or invoking the editor for each file.
.LI
When transferring text between files, yank or delete
text into a buffer; switch files, and then 
.Q "put" 
the text into the new file with the 
.B p
command.
.LI
If you want to execute \*(x1 commands while in Vi, 
use the shell escape 
.Q ":!" ,
or the 
.Q ":sh"  
command to create a new shell.
With either method, you can quickly return to Vi
without reinvocation.
.LE
.H 2 "When To Use Ex"
Since Ex and Vi are one and the same program, you
can switch back and forth between the two
quite easily. 
To enter Ex from Vi, use the 
.B Q
command.
To enter Vi from Ex,
use the 
.B vi
command.
.P
One major difference between the two 
is that Ex is line-oriented and
uses \*(x1 standard input and output. 
Vi is screen-oriented and uses its own special input
routines for handling keyboard input.
.P
Because of this difference, Ex is in some cases better than Vi.
For example, you can write scripts only for Ex:
scripts won't work in Vi.
Similarly, if you know how to use the line editor, 
Ed,
the transition to 
Ex will be easy, since the Ex command set 
is largely a superset of Ed.
Also use Ex whenever you need to perform
a substitution
command that requires more than one line of input.
Newlines can be escaped with a backslash (\e) in Ex, but not in Vi.
Therefore, the following command is legal in Ex,
but not in Vi:
.DS I
s/one line/one line\e
two lines\e
three lines\e
four lines/
.DE
.H 2 "Limitations"
In using Vi, you should note the following limits:
.BL
.LI
250,000 lines in a file
.LI
1024 characters per line
.LI
256 characters per global command list
.LI
128 characters per filename
.LI
128 characters in the previous inserted and deleted text
.LI
100 characters in a shell escape command
.LI
63 characters in a string valued option
.LI
30 characters in a tag name
.LE
.H 2 "Troubleshooting"
The following is a list of common problems that you may
encounter when using Vi, along with the probable
solution for each.
.VL 12
.LI "Don't know which operation mode you're in"
.br
You often want to abort a command or exit
insert mode.
To do this, type 
.SM <ESC>  
until the bell rings to assure
your return to Vi command mode.
.LI "Can't get out of subshell"
.br
Type 
.SM <CONTROL-D>
to exit any subshell.
.LI "Accidentally entered Ex command mode"
.br
If you pressed colon (:) accidentally,
you can return to where
you were in your file by typing an 
.SM <ESC> .
.LI "Inadvertent deletion or insertion"
.br
Type 
.Q "u"
to undo the last delete or insert command.
.LI "Scrambled Screen"
.br
Type 
.SM <CONTROL-L> 
to redraw the screen.
.LI "Line too long"
.br
Go to the middle of the line and type
.DS I
r<RETURN>
.DE
to break the line into two separate lines.
.LI "Can't see control characters"
.br
Set the 
.I list 
option by typing:
.DS I
:set list
.DE
This will substitute a caret (\|^\|) and the name of the
control letter in place of each control character.
This is most useful for detecting tab characters in files.
For example, 
.Q "^I"
would appear instead of the
expansion of the tab into one or more spaces.
.LI "Not in screen mode"
.br
Type 
.Q ":q!"
to abort and then restart.
Check to see if the TERM variable in the file
.FN .profile 
in your home directory contains the proper terminal
type definition.
.LI "Mistakenly in open mode"
.br
See above.
.LI "Full file not read in"
.br
Type 
.Q ":e! %"
to re-edit the current file.
.LI "Keyboard locked up"
.br
Vi has crashed and you are now in the shell
with your terminal characteristics set incorrectly.
To reset the keyboard, type:
.DS I
stty \-nl echo \-cbreak <LF>
.DE
Typing a linefeed, i.e., 
a
.SM <LF> 
or 
.SM <CONTROL-J> ) 
is important here, since it is quite possible that 
the 
.SM <RETURN> 
key will not work as a newline character.
To make sure that other terminal characteristics have
not been altered, it is easiest and best 
to log off, turn your terminal off, turn your terminal back on, 
and then log back in.
This should guarantee that your terminal's
characteristics are set back to normal.
.LI "System crashed"
.br
Normally, Vi will inform you that your editing
buffer has been saved before a crash. 
The buffer can be recovered by typing 
.DS I
vi -r \fIfilename\fR
.DE
If Vi was unable to save the buffer before the
crash,
then the editing buffer is irretrievably lost.
.LE 1
.bp
.H 2 "Character Functions"
.de Li
.LI "\fB\\$1\fR"
..
This section describes the use of each key on your keyboard
in Vi command mode and in insert mode. 
It does not describe the use of these keys in Ex
command mode.
If a character's only meaning in insert mode is to insert the
character in the text as is, then
only its meaning as a command is discussed.
Characters are presented alphabetically with a
lowercase, an uppercase, and a control character
description for each letter of the alphabet.
.P
.VL 15 2
.Li "a"
Appends text after the current cursor position.
.Li "A"
Appends text at the end of the current line.
This is a synonym for 
.Q "$a" .
.Li "\s-2<CONTROL-A>\s0"
Not used as a command.
.Li "\s-2<BKSP>\s0"
Moves the cursor one character to the left.
This has the same function as the left 
arrow key, the 
.Q "h"
key, and 
.SM <CONTROL-H> .
Note that arrow keys on certain kinds of terminals
cannot be used, and that some terminals have no
arrow keys at all.
A preceding count repeats the effect.
.P
In insert mode, 
.SM <BKSP>
eliminates the last input character, backing over it
and erasing it from the insertion, but not from the screen. 
The character remains so that you can see what you 
have typed if you wish to type something slightly different.
.Li "b"
Backs up the cursor to the beginning 
of the current word.
A word is a sequence of alphanumeric characters,
or a sequence of special characters.
A preceding count repeats the effect.
.Li "B"
Backs up a word and 
places the cursor at the beginning of the current word,
where words are composed of non-whitespace sequences of
characters.
A preceding count repeats the effect.
.Li "\s-2<CONTROL-B>\s0"
Move the cursor back one screen window.
A preceding count repeats the effect.
Two lines from the preceding window are kept for
continuity, if possible.
.Li "c"
Changes the following text object, 
replacing it with input text up to an 
.SM <ESC> .
If more than part of a single line is affected,
the text which is deleted is saved in the numeric buffers.
If only part of the current line is affected, 
then the last
character in the text to be changed is marked with a dollar sign ($).
A count specifies the number 
of the given objects to be affected, 
thus both
.Q "3c)"
and 
.Q "c3)"
change three sentences.
.Li "C"
Changes the rest of the text on the current line,
replacing it with input text up to an
.SM <ESC> .
This is a synonym for 
.Q "c$" .
.Li "\s-2<CONTROL-C>\s0"
Not used as a command.
.Li "d"
Deletes the following text object.
If more than part of
a line is affected, 
the text is saved in the numeric buffers.
A count specifies the number of the given objects to be affected, 
thus 
.Q "3dw"
is the same as 
.Q "d3w" .
.Li "D"
Deletes text from the cursor to the end of the line.
The character beneath the cursor is deleted as part
of this command.
This is a synonym for 
.Q "d$" .
.Li "\s-2<CONTROL-D>\s0"
Scrolls down a half-window of text.
A preceding count gives the number of (logical) 
lines to scroll, and is remembered
for future 
.SM <CONTROL-D> 
and 
.SM <CONTROL-U>
commands.
When in insert mode,
.SM <CONTROL-D>
backtabs over 
.I autoindent
whitespace
at the beginning of a line:
this whitespace cannot normally be backspaced over.
.Li "e"
Advances to the end of the next word,
where a word is defined as for the
.B b
and 
.B w 
commands.
A preceding count repeats the effect.
.Li "E"
Moves forward to the end of a word, 
where a word is defined as for the 
.B B
and
.B W 
commands.
A preceding count repeats the effect.
.Li "\s-2<CONTROL-E>\s0" 
Not used as a command.
.Li "\s-2<ESC>\s0"
Exits insert mode and
also aborts a partially formed Vi command.
Also terminates command line input 
on the status line for
commands such as colon (:), slash (/), and question mark (?)\|). 
If an 
.SM <ESC> 
is given when in command mode, the editor
rings the bell or flashes the screen.
.Li "f"
Moves forward from the cursor to the first instance 
of a given character on the current line.
This character is the next character typed.
The search for the character 
begins following the cursor on
the current line.
The search goes no farther than the end of the
current line.
A preceding count repeats the effect.
.Li "F"
Moves forward from the cursor to the first instance 
of a given character on the current line.
This character is the next character typed.
The search for the character begins preceding the cursor on
the current line.
The search goes no farther than the beginning of the 
current line.
A preceding count repeats the effect.
.Li "\s-2<CONTROL-F>\s0"
Moves the cursor forward one screen window.
A preceding count repeats the effect.
Two lines from the preceding window are kept for
continuity, if possible.
.Li "g"
Not used as a command.
.Li "G"
Moves the cursor to the line specified by a
preceding line number argument (e.g., 
.Q "12G" 
moves the cursor to the beginning of line 12.
If no line number is given, the cursor moves
to the end of the file.
The screen is redrawn with the
new current line in the center of the screen.
.Li "\s-2<CONTROL-G>\s0"
Prints the name of the file currently being edited, 
whether the file has been modified during the
current editing session, the line number of the
current line, the number of lines in the file,
and your location in the file as a percentage
of the number of lines in the file.
Same as 
.Q ":f<RETURN>" . 
.Li "h"
See 
.SM <BKSP> .
.Li "H"
Homes the cursor to the beginning of the top line on the screen.
If a count is given,
then the cursor is moved to the beginning of the
line that is the 
.Q "count'th"
line from the top of the screen.
In any case,
the cursor is moved to the first non-whitespace character on the line.
.Li "\s-2<CONTROL-H>\s0"
See 
.B h .
.Li "i"
Inserts text before the cursor, otherwise like 
.B a .
.Li "I"
Inserts text at the beginning of the current line. 
This is a synonym for 
.Q "^i" .
.Li "\s-2<CONTROL-I>\s0" 
See 
.SM <TAB> .
.Li "j"
Moves the cursor one line down in the same column.
If the column position does not exist,
.I vi
comes as close as possible to the same column.
Synonyms include
.SM <CONTROL-J> ,
.SM <LF> ,
and
.SM <CONTROL-N> .
.Li "J"
Joins together the current line 
with the next line,
supplying appropriate whitespace:
one space between words, two spaces after a period,
and no spaces at all if the first
character of the joined line is a right parenthesis.
A count causes the given number of lines to be
joined.
.Li "\s-2<CONTROL-J>\s0"
See
.B j .
.Li "k"
Moves the cursor up one line in the same column.
.SM <CONTROL-P>
is a synonym.
.Li "K"
Not used as a command.
.Li "\s-2<CONTROL-K>\s0"
Not used as a command.
.Li "l"
Moves the cursor one character to the right.
The 
.SM <SPACE> 
and 
right arrow keys
are synonyms.
.Li "L"
Moves the cursor to the first non-whitespace character of 
the last line on the screen.
With a preceding count, it moves
to the first non-whitespace character of the 
.Q "count'th"  
line from the bottom.
.Li "\s-2<CONTROL-L>\s0"
Causes the screen to be cleared and redrawn.
This is useful after a transmission error, 
if characters
typed by a program scramble the screen,
or after output is stopped by an interrupt.
The 
.SM <FF>
or form feed key
is a synonym for this key.
.Li "m"
Marks the current position of the cursor with an
alphabetic 
.Q "mark" .
The mark is specified by the character given as an argument
to the command.
This character is the next key typed,
and must be in the range 
.Q "a" \-
.Q "z" .
Move to this marked position
using \fB\'\fIletter\fR or \fB\`\fIletter\fR.
.Li "M"
Moves the cursor to the middle line on the screen,
at the first non-whitespace position on the line.
.Li "\s-2<CONTROL-M>\s0"
Same as
.SM <RETURN> .
.Li "n"
Repeats the last 
search command
.RB ( /
or
.BR ? ).
.Li "N"
Scans for the next match of the last pattern given to
.B /
or 
.B ?,
but in the reverse direction; this is the inverse
of 
.B n .
.Li "\s-2<CONTROL-N>\s0"
See
.B j .
.Li "o"
Opens a new line below 
the current line so that text can be inserted.
Input is terminated by typing
.SM <ESC> .
.Li "O"
Opens a new line above the current line 
so that text can be inserted.
Input is terminated by typing
.SM <ESC>.
A count can be used to specify a number
of lines to be opened.
.Li "\s-2<CONTROL-O>\s0"
Not used as a command.
.Li "p"
Puts last deleted text at either the line below the cursor
or inserts that text before the cursor on the same line. 
See 
.B P 
below for details.
.Li "P"
Puts the last deleted text back in the buffer 
either above or before the cursor.
The text goes back as whole lines above the cursor
if it was deleted as whole lines.
Otherwise, the text is inserted
between the characters before and at the cursor.
.B P 
may be preceded by a named buffer specification 
of the form
.DS I
"\fIx\fR
.DE
to retrieve the contents of the named buffer. 
Buffers 1\-9 contain deleted material;
buffers a\-z are available for general use.
.Li "\s-2<CONTROL-P>\s0"
See
.B k .
.Li "q"
Not used as a command.
.Li "Q"
Switches from Vi to Ex command mode.
In Ex command mode, whole lines
form commands, ending with a 
.SM <RETURN> .
You can give most Ex
commands in Ex command mode without
typing a preceding colon; the editor will supply the colon as a prompt.
To return to Vi command mode, use the 
.B vi
command.
.Li "\s-2<CONTROL-Q>\s0"
Not a command character.
.Li "\s-2<RETURN>\s0"
Advances to the next line,
at the first non-whitespace position in the line.
If given a count, it advances that many lines.
.P
When in insert mode, a 
.SM <RETURN>
causes the insertion to continue on to a new line.
The 
.SM <RETURN>
key is the same as the 
.SM <CONTROL-M>
key.
.Li "r"
Replaces the single character
at the cursor with the next typed character.
The new character may be a 
.SM <RETURN> : 
this is the easiest way to split lines.
A count replaces each of the following count characters
with the single character given.
.Li "R"
Replaces characters on the screen with characters you type
(this is sometimes called overstrike mode).
Replacement terminates with an 
.SM <ESC> .
.Li "\s-2<CONTROL-R>\s0"
Redraws the current screen, eliminating logical lines 
not corresponding
to physical lines (lines containing only a single at-sign (@)).
.Li "s"
Substitutes the single character under the cursor 
with the input text.
Text input is terminated with an
.SM <ESC> .
If given a count, 
.B s 
then substitutes 
the given number of characters rather than just one.
The last character to be changed is marked with 
a dollar sign ($), as with the 
.B c 
command.
.Li "S"
Changes whole lines, a synonym for the 
.B cc 
command.
A count substitutes the given number of lines instead
of just one.
Substituted lines are saved in the numeric buffers and erased
on the screen before the substitution begins.
.Li "\s-2<CONTROL-S>\s0"
Not used as a command.
.Li "\s-2<SPACE>\s0"
See 
.B l 
above.
.Li "t"
Advances the cursor forward, up to, but not on a
given character.
The given character is the next character typed.
Most useful with operators such as 
.B d
and 
.B c
to delete the
characters up to a character.
Use dot (.) to delete
more if this doesn't delete enough the first time.
.Li "T"
Takes the next typed character as an argument,
locates this character before the cursor in the current line,
and then places the cursor just after that character.
A count repeats the effect.
.Li "\s-2<CONTROL-T>\s0"
Not a command character.
During an insertion with 
.I autoindent
set and at the beginning of the
line, inserts 
.I shiftwidth 
whitespace.
.Li "\s-2<TAB>\s0"
Not a command character.
When in insert mode, a 
.SM <TAB> 
prints as a 
number of spaces appropriate to vi's tab settings.
When the cursor is at a tab character 
it rests at the last of the spaces
which represent the tab.
The spacing of tab stops is controlled by the 
.I tabstop
option.
.Li "u"
Undoes the last change made to the current buffer.
If repeated, will alternate between these two states,
thus this command is its own inverse.
When used after an insertion
that inserted text on more than one line,
then the inserted lines are saved in the numeric named buffers.
.Li "U"
Restores the current line to its state before you started changing it.
This works only for the duration of the particular line
edit; not for the duration of the editing session.
.Li "\s-2<CONTROL-U>\s0"
Scrolls the screen up.
Counts work as
they do for 
.SM <CONTROL-D> . 
The previous scroll amount is common to both.
.Li "v"
Not used as a command.
.Li "V"
Not used as a command.
.Li "\s-2<CONTROL-V>\s0"
Not a command character.
In input mode, 
.SM <CONTROL-V>
quotes the next character so that it is possible
to insert nonprinting and special characters into the file.
.Li "w"
Advances the cursor to the beginning of the next word, where a
word is as defined in the
.B b 
command, above.
.Li "W"
Moves the cursor forward to the beginning 
of a word in the current line,
where words are defined as sequences of non-whitespace characters.
A count repeats the effect.
.Li "\s-2<CONTROL-W>\s0"
Not a command character.
During an insertion, 
.SM <CONTROL-W>
backs up as 
.B b 
would in command mode. 
.Li "x"
Deletes the single character under the cursor.
With a count,
.B x
deletes the given number of characters forward 
from the cursor position, but only
on the current line.
.Li "X"
Deletes the character before the cursor.
A count repeats the effect,
but only characters on the current line are deleted.
.Li "\s-2<CONTROL-X>\s0"
Not used as a command.
.Li "y"
.Q "Yanks"
the following object into 
the unnamed temporary buffer.
If this command is preceded by a named buffer specification, 
then the text is placed in that buffer also.
Text can be recovered with a later 
.B p
or 
.B P 
command.
.Li "Y"
.Q "Yanks"
a copy of the current line into the unnamed buffer, 
to be put back by a later 
.B p 
or 
.B P 
command.
This is a useful synonym for 
.Q "yy" .
A count yanks the given number of lines.
May be preceded by a buffer name to put lines in that buffer.
.Li "\s-2<CONTROL-Y>\s0"
Not used as a command.
.Li "z"
Adjusts and redraws the screen with the current line placed
as specified by an alignment character.
The alignment character may be either a 
.SM <RETURN> ,
a period (.),
or a minus (\-).
A
.SM <RETURN>
specifies the top of the screen, 
a dot the
center of the screen, and a minus the bottom of the screen.
A count may be given after the 
.B z ,
but before the
alignment character, to specify the new screen size for the redraw.
A count before the 
.B z
gives the number of the line to place in the
center of the screen instead of the default current line.
.Li "ZZ"
Exits the editor.
(Same as 
.Q ":x\s-2<RETURN>\s0" .)
If any changes have been made,
the buffer is written out to the current file.
Then the editor quits.
.Li "\s-2<CONTROL-Z>\s0"
Not used as a command.
.Li "0"
Moves the cursor to the first character on the current line.
Also used in forming numbers, after an initial digit
in the range 1\-9.
Note that no command can take an initial zero as part
of a count argument.
.Li "1\-9"
Used to form numeric arguments to commands.
.Li "("
Retreats to the beginning of a
sentence, or a 
.SM LISP
s-expression,
if the 
.I lisp 
option is set.
A sentence ends at a period (\|.\|), exclamation (!), or 
question mark (?) which is followed by either
a newline or by two spaces.
Any number of closing parentheses, brackets,
quotation marks, or single quotes 
may appear after the period, exclamation, or question mark,
but 
.I before 
trailing spaces and before a newline.
Sentences also begin at paragraph and section boundaries
(see 
.B {
and 
.B [[ 
below).
If given a count, the command is repeated.
A count advances the given number of sentences.
.Li ")"
Advances to the beginning of a sentence.
A count repeats the effect.
See 
.B ( 
above for the definition of a sentence.
.Li "[["
Backs up to the previous section boundary.
A section begins at each macro in the 
.I sections
option,
normally a 
.Q ".NH"
or 
.Q ".SH"
and 
also at lines that start with a formfeed character,
.SM <CONTROL-L>.
Lines beginning with \fB{\fR also stop \fB[[\fR.
This makes it useful for looking backwards,
a function at a time, in C programs.
If the 
.I lisp
option is set, the 
.B [[ 
stops at each left parenthesis [(]
at the
beginning of a line. 
.Li "]]"
Moves forward to a section boundary. See 
.B [[ 
for the definition of a section boundary.
.Li "<"
Shifts lines left one 
.I shiftwidth , 
normally eight spaces.
Affects lines when repeated, as in 
.Q "<<" .
Counts are passed through to the basic object,
thus 
.Q "3<<"
shifts three lines.
.Li ">"
Shifts lines right one 
.I shiftwidth ,
normally eight spaces.
Counts repeat the basic object.
This operator can be made to 
affect a given number of lines when the character
is doubled and preceded by the number of lines to be
affected, as in 
.Q "23>>" . 
.Li "{"
Retreats to the beginning of the preceding paragraph.
A paragraph begins at each macro in the 
.I paragraphs 
option, normally at a
.Q ".IP" , 
.Q ".LP" , 
.Q ".PP" , 
.Q ".QP"
and 
.Q ".bp" .
A paragraph also begins after a completely
empty line, and at each section boundary (see 
.B [[ 
above).
.Li "}"
Advances to the beginning of the next paragraph.
See 
.B {
for the
definition of a paragraph.
.Li "\`"
When followed by another back quotation mark, this
returns to the previous context.
The previous context is set whenever the current
line is moved in a nonrelative way.
When followed by a letter in the range 
.Q "a" \-
.Q "z" ,
returns to the position marked with the given
letter by an
.B m
command.
When used with an operator such as 
.B d , 
the operation takes place
from the exact marked place to the current position within the line;
if a single quotation mark (\|\'\|) is used, 
the operation takes place over whole lines instead.
.Li "\'"
When followed by a single quotation mark (\') 
returns to the previous context at the beginning of a line.
The previous context is set whenever the current
line is moved in a nonrelative way.
When followed by a letter in the range 
.Q "a\-z" , 
it returns to the line marked with the given letter by an
.B m
command.
When used with an operator such as 
.B d ,
the operation takes place
over complete lines; if you use a back quotation mark
(\|\`\|), 
the operation takes place from the exact marked place to the current 
cursor position within the line.
.Li "+"
Same as 
.SM <RETURN>
when used as a command.
.Li "\-"
Retreats to the previous line at the first nonwhite character.
This is the inverse of 
plus (+)
and 
.SM <RETURN> .
If the line moved to is not on the screen, the screen is scrolled, or,
if this is not possible, cleared and redrawn.
If a large amount of scrolling 
would be required the screen is cleared
and redrawn, with the current line at the center.
.Li "^"
Moves to the first nonwhite position on the current line.
.Li "_"
Not used as a command.
.Li "!"
Processes a text object in the editing buffer
with a \*(x1 command given as the 
.I second
argument.
The 
.I first
argument is a cursor movement command that delimits the text
object.
The \*(x1 command is processed by the shell, so
normal \*(x1 quoting conventions apply.
The command line itself is terminated with a 
.SM <RETURN> .
Doubling 
.B !
and preceding it by a count
causes count lines to be filtered;
otherwise the count
is passed on to the object after the 
.B ! .
Thus 
.DS I
2!}sort\s-2<RETURN>\s0
.DE
sorts the next two paragraphs
by running them through the program 
.B sort .
To read a file or the output of a command into the buffer use 
.Q ":r" .
To simply execute a command use 
.Q ":!" .
.tr ~"
.Li "~"
Precedes a named buffer specification.
There are named buffers 1\-9
used for saving deleted text
and named buffers a\-z
into which you can place text.
.tr ~~ 
.Li "$"
Moves the cursor to the end of the current line.
If you use 
.Q ":set list\s-2<RETURN>\s0" ,
then the end of each line will be shown
by printing a dollar sign ($) 
after the end of the displayed text in the line.
Given a count, advances to the count'th following end of line;
thus 
.Q "2$"
advances to the end of the following line.
.Li "%"
Moves the cursor to the parenthesis or brace
that balances the parenthesis
or brace at the current cursor position.
.Li "&"
A synonym for 
.Q ":&\s-2<RETURN>\s0" , 
by analogy with the Ex
.B &
command.
.Li ","
Reverses the last 
.B f ,
.B F ,
.B t ,
or 
.B T 
command, searching in the opposite direction on the current line.
This is especially useful after typing 
too many semicolon (;) characters.
A count repeats the search.
.Li ";"
Repeats the last single character
find command (either 
.B f ,
.B F ,
.B t ,
or
.B T ).
A count repeats the scan count number of times.
.Li "\&."
Repeats the last command that changed the buffer.
This is especially useful
when deleting words or lines; you can delete some words
or lines and then
press dot (\|\fB.\fR\|) to delete more words or lines.
If given a count, 
.Q "dot"
passes it on 
to the command being repeated.
Thus after a 
.Q "2dw" , 
.Q "3."
deletes three words.
.Li "/"
Reads a string from the last line on the screen, and scans forward for
the next occurrence of this string.
The normal input editing sequences may
be used during input on the status line.
.P
The search begins when you press 
either
.SM <ESC>
or
.SM <RETURN> .
The cursor then moves to the beginning 
of the last line to indicate that the search
is in progress. 
The search can 
be terminated by typing an 
.SM <INTERRUPT> .
Searches normally wrap around the end of the file to
the beginning to find a string anywhere in the buffer.
.P
When used with an operator the enclosed region is normally affected.
By giving an
offset from the line matched by the pattern 
you can force whole lines to be affected.
To do this, give a pattern with a closing slash (\|/\|) 
and then an offset 
.BI + n
or
.BI - n.
.Li "?"
Searches backwards for the string given as an argument.
This is the opposite of slash (/).
See the description of slash above for details on searching.
.Li ":"
The Ex command escape character.
Ex command input is entered on the status line.
If you press colon (:) accidentally,
you can return to where
you were by typing an 
.SM <INTERRUPT> .
.Li "|"
Places the cursor on the character in the column specified
by a preceding count.
.Li "="
Not used as a command.
.Li "@"
Not used as a command.
.Li "~"
Not used as a command.
.Li "*"
Not used as a command.
.Li "#"
Not used as a command.
.Li "\e"
Not used as a command.
.Li "\s-2<CONTROL-_>\s0"
Not used as a command.
Reserved as the command character for 
some terminals.
.Li "\s-2<CONTROL-?>\s0"
Interrupts the editor, returning it to command mode.
.Li "\s-2<CONTROL-@>\s0"
Not a command character.
If typed as the first character of an insertion 
it is replaced with the
last text inserted, and the insertion terminates.
Only 128 characters are
saved from the last insertion.
If more characters were inserted than 128, then
this command inserts no characters.
A
.SM <CONTROL-@> 
cannot be part of a file, even if quoted.
.Li "\s-2<CONTROL-[>\s0"
Same as
.SM <ESC> .
.Li "\s-2<CONTROL-]>\s0"
Searches for the word which is after the cursor as a tag.
Equivalent to typing 
.Q ":ta" ,
this word, and then a 
.SM <RETURN> .
Mnemonically, this command is 
.Q "go right to" .
.Li "\s-2<CONTROL-^>\s0"
Equivalent to 
.Q ":e #\s-2<RETURN>\s0" , 
Returns to the previous position
in the last edited file.
If you do not want to write the file you should
use 
.Q ":e!\ #\s-2<RETURN>\s0"
instead.
.LE
.rm Li
