.PH "'The Shell''The Shell'"
.H 2 "Introduction"
When users log into \*(x1,
they communicate with
the shell command interpreter,
.B sh .
This interpreter is a \*(x1 program that supports a very 
powerful command language.
Each invocation of this interpreter is called a shell;
and each shell has one single-minded
function: to read and execute commands from its
standard input.
.P
Because the shell gives the user a high-level language
in which to communicate with the operating system,
\*(x1 can perform tasks unheard of in less sophisticated
operating systems.
Commands that would normally have to be written
in a traditional programming language can be written
with just a few lines in a shell procedure.
In other operating systems,
commands are executed in strict sequence.  
With \*(x1 and the shell, commands can be:
.BL "" 1 
.LI
Combined to form new commands 
.LI
Passed positional parameters
.LI
Added or renamed by the user 
.LI
Executed within loops or executed conditionally 
.LI
Created for local execution without fear of name conflict 
with other user commands
.LI
Executed in the background without interrupting 
a session at a terminal
.LE 1
.P
Furthermore, commands can 
.Q "redirect"
command input from
one source to another and redirect command output to
a file, terminal, printer, or to another command.
What this provides the user is flexibility and generality;
flexibility in tailoring a task for a particular purpose
and generality in the concept of input and output.
.H 2 "XENIX and the Shell"
The shell itself
(i.e., the program that reads your commands when you
log in or that is invoked with the
.B sh
command)
is a program written in the C language;
it is not part of the operating system proper,
but an ordinary user program.
.P
Note that the word 
.Q "shell"
has two distinct
meanings when used in this chapter. 
Normally, when we refer to  
.Q "the shell" ,
we mean 
the interpreter that implements the shell command language;
the word 
.Q "shell"
in this case is used in a general sense.
However, when we talk about several instances of
executing command interpreters, then each of these
is called a 
.Q "shell" .
Keep these two usages of the word in mind as you
read this chapter.
.ne 5i
.H 3 "The Shell Command Interface"
Because the shell is the interface to all of the
resources of the operating system, it is important 
to understand the structure of this interface.
Figure 7-1 illustrates the overall structure:
.DS 

      ----------   ------------
     | User     | | Shell      |  Commands from keyboard or
     | Input    | | Procedures |  commands in shell procedures.
      ----------   ------------
          |           |
          v           v
      -------------------
     | XENIX             |  One shell for each terminal.
     | Shell             |  Branching child shells are possible.
      -------------------
          |
          v
      -------------------
     | XENIX             |  Executable programs
     | Commands          |  are invoked by the shell.
      -------------------
          |
          v
      -------------------
     | XENIX             |  Interface to system resources
     | Kernel            |  
      -------------------
       |   |   |   |   |
       |   |   |   |   +--> Processes 
       |   |   |   +------> Files and directories
       |   |   +----------> Devices: terminals & printers
       |   +--------------> Disk space
       +------------------> Main memory

.FG "XENIX Command Structure" 7-
.DE
.P
Commands are typed at the user's terminal or read
from a file.  
Command lines are read and interpreted by the  user's
shell so that executable \*(x1 programs can be invoked.
Invoked commands then make system calls to the \*(x1 kernel.  
The actions of the kernel are transparent to the user
at the keyboard.
.H 3 "How Shells Are Created"
In \*(x1, a process is an executing entity complete
with instructions, data, input, and output.  
All processes have lives
of their own, and may even give birth to new life by
"forking" new processes.  
Thus, at any given moment in
\*(x1, several processes may be executing, some of which
are "children" of other processes.
Users log into the operating system and
are assigned a "shell" from which they execute. 
This shell is simply a personal copy of the shell command
interpreter that is reading commands from the
keyboard: in this context, the shell is simply
another process.
.P
In this multitasking environment,
processes may be created in one process and then sent
off on their own to be processed in the "background."
Such jobs are analogous to batch jobs in larger
computer installations. 
.P
A schematic look at how user shells might fork 
other shells is shown in Figure 7-2.
.DS

      ----------    ----------    ---------- 
     | User1    |  | User2    |  | User3    | 
     | Shell    |  | Shell    |  | Shell    |  
      ----------    ----------    ---------- 
        |   ^        |    ^          |    ^
        |   |        |    |          |    |
        v   |        v    |          v    |
      --------    ---------------    -------- 
     | Forked |  | Forked        |  | Forked | 
     | Child  |  | Child         |  | Child  |  
     | "who"  |  | "who;date"    |  | "date" |
      --------    ---------------    -------- 
                   |  ^     |  ^
                   |  |     |  |
                   v  |     v  | 
             -----------   ---------- 
            | Forked    | | Forked   | 
            | Child     | | Child    |  
            | "who"     | | "date"   |
             -----------  ---------- 

.FG "Forking Shells" 7-
.P
.DE
.DS CB 1
Arrows show how control is passed from a parent
shell to a child shell leaving the parent waiting.
When a child shell completes execution,
it dies and control returns to the parent shell.
.DE
.H 2 "Using the Shell"
The most common way of using the shell is by typing
simple commands at your keyboard.
A
.I "simple command"
is any sequence of arguments separated by spaces or tabs.
The first argument (numbered zero) specifies
the name of the command to be executed.
Any remaining arguments, with a few exceptions, 
are passed as arguments to that command.
The following command line might be typed to request 
printing of the files
.FN allan ,
.FN barry ,
and
.FN calvin :
.DS I
lpr allan barry calvin
.DE
.P
If the first argument of a command names a file that is
.I executable
(as indicated by an appropriate set of permission bits
associated with that file)
and is actually a compiled program,
the shell, as parent, creates a child process that immediately
executes that program.
If the file is marked as being executable,
but is not a compiled program, it is assumed to be
a shell procedure,
i.e., a file of ordinary text containing
shell command lines. 
In this case, the shell spawns another instance of itself (a
.I subshell )
to read the file
and execute the commands inside it. 
The shell
.B fork s
to do this, but no
.B exec
call is made.
.P
From the user's viewpoint,
compiled programs and shell procedures are
invoked in exactly the same way.
The shell determines which implementation has been used,
rather than requiring the user to do so.
This provides uniformity of invocation
and ease of choosing the implementation of a given command.
.H 2 "How the Shell Finds Commands"
The shell normally searches for commands 
in three distinct locations in the file system.
The shell first attempts to use the command name as given;
if this fails, it
prepends the string
.FN /bin
to the name,
and finally,
.FN /usr/bin .
The effect is to
search, in order, the current directory,
then the directory
.FN /bin ,
and
finally,
.FN /usr/bin .
For example,
the
.B pr
and
.B man
commands are actually the files
.FN /bin/pr
and
.FN /usr/bin/man ,
respectively.
A more complex pathname may be given,
either to locate a file relative to the user's current directory,
or to access a command with an absolute pathname.
If a given command name 
begins with a slash (/)
(e.g.,
.FN /bin/sort
or
.FN /cmd ),
the prepending is not performed.
Instead, a single attempt is made to execute the
unmodified command as named.
.P
This mechanism gives the user a convenient way to execute
public commands and commands in or near the current directory,
as well as the ability to execute any accessible command,
regardless of its location in the file structure.
Because the current directory is usually searched first,
anyone can possess a private version of a public command
without affecting other users.
Similarly, the creation of a new public command does
not affect a user who already has a private command with the same name.
The particular sequence of directories searched may be 
changed by resetting the shell 
.Q "PATH" 
variable. 
.H 3 "Generation of Argument Lists"
The arguments to commands are very often filenames.
Sometimes, these filenames have similar, but not
identical names.
To take advantage of this similarity in names,
the shell lets the user specify patterns that match
the filenames in a directory.
If a pattern is matched by one or more filenames in
a directory, then those filenames are automatically
generated by the shell as arguments to the command.
.P
Most characters in such a pattern match themselves, 
but there are also
special metacharacters that may be included in a pattern.
These special characters are: 
the star (*),
which matches any string, 
including the null string; 
the question mark (?), 
which matches
any one character; 
and any sequence of characters
enclosed within brackets
([ and ]), 
which matches any one of the enclosed characters.
.P
Inside brackets, a pair of characters separated by
a dash (\-) matches any character lexically within the 
range of that pair.
Thus, 
.Q "[a\-de]"
is equivalent to 
.Q "[abcde]" .
.P
Examples follow of metacharacter usage:
.DS I
*          (Matches all names in the current directory)
*temp*     (Matches all names containing "temp")
[a-f]*     (Matches all names beginning with "a" through "f")
*.c        (Matches all names ending in ".c")
/usr/bin/? (Matches all single-character names in /usr/bin)
.DE
.P
This pattern matching capability saves much typing
and, more importantly,
makes it possible to organize information in large collections
of small files that are named in a disciplined way.
.P
Pattern-matching has some restrictions.
If the first character of a filename is a period (.),
it can be matched only by an argument that
literally begins with a period.
If a pattern does not match any filenames, 
then the pattern itself is returned as the result of the match.
.P
Note that directory names should not contain any of
the following characters:
.DS I
*  ?  [  ]
.DE
because this may
cause infinite recursion during pattern matching attempts.
.H 3 "Quoting Mechanisms"
Many characters have special meanings to the shell.
To remove the special meaning of these characters 
requires some form of quoting.
Single quotation marks (\') and
double quotation marks (") surrounding
a string, or a backslash (\e) before a single character, 
provide this function in somewhat different ways.
(Back quotation marks (\`)
are used only for command substitution in the shell
and do not hide the special meanings of any characters.)~
.P
Within single quotation marks, all characters (except the
single quote (\|\'\|) itself) are taken
literally, with any special meaning removed.
Thus
.DS I
echostuff=\'echo $? $*; ls * | wc\'
.DE
results in the string 
.DS I
echo $? $*; ls * | wc 
.DE
being assigned
to the variable 
.I echostuff , 
but 
it does 
.I not 
result in any other commands being executed.
.P
Within double quotation marks, the special meaning of certain characters
does persist, while all other characters are taken literally.
The characters that retain their special meaning are 
the dollar sign ($), 
the single quote (\|\`\|), 
and the double quote (\|"\|) itself.
Thus, within double quotation marks, variables are expanded and command
substitution (discussed in a later section) takes place. 
However, 
any commands in a command substitution are not affected by double
quotation marks outside of the grave accents, so that characters such as
star (*) retain their special meaning.
.P
To hide the special meaning of 
dollar sign ($), 
single quote (\|\`\|), 
and double quote (\|"\|) 
within double quotation marks,
precede these characters with a backslash (\e).
Outside of
double quotation marks, preceding a character with 
a backslash is
equivalent to placing single
quotation marks around that character.
A backslash  (\e)
followed by a newline causes that newline to be ignored
and is equivalent to a space. 
The backslash-newline pair is therefore
useful in allowing continuation of long command lines.
.H 2 "Redirection of Input and Output"
In general, most commands do not know or care whether their 
input or output
is coming from or going to a terminal or a file.
Thus, a command can be used conveniently either at a terminal or
in a pipeline.
A few commands vary their actions
depending on the nature of their input or output,
either for efficiency's sake,
or to avoid useless actions (such as attempting
random access I/O on a terminal or a pipe).
.H 3 "Standard Input and Output"
When a command begins execution, it usually expects that
three files are already open: a
.Q "standard input" .
a 
.Q "standard output" .
and a
.Q "diagnostic output" ,
(also called 
.Q "standard error" ).
A number called a
.I "file descriptor"
is associated with each of these files. 
By convention, file descriptor 0 
is associated with the standard input, file descriptor 1
with the standard output, and file descriptor 2 
with the diagnostic output.
A child process normally inherits these files from its parent;
all three files are initially connected to the terminal
(0 to the keyboard, 
1 and 2 to 
the terminal screen).
The shell permits them to
be redirected elsewhere before control is passed to an invoked command.
.P
An argument to the shell of the form
.Q "<file"
or 
.Q ">file"
opens the specified file
as the standard input or output
(in the case of output, 
destroying the previous contents of 
.FN file , 
if any).
An argument of the form
.Q ">>file"
directs the standard output to the end of 
.FN file ,
thus providing a way to append
data to it without destroying its existing contents.
In either of the two output cases, the shell creates
.FN file
if it does not already exist
(thus 
.Q ">output" 
alone on a line creates a zero-length file).
The following appends to file
.FN log
the list of users who are currently logged on:
.DS I
who >> log
.DE
Such redirection arguments are only subject to variable and command
substitution; neither blank interpretation
nor pattern matching of filenames occurs after these substitutions.
For example
.DS I
echo \'this is a test\' > *.gal
.DE
produces a one-line file named
.FN *.gal ,
a most unfortunate name for a file.
Similarly, an error message is produced by the following
command, unless you have a file with the name 
.Q "?" :
.DS I
cat < ?
.DE
So remember, special characters are 
.I not
expanded in redirection arguments.
The reason this is so, is that redirection arguments
are scanned by the shell 
.I before
pattern recognition and expansion takes place.
.H 3 "Diagnostic and Other Outputs"
Diagnostic output from \*(x1 commands is traditionally directed to the
file associated with file descriptor 2.
(There is often a need for an error output file
that is different from standard output so
that error messages do not get lost down pipelines.)~
You can redirect this
error
output
to a file by immediately prepending
the number of the file descriptor (i.e., 2 in this case)
to either output redirection symbol
(> or >>).
The following line 
appends error messages from the 
.B cc 
command to the file named
.FN ERRORS :
.DS I
cc testfile.c 2>>ERRORS
.DE
Note that the file descriptor number
must be prepended to
the redirection symbol 
.I without 
any intervening spaces or tabs; 
otherwise,
the number will be passed as an argument to the command.
.P
This method may be generalized to allow redirection of output
associated with any of the first ten file descriptors (numbered 0-9).
For instance, if 
.I cmd 
puts
output on file descriptor 9, 
then the following line will capture that output in the file
.FN savedata :
.DS I
cmd 9>savedata
.DE
A command often generates standard output and error output,
and might
even have some other output, perhaps a data file.
In this case, one
can redirect independently all the different outputs.
Suppose, for example,
that
.I cmd
directs its
standard output to file descriptor 1, 
its error output to file descriptor 2,
and builds a data file on file descriptor 9.
The following would direct
each of these three outputs to
a different file:
.DS I
cmd >standard   2>error   9>data
.DE
.H 3 "Command Lines and Pipelines"
A sequence of commands separated by
the vertical bar (\||\|) makes up a
.I pipeline .
In a pipeline consisting of more than one command,
each command is run as a separate process
connected to its neighbors by
.I pipes ,
i.e., the 
.I output 
of each command 
(except the last one) becomes the
.I input\| 
of the next command in line.
.P
A
.I filter
is a command that reads its standard input, 
transforms it in some way,
then writes it as its standard output.
A pipeline normally consists of a series of filters.
Although the processes in a pipeline are permitted to
execute in parallel,
they are synchronized to the extent
that each program needs to read the output of its predecessor.
Many commands operate on individual lines of text,
reading a line, processing it, 
writing it out, and looping back for more input.
Some must read larger amounts of data before producing output;
.B sort
is an example of the extreme case 
that requires all input to be read before
any output is produced.
.P
The following is an example of a typical pipeline, where
.B nroff
is a text formatter whose output may contain reverse line motions,
.B col
converts these motions to a form that can be
printed on a terminal lacking reverse-motion capability,
and 
.B lpr
does the actual printing.
The flag
.B \-mm
indicates one of the commonly used formatting
options, and
.FN text
is the name of the file to be formatted:
.DS I
nroff -mm text | col | lpr
.DE
.P
The following examples illustrate the
variety of effects that can be obtained by combining a few commands
in the ways described above.
It may be helpful to try these examples at a terminal:
.br
.ne 4v
.BL 6
.LI
who
.br
Prints the list of logged-in users on the terminal screen.
.LI
who~>>log
.br
Appends the list of logged-in users to the end of file
.I log .
.LI
who~|~wc~\-l
.br
Prints the number of logged-in users.
(The argument to 
.B wc 
is
.Q "minus ell" .)
.LI
who~|~pr
.br
Prints a paginated list of logged-in users.
.LI
who~|~sort
.br
Prints an alphabetized list of logged-in users.
.LI
who~|~grep~bob
.br
Prints the list of logged-in users whose login names contain
the string
.I bob.
.LI
who~|~grep~bob~|~sort~|~pr
.br
Prints an alphabetized, paginated list of logged-in users
whose login names contain the string
.I bob .
.LI
{~date;~who~|~wc~-l~}~>>log
.br
Appends (to
file
.FN log )
the current date followed by the count of logged-in users.
Be sure to place a space after the left brace.
.LI
who~|~sed~-e~\'s/~.*/\|/\|\'~|~sort~|~uniq~-d
.br
Prints only the login names of all users 
who are logged in more than once.
Note the use of 
.B sed
as a filter to remove characters trailing the login
name from each line.
.LE 1
.P
The
.B who
command
does not
.I "by itself"
provide options to yield all these results\*(EMthey are obtained
by combining
.B who
with other commands.
Note that
.B who
just serves as the data source in these examples.
As an exercise, replace
.Q "who~|\ "
with
.Q "</etc/passwd"
in the above examples
to see how a file can be used as a data source in the same way.
Notice that redirection arguments may appear anywhere on the
command line, even at the start.
.H 3 "Command Substitution"
Any command line can be placed within back quotation marks
(\`\|.\|.\|.\`) so that the output of the command
replaces the command line itself.
This concept is known as
.I "command substitution" .
The command or commands enclosed between back
quotation marks are first executed by the shell and then their output
replaces the whole expression, back quotation marks and all.
This feature is often used to assign to shell variables.
(Shell variables are described in the next section.)
For example
.DS I
today=\`date\`
.DE
assigns the string representing the current date to the variable
.Q "today" 
(e.g., 
.Q "Tue Nov 27 16:01:09 EST 1982" ).
The following command
saves the number of logged-in users in the variable
.I users \|:
.DS I
users=\`who | wc \-l\`
.DE
Any command that writes to the standard output can be enclosed
in back quotation marks.
Back quotation marks may be nested, but the inside sets must be escaped
with backslashes (\|\e\|).
For example:
.DS I
logmsg=\`echo Your login directory is \e\`pwd\e\`\`
.DE
.P
Shell variables can also be given values indirectly by using the
.B read
command.
The 
.B read
command
takes a line from the standard 
input (usually your terminal) and assigns
consecutive words on that line to any variables named.
.P
For example
.DS I
read first init last
.DE
takes an input line
of the form
.DS I
G. A. Snyder
.DE
and has the same effect as typing:
.DS I
first=G.   init=A.   last=Snyder
.DE
The 
.B read 
command assigns any excess 
.Q "words"
to the last variable.
.H 2 "Shell Variables"
The shell has several mechanisms for creating variables.
A variable is a name representing a string value.
Certain variables are referred to as 
.IR "positional parameters" \|;
these are the variables that are normally set 
only on the command line.
Other shell variables are simply names
to which the user or the shell itself may assign string values.
.H 3 "Positional Parameters"
When a shell procedure is invoked, the shell implicitly creates
.I "positional parameters" .
The name of the shell procedure itself in position zero 
on the command line
is assigned to the positional parameter $0.
The first command argument is called $1, and so on.
The
.B shift
command 
may be used to access arguments 
in positions numbered higher than nine.
.P
One can explicitly force values into these positional parameters 
by using the
.B set
command.
For example
.DS I
set abc def ghi
.DE
assigns the string 
.Q "abc"
to the first positional parameter, $1,
the string 
.Q "def"
to $2,
and the string 
.Q "ghi"
to $3.
Note that $0 may not be assigned a value in 
this way\*(EMit always refers to the name
of the shell procedure, or 
in the login shell, to the name of the shell.
.H 3 "User-Defined Variables"
The shell also recognizes alphanumeric variables
to which string values may be assigned.
A simple assignment has the syntax:
.DS I
\fIname\fP=\fIstring\fP
.DE
Thereafter,
.RI $ name
will yield the value
.I string .
A
.I name
is a sequence of letters, digits, and 
underscores that begins with a letter
or an underscore.
No spaces surround the equal sign (=)
in an assignment statement.
Note that positional parameters may not appear 
on the left side of
an assignment statement; they can only be set as described 
in the previous section.
.P
More than one assignment may appear in an assignment statement, 
but beware:
.I "the shell performs the assignments from right to left.\^"
.P
The following command line results in
the variable 
.I a 
acquiring the value 
.Q "abc" :
.DS I
a=$b b=abc
.DE
The following are examples of simple assignments.
Double quotation marks around the right-hand side
allow spaces, tabs, semicolons, and
newlines to be included in a string,
while also allowing 
variable substitution 
(also known as 
.Q "parameter substitution" ) 
to occur. 
This means that 
references to positional parameters and other variable names
that are prefixed by 
a dollar sign ($)
are replaced by the corresponding values, if any.
Single quotation marks inhibit variable substitution:
.DS I
MAIL=/usr/mail/gas
echovar="echo $1 $2 $3 $4"
stars=*****
asterisks='$stars'
.DE
In the above example,
the variable 
.Q "echovar"
has as its value the string consisting of the
values of the first four positional parameters, 
separated by spaces.
No quotation marks are needed around the string of asterisks 
being assigned to
.I stars
because pattern matching
(expansion of star, the question mark, and brackets)
does not apply in this context.
Note that the value of 
.RI $ asterisks 
is the literal string 
.Q "$stars" , 
.I not
the string 
.Q "*****" ,
because the single quotation marks inhibit substitution.
.P
In assignments, spaces are not re-interpreted after variable
substitution,
so that the following example results in 
.RI $ first 
and 
.RI $ second 
having
the same value:
.DS I
first=\'a string with embedded spaces\'
second=$first
.DE
.P
In accessing the values of variables, 
you may enclose the variable name
(or digit, in positional parameters)
in braces 
.BR {\| ... \|} 
to delimit the variable name from any following string.
In particular, 
if the character immediately following the name is a letter,
digit, or underscore,
then the braces are required.
For example, examine the following input:
.DS I
a=\'This is a string\'
echo "${a}ent test of variables."
.DE
Here, the
.B echo 
command prints:
.DS I
This is a stringent test of variables.
.DE
If no braces were used, the shell would substitute
a null value for $aent and print:
.DS I
ent test of variables.
.DE
.ne 1i	
.P
The following variables are maintained by the shell.
Some of them are set by the shell, 
and all of them can be reset by the user:
.VL 11 3
.LI HOME
Initialized by the
.B login
program to the name of the user's
.I "login directory" ,
i.e., the directory that becomes the current directory upon
completion of a login;
.B cd 
without arguments 
switches to the $HOME directory.
Using this variable helps 
keep full pathnames out of shell procedures.
This is of great benefit when pathnames are changed, 
either to balance
disk loads or to reflect administrative changes.
.LI IFS
The variable that specifies which characters are
.I "internal field separators" .
These are the characters the shell uses
during blank interpretation.
(If you want to parse some delimiter-separated data
easily, you can set IFS 
to include that delimiter.)~
The shell initially sets IFS 
to include the blank, tab, and newline characters.
.LI MAIL
The pathname of a file where your mail is deposited.
If MAIL is set, then the shell checks to see 
if anything has been added to the file
it names and announces the arrival of new mail each 
time you return to command level (e.g., by leaving the editor).
MAIL must be set by the user and exported.
(The presence of mail in the standard mail file 
is also announced at login, regardless of
whether MAIL is set.)~
.LI PATH
The variable that specifies the search path used by the shell
in finding commands.
Its value is an ordered 
list of directory pathnames separated by colons.
The shell initializes PATH to the list
.I :/\|bin:\|/\|usr\|/\|bin
where a
null argument appears in front of the first colon.
A null anywhere in the path list represents the current
directory.
On some systems, a search of the current directory
is 
.I not
the default and the PATH variable is initialized instead to
.I /\|bin:\|/\|usr\|/\|bin .
If you wish to search your current directory last,
rather than first, use:
.DS I
PATH=/bin:/usr/bin::
.DE
Here, the two colons together represent a colon followed by a null,
followed by a colon, thus naming the current directory.
You could possess a personal directory of commands
(say, 
.FN $HOME/bin ) 
and cause it to be 
searched 
.I before 
the other three directories by using:
.DS I
PATH=$HOME/bin::/bin:/usr/bin
.DE
The setting of 
.Q "PATH" 
is normally done in your
.I .profile
file.
.LI PS1
The variable that specifies what string is to be used as the
primary
.I prompt\^
string.
If the shell is interactive, it prompts 
with the value of PS1 when it expects input.
The default value of PS1 is
.Q "$  "
(a dollar sign ($) followed by a blank).
.LI PS2
The variable that specifies the secondary prompt string.
If the shell expects more input when
it encounters a newline in its input,
it prompts with the value of PS2.
The default value for this variable is 
.Q ">~"
(a greater-than
symbol `>' followed by a
blank).
.LE
.P
In general, you should be sure to 
.B export 
all of the above variables
so that they are defined for all shells.
Use 
.B export
at the end of your 
.FN .profile 
file.
An example of an 
.B export 
statement follows:
.DS I
export HOME IFS MAIL PATH PS1 PS1
.DE
.H 3 "Predefined Special Variables"
Several variables have special meanings;
the following are set \f2only\^\fP by the shell:
.VL 9 3
.LI $#
Records the number of arguments passed
to the shell,
not counting the name of the shell procedure itself.
For instance, $# 
yields the number of the highest set positional parameter.
Thus
.DS I
sh cmd a b c
.DE
sets $# to 3.
One of its primary uses is in checking
for the presence of the required number of arguments:
.DS I
if test $# \-lt 2
then
	echo \'two or more args required\'; exit
fi
.DE
.LI $?
Contains the exit status 
of the last command executed
(also referred to as 
.Q "return code" , 
.Q "exit code" ,
or 
.Q "value" ).
Its value is a decimal string.
Most \*(x1 commands return zero 
to indicate successful completion.
The shell itself returns the current value of $? as
its exit status.
.LI $$
The process number of the current process.
Because process numbers 
are unique among all existing processes, this five-digit
string
is often used to generate unique names for temporary files.
\*(x2 provides no
mechanism for the automatic creation and deletion of temporary files;
a file exists until it is explicitly removed.
Temporary files are generally undesirable
objects; the \*(x1 pipe mechanism 
is far superior for many applications.
However, the need for uniquely-named 
temporary files does occasionally occur.
.P
The following example illustrates
the recommended practice of creating temporary files in a directory
used only for that purpose:
.DS I
: 	use current process id
: 	to form unique temp file
temp=$HOME/temp/$$	
ls > $temp		
: 	commands here, some of which use $temp
rm $temp 		
: 	clean up at end
.DE
.LI $!
The process number of the last process run 
in the background (using the ampersand (&)).
Again, this is a five-digit string.
.LI $\-
A string consisting of names of execution flags 
currently turned on in the shell. 
For example, $\- might have the value 
.Q "xv"
if you are tracing your output.
.LE
.H 2 "The Shell State"
The state of a given instance of the shell
includes the values of positional parameters, user-defined
variables, environment variables, modes of execution,
and the current working directory.
.P
The state of a shell may be altered in various ways.
These include 
changing the working directory with the
.B cd 
command, 
setting several flags,
and by reading commands from 
the special file,
.FN .profile ,
in your login directory.
The
.FN .profile
file is read each time you log in to \*(x1,
It is normally used to execute special one-time-only commands
and to set and export variables to all later shells.
.H 3 "Cd"
The
.B cd
command
changes the current directory to the one specified as its argument.
This can and should be used to change to a convenient place
in the directory structure.
Note that
.B cd
is often placed within parentheses
to cause a subshell to change to
a different directory and execute some commands
without affecting the original shell.
.P
For example,
the first sequence below copies the file
.FN /usr/bin/ls
to 
.FN /usr/you/bin/ls .
The second changes directories first, and then
copies the file.
.DS I
cp /usr/bin/ls /usr/you/bin/ls
(cd /usr/bin ; cp ls /usr/you/bin/ls)
.DE
Both command lines have the same effect.
.H 3 "The .profile File"
When you log in,
the shell is invoked
to read your commands.
The shell then proceeds to see if you have a
file named
.FN .profile
in your login directory.
If so, commands are read and executed from it.
Finally, the shell is ready to read commands from your
standard input\*(EMusually the terminal.
.H 3 "Execution Flags: set"
The
.B set
command lets you alter the behavior of the shell
by setting certain shell flags.
In particular, the 
.B \-x 
and 
.B \-v 
flags may be useful when invoking the shell as a
command from the terminal.
Flags may be 
.B set 
by typing, for example:
.DS I
set \-xv
.DE
(to turn on both flags 
.B \-x 
and 
.B  \-v ). 
The same flags may be turned 
.I off\^ 
by typing:
.DS I
set +xv
.DE
.P
These two flags have the following meaning:
.VL 9 3
.LI \-v
Input lines are printed as they are read by the shell.
This flag is particularly
useful for isolating syntax errors.
The commands on each input line are executed after
that input line is printed.
.LI \-x
Commands and their arguments are printed as they are executed.
(Shell control commands,
such as
.B for ,
.B while ,
etc., are not printed, however.)~
Note that 
.B \-x 
causes a trace of 
only those commands that are actually executed, 
whereas 
.B \-v 
prints each line of
input until a syntax error is detected.
.LE
.P
The 
.B set 
command
is also used to set these and other
flags within shell procedures. 
