.bp
.H 2 "Shell Procedure Examples"
.nr Hu 4
The power of the \*(x1 shell command language
is most readily seen by examining how \*(x1's many
labor-saving utilities can be combined to perform
powerful and useful commands with very little programming effort.
This section gives examples of procedures that 
do just that.
By studying these examples, you will gain insight
into the techniques and shortcuts that can be used
in programming shell procedures (also called 
.Q "scripts" ).
Note the use of the null command (:) for introducing
comments into shell procedures.
.P
All of the following procedures could conceivably be
entered at your keyboard.
However, it is intended that each procedure be
placed in file, given execute permission with the
.B chmod
command, 
and then executed like any other \*(x1 command.
.bp
.HU "BINUNIQ"
.DS I

ls /bin /usr/bin | sort | uniq \-d
.DE
This procedure determines 
which files are in both
.FN /bin 
and 
.FN /usr/bin.
It is done because files in 
.FN /bin 
will 
.Q "override" 
those in 
.FN /usr/bin 
during most searches
and duplicates need to be weeded out.
If the 
.FN /usr/bin 
file is obsolete, then space is being wasted;
if the 
.FN /bin 
file is outdated by a corresponding entry in
.FN /usr/bin 
then the wrong version is being run and, again,
space is being wasted.
This is also a good demonstration of 
.Q "sort | uniq" 
to find matches and/or duplications.
.bp
.HU "COPYPAIRS"
.DS I

:	Usage: copypairs file1 file2 ...
:	Copies file1 to file2, file3 to file4, ...
while test "$2" != ""
do
	cp $1 $2
	shift; shift
done
if test "$1" != ""
then echo "$0: odd number of arguments"
fi
.DE
.P
This procedure illustrates the use of a 
.B while 
loop to process a
list of positional parameters that are somehow related to one another.
Here a 
.B while 
loop is much better than a 
.B for 
loop, because you
can adjust the positional parameters with the 
.B shift 
command to handle related arguments.
.bp
.HU "COPYTO"
.DS I

:	Usage: copyto dir file ...
:	Copies argument files to "dir", 
:	making sure that at least
:	two arguments exist, that "dir" is a directory, 
:	and that each additional argument 
:	is a readable file.
if test $# -lt 2 
then	echo "$0: usage: copyto directory file ..."
elif test ! -d $1 
then	echo "$0: $1 is not a directory";
else	dir=$1; shift
	for eachfile
	do	cp $eachfile $dir
	done
fi
.DE
.P
This procedure uses an 
.B if 
command with several parts 
to screen out improper usage.
The 
.B for 
loop at the end of the procedure
loops over all of the arguments to 
.B copyto 
but the first; 
the original 
.B $1 
is shifted off.
.bp
.HU "DISTINCT1"
.DS I
:	Usage: distinct1
:	Reads standard input and reports list of 
:	alphanumeric strings that differ only in case, 
:	giving lowercase form of each.
tr -cs \'A-Za-z0-9\' \'\e012\'|sort \-u | \e
tr \'A-Z\' \'a\-z\' | sort | uniq \-d
.DE
.P
This procedure is an example of the kind of process
that is created by the
left-to-right construction of a long pipeline.
Note the use of the backslash at the end of the
first line as the line continuation character.
It may not be immediately obvious how this command works.
You may wish to consult 
.IR tr (1), 
.IR sort (1), 
and
.IR uniq (1) 
if you are completely unfamiliar with these commands.
The
.B tr
command
translates all characters except letters and digits
into newline characters, and then
squeezes out
repeated newline characters.
This leaves each string (in this case,
any contiguous sequence of letters and digits)
on a separate line.
The 
.B sort 
command
sorts the lines and emits only one line from
any sequence of one or more repeated lines.
The next
.B tr
converts everything to lowercase,
so that identifiers differing only in case become identical.
The output is sorted again to bring such duplicates together.
The
.Q "uniq\ \-d"
prints (once) only those lines that occur more than once,
yielding the desired list.
.P
The process of building such a pipeline
relies on the fact that pipes and files
can usually be interchanged.
The first line is equivalent to the last two lines,
assuming that sufficient disk space is available:
.DS I
cmd1 | cmd2 | cmd3

cmd1 > temp1; < temp1 cmd2 > temp2; < temp2 cmd3
rm temp[123]
.DE
Starting with a file of test data
on the standard input
and working from left to right,
each command is executed taking its input from the previous file and
putting its output in the next file.
The final output is then examined to make sure that 
it contains the expected result.
The goal is to create a series of
transformations that will convert 
the input to the desired output.
As an exercise, try to mimic
.B distinct1
with such a step-by-step process,
using a file of test data containing:
.DS I
ABC:DEF/DEF
ABC1 ABC
Abc abc
.DE
.P
Although pipelines can give a concise notation for complex processes,
you should exercise some restraint, 
since such practice often yields incomprehensible code.
.bp
.HU "DRAFT"
.DS I

:	Usage: draft file(s)
:	Print man pages for Diablo printer.
for i in $*
	do nroff \-T450 \-man $i | lpr
	done
.DE
.P
Users often write 
this kind of procedure for convenience in
dealing with commands that require the use of many distinct
flags that cannot be given default values 
that are reasonable for all (or even most) users.
.bp
.HU "EDFIND"
.DS I

:	Usage: edfind file arg
:	Finds the last occurrence in "file" of a line 
:	whose beginning matches "arg", then prints
:	3 lines (the one before, the line itself, 
:	and the one after)
ed - $1 <<!
?^$2?
-,+p
!
.DE
.P
This illustrates the practice of using
editor 
.RB ( ed )
in-line input scripts into which the shell can substitute the
values of variables.
.bp
.HU "EDLAST"
.DS I

:	Usage: edlast file
:	Prints the last line of file, 
:	then deletes that line.
ed - $1 <<\e!
	$p
	$d
	w
	q
!
echo done
.DE
.P
This procedure illustrates 
taking input from within the file itself
up to the exclamation point (\|!\|).
Variable substitution is prohibited because of the backslash.
.bp
.HU "FILCOM"
.DS I

if (cmp -s $1 $2 = 0)
  then  
    echo Files are identical
  else
    diff $1 $2
fi
.DE
This procedure compares 
two files ($1 and $2) and if they are identical
reports the fact that the files are indeed the same.  
If they are different, it lists the differences between them.
.bp
.HU "FSPLIT"
.DS I

:	Usage: fsplit file1 file2
:	Reads standard input and divides it into 3 parts:
:	appends any line containing at least one letter
:	to file1, any line containing digits but no 
:	letters to file2, and throws the rest away.
count=0 gone=0
while read next
do
	count="\`expr $count + \1`"
	case "$next"  in
	*[A-Za-z]*)
		echo  "$next"  >> $1 ;;
	*[0-9]*)
		echo  "$next"  >> $2 ;;
	*)
		gone="\`expr $gone + 1\`"
	esac
done
echo "$count lines read, $gone thrown away"
.DE
.P
Each iteration of the loop reads
a line from the input and analyzes it.
The loop terminates
only when
.B read
encounters an end-of-file.
Note the use of the 
.B expr
command.
.P
Don't use the shell to read a line 
at a time unless you must\*(EMit can
be an extremely slow process.
.bp
.HU "GDIF"
.DS I

PATH=/bin:/usr/bin
: ${STD=}

if test "$1" = "\-h"; then
	diff="diff \-hb"
	shift
else
	diff="diff \-b"
fi
for i 
do
	if test \-f $i 
	then    if test ! \-f $STD/$i
		then    echo "New file: $i"
			if test \`tail \-41 $i | wc \-l |\e
				tr \-d \' \' \` \-lt 41 
			then cat $i
			fi
			echo ""
		elif cmp \-s $i $STD/$i; then
			:
		else 	echo "$i -- $STD/$i"
			$diff $i $STD/$i
			echo ""
		fi
	fi
done
.DE
.P
This procedure can be used to find the differences between
one set of files and another set which must be in a similar
directory hierarchy.  
The second set of filenames is 
constructed by prepending a string to each name in the first set.  
The string to be used may be exported to the procedure
in the variable STD; by default it is a slash (/).  
The procedure will also indicate 
if new files have appeared in the first set of names.  
If a new file is relatively short, it will be printed.  
If an
.B \-h 
flag is given, the 
.B diffh 
program will
be used to list the differences.
.bp
.HU "INITVARS"
.DS I

:	Usage: . initvars
:	Uses carriage returns for "no change."
echo -n 'initializations? '
read response
if test "$response" = y
then	echo -n 'HOME='; read temp
	HOME=${temp:-$HOME}
	echo -n "PATH="; read temp
	PATH=${temp:-$PATH}
	echo -n "TERM="; read temp
	TERM=${temp:-$TERM}
fi
.DE
.P
This shell procedure would be 
invoked by a user at the terminal, or
as part of a
.FN \&.profile
file.
The assignments are effective even when 
the procedure is finished, because
the 
.Q "dot"
command is used to invoke it.
To better understand the dot command, invoke 
.B initvars 
as indicated above and check the values of 
HOME, PATH, and TERM.
Then make 
.I initvars 
executable, type 
.I initvars, 
assigning different values to the three variables,
and check again the values of these three shell variables after
.I initvars
terminates.
.bp
.HU "LISTFIELDS"
.DS I

grep $* | tr ":" "\e012"
.DE
.P
This procedure lists lines containing any desired entry 
that is given to it as an argument.
It places any field that begins with a semicolon on a
newline.
Thus, if given the following input
.DS I
joe newman: 13509 NE 78th St: Redmond, Wa 98062
.DE
.I listfields 
will produce this:
.DS I
joe newman
 13509 NE 78th St
 Redmond, Wa 98062
.DE
.P
Note the use of
the 
.B tr
command to transpose colons to line feeds.
.bp
.HU "MERGE"
.DS I

:	Usage:	merge src1 src2 [ dest ]
:	Merges two files, every other line.
:	The first argument starts off the merge,
:	excess lines of the longer file are appended to
:	the end of the resultant file.
exec 4<$1 5<$2
: default dest. file below is named $1.m
dest=${3\-$1.m}	
while true 
do
		: Alternate reading from the files;
		: The variable \'more\' represents the file 
		: descriptor of the longer file.
	line <&4 >>$dest || { more=5; break ;}
	line <&5 >>$dest || { more=4; break ;}
done
		: Delete the last line of dest
		: file, because it is blank.
ed \- $dest <<!
	\e$d	
	w
	q
!
while line <&$more >> $dest
do :; done
		: Read the remainder of the longer file.
		: The body of the "while" loop
		: does nothing; the work of the loop
		: is done in the command list following
		: the "while".
.DE
.P
This command illustrates a technique 
for reading sequential lines from
a file or files without creating any subshells to do so.
When the file descriptor is used to access a file, 
the effect is that of opening the file
and moving a file pointer along 
until the end of the file is read.
If the input redirections used 
.I src1 
and 
.I src2 
explicitly
rather than the associated file descriptors, 
this procedure would never terminate,
because the first
line of each file would be read over and over again.
.bp
.HU "MKFILES"
.DS I

:	Usage: mkfiles pref [quantity]
:	Makes "quantity" files, named pref1, pref2, ...
: 	Default is 5 as determined on following line.
quantity=${2-5}		
i=1
while test "$i" \-le "$quantity" 
do
	> $1$i
	i="\`expr $i + 1\`"
done
.DE
.P
The
.I mkfiles 
procedure uses input/output redirection to create zero-length files.
The 
.B expr 
command is used for counting iterations of the
.B while
loop.
.bp
.HU "NULL"
.DS I

:	Usage: null files
:	Create each of the named files as an empty file.
for each file
do
	>$eachfile
done
.DE
.P
This procedure
uses the fact that output redirection creates 
the (empty) output file
if a file does not already exist.
.bp
.HU "PHONE"
.DS I

:	Usage: phone initials ...
:	Prints the phone numbers of the
:	people with the given initials.
echo \'inits	ext	home\'
grep "^$1" <<!
jfk	1234	999-2345
lbj	2234	583-2245
hst	3342	988-1010
jqa	4567	555-1234
!
.DE
.P
This procedure is an example of using an in-line input
script to maintain a small data base.
.bp
.HU "STATLOG"
.DS I

(systat 600 &
 while sleep 3500; do
    date
 done) >file&
.DE
.P
To run two programs simultaneously, 
and intermingle their output, you can use:
.DS I
(prog1 &
prog2) >outfile
.DE
Thus, the above 
.I statlog
procedure performs a 
.I systat 
every 10 minutes.
Every almost-hour,
the date is interjected into the file.  
In order to get 
.Q "delta"
figures, 
you don't want to rerun systat each time, but
have him sleep, thus the 600.
.bp
.HU "SUBMIT"
.DS 

: "Submit a job for later execution, redirect outputs, 
:  send mail when done"

if test $# = 2; then
	if test ! \-r $2 
	then 	echo "$0: cant find $2"
		exit 1
	fi
	if test "$1" = now
	then	i=\`date | \e
		sed -e \'s/^.*\e(..\e):\e(..\e):.*$/\e1\e2/\'\`
		i=\`expr $i + 2\`
		echo "Will start at $i."
	else	i="$1"
	fi

	usr=\`who am i | awk \'{print $1}\'\`
	at "$i" <<!
		( echo -n "Started at:  "; date
		  sh $2
		  echo -n "Finished at: ";date
		  ) 1>$2out 2>&1
		echo "\`pwd\`/$2 finished." | mail $usr
!
elif	test $# = 1; then
	$0 2100 $1
else
	echo usage: $0 [ time ] shfile
fi
.DE
.P
This procedure lets you submit a batch job 
that saves the results and notifies you that the job is done.
It does this by placing a process in the background,
writing results to a file, and then sending mail to the user.
.bp
.HU "TEXTFILE"
.DS I

if test "#$1" = #\-s 
then
:	Return condition code
	shift
	if test -z "\`$0 $*\`"; then
		exit 1
	else
		exit 0
	fi
fi

if test $# \-lt 1
then 	echo "$0: Usage: $0 [ -s ] file ..." 1>&2
	exit 0
fi

file $* | fgrep \' text\' | sed \'s/:	.*//\'

.DE
.P
To determine which files 
in a directory contain only textual information,
.I textfile 
filters argument lists to other commands.
For example, the following command line will
print all the text files in the current directory:
.DS I
pr \`textfile *\` | lpr
.DE
This procedure also uses an 
.B \-s 
flag which silently tests
whether any of the files in the argument list is a text file.
.bp
.HU "WRITEMAIL"
.DS I

:	Usage: writemail message user
:	If user is logged in, 
:	writes message to terminal;
:	otherwise, mails it to user.
echo "$1" | { write "$2" || mail "$2" ;}
.DE
.P
This procedure illustrates the use of 
command grouping.
The message specified by $1 is piped to both the 
.B write 
command and,
if 
.B write 
fails, to the 
.B mail 
command.
.bp
.H 2 "Shell Grammar"
.if t \{\
.DS
\fIitem:		word
		input-output
		name = value
.sp 1
simple-command: item
		simple-command item
.sp  1
command:	simple-command
		\fB( \fIcommand-list \fB)
		\fB{ \fIcommand-list \fB}
		\fBfor \fIname \fBdo \fIcommand-list \fBdone
		\fBfor \fIname \fBin \fIword \*(ZZ \fBdo \fIcommand-list \fBdone
		\fBwhile \fIcommand-list \fBdo \fIcommand-list \fBdone
		\fBuntil \fIcommand-list \fBdo \fIcommand-list \fBdone
		\fBcase \fIword \fBin \fIcase-part \*(ZZ \fBesac
		\fBif \fIcommand-list \fBthen \fIcommand-list \fIelse-part \fBfi
.sp 1
\fIpipeline:		command
		pipeline \fB\*(VT\fI command
.sp 1
andor:		pipeline
		andor \fB&&\fI pipeline
		andor \fB\*(VT\*(VT\fI pipeline
.sp 1
command-list:	andor
		command-list \fB;\fI
		command-list \fB&\fI
		command-list \fB;\fI andor
		command-list \fB&\fI andor
.sp 1
input-output:	\fB> \fIfile
		\fB< \fIfile
		\fB\*(AP \fIword
		\fB\*(HE \fIword
.sp 1
file:		word
		\fB&\fI digit
		\fB&\fI \(mi
.sp 1
case-part:	pattern\fB ) \fIcommand-list\fB ;;
.sp 1
\fIpattern:		word
		pattern \fB\*(VT\fI word
.sp 1
\fIelse-part:	\fBelif \fIcommand-list\fB then\fI command-list else-part\fP
		\fBelse \fIcommand-list\fI
		empty
.sp 1
empty:
.sp 1
word:		\fPa sequence of nonblank characters\fI
.sp 1
name:		\fPa sequence of letters, digits, or underscores 
\&		starting with a letter\fI
.sp 1
digit:		\fB0 1 2 3 4 5 6 7 8 9\fR
.DE\}
.if n \{\
.DS
.R
item:		word
		input-output
		name = value
.sp 1
simple-command: item
		simple-command item
.sp  1
command:	simple-command
		\fB( \fRcommand-list \fB)
		\fB{ \fRcommand-list \fB}

		\fBfor \fRname 
			\fBdo \fRcommand-list 
			\fBdone

		\fBfor \fRname \fBin \fRword
			\fBdo \fRcommand-list 
			\fBdone

		\fBwhile \fRcommand-list 
			\fBdo \fRcommand-list 
			\fBdone

		\fBuntil \fRcommand-list 
			\fBdo \fRcommand-list 
			\fBdone

		\fBcase \fRword \fBin 
			\fRcase-part 
		\fBesac

		\fBif \fRcommand-list 
		\fBthen \fRcommand-list 
		\fRelse-part 
		\fBfi
.sp 1
\fRpipeline:		command
		pipeline \fB|\fR command
.sp 1
andor:		pipeline
		andor \fB&&\fR pipeline
		andor \fB||\fR pipeline
.sp 1
command-list:	andor
		command-list \fB;\fR
		command-list \fB&\fR
		command-list \fB;\fR andor
		command-list \fB&\fR andor
.sp 1
input-output:	\fB> \fRfile
		\fB< \fRfile
		\fB<< \fRword
		\fB>> \fRword
.sp 1
file:		word
		\fB&\fR digit
		\fB&\fR \(mi
.sp 1
case-part:	pattern\fB ) \fRcommand-list\fB ;;
.sp 1
\fRpattern:		word
		pattern \fB|\fR word
.sp 1
\fRelse-part:	\fBelif \fRcommand-list
		\fBthen\fR command-list else-part\fR
		\fBelse \fRcommand-list\fR
		empty
.sp 1
empty:
.sp 1
word:		a sequence of non-blank characters
.sp 1
name:		a sequence of letters, digits, or underscores 
\&		starting with a letter
.sp 1
digit:		\fB0 1 2 3 4 5 6 7 8 9\fR
.DE
\}
.bp
.sp 1
.DS
.B "Metacharacters\ and\ Reserved\ Words"
.R
.DE
.P
.AL a
.LI 
syntactic
.VL 10
.MS
.LI \fB|\fR 
pipe symbol
.LI \fB&&\fR 
and-if symbol
.LI \fB||\fR 
or-if symbol
.LI \fB;\fR 
command separator
.LI \fB;;\fR 
case delimiter
.LI \fB&\fR 
background commands
.LI \fB(\ )\fR 
command grouping
.LI \fB<\fR 
input redirection
.LI \fB<\|<\fR 
input from a here document
.LI \fB>\fR 
output creation
.LI \fB<\fR 
output append
.sp 2
.LE 1
.LI
patterns
.VL 10
.LI \fB*\fP 
match any character(s) including none
.LI \fB?\fP 
match any single character
.LI \fB[...]\fP 
match any of enclosed characters
.sp 2
.LE 1
.LI
substitution
.VL 10
.LI \fB${...}\fP 
substitute shell variable
.LI \fB\`...\`\fP 
substitute command output
.sp 2
.LE
.LI
quoting
.VL 10
.LI \fB\e\fP 
quote next character as literal with no special meaning
.LI \fB\'...\'\fP 
quote enclosed characters excepting the back quotation marks (\')
.LI \fB"\&..."\fR 
quote enclosed characters excepting: \fB$ \` \e "\fP
.sp 2
.LE
.LI
reserved words
.DS
.B
if then else elif fi
case in esac
for while until do done
{  }
.R
.DE
.LE 1
