'\" 	@(#)Document: V2-00-
'\" 	@(#)Subject: V3.0 SW Dev - BC
'\" 	@(#)Writer: Stewart Konzen
'\" 	@(#)Work: 5 weeks
'\" 	@(#)Target: 1/1
'\" 	@(#)Notes: 
'\" 	@(#)Mods: 
.ds :? BC: A CALCULATOR
.nr H1 9
.PH "'BC: A Calculator''BC: A Calculator'"
.H 2 "Introduction"
.hy 14
BC is a program for
doing arbitrary precision arithmetic.
BC is both a language and a compiler.
The output of the compiler is interpreted and executed by
a collection of routines which can input, output, and do
arithmetic on indefinitely large integers 
and on scaled fixed-point numbers.
Although you can write substantial programs with BC,
it is also a useful interactive tool for performing
calculator-like computations.
The language has a complete control structure 
as well as immediate-mode operation.  
Functions can be defined and saved for later execution.
The execution speed of BC is quite fast.
For example, 
two 500-digit numbers can be multiplied to give a
1000-digit result in about ten seconds.
.P
A small collection of library functions is also available,
including sin, cos, arctan, log, exponential, and 
Bessel functions of integer order.
.P
Some of the uses of BC are to perform:
.BL
.LI 
Computation with large integers
.LI 
Computations accurate to many decimal places
.LI 
Conversions of numbers from one base to another base
.LE 1
.P
There is a scaling provision that permits the
use of decimal point notation.
Provision is made for input and output in bases other than decimal.  
Numbers can be converted from decimal to octal 
simply by setting the output base to equal 8.
.P
The actual limit on the number of digits that can
be handled depends on the amount of storage available on the machine.
Manipulation of numbers with many hundreds of digits
is possible even on the smallest versions of \*(x1 .
.P
The syntax of BC has been deliberately selected to agree
substantially with the C language.  
Those who
are familiar with C will find few surprises in this language.
.H 2 "Simple Computations With Integers"
The simplest kind of statement is an arithmetic expression
on a line by itself.
For instance, if you type
.DS I
142857 + 285714
.DE
the program responds immediately with the line:
.DS I
428571
.DE
The following operators 
can be used:
.DS I
\-   *   /   %   ^ 
.DE
They indicate subtraction, multiplication, division, modulo
(remaindering), and
exponentiation, respectively.  
Division of integers produces an integer result truncated toward zero.
Division by zero produces an error comment.
.P
Any term in an expression may be prefixed with a minus sign to
indicate that it is to be negated (this is the 
.Q "unary"
minus sign).
For example, the expression
.DS I
7+-3
.DE
is interpreted to mean that \-3 is to be added to 7.
.P
More complex expressions with several operators and with
parentheses are interpreted just as in
FORTRAN, with exponentiation (^)
having the greatest binding
power, then multiplication (*), division (/), and
modulo (%), and, finally,
addition (+), and subtraction (\-).
The contents of parentheses are evaluated before expressions
inside the parentheses.
All of the above operators are performed from left
to right, except exponentiation, which is performed
from right to left.
The two expressions
.DS I
a^b^c  and  a^(b^c)
.DE
are equivalent, as are the two expressions:
.DS I
a*b*c  and  (a*b)*c
.DE
BC shares with FORTRAN and C the convention that
a/b*c  is equivalent to  (a/b)*c.
Internal storage registers 
to hold numbers have single lowercase letter names.  
The value of an expression can be assigned to
a register in the usual way.  
The statement
.DS I
x = x + 3
.DE
has the effect of increasing 
by three the value of the contents of the register named 
.Q x .
When, as in this case, the outermost operator is the
assignment operator (=),
then the assignment is performed but the result is not printed.
There are twenty-six available named storage registers.
.P
There is a built-in square root function whose
result is truncated to an integer (See also 
Section 9.4, 
.Q "Scaling" ).
The lines
.DS I
x = sqrt(191)
x
.DE
produce the printed result
.DS I
13
.DE
.H 2 "Bases"
There are special internal quantities in BC, called 
.I ibase 
and 
.I obase .
.I Ibase  
is
initially set to 10,
and determines the base used for interpreting numbers that
are read by BC.
For example, the lines
.DS I
ibase = 8
11
.DE
produce the output line
.DS I
9
.DE
and you are all set up to do octal to decimal conversions.
However, beware of trying to change the input base back
to decimal by typing:
.DS I
ibase = 10
.DE
Because the number 10 is interpreted as octal, 
this statement has no effect.
For those who deal in hexadecimal notation,
the characters A\-F are permitted in numbers
(no matter what base is in effect)
and are interpreted as digits having values 10\-15, respectively.
These characters 
.I must
be uppercase and not lowercase.
The statement
.DS I
ibase = A
.DE
changes you back to decimal input base no matter what the
current input base is.
Negative and large positive input bases are
permitted, but useless.
No mechanism has been provided for the input of arbitrary
numbers in bases less than 1 and greater than 16.
.P
The value of
.I obase  
is initially set to 10 decimal. 
.I Obase 
is used as the base for output numbers.  
The lines
.DS I
obase = 16
1000
.DE
produce the output line
.DS I
3E8
.DE
which is to be interpreted as a three-digit hexadecimal number.
Very large output bases are permitted.
For example, large numbers can be output in groups of five digits
by setting 
.I obase
to 100000.
Strange  output bases, such as negative bases, and 1 and 0,
are handled correctly.
.P
Very large numbers are split across lines 
with seventy characters per line.
A split line that continues on the next line ends
with a backslash (\e).
Decimal output conversion is practically instantaneous, 
but output of very large numbers 
(i.e., more than 100 digits) 
with other bases is rather slow.
Nondecimal output conversion of
a one hundred digit number takes about
three seconds.
.P
Remember that 
.I ibase 
and 
.I obase 
do not affect the course 
of internal computation or
the evaluation of expressions; they only affect input and
output conversion.
.H 2 "Scaling"
A third special internal quantity called 
.I scale
is used to determine the scale of calculated quantities.
Numbers may have up to 99 decimal digits after the decimal point.
This fractional part is retained in further computations.
We refer to the number of digits after the decimal point of
a number as its scale.
.P
When two scaled numbers are combined by
means of one of the arithmetic operations, the result
has a scale determined by the following rules: 
.VL 16
.LI "Addition and subtraction" 
.br
The scale of the result is the larger
of the scales of the two operands.  
There is never any truncation of the result.
.LI "Multiplication"
The scale of the result is never
less than the maximum of the two scales of the operands,
never more than the sum of the scales of the operands,
and subject to those two restrictions,
the scale of the result is set equal 
to the contents of the internal quantity,
.I scale.
.LI "Division"
The scale of a quotient is the contents 
of the internal quantity,
.I scale.  
.LI "Modulo"
The scale of a remainder is
the sum of the scales of the quotient and the divisor.
.LI "Exponentiation"
The result of an exponentiation is scaled as if
the implied multiplications were performed.
An exponent must be an integer.
.LI "Square Root"
The scale of a square root is set 
to the maximum of the scale
of the argument and the contents of 
.I scale.
.LE
.P
All of the internal operations are actually carried out in terms
of integers, with digits being discarded when necessary.
In every case where digits are discarded, truncation
is performed, and not rounding.
.P
The contents of 
.I scale 
must be no greater than
99 and no less than 0.  
It is initially set to 0.
If more than 99 fraction digits are needed, 
it is possible to write a BC program that will
handle this.
.P
The internal quantities 
.I scale, 
.I ibase, 
and 
.I base
can be used in expressions just like other variables.
The line
.DS I
scale = scale + 1
.DE
increases the value of 
.I scale
by one, and the line
.DS I
scale
.DE
causes the current value of 
.I scale
to be printed.
.P
The value of 
.I scale
retains its meaning as a
number of decimal digits to be retained in internal
computation even when 
.I ibase 
or 
.I obase
are not equal to 10.
The internal computations (which are still conducted in decimal,
regardless of the bases) are performed to the specified number
of decimal digits, never hexadecimal or octal or any
other kind of digits.
.H 2 "Functions"
The name of a function is a single lowercase letter.
Function names are permitted to collide with simple
variable names.
Twenty-six different defined functions are permitted
in addition to the twenty-six variable names.
The line
.DS I
define a(x){
.DE
begins the definition of a function with one argument.
This line must be followed by one or more statements,
which make up the body of the function, ending
with a right brace (\|}\|).
Return of control from a function occurs when a return
statement is executed or when the end of the function is reached.
The return statement can take either
of the two forms:
.DS I
return
return(x)
.DE
In the first case, the value of the function is 0, and in
the second, the value of the expression in parentheses.
.P
Variables used in the function can be declared as automatic
by a statement of the form
.DS I
auto x,y,z
.DE
There can be only one 
.B auto
statement in a function and it must
be the first statement in the definition.
These automatic variables are allocated space and initialized
to zero on entry to the function and thrown away on return.  The
values of any variables with the same names outside the function
are not disturbed.
Functions may be called recursively and the automatic variables
at each call level are protected.
The parameters named in a function definition are treated in
the same way as the automatic variables of that function,
with the single exception that they are given a value
on entry to the function.
An example of a function definition follows:
.DS I
define a(x,y){
	auto z
	z = x*y
	return(z)
}
.DE
The value of this function, when called, will be the
product of its two arguments.
.P
A function is called by the appearance of its name,
followed by a string of arguments enclosed in
parentheses and separated by commas.
The result is unpredictable if the wrong number of arguments is used.
.P
Functions may require no arguments, but still
perform some useful operation or return a
useful result.
Such functions are defined and called using
parentheses with nothing between them. 
For example:
.DS I
a ()
.DE
.P
If the function, 
.Q "a" ,
is defined as shown above, then the line
.DS I
a(7,3.14)
.DE
would print the result:
.DS I
21.98
.DE
.P
Similarly, the line
.DS I
x = a(a(3,4),5)
.DE
would cause the value of 
.Q "x"
to become 60.
.H 2 "Subscripted Variables"
A single lowercase letter variable name
followed by an expression in brackets is called a subscripted
variable and indicates an array element.
The variable name is the name of the array and the expression
in brackets is called the subscript.
Only one-dimensional arrays are permitted in BC.  
The names of arrays are permitted to
collide with the names of simple variables and function names.
Any fractional
part of a subscript is discarded before use.
Subscripts must be greater than or equal to zero and 
less than or equal to 2047.
.P
Subscripted variables may be freely used in expressions, in
function calls, and in return statements.
.P
An array name may be used as an argument to a function,
as in:
.DS I
f(a[])
.DE
Array names may also be declared as automatic in
a function definition with the use of empty brackets:
.DS I
define f(a[])
auto a[]
.DE
.P
When an array name is so used, the entire contents of the array
are copied for the use of the function, then thrown away on exit
from the function.
Array names that refer to whole arrays cannot be used
in any other context.
.H 2 "Control Statements"
The
.B if ,
.B while ,
and 
.B for
statements are used to alter 
the flow within programs or to cause iteration.
The range of each of these statements is a following
statement or
compound statement consisting of a collection of
statements enclosed in braces.
They are written in the following ways:
.DS I
\fBif\fP(\|\fIrelation\|\fP) \fIstatement\fR
\fBwhile\fP(\|\fIrelation\|\fP) \fIstatement\fR
\fBfor\fP(\|\fIexpression1\|\fP; \fIrelation\|\fP; \fIexpression2\|\fP)\
\fIstatement\fR
.DE
.DS I
\fBif\fP(\|\fIrelation\|\fP) {\|\fIstatements\fR\|}
\fBwhile\fP(\|\fIrelation\|\fP) {\|\fIstatements\fR\|}
\fBfor\fP(\|\fIexpression1\|\fP; \fIrelation\|\fP; \
\fIexpression2\|\fP) {\|\fIstatements\fR\|}
.DE
.P
A relation in one of the control statements 
is an expression of the form
.DS I
\fIexpression1\fB rel-op \fIexpression2\fR
.DE
where the two expressions are 
related by one of the six relational
operators:
.DS I
<  >  <=  >=  ==  !=
.DE
.P
Note that a double equal sign (==)
stands for 
.Q "equal to"
and an exclamation-equal (!=)
stands for 
.Q "not equal to" .
The meaning of the remaining relational operators is 
their normal arithmetic and logical meaning.
.P
Beware of using a single equal sign (=)
instead of the double equal sign (==) in a relational.  
Both of these symbols are legal, 
so you will not get a diagnostic message. 
However, the operation will not perform the intended comparison.
.P
The 
.B if 
statement causes execution of its range
if and only if the relation is true.
Then control passes to the next statement in sequence.
.P
The 
.B while
statement causes execution of its range
repeatedly as long as the relation
is true.  
The relation is tested before each execution
of its range and if the relation
is false, control passes to the next statement beyond the range
of the 
.B while
statement.
.P
The 
.B for 
statement begins
by executing 
.I expression1.  
Then the relation is tested
and, if true, the statements in the range of the 
.B for 
are executed.
Then 
.I expression2 
is executed.  
The relation is tested, and so on.
The typical use of the 
.B for 
statement is for a controlled iteration,
as in the statement
.DS I
for(i=1; i<=10; i=i+1) i
.DE
which will print the integers from 1 to 10.
Here are some examples of the use of the control statements:
.DS I
define f(n){
auto i, x
x=1
for(i=1; i<=n; i=i+1) x=x*i
return(x)
}
.DE
Here, the line
.DS I
f(a)
.DE
will print 
.Q "a"
factorial if 
.Q "a"
is a positive integer.
Here is the definition of a function that
computes values of the binomial coefficient
( 
.Q "m"
and 
.Q "n"
are assumed to be positive integers):
.DS I
define b(n,m){
auto x, j
x=1
for(j=1; j<=m; j=j+1) x=x*(n-j+1)/j
return(x)
}
.DE
.ne 3i
.P
The following function computes values of the exponential function
by summing the appropriate series
without regard to possible truncation errors:
.DS I
scale = 20
define e(x){
	auto a, b, c, d, n
	a = 1
	b = 1
	c = 1
	d = 0
	n = 1
	while(1==1){
		a = a*x
		b = b*n
		c = c + a/b
		n = n + 1
		if(c==d) return(c)
		d = c
	}
}
.DE
.H 2 "Language Features"
Some language features that every user should know
about are collected below.
.P
Normally, statements are typed one to a line.  
It is also permissible
to type several statements on a line if they are
separated by semicolons.
.P
If an assignment statement is parenthesized, it then has
a value and can be used anywhere that an expression can.
For example, the line
.DS I
(x=y+17)
.DE
not only makes the indicated assignment, but also prints the
resulting value.
.P
Here is an example of a use of the value of an
assignment statement even when it is not parenthesized:
.DS I
x = a[i=i+1]
.DE
This causes a value to be assigned to 
.Q "x"
and also increments 
.Q "i"
before it is used as a subscript.
.ne 2.5i
.P
The following constructions work in BC in exactly the same manner
as they do in the C language:  
.DS I
x=y=z   is the same as  x =(y=z)
x =+ y  is the same as  x = x+y
x =- y  is the same as  x = x-y
x =* y  is the same as  x = x*y
x =/ y  is the same as  x = x/y
x =% y  is the same as  x = x%y
x =^ y  is the same as  x = x^y
x++     is the same as (x=x+1)-1
x--     is the same as (x=x-1)+1
++x     is the same as  x = x+1
--x     is the same as  x = x-1
.DE
.P
Even if you don't intend to use these constructions,
if you type one inadvertently, something legal but unexpected
may happen.
.P
\fBWARNING\fP  
.br
In some of these constructions, spaces are significant.
There is a real difference between
.Q "x=\-y"
and 
.Q "x=\0\-y" .
The first replaces 
.Q "x"
by 
.Q "x\-y"
and the second by 
.Q "\-y" .
.P
To exit a BC program, type:
.DS I
quit
.DE
Typing just a 
.Q "q"
will not do.
To exit, you may also type:
.DS I
.SM <CONTROL-D>
.DE
.P
There is a comment convention identical to that of C.
Comments begin with 
.Q "/*"
and end with 
.Q "*/" .
.P
There is a library of math functions that may be obtained by
typing
.DS I
bc -l
.DE
when you invoke BC.
This command will load the library functions
sine, cosine, arctangent, natural
logarithm, exponential, and Bessel functions of integer order.
These are named 
.I s , 
.I a , 
.I l , 
.I e ,
and 
.I j(n,x) ,
respectively.
This library sets 
.I scale 
to 20 by default.  
.P
If you type
.DS I
\fBbc \fIfile \fB...\fR
.DE
BC will read and execute the named file or files before accepting
commands from the keyboard.  
In this way, you may load your
favorite programs and function definitions.
.bp
.H 2 "The BC Language"
Below is a specification of the BC language.
.H 3 "Tokens"
Tokens consist of keywords, identifiers, constants, operators,
and separators.
Token separators may be blanks, tabs or comments.
Newline characters or semicolons separate statements.
.VL 15
.de Li
.LI "\\fB\\$1\\fR"
..
.LI "Comments"
Comments are introduced by the characters 
.Q "/*"
and terminated by 
.Q "*/" .
.LI "Identifiers"
There are three kinds of identifiers:
ordinary identifiers, 
array identifiers and function identifiers.
All three types consist of single lowercase letters.
Array identifiers are followed by square brackets, possibly
enclosing an expression describing a subscript.
Arrays are singly dimensioned and may contain up to 2048 elements.
Indexing begins at zero so an array may be indexed from 0 to 2047.
Subscripts are truncated to integers.
Function identifiers are followed by parentheses, 
possibly enclosing arguments.
The three types of identifiers do not conflict;
a program can have a variable named 
.Q "x" ,
an array named 
.Q "x" ,
and 
a function named 
.Q "x" , 
all of which are separate and distinct.
.LI "Keywords"
The following are reserved keywords:
.DS I
.B
ibase	if
obase	break
scale	define
sqrt	auto
length	return
while	quit
for
.R
.DE
.LI "Constants"
Constants consist of arbitrarily long numbers
with an optional decimal point.
The hexadecimal digits A-F are 
also recognized as digits with values 10\-15, respectively.
.LE
.H 3 "Expressions"
All expressions can be evaluated to a value.
The value of an expression is always printed unless the main
operator is an assignment.
Precedence is the same as the order
of presentation here, with highest appearing first.
Left or right associativity, where applicable, is
discussed with each operator.
There are several types of expressions:
.VL 5
.LI "Named expressions"
.br
Named expressions are
places where values are stored.
Simply stated,
named expressions are legal on the left
side of an assignment.
The value of a named expression is the value stored in the place named.
.VL 5
.LI "\fIidentifiers\fP"
.br
Simple identifiers are named expressions.
They have an initial value of zero.
.LI "\fIarray-name\|\fB[\fI\|expression\|\fB]\fR"
.br
Array elements are named expressions.
They have an initial value of zero.
.LI "scale, ibase and obase"
.br
The internal registers
.I scale , 
.I ibase ,
and 
.I obase
are all named expressions.
.I Scale
is the number of digits after the decimal point to be
retained in arithmetic operations.
.I Scale
has an initial value of zero.
.I Ibase
and 
.I obase 
are the input and output number radixes respectively.
Both 
.I ibase
and 
.I obase
have initial values of 10.
.LE
.LI "Constants"
.br
Constants are primitive expressions that evaluate to
themselves.
.LI "Parenthetic Expressions"
.br
An expression surrounded by parentheses is
a primitive expression.
The parentheses are used to alter the
normal precedence.
.LI "Function Calls"
.br
Function calls are expressions that return values.
They are discussed in the following subsection.
.LE
.H 3 "Function Calls"
A function call consists of a function name followed by parentheses
containing a comma-separated list of
expressions, which are the function arguments.
The syntax is as follows:
.DS I
.I
function-name \fR( [\fP\|expression \fR[ ,\fP expression ...\fR ] ] )
.R
.DE
.P
A whole array passed as an argument is specified by the
array name followed by empty square brackets.
All function arguments are passed by value.
As a result, changes made to the formal parameters have
no effect on the actual arguments.
If the function terminates by executing a return
statement, the value of the function is
the value of the expression 
in the parentheses of the return statement,
or is zero if no expression is provided
or if there is no return statement.
.VL 15
.LI "sqrt\|(\|expr\|)"
The result is the square root of the expression.
The result is truncated in the least significant decimal place.
The scale of the result is the scale of the expression or the
value of
.I scale
whichever is larger.
.LI "length\|(\|expr\|)"
The result is the total number 
of significant decimal digits in the expression.
The scale of the result is zero.
.LI "scale\|(\|expr\|)"
The result is the scale of the expression.
The scale of the result is zero.
.LE
.H 3 "Unary Operators"
The unary operators bind right to left.
.VL 15
.LI "\-\|expr"
The result is the negative of the expression.
.LI "++\|named_expr"
The named expression is incremented by one.
The result is the value of the named expression after incrementing.
.LI "\-\-\|named_expr"
The named expression is decremented by one.
The result is the value of the named expression after
decrementing.
.LI "named_expr\|++"
The named expression is incremented by one.
The result is the value of the named expression before incrementing.
.LI "named_expr\|\-\-"
The named expression is decremented by one.
The result is the value of the named expression before decrementing.
.LE
.H 3 "Multiplicative Operators"
The multiplicative operators (*, /, and %)
bind from left to right.
.VL 15
.LI "expr*expr"
The result is the product
of the two expressions.
If 
.Q "a"
and 
.Q "b"
are the scales of the two expressions, 
then the scale of the result is:
.DS I
min\|(\|a+b,\|max\|(\|scale,\|a,\|b\|)\|)
.DE
.LI "expr/expr"
The result is the quotient of the two expressions.
The scale of the result is the value of 
.I scale.
.LI "expr%expr"
The modulo operator (%) produces the remainder of the division
of the two expressions.
More precisely,
\fIa\fP%\fIb\fP is \fIa\fP\-\fIa\fP/\fIb\fP*\fIb\fP.
The scale of the result is the sum of the scale of
the divisor and the value of
.I scale .
.LI "expr^expr"
The exponentiation operator binds right to left.
The result is the first
expression raised to the power of the second expression.
The second expression must be an integer.
If 
.Q "a"
is the scale of the left expression and 
.Q "b"
is the absolute value of the right expression,
then the scale of the result is:
.DS I
min\|(\|a*b,\|max\|(\|scale,\|a\|)\|)
.DE
.LE 
.H 3 "Additive Operators"
The additive operators bind left to right.
.VL 15
.LI "expr+expr"
The result is the sum of the two expressions.
The scale of the result is
the maximum of the scales of the expressions.
.LI "expr\-expr"
The result is the difference of the two expressions.
The scale of the result is the
maximum of the scales of the expressions.
.LE
.H 3 "Assignment Operators"
The assignment operators listed below assign values to the left-hand
named expression.
.VL 10
.LI "named_expr=expr"
.br
This expression results in assigning the value of the expression
on the right to the named expression on the left.
.LI "named_expr=+expr"
.br
The result of this expression is equivalent
to 
.Q "named_expr=named_expr+expr" .
.LI "named_expr=\-expr"
.br
The result of this expression is equivalent
to 
.Q "named_expr=named_expr\-expr" .
.LI "named_expr=*expr"
.br
The result of this expression is equivalent
to 
.Q "named_expr=named_expr*expr" .
.LI "named_expr=/expr"
.br
The result of this expression is equivalent
to 
.Q "named_expr=named_expr/expr" .
.LI "named_expr=%expr"
.br
The result of this expression is equivalent
to 
.Q "named_expr=named_expr%expr" .
.LI "named_expr=^expr"
.br
The result of this expression is equivalent
to 
.Q "named_expr=named_expr^expr" .
.LE
.H 3 "Relations"
Unlike all other operators, the relational operators
are only valid as the object of an 
.B if ,
.B while ,
or inside a 
.B for
statement.
These operators are listed below:
.VL 10 5
.LI "expr<expr"
.LI "expr>expr"
.LI "expr<=expr"
.LI "expr>=expr"
.LI "expr==expr"
.LI "expr!=expr"
.LE
.H 3 "Storage Classes"
There are only two storage classes in BC: 
global and automatic (local).
Only identifiers that are to be local to a function need be 
declared with the 
.B auto
command.
The arguments to a function
are local to the function.
All other identifiers are assumed to be global
and available to all functions.
.P
All identifiers, global and local, have initial values
of zero.
Identifiers declared as 
.B auto
are allocated on entry to the function 
and released on returning from the function.
They, therefore, do not retain values between function calls.
.B Auto
arrays are specified 
by the array namer, followed by empty square brackets.
.P
Automatic variables in BC do not work in the same way as in C.  
On entry to a function, the old values of
the names that appear as parameters and as automatic
variables are pushed onto a stack.  
Until return is made from the function, reference to these
names refers only to the new values.
.H 3 "Statements"
Statements must be separated by a semicolon or a newline.
Except where altered by control statements, execution
is sequential.
There are four types of statements:
expression statements, compound statements, quoted
string statements, and built-in statements.
Built-in statements include 
.B auto ,
.B break ,
.B define ,
.B for ,
.B if ,
.B quit ,
.B return ,
and
.B while .
Each kind of statement is discussed below:
.VL 5 
.LI "Expression statements"
.br
When a statement is an expression, unless
the main operator is an assignment, the value
of the expression is printed, followed by a newline character.
.LI "Compound statements"
.br
Statements may be grouped together 
and used when one statement is expected
by surrounding them with curly braces (\|{ and \|}\|).
.LI "Quoted string statements"
.br
For example
.DS I
"\fIstring\fP"
.DE
prints the string inside the quotes.
.LI "Built-in Statements"
.br
The syntax for each built-in statement is given
below:
.VL 5
.Li "auto \fIidentifier\fP [, \fIidentifier\fP]\fP"
.P
The auto statement causes 
the values of the identifiers to be pushed down.
The identifiers can be ordinary identifiers or array identifiers.
Array identifiers are specified 
by following the array name by empty square brackets.
The auto statement must be the first 
statement in a function definition.
.Li "break"
.P
.B Break
causes termination of a 
.B for
or 
.B while
statement.
.Li "define ([\fIparameter\fP [ , \fIparameter\fP ...]])\
{\fIstatements\fP}"
.P
The 
.B define 
statement defines a function.
The parameters may
be ordinary identifiers or array names.
Array names must be followed by empty square brackets.
.Li "for (\fIexpression\fP; \fIrelation\fP;\
\fIexpression\fP) \fIstatement\fP"
.P
The 
.B for 
statement is the same as:
.DS I
\fIfirst-expression\fP
\fBwhile\|(\fIrelation\|\fB) {\fP
	\fIstatement\fP
	\fIlast-expression\fP
}
.DE
.P
All three expressions must be present.
.Li "if (\fIrelation\fP) \fIsubstatement\fP"
.P
The substatement is executed if the relation is true.
.Li "quit"
.br
The 
.B quit 
statement stops execution of a BC program and returns
control to \*(x1 when it is first encountered.
Because it is not treated as an executable statement,
it cannot be used
in a function definition or in an 
.B if , 
.B for ,
or
.B while
statement.
.Li "return"
.Li "return(\fIexpr\fP)"
.P
The 
.B return 
statement terminates a function,
pops its auto variables off the stack, and
specifies the result of the function.
The first form is equivalent to 
.B return(0) .
The result of the function is the result of the expression
in parentheses.
.Li "while (\fIrelation\fP) \fIstatement\fP"
.P
The statement is executed while the relation is true.
The test occurs before each execution of the statement.
.LE
.rm Li
.TC 2 1 5 0
