.nr H1 0
.aX 
.H 1 "APPENDIX A: GLOSSARY"
.PH "'Glossary''Glossary'"
This glossary lists important terms used in this manual.
Note that underlined words followed by a number in
parentheses refer to entries in the 
.I "\*(x2 Reference Manual."
.de Li
.LI "\\fB\\$1\\fR"
..
.VL 15 
.Li \&\fB.\fR 
Your current directory has the name 
.Q "dot"
(\|.\|)
as well as the name printed by the command
.B pwd.
The current directory is usually the first component 
of the search path contained in the variable path,
thus commands which are in the current directory are found first.
The period (.) at the beginning of a 
component of a pathname 
is treated specially and not matched by the 
filename expansion metacharacters (?, *, [, and ]).
An example of this is the standard file
.FN \&.profile .
.Li \&\fB..\fR
Each directory has a file named 
.Q "dot-dot"
(\|..\|) 
that is a reference to its parent directory.
After changing into any directory with
.DS I
cd dirname
.DE
you can return to the parent directory by typing
.DS I
cd ..
.DE
You can always print the current directory with the
.B pwd
command.
.Li "absolute pathname"
.br
A pathname that begins with a slash (\|/\|) is
absolute since it specifies the 
path of directories from the beginning
of the entire directory system\*(EMcalled the
root directory.  
Pathnames which are not absolute are called relative
(see the definition of
.I "relative pathname" ).
.Li argument
Commands in \*(x1 may accept a list of argument words.
Thus, the command
.DS I
echo a b c
.DE
consists of the
command name
.B echo
and three argument words 
.Q a ,
.Q b ,
and
.Q c .
The set of arguments after the command name
is said to be the argument list of the command.
.Li background
Commands started without waiting for them to complete are called
background commands.
You can execute other commands while background
commands are running.
.Li bin
A directory containing executable programs 
(sometimes called 
.Q "binaries" )
and shell scripts is called a 
.I bin 
directory.
The standard system bin directories are 
.FN /bin ,
containing the most frequently used commands and 
.FN /usr/bin ,
which contains most other user programs.
Games are kept in the directory
.FN /usr/games .
You can place programs in any directory.
If you wish to execute them often, you should
make the name of the directory
a component of the variable PATH.
.Li break
.B Break
is a built-in command used to exit from loops within the control
structure of the shell.
.Li built-in
A command executed directly by the shell is called a
built-in command.
Most commands in \*(x1 are 
.I not 
built into the shell,
but exist as files in bin directories.
These commands are accessible because the directories in which
they reside are named in the PATH variable.
.Li case
The shell built-in
.B case
command allows the shell
to select one of a number of sequences of commands based on an
argument string.
.Li cat
The
.B cat
program concatenates the contents of a list of files on the 
standard output.
It is usually used to look 
at the contents of a single file on the terminal.
.Li cd
The
.B cd
command is used to change your working directory.
With no arguments,
.B cd
changes your working directory to be your HOME directory.
.Li cmp
.B Cmp
is a program that compares files.
It is usually used to compare binary files, 
or to see if two files are identical.
For comparing text files the program
.B diff ,
described in 
.IR diff (1) 
is used.
.Li command
A command is an order to execute a given system function. 
Commands are recognized and executed by the shell.
Some commands are part of the shell itself, and
are therefore called built-ins.
Other commands are programs or shell procedures residing in a file 
within the \*(x1 system.
.Li "command name"
.br
When a command is issued, it consists of a
command name, which is the first word of the command,
followed by arguments.
The convention in \*(x1 is that the first word of a
command names the function to be performed.
.Li "command substitution"
.br
Command substitution
refers to the replacement of a command enclosed in back quotation marks
(\|\`\|) with the text output by that command.
For example, the following assigns the name of the
working directory to the shell variable HERE:
.DS I
HERE=\`pwd\`
.DE
.Li component
The parts of pathnames
separated by slash characters (\|/\|) 
are called components of that pathname.
.Li control-
Certain special characters, called control
characters, are produced by holding down the 
.SM <CONTROL>
key on your terminal and simultaneously pressing 
another character, much like
the 
.SM <SHIFT>
key is used to produce uppercase characters. 
Thus
.SM <CONTROL-C> 
is produced by holding down the 
.SM <CONTROL> 
key while pressing the 
.Q "c"
key.  
.Li cp
The
.B cp
(copy) program is used to copy the contents of 
one file into another file.
It can also be used to copy several files into a directory.
.Li date
The
.B date
command prints the current date and time.
.Li \s-2<DEL>\s0
The 
.SM <DEL>
key sends an interrupt to the current job
and is normally the same as the
.SM <INTERRUPT> 
key.
Most interactive commands return to their command level upon
receipt of an interrupt, while noninteractive commands usually
terminate, returning control to the shell.
.Li detached
A command that continues running in the background 
after you log out is said to be detached.
.Li diagnostic
An error message produced by a program is often referred to as a
diagnostic.
Most error messages are not written to the standard output,
since that is often directed away from the terminal.
Error messages are instead written 
to the diagnostic output called 
.Q "standard error" ,
which is directed to the terminal, but may be
redirected if desired.
.Li directory
A structure that contains files.
When in \*(x1,
you are always in one particular directory 
whose name can be printed by the command 
.B pwd.
The
.B cd
command will change you to another 
directory.
The directory you are in when you first log into
\*(x1 is called your 
.Q "home"
directory.
.Li du
The
.B du
command is a program (described in 
.IR du (1)) 
which prints the number of disk blocks in all directories below
and including your current working directory.
.Li echo
The
.B echo
command prints its arguments.
.Li else
The
.B else
command is part of the 
.Q "if-then-else-fi"
control command construct.
.Li \s-2EOF\s0
An
.I "end\f1-\fPof\f1-\fPfile"
is generated at the terminal with a 
.SM <CONTROL-D> ,
and whenever a command reads to the end of a file which
it has been given as input.
Commands receiving input from a
.I pipe
receive an 
.I "end\f1-\fPof\f1-\fPfile" 
when the command sending them input completes.
Most commands terminate when they receive an 
.I "end\f1-\fPof\f1-\fPfile" .
.Li escape
A backslash (\|\e\|) is used to prevent 
interpretation of the special meaning 
of a metacharacter. 
It is said to
.Q "escape"
the character from its special meaning.
Thus
.DS I
echo \e*
.DE
will echo
.DS I
*
.DE
while just
.DS I
echo *
.DE
will echo the names of the files in the current directory.
In this example, the backslash (\|\e\|)
escapes the asterisk(*).
.P
There is also a nonprinting character called 
.Q "escape"
which we refer to as
.SM <ESC> 
in this manual.
This character has no relation to the backslash escape
character discussed above.
.Li /etc/passwd
This file contains information about 
the accounts currently on the system.
It consists of a line for each account 
with fields separated by colon (:) characters.
You can look at this file by typing
.DS I
cat /etc/passwd
.DE
The commands
.B finger
and
.B grep
are often used to search for information in this file.
See 
.IR finger (1), 
.IR passwd (5), 
and 
.IR grep (1) 
for more details.
.Li exit
The
.B exit
command is used to force termination of a shell script,
and is built into the shell.
.Li "exit\ status"
A command which 
finishes executing because of some problem
can report this fact to the command
which invoked it (such as a shell).
It does this by returning a nonzero number as its
exit status, where 
a status of zero is considered normal termination.
The
.B exit
command can be used to force 
a shell command script to give a nonzero
exit status. 
.Li expansion
The replacement of strings in the shell input 
which contain metacharacters
by other strings is referred to as the process of
expansion.
Thus, the replacement of star (*) 
by a sorted list of files
in the current directory is 
.Q "filename expansion" .
Expansions are also referred to as substitutions.
.Li expressions
Expressions 
are used in the shell
to control the conditional structures used in the writing of shell
scripts and in calculating values for these scripts.
.Li filename
Each file in \*(x1 has a name consisting of up to fourteen
characters
not including the slash character (/) which is used in
pathname building.  
Most filenames do not begin with the period character, and contain 
only letters and digits with perhaps a period separating the
base portion of the filename from an extension.
Note that \*(x1 does not interpret the filename
characters in any way; base names and extensions
are conventions only.
.Li "filename expansion"
.br
Filename expansion 
uses the metacharacters (*, ?, \e, and, [ and ])
to provide a convenient mechanism for naming files.
Using filename expansion,
it is easy to name all the files in
the current directory or all files that have a common base name. 
.Li flag
See
.I switch .
.Li for
The
.B for
command is used in shell scripts and at the terminal to specify
repetition of a sequence of commands while the value of a certain
shell variable ranges through a specified list.
.Li foreground
When commands execute so that the shell command
interpreter waits for them to finish before prompting for another
command, these commands are said to be running in the 
foreground.
Foreground jobs can be stopped by signals
from the terminal caused by typing different
control characters at the keyboard.
This is in contrast to commands executing in the 
background, which the shell does not wait for 
and which cannot be killed except with the 
.B kill
command.
.Li grep
The
.B grep
command searches through a list 
of argument files for a specified string.
Thus
.DS I
grep bill /etc/passwd
.DE
will print each line in the file
.FN /etc/passwd
that contains the string 
.Q "bill" .
Actually,
.B grep
scans for patterns of text called 
.Q "regular expressions"
Thus, the word
.Q "grep"
stands for
.Q "globally find regular expression and print" .
.Li head
The
.B head
command prints the first few lines of one or more files.
If you have a number of files containing text,
only one of which you are interested in,
it is sometimes useful to run
.B head
with the names of these files as arguments.
.B Head 
will usually show enough of what is in these files 
to let you decide which one you are interested in.
.Li "home\ directory"
.br
Each user has a 
home directory,
which is given in your entry
in the password file,
.FN /etc/passwd .
This is the directory in which you are placed when you first log
in.
The
.B cd
command with no arguments takes you back to this directory. 
The name of this directory is recorded in the shell variable
.I HOME .
.Li if
The conditional command,
.B if ,
is used within shell command scripts to make decisions
about what course of action to take next.
.Li input
Many commands in \*(x1 take information 
from the terminal or from files which they then act on.
This information is called input.
Commands normally read for input from their
.I "standard input"
which is, by default, the terminal.
This standard input 
can be redirected from a file using the character (\|<\|).
Many commands will also read from a file specified as 
an argument.
Commands placed in 
pipelines will read from the output of the previous
command in the pipeline.
The leftmost command in a pipeline 
reads from the terminal if you neither redirect its 
input nor give it a filename to use as
standard input.
.Li interrupt
An interrupt
is a signal to a program that is generated by hitting the
.SM <INTERRUPT> 
key.
It causes most programs to stop execution.
Certain programs, such as the shell and the editors,
handle an interrupt 
in special ways, usually by stopping what they
are doing and prompting for another command.
While the shell is executing another command and waiting for it
to finish, the shell does not listen to interrupts.
The shell often wakes up when you press 
.SM <INTERRUPT>
because many commands die when they receive an interrupt.
.Li \s-2<INTERRUPT>\s0
The
.SM <INTERRUPT>
key causes an interrupt to be sent to the currently running 
foreground process.
This key is normally configured to one of the
following keys on a keyboard:
.SM <DEL> ,
.SM <DELETE> ,
.SM <RUBOUT> ,
or
.SM <CONTROL-C> .
.Li kill
The
.B kill
command sends 
signals to processes causing them to terminate.
.Li "login\ shell"
The shell that is started on your terminal 
when you log in is called your
.Q "login shell" .
.Li logout
A login shell will exit when you type
.SM <CONTROL-D> ,
generating an end-of-file. 
.Li lpr
The 
.B lpr
prints files on the lineprinter.
It is common to use
.B lpr
as the last component of a
pipeline.
.Li ls
The
.B ls
(list files) command 
with no argument filenames prints the names of the files in the
current directory.
It has a number of useful
switches,
and can also be given the names of directories
as arguments, in which case 
it lists the names of the files in these directories.
.Li mail
The
.B mail
program is used to send and receive messages from other \*(x1 users.
.Li manual
.Q "The manual"
is the
.I "\*(x2 Reference Manual."
It contains eight sections, the first of which
describes each available \*(x1 program.
An on-line version of the manual 
is accessible through the
.B man
command,
which comes only with the \*(x2 Text Processing Package.
.Li metacharacter
Many characters that are neither letters nor digits 
have special meaning either to the shell or to \*(x1.
These characters are called
metacharacters.
If it is necessary to place these characters 
in arguments to commands without them having their special meaning, 
then they must be quoted, or escaped.
An example of a 
metacharacter 
is the greater-than sign (>), which is used
to indicate placement of command output into a file.
.Li mkdir
The
.B mkdir
command is used to create a new directory.
.Li more
The program
.B more
displays the contents of a file on your terminal, 
allowing you to control how much text
is displayed at a time.
.B More
can move through the file screenful by screenful, line by line,
search forward for a string, 
or start again at the beginning of the file.
It is generally the easiest way to view long files.
.Li output
Many commands in \*(x1 result in 
lines of text, called "output".
This output is usually sent to what is known as the
standard output,
which is normally connected to the user's terminal.
The shell has a syntax using the less-than character
(>) for redirecting the 
standard output of a command to a file.
Using the pipe
mechanism and the pipe symbol (\||\|),
it is also possible for the standard output 
of one command to become the standard input 
of another command.
Certain commands such as 
.B lpr
do not send their results to the standard output 
but rather to more useful places such as the lineprinter.
Similarly, the
.B write
command sends its output to another user's terminal rather 
than its standard output.
Commands also have a diagnostic output
in which they write error messages.
Normally these go to the terminal even if the 
standard output has been sent 
to a file or to another command, but it is possible
to redirect error diagnostics along with 
standard output using a special metanotation.
.Li PATH
The shell has a variable, PATH,
which gives the names of the directories in which it searches for
commands to execute.
The shell always checks first to see 
if the command it is given is built into the shell.
If the command is built in, then then the shell need not search 
for the command as it can execute the command internally.
If the command is not built in, then the shell 
searches for a file with the name given 
in each of the directories in the
PATH variable, left to right.
Since the normal definition of the PATH variable is
.DS I
PATH=:/bin:/usr/bin
.DE
the shell normally looks in the current directory, and then in
the standard system directories 
.FN /bin 
and 
.FN /usr/bin 
for the named command. 
If the command cannot be found 
the shell prints an error diagnostic.
Scripts of shell commands will be executed 
using another shell to interpret
them if they have 
.Q "execute"
permission set.
This is normally true because a command of the form
.DS I
chmod +x script
.DE
was executed to turn this execute permission on.
.Li pathname
A list of names, separated by slash (/) characters, forms a pathname.
Each component, between successive slashes, names a directory
in which the next component file resides.
Pathnames beginning with a slash are interpreted relative to the
root directory in the file system.
Other pathnames 
are interpreted relative to the current directory.
The last component of a pathname 
may name either a directory or a file.
.Li pipeline
A pipeline is a group of commands that are connected 
by pipe symbols (\||\|).
The
standard output
of each command is then connected to the 
standard input of the next.
.Li port
The part of a computer system to which each terminal is
connected is called a port.
Usually the system has a fixed number of ports,
some of which may be connected to telephone lines
for dial-up access, and some of which may be  permanently
wired directly to specific terminals.
.Li pr
The
.B pr
command is used to paginate files.
At the top of each page is a header
giving the name of the file and the date and
time at which the file was last modified.
Each page also has a page number.
.Li process
A running program is called a process.
\*(x2 assigns each process a unique number from
1\-30,000 when it is 
started called the process number.
Process numbers can be used to stop individual 
processes using the 
.I kill
command.
.Li program
Usually synonymous with
command; a program is 
a binary file or shell procedure 
which performs a system function.
.Li prompt
Many programs will print a 
.I prompt 
on the terminal when they expect input.
Thus the editor
.IR vi (1)
will print a colon (:) when it expects input.
The shell 
.I prompts
for input with 
.Q "$\ "
and occasionally with 
.Q ">\ "
when reading commands from the terminal.
These prompts are defined by the shell variables named PS1 and PS2,
and can be changed by the user.
.Li ps
The
.B ps
command is used to show the processes you are currently running.
Each process is shown with its unique process number,
the terminal name it is attached to,
the state of the process (whether it is running,
awaiting some event (sleeping), 
and whether it is swapped out),
and the amount of 
.SM CPU
time it has used so far.
The command itself is identified by printing some of the words used
when it was invoked.
.Li pwd
The
.B pwd
command prints the full 
pathname of the current
working directory.
.Li quit
The
.I quit
signal, generated by a 
.SM <CONTROL-\e> ,
is used to terminate programs which are behaving unreasonably.
It normally produces a core image file that is named
.I core
in the current directory.
.Li quotation
The method of turning off the special meaning
of metacharacters either by using the back quote (\`) in pairs, 
or by using the backslash (\e) for individual
characters.
.Li redirection
The routing of input or output from or to a file is known
as redirection of input or output.
.Li "relative pathname"
.br
A pathname which does not begin with a slash (/) is called a
relative pathname,
since it is interpreted relative to the current 
working directory.
The first component of such a pathname
refers to some file or directory in the working directory,
and subsequent components between slashes (/) 
refer to directories below the
working directory.
Pathnames that are not relative are called
absolute pathnames.
.Li root
The directory that is at the top of the entire directory 
structure is called the root directory, 
since it is the 
.Q "root"
of the 
.Q "tree" 
of directories in the file system.
The name used in pathnames to indicate the root
is a single slash (\|/\|).
Pathnames starting with a slash are said to be absolute
since they start at the root directory.
.Li script
Sequences of shell commands placed in a file 
are called shell procedures or
.Q "scripts" .
You can perform many tasks using scripts 
instead of writing a program in a language such as C.
.Li set
The built-in shell command
.B set
is used to examine the setting of shell variables.
For example, typical output might look like this:
.DS I
DEF=/usr/stew/lib/def
HOME=/usr/stew
IFS= 	

MAIL=/usr/spool/mail/stewk
TERM=h19
PATH=:/bin:/usr/bin:/usr/stew/bin
SHELL=/bin/sh
.DE
.Li shell
A shell is a command language interpreter.
It is possible to write and run your own shell,
as shells are no different than any other programs 
as far as the system is concerned.
This manual deals with the details of one particular 
shell called
.B sh .
.Li "shell script"
See
.I script.
.Li signal
A signal
in \*(x1 is a short message that is sent 
to a running program to cause some action.
Signals are sent either by typing special
control characters on the keyboard or by using the
.B kill
command.
.Li sort
The
.B sort
program sorts a sequence of lines in ways that can be controlled
by switches.
.Li "special character"
.br
See
.I metacharacters.
.Li status
A command normally returns an exit status when it finishes
execution.
By convention a status
of zero indicates that the command successfully
completed execution.
Commands may return nonzero status 
to indicate that some abnormal event has occurred.
The status of the last executed command is kept in
the shell variable 
.B $? .
.Li string
A sequential group of characters taken together is called a string.
Strings can contain any printable characters.
.Li stty
The
.B stty
program changes certain parameters inside \*(x1 
which determine how your terminal is handled.  
See 
.IR stty (1) 
for a complete description.
.Li substitution
The shell implements a number of substitutions
where metacharacters are replaced by other sequences of characters.
We also often refer to 
substitutions as expansions.
.Li super-user
The only user who has permission to access 
.I all
files on the system.
You will normally log in as super-user when you need
to perform special maintenance operations,
described in the 
.I "\*(x2 Operations Guide" .
In general, however, logging in as super-user can
be very dangerous, since the super-user has the ability
to tamper with parts of the system that are
protected from all other users.
.Li switch
Many \*(x1 commands accept arguments which are not the names
of files or other users but are used to modify the action 
of the commands.
These are referred to as switches,
flags, or options.
By convention, switches
consist of one or more letters preceded by
the dash character (\-).
Thus, the
.B ls
(list files) command has an option
.B \-s 
to list the sizes of files.
This is specified
.DS I
ls \-s
.DE
.Li termination
When a command finishes executing we say it 
.Q "terminates" .
Commands normally terminate when they read an end-of-file
from their standard input.
It is also possible to terminate a command by sending it
an interrupt or quit signal.
The
.B kill
program also terminates specified jobs.
.Li then
The
.B then
command is part of the shell's
.Q "if-then-else-fi"
control construct 
used in shell procedures and scripts.
.Li tty
The word
.Q "tty"
is an abbreviation for the word 
.Q "teletype" , 
which is frequently used in \*(x1 to indicate the port
to which a given terminal is connected.  
The
.B tty
command prints the name of the tty or port
to which your terminal is presently connected.
.Li "variable expansion"
.br
See 
.I variables 
and 
.I expansion .
.Li variables
Variables have values given by a string of characters.
Variables are used to help control the behavior of the shell.
See PATH for an example.
.Li wc
The
.B wc
program calculates the number of characters, words, and lines in the
files whose names are given as arguments.
.Li while
The
.B while
built-in control construct is used in shell command scripts.
.Li word
A sequence of characters that forms an argument to a command 
is called a word.
In general, words are separated by tabs, blanks, or
newlines.
Any sequence of characters, including spaces, may be made into a 
word by surrounding it with single quotation marks (\|\'\|),
except for the quote character itself,
which requires special treatment.
This process of placing special characters in words 
without their special meaning is called quoting.
.Li "working directory"
.br
At any given time you are in one particular directory, 
called your current, or
.Q "working directory" .
This directory's name is printed by the
.B pwd
command and the files listed by
.B ls
are the ones in this directory.
You can change 
working directories using the
.B cd 
command.
.Li write
The
.B write
command is used to communicate with other logged in users.
.LE
