/*
 * c544.c
 *	iSBC 544 Specific Configuration file.
 *
 * This split out from c.c to avoid name-clashing with other device-
 * specific configuration files.
 */

#include "../h/param.h"
#include "../h/systm.h"			/* system */
#include "../h/conf.h"			/* system configuration */
#include "../h/dir.h"			/* system directory structures */
#include "../h/a.out.h"			/* needed for user */
#include "../h/user.h"			/* user structures (system) */
#include "../h/tty.h"			/* device structures (system) */
#include "../h/intr.h"			/* some pic commands from system */
#include "../h/i544.h"
	
/*
 * To configure the maximum number of 544 boards in the system, 
 * simply change NUM544.  There is a maximum of 4 and a minimum of 1.
 */

#define	NUM544	2
int	N544 = NUM544;

/*
 * This table gives the memory I/O address for each possible
 * iSBC 544 controller.  The driver procedure entry-points are 
 * configured in c.c
 */

struct	i544cfg	i544cfg[] = {
		0x0E0000,	    /* first board base addr = 0xE000:0  */
		0x0E4000,	    /* second board base addr = 0xE400:0 */
		0x0E8000,	    /* third board base addr = 0xE800:0  */
		0x0EC000	    /* forth board base addr = 0xEC00:0  */
};

struct	tty	i544tty[NUM544*4];	    /* 4 lines per 544 */
struct  firm544 i544firm[NUM544];           /* board firmware structure */
struct  i544off i544off[NUM544];	    /* firmware offset structure */
struct  ibuf    i544ibuf[NUM544*4];         /* input buffer address */
struct  obuf    i544obuf[NUM544*4];         /* output buffer address */
struct 	tout	i544tout[NUM544*4];	    /* timeout structure for each line */
char		i544cmd[NUM544];	    /* command state for each board */
char		i544scd[NUM544*4];	    /* status state for each line */
char		i544i_buf[NUM544*4];  	    /* input buffer for each line */
int		i544alive[NUM544];	    /* does it live ?? */
long            i544laddr[NUM544*4];        /* line structures address */
char		i544bufs[NUM544*4][TTYHOG]; /* output buffer for each line */
char		*iobuffer[] = {
			&i544bufs[0][0],
			&i544bufs[1][0],
			&i544bufs[2][0],
			&i544bufs[3][0],
			&i544bufs[4][0],
			&i544bufs[5][0],
			&i544bufs[6][0],
			&i544bufs[7][0],
			&i544bufs[8][0],
			&i544bufs[9][0],
			&i544bufs[10][0],
			&i544bufs[11][0],
			&i544bufs[12][0],
			&i544bufs[13][0],
			&i544bufs[14][0],
			&i544bufs[15][0] };
