|
|* mch.a86
|*
|*	iSBC/330 kernel	initialization and utilities.
|*
|* See xenix/TODO for list of things that need doing.
|*
|* Uses	awk/sed	filter to allow	use of C-style #include	files and hex-constants.
|*
|* Modified to 86/330 by Bob Beck, 12-15-81.
|* Clock start added 12-29-81.
|* Modified to have .data first, 12-30-81.
|* Modified for	trapped-maskable-interrupt handling, and cret 1-13-82.
|* Modified for	spl0() to mask 6-7 (DEBUG), 1-25-82.
|* Modified to make room for 215 WUA & move that to wua.a86, 1-26-82.
|*	Also, uses skipped page	for proc[0] u-page.
|* Modified 1-30-82 to make spl1() a NOP (see notes on clock.c)
|* Added spl2()	to replace spl1(), 2-3-82.
|* Fixed to handle "trapped-maskable-int-syscall" 2-9-82.
|* Fixed to understand "stack-probe" (see trap.c) 2-12-82.
|* Modified 2-17-82: int's on in copy*,	idle() fuss, comment out copybuf.
|* Modified 3-1-82 to comment out "clk2", and default turn clock ON.
|* Modified 3-9-82 to turn "int	#3's" into panics for bad situations.
|*
|*      Extensively modified 10/83  JGL
|*              1) middle model support
|*                 Logical pages 0 and 2 are now permenantly mapped
|*                 to physical pages 0 and 2 for all proceses, including
|*                 the kernel.  (only the kernel has write access)
|*                 This means that all code to be run under the user maps
|*                 and all data to be referenced then must fit in page 2.
|*              2) sped up fuword/suword and friends.  Much time is
|*                 spent in these routines.  They're now quite fat and
|*                 ugly, but considerably faster
|*              3) floating point emulator support.




	.insrt	"sym.inc"

NFPVEC=	10		| traps	f0 - f9	for 8087 support


|**	Opcodes	not in the assembler

ESC1 =	/D9
ESC3 =	/DB
ESC5 =	/DD
ESC7 =	/DF
WAIT =	/9B
CALLI=  /9a
JMPI=   /ea

|	Macro to fix page number into correct form for page-port.




|	The kernel data	is first, then the text.  The data is loaded at	absolute
|	(physical) 0, the code after that.  Thus, we need to skip the interrupt
|	vectors, 957 monitor data (1st 2K of physical memory), and make	room fpr
|	various	wake-up	addresses (215/220).  This is done in wub.a86.	Also,
|	see ../h/mmu.h


	.text

|***	This is	the Initial entry point	for the	XENIX Kernel

|***	start of whole show.

|*
|* The boot program has	loaded us into memory as:
|*
|*	00000:	data page
|*		    .
|*		    .
|*	nnx00:	text page
|*		    .
|*		    .
|*
|* The MMU is not on, not mapped.
|*
|* DS is not initialized, it wants to be zero.	CS is initialized to the
|* physical location of	the code.  This	will be	changed	after mapping
|* is turned on	(set to	1000 (64K)).
|*
|* It is necessary to zap the entire MMU, then set up the kernel (see mmu.h).
|* The kernel uses map[0].  The	other maps will	have their invariant parts
|* intialized.
|*
|* The kernel data needs to be at physical 0 with DS = 0, since	kernel routines
|* assumes the DS-relative offset of data is ALSO the physical address.	 The
|* best	example	is usage of the	buf[] array.


strt:
	cli				| clear	interrupts
	mov	ax, #SEGKD		| Kernels DS value (invariant when mapped)
	mov	ds, ax			| which	is just	right for DS,
	mov	es, ax			| ES, and
	mov	ss, ax			| SS.
	mov	sp, #MM_BSTACK		| temp boot stack
	mov     ax,cs
	mov     mapcs,ax                | save unmapped CS for debugging
	mov	dx, #MM_CLRST		| set to...
	inw				|	clear SR,TR
	call	_mmuinit		| Init the MMU.
	mov	bx, ax			| save 1st free	page number
	.byte   CALLI
	.word   mapon,SEGKD           | long call to turn on mapping
	.data				| in .data since DS is invariant
	.globl  mapon
mapon:					| across turn-on of map.
	movb    al, *MM_KMAP+MMP_ENA    | map[0] + enable mapping
	mov	dx, #MM_PROC		| process select register
	outw				| start	running	in map[0]
	xchg    bx, sp                  | address stack
	mov     *2(bx), #SEGKI          | fix so long-ret returns to mapped CS
	xchg    bx, sp                  | restore stack
	reti				| long return

mapoff:
	movb    al, *MM_KMAP
	mov     dx,#MM_PROC
	outw
	xchg    bx,sp
	mov     ax, mapcs
	mov     *2(bx),ax
	xchg    bx,sp
	reti
	.text                           | no more code in .data

| Am now running with data and code in proper physical and logical
| location.
|
|	logical		description
|	 00000		   data
|	 10000		   code
|
| Next zero bss	area in	data segment.

	mov	di, #_edata		| start	at end of data
	mov	cx, #_end+MMPGSZ-1	| round	count to...
	and	cx, #-MMPGSZ		|	page boundary.
	sub	cx, di			| (cx) = bytes to zero
	sub	ax, ax			| zap to zeros
	cld				| ES set above = DS.
	rep				| multiple...
	stob				|	smashem	(into es:di)

|	map proc[0] U_ page to skipped page for	WUB's

	movb	al, *MM_KMAP+MMP_ENA+SEGKDATA
	mov	dx, #MM_PROC		| stay in kernel map [0], but
	outw				| program kernel data pages
	mov     ax, bx                  | (ax) = first free memory page
	shl	ax, #1
	shl	ax, #1			| page number to command format
	shl	ax, #1
	xchgb	ah, al
	orb	al, #MM_RD+MM_WR	| want RW
	mov	dx, #PGADRUU		| set dx and...
	outw				|	remap U_ page

|	Zap U_ page

	mov	di, #_u			| (di) = u_ page logical addr
	mov	cx, #MMPGSZ/2		| cx = word count of U_	page
	sub	ax, ax			| zap to zeros
	cld				| ES set above = DS.
	rep				| multiple times...
	stow				| zero the u_ page (into es:di)

|	Setup interrupt	vectors.  DS = 0 ==> implicit access to	vectors.

	mov     ax, #SEGKD              | ax = data-segment base
	mov	si, #5*4		| (si) = addr of vector	5
	mov	cx, #251		| (cx) = count
	mov	dx, #ivecbad		| dx = offset of vector
civec:					|
	mov     (si), dx                | 0[si] = offset
	mov	*2(si),	ax		| 2[si]	= CS
	add	si, #4			| Set for next vector.
	loop	civec			| zap 'em

|	Set up "trap" vectors.
|	Remove comments	on vectors 1 & 3 when kernel in	better shape.
|	For now, the monitor keeps these.

	mov	/00*4+2, ax		| cs for vec0
	mov	/00*4+0, #iv0div	| offset for vec0
	mov	cx, /01*4+2		| save monitors	*** DEBUG
	mov	monssvec+2, cx		| single-step vector *** DEBUG
	mov	cx, /01*4+0		| save monitors	*** DEBUG
	mov	monssvec+0, cx		| single-step vector *** DEBUG
	mov	/01*4+2, ax		| cs for vec1 (single-step)
	mov	/01*4+0, #ivsstep	| offset for vec1
	mov	/02*4+2, ax		| cs for vec2
	mov	/02*4+0, #nmintr	| offset for vec2
	mov	cx, /03*4+2		| save monitors	*** DEBUG
	mov	mon3vec+2, cx		| int-3	vector *** DEBUG
	mov	cx, /03*4+0		| save monitors	*** DEBUG
	mov	mon3vec+0, cx		| int-3	vector *** DEBUG
	mov	/03*4+2, ax		| cs for vec3
	mov	/03*4+0, #int3vec	| offset for vec3
	mov	/04*4+2, ax		| cs for vec4
	mov	/04*4+0, #ivovflo	| offset for vec4

	.data				| space	for monitors vectors *** DEBUG
	.globl  monssvec
monssvec:.blkw	2			| monitor's single-step	vector *** DEBUG
mon3vec:.blkw	2			| monitor's int-3 vector *** DEBUG
	.text				|


|	Set up maskable	vectors.  These	go to ivec10-ivec17, regardless
|	of actual vectors.

	mov	cx, #8			| 8 maskable vectors.
	mov	si, #PIC_VEC_BASE*4	| si = maskable	vector offset.
	mov	di, #ivec10		| di = offset of "vector" routine.
imvec:					|
	mov     (si), di                | 0[si] = offset.  CS already set.
	add	si, #4			| si points at next vector.
	add	di, #4			| di points at next target.
	loop	imvec			| do'em	all

|	Setup the vectors for the range	/f0-/f9	to point to `ivecf0'.
|       These are used in int instructions for floating pt. emulation.

	mov	si,#/f0*4	| (si) = addr
	mov	cx,#NFPVEC	| (cx) = count
	mov	dx,#if0vec
civec1: mov     (si),dx
	add	dx, *2
	add	si, *4
	loop	civec1		| zap 'em

|	Test for the presence of an 8087.
|	We'll try to load a register with 1.0 and store	it into	memory.
|	If it really gets there, it will flag the presence of the FP H/W.
|	The code here should avoid using the wait instruction since
|	some 8086's with an 8087 will idle forever when	a wait is executed.

	.byte	ESC3,/E3		|	FINIT
	mov	cx,*10			| wait for 8 clock times
	nop
	nop
	.byte	ESC1,/E8		|	FLD1
1$:	loop	1$			| wait for 21 clock times
	.byte	ESC7,/16		|	FIST	fpp,st(0)
	.word	_Got8087
	.data
	.globl	_Got8087
_Got8087:	.word	0		| will be =1 if	we have	8087
	.text

|	Set stack to top of u_ page

	mov	sp, #U_STACK

|	Call main

	push	bx			| arg is 1st free page
	call	_main			| complete the initialization

|	When we	return here we want to pass control to a user program

	cli				| no interrupts	until start user process.
	movb	state, #PS_USER		| set (soft) user mode
	mov	bx, _u+U_PROCP		| bx = u.u_procp
	movb	al, #P_PNUM(bx)		| al = u.u_procp->p_pnum
	shlb	al, *1			|
	shlb	al, *1			| ax = map # in	proper bit position
	orb	al, #MMP_ENA		| ax now set up	to turn	on mapping in user map.
	mov	dx, #MM_PROC		| set up and...
	.byte   JMPI
	.word   mch1,SEGKD             | execute in data mapped to user

	.data
	.globl  mch1
mch1:   outw                            |       map into user process.

| no static data references until iret

	mov	ax, #SEGUD		| default user DS goes into...
	mov	ds, ax			| DS,
	mov	es, ax			|    ES, and
	mov	ss, ax			|	SS.
	mov	sp, #MMPGSZ-4		| setup	user stack
	mov	ax, #IBIT		| initial flags...
	push	ax			|	has interupts enabled
	mov	ax, #SEGUI		| set up...
	push	ax			|	default	user CS
	sub	ax, ax			| set up...
	push	ax			|	initial	ip = 0
	mov	dx, #MM_CLRST		| set up and...
	inw				|	Clear status.
	mov	dx, #MM_SCSYS		| turn on...
	outw				|	user mode (ax =	don't care).
	iret				| return to user state at loc 0

	.text




|***	Interrupt Vectors
|*
|*	NOTE that the 'call intr' sets up the vector number on the
|*	stack in the form
|*
|*		number = (addr - #_ibase) / 4
|*
|*	This means that	the vector entrys here must be in order,
|*	with no	gaps.
|*
|*	vector	usage
|*
|*	/00    /0
|*	/01    single step
|*	/02    NMI
|*	/03    single byte interrupt
|*	/04    overflow
|*
|*              these are not generated by the CPU, they are dumy vectors
|*              to flag "trap()".
|*
|*	/05    not generated by	CPU, illegal use SWIs are mapped here
|*      /06    special flag for verification of "trapmask" sequence.
|*                              (see trapmask() in mch.s)
|*		<**** first Non-trap interrupt **** >
|*
|*	/10    8259 #0	      -	8087
|*	/11    8259 #1	      -	"trap" interrupt from H/W panel
|*	/12    8259 #2	      -	clock (PIT # xx) ********CHECK
|*	/13    8259 #3
|*	/14    8259 #4
|*	/15    8259 #5
|*	/16    8259 #6
|*	/17    8259 #7
|*
|*	/f0    Floading	point traps
|*	/f1
|*	/f2
|*	/f3
|*      /f4
|*	/f5
|*	/f6
|*	/f7
|*	/f8
|*      /f9
|*
|*
|*
|*
|*
|*
|*
|* The tight loops below allow nmintr to sense the trap	by the pushed ip.
|* These will trap in user mode, since the interrupt turns OFF maskable
|* interrupts, causing the MMU to trap.
|*
|* User	execution of S/W int to	maskable vector	will cause nmi trap,
|* wich	will get default action	of fault.  User	execution of S/W int to
|* tight-loop vector will behave as if the tight-loop was actually invoked.
|*
|*			Interrupt Model
|*			========= =====
|*
|*  1.	Trap, System-call, & I/O interrupt get user mode process into system
|*	mode, running in the kernel.
|*  2.	System-call & Trap don't modify	"spl" -- it interrupted	from spl0
|*	(unless	trap from system; this is a panic anyhow).
|*  3.	spl?() sets 8259 (PIC) mask-register.  They do NOT modify the "soft"
|*	state word.
|*  4.	On entry to the	system,	the "soft" state is pushed.  The high byte
|*	of the pushed value is the old PIC mask.
|*  5.	The "soft" state word does NOT include a copy of the PIC mask.	The
|*	PIC mask is entirely maintained	in the PIC, and	in the pushed copies
|*	of the mask.
|*  6.	I/O interrupt does:  set PIC mask to mask off interrupting level and
|*	lower levels, then do EOI, then	STI.  This allows interrupts at	higher
|*	levels,	& the PIC mask is tracked by the entry/exit mechanism.	Note
|*	that this allows multiple interrupts on	the same stack.
|*  7.	Ioint (see trap.c) doesn't "switch" unless its about to	return to
|*	user mode.
|*  8.	STI is done as soon as safe & on system	stack; this turns out to
|*	just before call to _trap,_scall,_ioint.
|*  9.	Must do	EOI before (posible) switch in _ioint, since process may never
|*	return from the	switch.	 This is handled via (6) above.
|* 10.	"resume" does spl0() just before it returns.  Thus, PIC	mask fuss
|*	(really) only affects one stack.
|* 11.	Thus, interrupt	gets process from user mode -> system mode.  The mask
|*	is set to allow	only higher-level interrupts, until a switch occurs.
|*	No switch will occur if	the interrupt occured while running in system
|*	mode.  Thus, once a process is in system mode, AT MOST ONE interrupt
|*	context	per PIC	level may occur	on the system stack of that process.
|*	This implies a bounded size (8 int's + entry to	system)	for the
|*	system stack, while allowing reasonable	interrupt responsiveness.



|**	Dumy int-vectors
|
|	These SWI handlers are complicated as the user porgram cannot
|	do a normal SWI.  If he	issues one he will indeed jump here
|	(this part of the kernel is in his address space, although below
|	ds:0).	The kicker is that the SWI turns off interrupts	which
|	is illegal in user mode.  The user will	execute	only none, 1 or	2
|	instructions before the	NMI takes him away to the NMI vector, this
|	time in	system mode.
|	The NMI	handler	then "looks back" and adjusts
|	the stack so it	looked like the	SWI put	us into	kernel mode.
|	Some of	these SWI handlers are just tight loops	waiting	for the
|	NMI.  If we were to somehow take one in	system mode we'd hang.
|	Single-step and	breakpoint actually transfer to	the monitor
|	ROM.  In user mode the NMI grabs us while we're	still executing
|	the "nop"s, in kernel mode we do enter the monitor rom.	 This allows
|	adb to handle user-program breakpoints and the intel monitor rom
|	to place and intercept breakpoints in the kernel.
|
|	WARNING:  study	the NMI	analysis code before reordering	or changing
|		these routines.	 NMI analysis makes assumptions	about
|		the size and relative position of the following	code!

	.data
	.globl  ivecbad,iv0div,ivsstep,int3vec,ivovflo

|*      the 'j SNO' at the dumy vectors should never be actually
|*      executed.  If they are there is some problem, it might be
|*      found by ICE-trapping at SNO:

SNO:    j       SNO

ivecbad:j       SNO                     | all other non-maskable's

|	** VECTORS BEFORE THIS ONE DO NOT GET SPECIAL SWI PROCESSING
iv0div: j       SNO                     | zero-divide

ivsstep:nop				| single-step; *** DEBUG
	nop				| user mode traps before push *** DEBUG
	push	monssvec+2		| monitor sstep	segment	*** DEBUG
	push	monssvec+0		| monitor sstep	offset *** DEBUG
	reti				| kernel goes to monitor *** DEBUG

int3vec:nop				| single-byte interrupt	(use for debug)	*** DEBUG
	nop				| user mode traps before push *** DEBUG
	push	mon3vec+2		| monitor int-3	segment	*** DEBUG
	push	mon3vec+0		| monitor int-3	offset *** DEBUG
	reti				| kernel goes to monitor *** DEBUG

ivovflo:j	ivovflo			| overflow interrupt

|	special	floating point trap handlers

if0vec: j       SNO                     | f0
	j       SNO                     | f1
	j       SNO                     | f2
	j       SNO                     | f3
	j       SNO                     | f4
	j       SNO                     | f5
	j       SNO                     | f6
	j       SNO                     | f7
	j       SNO                     | f8
	j       SNO                     | f9

|	VECTORS	AFTER HERE TO NOT GET SPECIAL SWI PROCESSING





|	The maskable interrupts	come here.  The	call pushes a "vector indicator"
|	before going to	the common code.
|
|	The actual interrupt handler addresses are stored in _vecintsw in c.c.


ivec10:	call	intr			| 8259 # 0 comes here.
ivecnt:	.byte	0			| addrs	< ivecnt  are traps
ivec11:	call	intr			| 8259 # 1 comes here.
	.byte	0			| pad to 4-byte	boundries from ivecnt
ivec12:	call	intr			| 8259 # 2 comes here.
	.byte	0			|
ivec13:	call	intr			| 8259 # 3 comes here.
	.byte	0			|
ivec14:	call	intr			| 8259 # 4 comes here.
	.byte	0			|
ivec15:	call	intr			| 8259 # 5 comes here.
	.byte	0			|
ivec16:	call	intr			| 8259 # 6 comes here.
	.byte	0			|
ivec17:	call	intr			| 8259 # 7 comes here.


|* nmintr
|*	All traps (non I/O interrupts) come here, with
|*
|*		((sp)+4) = flags
|*		((sp)+2) = cs
|*		((sp)+0) = ip
|*
|*	Must push a "garbage" vector info, to have common stack	with maskable
|*	interrupts.  Then, save	bp,es,dx -- they're needed later.  Thus, stack
|*	will look like:
|*
|*		((sp)+12) = flags
|*		((sp)+10) = cs
|*		((sp)+8) = ip
|*		((sp)+6) = vector info (garbage	initially)
|*		((sp)+4) = bp
|*		((sp)+2) = es
|*		((sp)+0) = dx
|*
|*			<***************>
|*	NOTE that we must be very careful here,	because	often
|*	we cannot address data items because the 'ds' register
|*	is not yet setup!  Be especially careful of static references.
|*	Also must be VERY careful of stack references when switching from/to
|*	system map to/from user	map -- stack is	invalid.
|*			<***************>
|*
|* Major work is to find out what kind of NMI this is, and handle appropriately.
|* Also, in case got stack overflow on maskable-interrupt, must	dispatch this
|* properly.
|*
|* Note	that once a trap has occured (TR=1), another trap can't	occur, even if
|* bad references are made.
|*
|* Note	that "vector" info is unreliable during	a trap,	since it is pushed into
|* the (possibly overflowed) user stack.
|*
|* Can get here	due to:
|*	1. illegal ref in user mode (stack or otherwise)
|*	2. user	tried to do I/O, hlt, SW int
|*	3. got /0, overflow interrupt, single-step, single-byte	interrupt
|*	4. trap	during maskable	interrupt
|*	5. System Call
|*	6. fuibyte(etc)	nofault
|*
|* 1&2 cause segmentation fault	in the user process.
|*
|* 3 is	passed along to	_trap for further fussing.
|*
|* 4 requires the int to happen, then give a fault to the user process.	 This
|* can be sensed by the	PIC's ISR being	non-zero.
|*
|* 5 is	dispatched to _scall.
|*
|* 6 causes a "branch" to (nofault).
|*
|* Overlap in SW int between 2&3 are resolved as 3.
|*
|* Note that nofault lives in the shared low data so that its accessable
|* during NMI entry.


nmintr:					| NMI
	push	dx			| garbage vector info
	push	bp			| save 3 working registers
	push	es
	push	dx
	mov	es, ax			| ES saves old AX for now
	mov	dx, #MM_SCSYS		| set to...
	outw				|	turn ON	system mode (ax	= don't	care)

|**     yes, the dreaded self-modifying code.  THis is required by
|       an assembler bug at the moment; perhaps it should stay
|       cause its faster and not really "self modifying", its only
|       the data field that changes

	.byte   /b8                     | mov   ax,#<nofault value>
nofault:        .word   0

	and	ax, ax			| is zero?
	jnz     isnofault               | nofault processing

|       Not a nofault.  Dispatch based on <SR,TR>.
|	See mmu.h for definition of <SR,TR>.  Still in user map.

	mov     dx, #PGZERO             | read a page register...
	inw				|	to get SR,TR
	andb    al, *MM_SR+MM_TR        | only want <SR,TR>
	cmpb    al, *MM_SR+MM_TR        | Is complicated case?
	jz	nmicomplex		| Yup.
	cmpb    al, *MM_TR              | Is trap?
	jz	nmitrap			| Yup.
	movb    al, *MM_KMAP+MMP_ENA
	mov     dx, #MM_PROC
	outw                            | switch to system map
	mov     ax,#nfpanic             | panic time!
	push	ax			|
	.byte   JMPI
	.word   nmint3,SEGKI           | enter main code
	.text
nmint3:	call	_monitor		| can't panic because our segment
					| registers are all messed up!
	call	_panic			| This "can't" occur
	.data

nfpanic:.byte	/6e,/6d,/69,/6e,/74,/72,0	| "nmintr"


|	Nofault	can only occur while already running in	the kernel.
|	Don't need to do the check on maskable interrupt; it either
|	didn't start, or will get returned to.	Interrupt occured using
|	system map -- all "nofault" routines guarantee this.
|
|       (ax) = nofault address to use

isnofault:
	mov	bp, sp			| address stack
	mov	*8(bp),	ax		| set new return address
	mov	dx, #MM_CLRST		| set to...
	inw				|	Clear status.
	mov	ax, es			| restore old AX
	jmp	intr9			| exit to nofault




|	Is complex case	-- is either system call or trapped maskable
|	interrupt.  You	can tell by ISR.  Still	in user	map.
|
|	In case	where maskable-interrupt is concurrent with NMI	trap, we
|	handle by servicing the	maskable interrupt, and	then giving a fault
|	to the user process.
|
|	Note: only way to sense	trapped	maskable interrupt is via PIC_ISR.
|	ISR = 0	if this	is due to a "stray" level 7.  This can ONLY occur
|	from the clock;	that's ok, since we were want to trap the user
|	process	anyhow,	and an illegal system-call is ok.  The clock is
|	a square-wave allowing 25ms to acknowlegde the interrupt; thus a
|	"stray"	should occur rarely.
|
|	Maskable-interrupt concurrent with sys-call is detected	here as	a trap,
|	and handled by "trapmask", below.


nmicomplex:
	in	PIC_ISR			| al = ISR
	orb	al, al			| Is zero?
	jnz     totrpmsk                | handle trapped-maskable interrupt

|	To do a	system call, the user program issues an	OUTW to	MM_SCALL.
|	The MMU	turns that into	an NMI with <SR,TR> = <1,1>.  On entry here,
|	we have	come through nmintr.  This needs to change vector info to
|	indicate system-call, then behave as a trap.

	mov	bp, sp			| want to address user stack.
	mov	*6(bp),	#MM_SCALL	| special case vector in trap
	j	intr0			| continue...

totrpmsk: jmp   trapmask


| nmitrap
|	Got a real trap.  Check	saved ip with "tight loops", and set vector
|	info appropriately.  If	no match, the user did something wierd (like
|	S/W int	to a maskable int vector), give	him ivecbad.  Note that	there
|	are 2 contexts on the stack -- clean 2nd off.
|
|	Note that we do	range checks for single-step and int-3;	this allows
|	us to code real	service	routines (not just one-insructions loops)
|	for those interrupts.  If we take one in user mode we get NMI-ed
|	to here	while we're in the initial nops	of the service routine.
|	If we take one in kernel mode we'll execute the	service	routine
|	which sends one	to the debugging rom.


nmitrap:
	mov	bp, sp			| want to address user stack.
	sub	dx, dx			| dx = vector number
	mov	ax, #10(bp)		| (ax) = interrupted cs
	cmp     ax,#SEGKD
	jnz	notswi			| cannot be a SWI trap
	mov	ax, *8(bp)		| get interrupt	ip
	cmp	ax, #iv0div		| zero-divide?
	jb	notswi			| no, is not special SWI processing
	jz	isswi			| is /0	SWI
	inc	dx
	cmp	ax, #int3vec
	jb	isswi			| is single-step SWI
	inc	dx
	inc	dx
	cmp	ax, #ivovflo
	jb	isswi			| is "breakpoint" NMI
	mov	dx,*4
	jz	isswi			| is overflow NMI
	sub	ax, #if0vec
	jb	notswi			| is not FP trap, is unknown
	shr	ax,*1
	add	ax,#/f0
	xchg	ax,dx			| (dx) = fp trap # scaled to 5-14
	cmp	dx,*NFPVEC+/f0
	jb	isswi			| is FP	trap
notswi:	mov	*6(bp),	#5		| no - simulate	bad
	j	intr0			| no 2nd context in this case

|	Have a SWI which was in	turn NMI'ed.  Repair stack to look
|	like a normal SWI
|
|	(dx) = vector number (0	to 4)  for "built-in" swi's
|			     (/f0 to /f9) for the NFPVEC floating point	traps

isswi:					|
	mov	*12(bp), dx		| replace 2nd flags with vector
	mov	ax, es			| get old ax back
	pop	dx			| clean	the 2nd	<int>
	pop	es			| get reg's back,
	pop	bp			| so we	can
	add	sp, #6			| off the stack.  Vector info there already.
	push	bp			| resave
	push	es
	push	dx
	mov	es, ax			| save ax in es	again.
	j	intr0			| handle common	trap




|*	We have	a maskable interrupt.  We are already in MMU system mode.
|*	We're using the	user stack, which looks	like:
|*
|*		((sp)+6) = flags
|*		((sp)+4) = cs
|*		((sp)+2) = ip
|*		((sp)+0) = vector info
|*
|*	Will push dx,bp,es as in nmintr.  Stack	will look like:
|*
|*		((sp)+12) = flags
|*		((sp)+10) = cs
|*		((sp)+8) = ip
|*		((sp)+6) = vector info
|*		((sp)+4) = bp
|*		((sp)+2) = es
|*		((sp)+0) = dx
|*
|*	The vector info	is used	to index a table of actual interrupt vectors.

intr:
	push	bp			| save regs
	push	es
	push	dx
	mov	es, ax			| ES saves old AX for now

|	All traps/interrupts come thru here.
|	ES,BP,DX are on	users stack.
|	Old AX is in ES.
|	We're still in user map, on user stack.
|	Want to	be in kernel map.

intr0:					| traps	come here, too.
	mov     bp, sp
	mov     bp, *6(bp)              | (bp) = copy of int vector #
	movb	al, *MM_KMAP+MMP_ENA	| want kernel map, enabled
	mov     dx, #MM_PROC            | this guy gets told...
	outw				| to do	the mapping.
	mov	ax, es			| restore old AX
	mov	dx, #SEGKD		| Kernel DS
	mov	es, dx			| want to address system data
	mov	dx, bp			| restore vector info
|	BP and ES are only usable registers.
	seg	es			| es:
	testb	state, #PS_USER		| test state flag in system memory
	jnz	intr1			| am in	user mode

|	am in system mode, using system	stack.	We'll go ahead
|	and push ss and	sp so that we can use just one common return

	mov	bp, sp			| address stack, and
	push	bp			| push SP
	push	ss			| probably a good idea
	push	dx			| duplicate vector indicator address
	.byte   JMPI
	.word   intr2,SEGKI            | enter main code

|	am in user mode, we need to switch over	to the system stack.

intr1:	mov	bp, ss			| need to remember user	stack
	mov	es, bp			| and es is already volitile
	mov	bp, sp			| save user SP
	mov	sp, #SEGKD		| kernel DS
	mov	ss, sp			| set system segment
	mov	sp, #U_STACK		| get real kernel SP
	push	bp			| push user SP
	push	es			| push user SS
	push	dx			| duplicate vector indicator address
					| on the system	per-user stack
	.byte   JMPI
	.word   intr2,SEGKI            | enter main code

|	we are now safe	in our system stack.  Push all the registers
|	and call _trap

	.text
intr2:	push	ds
	push	di
	push	si
	push	cx
	push	bx
	push	ax

|	setup segment registers.

	mov	ax, ss			| SS already has kernel	DS value
	mov	ds, ax			| DS, and
	mov	es, ax			|    ES	want it	too.

|	It is now safe to address system data.
|	Push old "state" and set new state.

	in	PIC_MASK		| interrupted mask
	xchgb   ah, al                  | in high-byte of pushed state
	movb	al, state		| "soft" state in low byte
	push	ax			| save previous	state
	andb	state, #PS_SYS		| set in system	mode

|	(n+12) = previous (flags)
|	(n+10) = previous (cs)
|	(n+8) =	previous (ip)
|	(n+6) =	vector info
|	(n+4) =	previous (bp)
|	(n+2) =	previous (es)
|	(n+0) =	previous (bx)	   <======\
|		<break,	maybe>		 ||
|	((sp)+18) = previous (sp)   ------|
|	((sp)+16) = previous (ss)   ------/
|	((sp)+14) = vector info
|	((sp)+12) = previous (ds)
|	((sp)+10) = previous (di)
|	((sp)+8) = previous (si)
|	((sp)+6) = previous (cx)
|	((sp)+4) = previous (bx)
|	((sp)+2) = previous (ax)
|	((sp)) = previous 'state' contents
|
|	Determine if it	was a maskable interrupt.  Vector info is not
|	enough,	since traps come thru here.  Could have	completely seperate
|	entry for maskables, but that's	>> code.
|
|	Can't use PIC_ISR to sense interrupt, as "stray" level 7 comes in
|	with ISR = 0.  Thus, use MM_TR+MM_SR ==	MM_SR.

	mov	bp, sp			| want our stack (did enuf work	for it!)
	mov	dx, #PGZERO		| just need to look
	inw				| at one page to get <SR,TR>
	andb	al, #MM_SR+MM_TR	| just look at <SR,TR>
	cmpb	al, #MM_SR		| <SR,TR> = <1,0> ==> maskable
	jnz	intr4			| not maskable.

|	Handle I/O interrupt.  Trapped-maskable	enters at doioint.

doioint:mov	ax, #14(bp)		| vector info
	sub	ax, #ivecnt		| get offset
	shr	ax, #1			| >>1
	shr	ax, #1			| >>2 =	/ 4 ==>	ax = interrupt number
	mov	#14(bp), ax		| reset	vector info to actual vector numbver
	mov	bx, ax			|
	movb	al, intmask(bx)		| new PIC mask for this	interrupt
	out	PIC_MASK		| masks	this level and all lower levels
	mov	dx, #MM_CLRST		| clear...
	inw				|	<SR,TR>	flags.
	movb	al, #PIC_EOI		| now do EOI
	out	PIC_CMD1		| mask doesn't allow more at this level
	sti				| safe for these again.
	call	_ioint			| do an	I/O interrupt.
	j	intr8			| go and return	from interrupt
	.data
	.globl  intmask

|	Masks per interrupt-level.  Note: BOTH 6&7 mask	BOTH 6&7 (for USART)

intmask:.byte	/FF,/FE,/FC,/F8,/F0,/E0,/C0,/C0
	.text

|	Is trap; push the info he needs.  Note that trapped-maskable comes
|	to intr4b.

intr4:
	mov	ax, #14(bp)		| ax = vector info
	cmp	ax, #MM_SCALL		| vector == MM_SCALL ==> system-call
	jnz	intr4a			| else ==> real	trap
	mov	dx, #MM_CLRST		| want clear status
	inw				| before _scall
	sti				| ok to	interrupt now
doscall:call	_scall			| do the system	call
	j	intr8			| continue...
intr4a:					| is real trap
	mov	dx, #PGZERO		| reading a page register gets...
	inw				| the <SR,TR> bits.
	and	ax, #MM_SR+MM_TR	| only want <SR,TR>
	push	ax			| trap wants to	see these
	mov	dx, #MM_CLRST		| reset...
	inw				|	<SR,TR>
intr4b:	sti				| ok to	interrupt now
	call	_trap			| let C	routine	do the work
	pop	cx			| clean	violation
	or	ax, ax			| return value == 0 ==>	was trap
	jz	intr8			| was normal trap
	cmp	ax, #2			| Was a	successful stack-probe grow?
	jnz	doscall			| Nope - was trapped-syscall

|	return from trap.  Registers are as described above

intr8:	cli				| off interrupts, in case back on again
	.byte   JMPI
	.word   intr81,SEGKD           | back to shared data map for exiting

	.data
	.globl  intr81
intr81: pop     ax                      | pop "soft" state
	mov	state, ax		| restore
	xchgb	al, ah			| old PIC mask
	out	PIC_MASK		| restore
	testb	ah, #PS_USER		| staying in system mode?
	jnz     intr85                  | no - go back to user mode and map.

|	Returning to system-mode.  Just	restore	registers.

	pop	ax
	pop	bx
	pop	cx
	pop	si
	pop	di
	pop	ds
	add	sp, #6			| skip vector, ss,sp (no break!)
	j	intr9			| final	exit

|	Must restore registers and return to user map.	Have to	pop most
|	registers from kernel stack, then switch to user stack.

intr85:
	mov	bx, _u+U_PROCP		| users	process
	movb	al, #P_PNUM(bx)		| users	map number
	shlb	al, *1			| need *4 to...
	shlb	al, *1			|	get map	number in right	bits
	orb	al, #MMP_ENA		| would	like it	enabled
	mov	bp, ax			| save for now in bp
	pop	ax			| get reg's off	system stack
	pop	bx
	pop	cx
	pop	si
	pop	di
	pop	ds
	inc	sp			| skip vector info
	inc	sp

|	It is no longer	safe to	address	system data (DS	changed)
|	Must get back to users map, and	restore	users SS,SP.  Can't use
|	user stack, since that might cause a fault; must use registers.
|	Must be	VERY careful how the registers are used	-- only	bp,es are
|	volitile & bp has the users map	number.

	pop	dx			| old SS
	pop	sp			| old SP
	mov	ss, dx			| establish old	SS.  Now on user stack.
	xchg	ax, bp			| ax = map #, bp = old ax
	mov	dx, #MM_PROC		| let's	get...
	outw				|	back in	users map
	mov	dx, #MM_SCSYS		| set dx to...
	outw				|	turn ON	user mode (ax =	don't care)
	mov	ax, bp			| get it back

|	Whew!

|	Stack is clean except for pushed dx,es,bp,vector.  Am in system/user mode,
|	depending on how caller	wants to return.  Nofault comes	here too.


intr9:
	pop	dx			| interrupted guy wants...
	pop	es			|	these as...
	pop	bp			|		they were.
	inc	sp			| skip...
	inc	sp			|	vector info.
	iret				| return to previous state and mode


	.text


|	Handle trapped maskable	interupt.  See comments	above.
|
|	Must also deal with trapped-maskable-interrupt-syscall,	which occurs
|	if maskable interrupt occurs concurrent	with sys-call "outw".  MMU
|	status indicates a trap	has occured; we	will let trap()	decide.
|
|	Must handle interrupt, then give trap to user process.	Do this	via:
|	0.  Pop	2nd interrupt context off stack, so trap has more accurate data.
|	1.  Switch to kernel map & stack (as in	intr0,intr1,etc)
|	2.  Push the "violation" as if to call _trap.
|	3.  Clear MMU status
|	4.  Push flags,CS,IP for iret to  intr4b (common exit)
|	5.  Figure "vec" from ISR, push.
|	6.  GOTO doioint (simulate interrupt occurance).
|
|	Note that user stack may be invalid during this.  Thus,	can't trust it.
|
|	Thus, will handle maskable interrupt.  Iret causes call	to _trap,
|	and user process gets it where it hurts.
|
|	Much of	this code is a rip-off from intr0,etc.
|
|	Note: in case of trapped-mask-syscall, maskable-interrupt got in 1st,
|	      then NMI occurs.	NMI occurs BEFORE the maskable can do the
|	      "call intr".  Thus, need to remove 6-bytes of useless "NMI"
|	      interrupt	context, since maskable	points back to after his
|	      sys-call.	 Note: is VERY important to follow the sys-call	"outw"
|	      with at least 2 NOPs, in case they're re-executed.
|
| On entry, vec,DX,BP,ES are on	user stack, ES holds users AX.


	.data                           | is used while under user map
	.globl  trapmask
trapmask:				|
	pop	dx			| saved	DX
	pop	ax			| saved	ES
	pop	bp			| saved	BP
	add	sp, #6			| skip NMI <fl,cs,ip>.	Keep room for "vec".
	push	bp			| save BP again
	push	ax			| save ES again
	push	dx			| save DX again
	movb	al, *MM_KMAP+MMP_ENA	| want kernel map, enabled
	mov	dx, #MM_PROC		| this guy gets	told...
	outw				| to do	the mapping.
	.byte   JMPI
	.word   trapm0,SEGKI           | in kernel map, resume running text

	.text
trapm0: mov     ax, es                  | restore old AX
	mov	dx, #SEGKD		| Kernel DS
	mov	es, dx			| want to address system data

|	BP,ES,DX are only usable registers.

	seg	es			| es:
	testb	state, #PS_USER		| test state flag in system memory
	jnz	trapm1			| am in	user mode

|	am in system mode, using system	stack.	We'll go ahead
|	and push ss and	sp so that we can use just one common return

	mov	bp, sp			| address stack, and
	push	bp			| push SP
	push	ss			| probably a good idea
	push    dx
	j	trapm2			| continue...

|	am in user mode, we need to switch over	to the system stack.

trapm1:	mov	bp, ss			| need to remember user	stack
	mov	es, bp			| and es is already volitile
	mov	bp, sp			| save user SP
	mov	sp, #SEGKD		| kernel DS
	mov	ss, sp			| set system segment
	mov	sp, #U_STACK		| get real kernel SP
	push	bp			| push user SP
	push	es			| push user SS
	push    dx

|	we are now safe	in our system stack.  Push all the registers.

trapm2:	push	ds
	push	di
	push	si
	push	cx
	push	bx
	push	ax

|	setup segment registers.

	mov	ax, ss			| SS already has kernel	DS value
	mov	ds, ax			| DS, and
	mov	es, ax			|    ES	want it	too.

|	It is now safe to address system data.
|	Push old "state" and set new state.

	in	PIC_MASK		| interrupted mask
	movb	ah, al			| in high-byte of pushed state
	movb	al, state		| "soft" state in low byte
	push	ax			| save previous	state
	andb	state, #PS_SYS		| set in system	mode

|       Set "vector" to /06, push violation (ie, set up for trap()).

	mov	bp, sp			| mark stack
	mov     #14(bp), */06           | reset vector for trap.
	mov	dx, #PGZERO		| read violation
	inw				|
	and	ax, #MM_SR+MM_TR	| only want <SR,TR>
	push	ax			|
	mov	dx, #MM_CLRST		| clear...
	inw				| MMU status.

|	Push flags,CS,IP, then get ISR & figure	return address to
|	ivec1x procedures.

	pushf				| note:	I-bit off
	push	cs			|
	lea	ax, intr4b		| return here after maskable
	push	ax			|
	in	PIC_ISR			| al = ISR
	mov	bx, #ivecnt		| will hold "return" address
findisr:testb	al, *1			| found	it?
	jnz	foundisr		| yes
	add	bx, #4			| point	at next	"return"
	shrb	al, *1			| try next
	j	findisr			|

foundisr:				| found	it. bx = return	address
	push	bx			| "vector" for interrupt

|	Push "state"; intr uses	MMU status to direct maskable interrupt.
|	Note: most of "state" is ignored; was saved above for trap().

	sub	sp, #6			| "push" dx,bp,es
	mov	ax, sp			| kernel ss:sp
	push	ax			|
	push	ss			|
	push	bx			| copy of vector
	push	ds			| save kernel DS
	sub	sp, #10			| "push" di,si,cx,bx,ax.
	in	PIC_MASK		| get PIC "state"
	movb	ah, al			| in high byte
	subb	al, al			| system-mode
	push	ax			| old "state"
	mov	bp, sp			| mark stack
	jmp	doioint			| make believe interrupt occured

	.data
	.globl  state
state:	.word	0			| see intr.h for bit definitions
	.text




|***	routine	to wait	for interupt
|*
|*
	.globl	_idle, _waitloc
_idle:
	pushf				| save i flag
	cli				| Int's	OFF while fussing mask
	in	PIC_MASK		| save callers PIC-mask,
	push	ax			| and do
	movb	al, #SPL0MASK		| spl0()
	out	PIC_MASK		|
	incb	_Idlef			| set idling flag
	sti
	hlt				| wait for the interrupt
_waitloc:				| so "they" know we were idle
	cli				| int's	OFF while fussing mask
	pop	ax
	out	PIC_MASK		| restore callers PIC-mask
	movb	_Idlef,*0
	popf				| PIC Mask stable now
	ret

	.data
	.globl	_Idlef			| non-zero when	idling
_Idlef:	.word	0			| declared 'short' in c	code
	.even
	.text



|***					***
|***	routines to switch context	***
|***					***

	.globl	_save, _resume

|	save(u.u_?sav)	- save registers in u structure

_save:
	mov	ax, ds			|
	mov	es, ax			| es = ds
	pop	ax			| (ax) = return	address
	mov	bx, sp			|
	mov	dx, di			| (dx) = saved di
	mov     di, (bx)                | (es:di) = target address
	cld				|
	stow				| store	return address
	mov	bx, ax			| (bx) = retadr
	mov	ax, sp			|
	stow				| store	stack
	mov	ax, bp			|
	stow				| store	bp
	mov	ax, si			|
	stow				| store	si
	xchg	ax, dx			|
	stow				| store	di
	xchg	ax, di			|
	sub	ax, ax			| indicate old process
	jmp	@bx			|


|	resume(proc.p_addr, u.u_qsav) -	resume a process
|
|	NOTE: This routine does	an spl0() upon return

_resume:
	movb	al, *MM_KMAP+MMP_ENA+SEGKDATA
	mov	dx, #MM_PROC		| set to program kernel	data bank
	outw				|
	pop	bx			| discard return address
	pop	ax			| (ax) = new proc address
	pop	si			| (ds:si) = regsav logical address
	shl	ax, #1
	shl	ax, #1			| page number to command format
	shl	ax, #1
	xchgb	ah, al
	orb	al, #MM_RD+MM_WR	| read/write permission
	mov	dx, #PGADRUU		| dx ->	U_ page	register
	cli				| NO INTERRUPTS	WHILE STACK INVALID
	outw				| remap	U_ page
	cld				|
	lodw				|
	xchg    bx, ax                  | (bx) = new return address
	lodw				|
	xchg    sp, ax                  | restore stack pointer
	lodw				|
	xchg    bp, ax                  | restore bp
	lodw				|
	xchg    dx, ax                  | restore si into dx
	lodw				|
	xchg    di, ax                  | restore di
	mov	si, dx			| restore si
	movb	al, #SPL0MASK		| want spl0()
	out	PIC_MASK		| all levels enabled
	sti				| set interrupts; stack	is valid again
	inc	ax			| indicate transfer
	jmp	@bx			| return

	.data				|
respanic:.byte	/72,/65,/73,/75,/6d,/65,0	| "resume"
	.text				|



|***					***
|***	spl?(),	splx(p)			***
|***					***
|*
|*	spl0()	Enables	all levels (Everything ON)
|*	spl5()	Disables PIC 3-7 (All but Clock	OFF)
|*	spl6()	Disables PIC 2-7 (Clock	& below	OFF)
|*	spl7()	Disables PIC 0-7 (Everything OFF)
|*
|* Spl?() return old priority; splx(pri) restores saved	level.
|*
|*
|* Note: interrupts must be off	to put new value in PIC_MASK, in case more
|*	 levels	are being masked (have race with PIC if	ints on).


|***	tasktime() - Put system	in task	state.
|*
|*	tasktime(i) puts the system in 'task' mode.  Any pending interrupts
|*	are dismissed, further interrupts are allowed.
|*
|*	i = 0	- initial enabling of interrupts during	bootup
|*	i = 1	- going	task-time during lightning bolt
|*	i = 2	- going	task-time during system	call processing
|*
|*	Note that we may already be setup tasktime when	tasktime() is
|*	called.	 For example, clock() may call twice...


       .globl	_spl0,_spl2,_spl5,_spl6,_spl7,_splx
	.globl	_tasktime

_tasktime:				| same as spl0 for here
_spl0:					| Everything ON
	movb	ah, #SPL0MASK		| PIC mask for all enabled
	j	spl			| finish.
_spl2:					| Disable 6-7
	movb	ah, #/C0		| PIC mask for 6-7 disabled
	j	spl			| finish
_spl5:					| Disable 3-7
	movb	ah, #/F8		| PIC mask for 3-7 disabled
	j	spl			| finish.
_spl6:					| Disable 2-7
	movb	ah, #/FC		| PIC mask for 2-7 disabled
	j	spl			| finish.
_spl7:					| ALL OFF!
	movb	ah, #/FF		| Disable 0-7
spl:					| Common finish.
	cli				| zap ints while doing this
	in	PIC_MASK		| get old value
	xchgb	ah, al			| swap old/new mask
	out	PIC_MASK		| output new mask
	sti				| turn ON
	ret				| ah = old mask, al = new mask
_splx:					| Restore old "state"
	mov	bx, sp			| frame	pointer
	movb	al, *3(bx)		| al = old mask
	out	PIC_MASK		| set in PIC
	ret				|







|***	_CLKSTART - Start/Restart System Clock
|
|	_clkstart is called to start or	restart	the system clock,
|	which is an intel 8253 counter timer chip.  Only the timer 0
|	is used.
|
|	The 8253 is setup to count in square wave mode.	 The 8259
|	interrupt controller is	setup edge-triggered, so it dosent
|	hurt to	have an	interrupt requested 50%	of the time.  Since
|	the counter is in square-wave mode, we don't have to reprogram
|	the count, and we don't	have to	worry about response latency,
|	so long	as we dont miss	a whole	tick.
|
|	This means that	we only	need to	be called once.
|	The OS likes to	call us	once per tick, so we'll	use a
|	static flag to see to it that we only initialize once.


	.data
clkflg:	.word	1			| ==0 if not to	initialize

	.text
	.globl	_clkstart
_clkstart:
	mov	cx, clkflg		| See what to do.
	jcxz	clk1			| already initialized
	dec	clkflg			|
	pushf				| save interrupt flag
	cli				| no interrupts	while programming
	movb	al, *PIT_S0+PIT_READ_LOAD+PIT_SQWAVE_MODE
	out	PIT_CTRL_PORT		| control byte
	movb	al, _clknumb+0		| least	significant byte
	out	PIT_CTR0_PORT		| goes out first
	movb	al, _clknumb+1		| most significant byte
	out	PIT_CTR0_PORT		| goes out next
	popf				| restore interrupt flag
clk1:	ret				| exit



|*	Fetch/Store from/to various places routines.
|*
|*	This is	done by	getting	a copy of the page-registers from the
|*	user map, installing them in the system	space, and doing the
|*	fetch/store.  For word fetch/store, two	page-registers are copied
|*	in case	the fetch goes across a	page-boundary (note that 8086 byte
|*	fetches	are actually a word fetch on an	even boundary).

	.globl	_fubyte,_fuibyte,_subyte,_suibyte
	.globl	_fuword,_fuiword,_suword,_suiword
	.globl  _fulbyte,_fulword,_sulword
	.globl  _fupolute


|**     fupolute - polute [fs]uword, [fs]ubyte
|*
|*      In order to hold down their cost these routines
|*      remember the previous request and don't reprogram the MMU registers
|*      if its not necessary.  The vast majority of calls to these
|*      routines are referencing cells close to those that were referenced
|*      just beforehand.
|*
|*      It is important that the "last peek page" be reset when we switch
|*      context or otherwise manipulate the MMU registers.  This is
|*      done in mch.s in a few spots, mmu.c does it by calling "fupolute".

_fupolute:
	mov     fumap,*1
	mov     sumap,*1                | polute stats
	ret


|***	FUIBYTE	- Fetch	User I-space Byte
|*	FUBYTE	- Fetch	User D-space Byte
|*
|*		fuibyte(addr)
|*		fubyte (addr)
|*
|*	returns	byte value if ok, -1 if	mmu violation

ENA     =       MMP_ENA*256

_fulbyte:
|       inc     Fulbyte
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     dx,*2(bx)
	xchgb   dh,dl                   | (dx) = H.O. bits *256
	add     dx, #MMPGSZ/256*MMSEG_T+ENA
	mov     cx,*4(bx)               | (cx) = user address
	mov     bx,cx
	and     cx, #MMPGSZ-1           | (cx) = offset in page
	xor     bx,cx                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add     bx,#PGZERO              | (bx) = port address
	pushf				| save interrupt state
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get1um,SEGKD            | fetch 1 user map register
	mov     dx, #PGADRSF            | program 'from' page to do fetch
	xchg    ax, bx                  | user page
	outw				| set up
	mov     ax, #SEGSF              | 'from' segment register
	mov	es, ax			| set up to address
	mov	bx, cx			| address (offset += 2,	due to flags)
	mov	nofault, #uferr		| in case MMU violation
	seg	es			|
	movb    al, (bx)                | do the fetch
	subb	ah, ah			|
	jmp     uxit                    | break fetchahead

_fuibyte:
|       inc     Fuibyte
	mov     dx, #MMPGSZ/256*MMSEG_T+ENA
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     cx,*2(bx)               | (cx) = user address
	mov     bx,cx
	and     cx, #MMPGSZ-1           | (cx) = offset in page
	xor     bx,cx                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add     bx,#PGZERO              | (bx) = port address
	pushf				| save interrupt state
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get1um,SEGKD            | fetch 1 user map register
	mov     dx, #PGADRSF            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page
	outw				| set up
	mov     ax, #SEGSF              | 'from' segment register
	mov	es, ax			| set up to address
	mov	bx, cx			| address (offset += 2,	due to flags)
	mov	nofault, #uferr		| in case MMU violation
	seg     es
	movb    al, (bx)                | do the fetch
	subb	ah, ah			|
	j	uxit			| break	fetchahead

_fubyte:
	mov     bx,sp
	pushf                           | save interrupt state
	cli                             | routine used by intservice
	mov     ax,*2(bx)
	and     ax,#-MMPGSZ
	cmp     ax,fumap
	jnz     fub0

|*      we have a "hit"; its already mapped and known valid

|       inc     FHbyte
	xor     ax,*2(bx)               | (ax) = offset
	xchg    ax,bx
	mov     ax,#SEGFU
	mov     es,ax
	seg     es
	movb    al,(bx)
	popf
	subb    ah,ah
	mov     bx,ds
	mov     es,bx                   | restore es
	ret

fub0:   mov     fumap,ax                | we'll map this one, if all goes well
|       inc     Fubyte
	mov     dx, #MMPGSZ/256*MMSEG_D+ENA
	push    si                      | save caller's (si)
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     si,*6(bx)               | (si) = user address
	mov     bx,si
	and     si, #MMPGSZ-1           | (si) = offset in page
	xor     bx,si                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add     bx,#PGZERO              | (bx) = port address
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRFU            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page
	outw				| set up
	mov     bx,si                   | (bx) = value offset
	pop     si                      | restore caller's si
	mov     ax, #SEGFU              | 'from' segment register
	mov	es, ax			| set up to address
	mov	nofault, #uferr		| in case MMU violation
	seg     es
	movb    al, (bx)                | do the fetch
	subb	ah, ah			|
	j	uxit			| break	fetchahead

|	the various routines share this	code
|
|	((sp)) = saved flags

uxit:
	mov	nofault, #0		| not "nofault"	any more
	popf				| restore interrupt state
	mov	bx, ds			| set up es...
	mov	es, bx			|	just to	be safe
	ret


|***	FUIWORD	- Fetch	User I-space Word
|***	FUWORD	- Fetch	User D-space Word
|***    FULWORD - Fetch User I-space Word, large address space
|*
|*		fuiword(addr)
|*		fuword (addr)
|*              fulword(hiaddr, loaddr)
|*
|*	returns	word value if ok, -1 if	mmu violation
|*
|*      Fulword models the user ispace as a contiguous segment of maxsize
|*      one meg.  "Hiaddr" contains the 4 high-order bits of the addr)
|*
|*	NOTE that -1 is	a valid	word value, thus the error condition
|*	is of doubtful use.

_fulword:
|       inc     Fulword
	pushf                           | save interrupt state
	cli
	push    si                      | save caller's (si)
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     dx,*6(bx)
	xchgb   dh,dl                   | (dx) = H.O. bits *256
	add     dx, #MMPGSZ/256*MMSEG_T+ENA
	mov     si,*8(bx)               | (si) = user address
	mov     bx,si
	and     si, #MMPGSZ-1           | (cx) = offset in page
	xor     bx,si                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add	bx, #PGZERO		| just happens to be port addr
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRSF            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page
	outw				| set up
	mov     bx,si                   | (bx) = value offset
	pop     si                      | restore caller's si
	mov     ax, #SEGSF              | 'from' segment register
	mov	es, ax			| set up to address
	mov	nofault, #uferr		| in case MMU violation
	seg	es			| fetch	from this segment
	mov     ax, (bx)                | do the fetch
	jmp     uxit                    | we all share an exit

_fuiword:
|       inc     Fuiword
	mov     dx, #MMPGSZ/256*MMSEG_T+ENA
	pushf                           | save interrupt state
	push    si                      | save caller's (si)
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     si,*6(bx)               | (si) = user address
	mov     bx,si
	and     si, #MMPGSZ-1           | (si) = offset in page
	xor     bx,si                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add     bx,#PGZERO              | (bx) = port address
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRSF            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page
	outw				| set up
	mov     bx,si                   | (bx) = value offset
	pop     si                      | restore caller's si
	mov     ax, #SEGSF              | 'from' segment register
	mov	es, ax			| set up to address
	mov	nofault, #uferr		| in case MMU violation
	seg     es
	mov     ax, (bx)                | do the fetch
	jmp     uxit                    | we all share an exit

_fuword:
	mov     bx,sp
	mov     ax,*2(bx)
	and     ax,#-MMPGSZ
	pushf                           | save interrupt state
	cli                             | routine used by intservice routines!
	cmp     ax,fumap
	jnz     fuw4

|*      we have a "hit"; its already mapped and known valid

|       inc     FHwrdc
	xor     ax,*2(bx)               | (ax) = offset
	xchg    ax,bx
	mov     ax,#SEGFU
	mov     es,ax
	cmp     bx,#MMPGSZ-1
	jz      fuw1                    | must set nofault
	seg     es
	mov     ax,(bx)
	popf
	mov     bx,ds
	mov     es,bx                   | restore es
	ret

|       am referencing last byte of page and 1st byte of next page.
|       must set nofault cause only 1st page is guaranteed "good"

fuw1:   mov     nofault, #fuw2          | in case MMU violation
	seg     es
	mov     ax,(bx)
	j       fuw3

fuw2:   mov     ax,*-1                  | NOFAULT COMES HERE
	mov     fumap,*1
fuw3:   mov     nofault, *0
	popf
	mov     bx,ds
	mov     es,bx                   | restore es
	ret

|       Cant use the current mapped area, must remap it

fuw4:   mov     fumap,ax                | we'll map this one, if all goes well
|       inc     Fuwrdc
	mov     dx, #MMPGSZ/256*MMSEG_D+ENA
	push    si                      | save caller's (si)
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     si,*6(bx)               | (si) = user address
	mov     bx,si
	and     si, #MMPGSZ-1           | (si) = offset in page
	xor     bx,si                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add     bx,#PGZERO              | (bx) = port address
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRFU            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page
	outw				| set up
	mov     bx,si                   | (bx) = value offset
	pop     si                      | restore caller's si
	mov     ax, #SEGFU              | 'from' segment register
	mov	es, ax			| set up to address
	mov	nofault, #uferr		| in case MMU violation
	seg     es
	mov     ax, (bx)                | do the fetch
	jmp     uxit                    | we all share an exit

|	UFERR -	handle nofault trap
|
|	If the mmu flags a violation when we fetch the user's
|	area, we are transfered	here, as if a 'jmp' occoured at	the
|	point of the violation.	 We do the exit	for the	routine
|	which had the problem, _fuibyte, _fubyte, _fuword, _fuiword.

uferr:	mov	ax, #-1			| return bad reference indication
	mov     fumap,*1                | dont skip nofault on next fetch
	jmp     uxit                    | just exit



|***	SUIBYTE	- Store	User I-space Byte (assumes target writeable)
|***	SUBYTE	- Store	User D-space Byte (assumes target writeable)
|
|		suibyte(addr, value)
|		subyte (addr, value)

_suibyte:
|       inc     Suibyte
	mov     dx, #MMPGSZ/256*MMSEG_T+ENA
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     cx,*2(bx)               | (cx) = user address
	mov     bx,cx
	and     cx, #MMPGSZ-1           | (cx) = offset in page
	xor     bx,cx                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add     bx,#PGZERO              | (bx) = port address
	pushf				| save interrupt state
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get1um,SEGKD            | fetch 1 user map register
	mov     dx, #PGADRSF            | program 'from' page to do fetch
	xchg    ax, bx                  | user page (not writeable ==> fault)
	outw				| set up
	mov     ax, #SEGSF              | 'from' segment register
	mov	es, ax			| set up to address
	mov	bx, sp			| stack	"pointer"
	mov	ax, *6(bx)		| (al) = value (6 due to flags)
	mov	bx, cx			| address (offset += 2,	due to flags)
	mov     nofault, #userr         | in case MMU violation
	seg	es			|
	movb    (bx), al                | do the store
	sub     ax, ax                  | return 0 for success
	jmp	uxit			| we all share an exit


_subyte:
	mov     bx,sp
	mov     ax,*2(bx)
	and     ax,#-MMPGSZ
	pushf                           | save interrupt state
	cli                             | routine used at interrupt time
	cmp     ax,sumap
	jnz     sub4

|*      we have a "hit"; its already mapped and valid
|*      Note that all data pages are writable, so we needent nofault

|       inc     SHbyte
	xor     ax,*2(bx)               | (ax) = offset
	movb    cl,*4(bx)               | (cl) = value
	xchg    ax,bx
	mov     ax,#SEGSU
	mov     es,ax
	seg     es
	movb    (bx),cl
	popf
	sub     ax,ax                   | return OK code
	mov     bx,ds
	mov     es,bx                   | restore es
	ret

sub4:   mov     sumap,ax                | we'll map this one, if all goes well
|       inc     Subyte
	mov     dx, #MMPGSZ/256*MMSEG_D+ENA
	push    si                      | save caller's (si)
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     si,*6(bx)               | (si) = user address
	mov     bx,si
	and     si, #MMPGSZ-1           | (si) = offset in page
	xor     bx,si                   | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add     bx,#PGZERO              | (bx) = port address
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRSU            | program 'to' pages to do store
	xchg    ax, bx                  | 1st user page
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page
	outw				| set up
	mov     ax, #SEGSU              | 'from' segment register
	mov	es, ax			| set up to address
	mov	bx, sp			| stack	"pointer"
	movb    al, *8(bx)              | (al) = value
	mov     bx,si                   | (bx) = value offset
	pop     si                      | restore caller's si
	mov     nofault, #userr         | in case MMU violation
	seg	es			|
	movb    (bx), al                | do the store
	sub     ax, ax                  | return 0 for success
	jmp	uxit			| we all share an exit



|***	SUIWORD	- Store	User I-space Word (assumes target writeable)
|***	SUWORD	- Store	User D-space Word (assumes target writeable)
|***    SULWORD - Store User I-space Word, large address space
|*
|*              suiword(addr, value)
|*              suword (addr, value)
|*              sulword(hiaddr, loaddr, value)
|*
|*      Sulword models the user ispace as a contiguous segment of maxsize
|*      one meg.  "Hiaddr" contains the 4 high-order bits of the addr)

_suiword:
|       inc     Suiword
	mov     dx, #MMPGSZ/256*MMSEG_T+ENA
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     bx,*2(bx)               | (cx) = user address
	and     bx,#-MMPGSZ             | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add	bx, #PGZERO		| just happens to be port addr
	pushf				| save interrupt state
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRSF            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page (not writeable ==> fault)
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page (not writeable ==> fault)
	outw				| set up
	mov     ax, #SEGSF              | 'from' segment register
	mov	es, ax			| set up to address
	mov	bx, sp			| get stack "pointer"
	mov	ax, *6(bx)		| (ax) = value
	mov	bx, *4(bx)		| address (4 due to flags)
	and	bx, #MMPGSZ-1		| only want offset
	mov     nofault, #userr         | in case MMU violation
	seg	es			|
	mov     (bx), ax                | do the store
	sub     ax,ax                   | return 0 for success
	jmp	uxit			| we all share an exit

_suword:
	mov     bx,sp
	mov     ax,*2(bx)
	and     ax,#-MMPGSZ
	pushf				| save interrupt state
	cli				| no interrupts	while fussing map
	cmp     ax,sumap
	jnz     suw4

|*      we have a "hit"; its already mapped and known valid

|       inc     SHwrdc
	xor     ax,*2(bx)               | (ax) = offset
	mov     cx,*4(bx)               | (cx) = value
	xchg    ax,bx
	mov     ax,#SEGSU
	mov     es,ax
	cmp     bx,#MMPGSZ-1
	jz      suw1                    | must set nofault
	seg     es
	mov     (bx),cx                 | store it
	popf
	sub     ax,ax                   | return 0 for OK
	mov     bx,ds
	mov     es,bx                   | restore es
	ret

|       am referencing last byte of page and 1st byte of next page.
|       must set nofault cause only 1st page is guaranteed "good"

suw1:   mov     nofault, #suw2          | in case MMU violation
	seg     es
	mov     ax,(bx)
	j       suw3

suw2:   mov     ax,*-1                  | NOFAULT COMES HERE
	mov     sumap,*1
suw3:   mov     nofault, *0
	popf
	mov     bx,ds
	mov     es,bx                   | restore es
	ret

|       Cant use the current mapped area, must remap it

suw4:   mov     sumap,ax                | we'll map this one, if all goes well
|       inc     Suwrdc
	mov     dx, #MMPGSZ/256*MMSEG_D+ENA
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     bx,*4(bx)               | (cx) = user address
	and     bx,#-MMPGSZ             | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add	bx, #PGZERO		| just happens to be port addr
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRSU            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page (not writeable ==> fault)
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page (not writeable ==> fault)
	outw				| set up
	mov     ax, #SEGSU              | 'from' segment register
	mov	es, ax			| set up to address
	mov	bx, sp			| get stack "pointer"
	mov	ax, *6(bx)		| (ax) = value
	mov	bx, *4(bx)		| address (4 due to flags)
	and	bx, #MMPGSZ-1		| only want offset
	mov     nofault, #userr         | in case MMU violation
	seg	es			|
	mov     (bx), ax                | do the store
	sub     ax,ax                   | return 0 for success
	jmp	uxit			| we all share an exit

_sulword:
|        inc     Sulword
	mov     bx, _u+U_PROCP
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb    al, *1
	shlb	al, *1			| >>2 =	map number in right bits
	mov     bx,sp
	mov     dx,*2(bx)               | (dx) = high order addr bits
	xchgb   dh,dl
	add     dx, #MMPGSZ/256*MMSEG_T+ENA
	mov     bx,*4(bx)               | (cx) = user address
	and     bx,#-MMPGSZ             | (bx) = page index *MMPGSZ
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add	bx, #PGZERO		| just happens to be port addr
	pushf				| save interrupt state
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get2um,SEGKD
	mov     dx, #PGADRSF            | program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page (not writeable ==> fault)
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page (not writeable ==> fault)
	outw				| set up
	mov     ax, #SEGSF              | 'from' segment register
	mov	es, ax			| set up to address
	mov	bx, sp			| get stack "pointer"
	mov     ax, *8(bx)              | (ax) = value
	mov     bx, *6(bx)              | address (4 due to flags)
	and	bx, #MMPGSZ-1		| only want offset
	mov     nofault, #userr         | in case MMU violation
	seg	es			|
	mov     (bx), ax                | do the store
	sub     ax,ax                   | return 0 for success
	jmp	uxit			| we all share an exit



|       USERR - handle nofault trap
|
|       If the mmu flags a violation when we store the user's
|	area, we are transfered	here, as if a 'jmp' occoured at	the
|	point of the violation.	 We do the exit	for the	routine
|       which had the problem, _suibyte, _subyte, _suword, _suiword.

userr:  mov     ax, #-1                 | return bad reference indication
	mov     sumap,*1                | dont skip nofault on next store
	jmp     uxit                    | just exit




|***    get1um - get single user map register
|
|       We cannot make accesses through a user map while running in the
|       kernel map.  Instead we program a reserved kernel map page to the
|       same value as the proper register in the user map; we then
|       can reference the user location via that special kernel page.
|       To read the value from the user map we must be under the user map;
|       thus get1um is in the special data space which is included
|       (read-only) in every user map.  While the user map is in effect
|       the code which called us "vanishes..."
|
|       entry   (ax) = MM_PROC value to turn on proper user map & bank
|               (bx) = port addr of user map to read
|       exit    (bx) = read value
|               Map reset to kernel, SEGKCOPY bank selected
|       uses    ax, bx, dx


	.data
get1um: mov     dx, #MM_PROC            | want to switch map briefly
	outw				| switch to users map
	mov	dx, bx			| address page port
	inw				| get page register
	xchg    bx, ax                  | save
	movb	al, *MM_KMAP+MMP_ENA+SEGKCOPY
	mov	dx, #MM_PROC		| switch back to...
	outw				|	kernel map
	reti



|***    get2um - get two user map registers
|
|       We cannot make accesses through a user map while running in the
|       kernel map.  Instead we program two reserved kernel map pages to the
|       same values as the proper registers in the user map; we then
|       can reference the user location via those special kernel pages.
|       To read the values from the user map we must be under the user map;
|       thus get2um is in the special data space which is included
|       (read-only) in every user map.  While the user map is in effect
|       the code which called us "vanishes..."
|
|       entry   (ax) = MM_PROC value to turn on proper user map & bank
|               (bx) = port addr of user map to read
|       exit    (bx) = read value 1
|               (cx) = read value 2
|               Map reset to kernel, SEGKCOPY bank selected
|       uses    ax, bx, dx


get2um: mov     dx, #MM_PROC            | want to switch map briefly
	outw				| switch to users map
	xchg    cx, ax                  | (cx) = map and bank number
	mov	dx, bx			| 1st interesting page port
	inw				| get 1st page register
	xchg    bx, ax                  | save
	add	dx, #PGDELTA		| for next page
	jnc     get21                   | next page is in same bank
	mov     dx, #MM_PROC
	xchg    ax, cx
	inc     ax                      | (ax) = next bank in this map
	outw
	mov     dx, #PGZERO             | first reg on next bank
get21:  inw                             | get this, too
	xchg    cx, ax                  | save 2nd page
	movb	al, *MM_KMAP+MMP_ENA+SEGKCOPY
	mov	dx, #MM_PROC		| switch back to...
	outw				|	kernel map
	reti

	.text



|***	Copy - Copy kernal data	memory
|
|	copy copies a block of kernal data memory.
|
|	copy (&from, &to, count)
|
|	both the source	and destination	must be	in kernal space.


	.globl	_copy
_copy:
	mov	bx,sp
	push	si
	push	di
	mov	si,*2(bx)
	mov	di,*4(bx)
	mov	cx,*6(bx)
	mov	ax,si
	or	ax,di
	or	ax,cx
	shr	ax,*1
	jb	_copy1		| do it	byte at	a time
	shr	cx,*1
	rep
	movs
	pop	di
	pop	si
	ret			| exit

_copy1:	rep
	movsb			| move bytewise
	pop	di
	pop	si
	ret







|***	COPYSEG	- Copy Pages
|
|	copyseg	copys one memory page into another.
|       The name 'copyseg' is historic, we're actually copying PAGES.
|
|	copyseg(from, to)
|
|	NOTE: Int's on during movb ==> no interrupt proc may call these	functs.

	.globl _copyseg
_copyseg:
	mov	bx, sp			| (bx) is our 'frame pointer'
	push	di			|
	push	si			| preserve regs
	push	ds			|
	push	es			|
	mov	cx, #MMPGSZ/2		| (cx) = word count
	sub	si, si			| from addr = (fseg:0000)
	mov	di, si			| to addr =   (tseg:0000)
	cld				|
	cli				| NO INTERRUPTS	while mucking with pages
	movb	al, *MM_KMAP+MMP_ENA+SEGKCOPY
	mov	dx, #MM_PROC		| want to program...
	outw				| kernel "copy"	page.
	mov	ax, *4(bx)		| "to" page
	shl	ax, #1
	shl	ax, #1			| page number to command format
	shl	ax, #1
	xchgb	ah, al
	orb	al, #MM_WR		| make write-only
	mov	dx, #PGADRCT		| first	"copy" page
	outw				| map page to 'to'
	mov	ax, *2(bx)		| "from" page
	shl	ax, #1
	shl	ax, #1			| page number to command format
	shl	ax, #1
	xchgb	ah, al
	orb	al, #MM_RD		| make read-only
	mov	dx, #PGADRCF		| first	"copy" page
	outw				| map page to 'from'
	mov	ax, #SEGCF		| source segment address
	mov	ds, ax			| in DS
	mov	ax, #SEGCT		| target segment address
	mov	es, ax			| in ES
	sti				| int's	back on	for the	move

|	No data	references beyond this point (ds trashed)

	rep				|
	movs				| move by words
	pop	es			|
	pop	ds			|

|	data references	now safe.

	pop	si			|
	pop	di			|
	ret				| exit






|***	CLEARSEG - Zero	a page
|*
|*	clearseg zeros a page.	It is called clear'seg'	for
|*	historical reasons.
|*
|*	clearseg (pageno)
|*
|*	Trashes: ES, AX, BX, CX, DX
|*
|*	NOTE: Int's on during stob ==> no interrupt proc may call these	functs.

       .globl _clearseg
_clearseg:
	mov	bx, sp			| bx is	stack marker
	push	di			| save registers
	mov	cx, #MMPGSZ/2		| (cx) = count
	movb	al, *MM_KMAP+MMP_ENA+SEGKCOPY
	mov	dx, #MM_PROC		| set to program kernel	copy bank
	cli				| int's	OFF while fussing map
	outw				| fix to kernel	data bank
	mov	ax, *2(bx)		| (ax) = page number
	shl	ax, #1
	shl	ax, #1			| page number to command format
	shl	ax, #1
	xchgb	ah, al
	orb	al, #MM_WR		| want it writeable
	mov	dx, #PGADRCT		| program 'to' pages to	do store
	outw				| remap	working	segment
	mov	ax, #SEGCT		| segment for the transfer
	mov	es, ax			| store	into es:di
	sub	ax, ax			| want zero
	mov	di, ax			| also,	offset = 0
	sti				| int's	on for the store
	cld				| store	"forward"
	rep				| multiple times...
	stow				| store	a word of zeros
	mov	di,ds
	mov	es,di			| es = ds
	pop	di			| restore register(s) and
	ret				| return.




|***	ZEROMEM	- Zero Memory
|*
|*	zeromem	zeros memory in	the kernel's address space
|*
|*	zeromem	(addr, cnt)

	.globl	_zeromem
_zeromem:
	mov	bx, sp			| bx is	stack marker
	push	di			| save
	mov	di, *2(bx)		| (di) = destination
	mov	ax, ds			|
	mov	es, ax			| (es:di)
	mov	cx, *4(bx)		| (cx) = count
	subb	al, al			| store	zeroes
	rep				|
	stob				| repeat zap
	pop	di			|
	ret				|




|**	copyin	(user, sys , len)
|**	copyiin	(user, sys , len)
|**     copylin (userlow, sys , len, userhi)
|**	copyout	(sys,  user, len)
|**	copyiout(sys,  user, len)
|**     copylout(sys, userlow, len,  userhi)
|
|	Copy to/from user space, from/to kernal	space.
|
|       The copys are all from arbitrary addresses, and for an arbitrary
|	number of bytes.
|	The 'large address space' versions (copylin, copylout) copy
|	to/fromt the user task's I space.  A 20-bit address is passed,
|	the high 4 bits, then the low 16.

	.globl  _copyin,_copyiin,_copyout,_copyiout
	.globl  _copylin,_copylout

_copylin:
	mov     bx, sp
	mov     dx, *8(bx)              | (dx) = high 4 bits of addr
	xchgb   dh, dl
	add     dx, #MMPGSZ/256*MMSEG_T+ENA
	j       copyi1

_copyin:				| copy from user data to kernal	data
	mov     dx, #MMPGSZ/256*MMSEG_D+ENA
	j	copyi1			|

_copyiin:				| copy from user ispace	to kernal data
	mov     dx, #MMPGSZ/256*MMSEG_T+ENA

copyi1:					|
	mov	bx, _u+U_PROCP		| u.u_procp
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb	al, *1			| >>1
	shlb	al, *1			| >>2 =	map number in right bits
	mov	bx, sp			| (bx) = frame pointer
	push	si			|
	push	di			| preserve regs
	mov	si, *2(bx)		| (si) = source	(user)
	mov	di, *4(bx)		| (di) = dest	(sys)
	push	ds			| push destination seg = kernal	data
	mov	cx, #SEGCF		| source segment = 'copy from'
	push	cx			|
	mov	bx, si			| address ... want page
	and	bx, #-MMPGSZ		| get "page" in	high bits
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add	bx, #PGZERO		| just happens to be port addr
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get2um,SEGKD           | get 2 user maps
	mov	dx, #PGADRCF		| program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page
	outw				| set up
	and	si, #MMPGSZ-1		| only want offset
	j	copy			| do the work

|	Copy-out routines.

_copylout:
	mov     bx, sp
	mov     dx, *8(bx)              | (dx) = high 4 bits of addr
	xchgb   dh,dl
	add     dx, #MMPGSZ/256*MMSEG_T+ENA
	j       copyo1

_copyout:				| copy from kernal data	to user	data
	mov     dx, #MMPGSZ/256*MMSEG_D+ENA
	j	copyo1			|

_copyiout:				| copy from kernal data	to user	ispace
	mov     dx, #MMPGSZ/256*MMSEG_T+ENA

copyo1:					|
	mov	bx, _u+U_PROCP		| u.u_procp
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum = map number
	shlb	al, *1			| >>1
	shlb	al, *1			| >>2 =	map number in right bits
	mov	bx, sp			| (bx) = frame pointer
	push	si			|
	push	di			| preserve regs
	mov	si, *2(bx)		| (si) = source	(system)
	mov	di, *4(bx)		| (di) = dest	(user)
	mov	cx, #SEGCF		| destination segment =	'copy from'
	push	cx			|
	push	ds			| source seg = kernal data
	mov	bx, di			| address ... want page
	and	bx, #-MMPGSZ		| get "page" in	high bits
	xchgb   bh,bl
	add     bx,dx                   | (bx) = page num *8
	orb     al,bh                   | (al) = map and bank select
	xchgb   bh,bl
	subb    bl,bl
	add	bx, #PGZERO		| just happens to be port addr
	cli				| no interrupts	while fussing map
	.byte   CALLI
	.word   get2um,SEGKD           | get 2 user map registers
	mov	dx, #PGADRCF		| program 'from' pages to do fetch
	xchg    ax, bx                  | 1st user page (not writeable ==> fault)
	outw				| set up
	add	dx, #PGDELTA		| next register
	xchg    ax, cx                  | 2nd user page (not writeable ==> fault)
	outw				| set up
	and	di, #MMPGSZ-1		| only want offset
	j	copy			| do the work




|	Do the copy
|
|	shared by the four copy	routines
|
|	(si) = source offset
|	(di) = destination offset
|	((sp)+14)= len
|	((sp)+12)= dst addr
|	((sp)+10)= src addr
|	((sp)+8)= return addr
|	((sp)+6) = caller (si)
|	((sp)+4) = caller (di)
|	((sp)+2) = destination segment
|	((sp)+0) = source segment
|
|	Note we	must be	careful	not to load 'ds' before	we're done
|	with '(bx)' and	static references!
|
|	NOTE: Int's on during movb ==> no interrupt proc may call these	functs.

copy:	mov	bx, sp			| address stack
	sti				| int's	on for the move
	mov	cx, #14(bx)		| length
	mov	nofault, #copyf		| in case MMU trap
	pop     ds
	pop	es			| load source and dest segments
| NO STATIC REFERENCES UNTIL DS	IS RESTORED
	cld
	mov	ax, #-1			| assume have a	mmu fault
	shr     cx, #1                  | (cx) = word count, 'C' set if odd
	jcxz    copy0                   | if move count == 0 (words)
	rep				|
	movs				| move the word
copy0:  jnb     copy1                   | was an even count
	movsb                           |
	j       copy1                   | break fetch-ahead & time for MMU trap
copy1:	sub	ax, ax			| no mmu fault

|	we may transfer	at this	point to via 'nofault'
|
|	Note that DS and ES are	garbage, but 'pops' are	safe because
|	SS is still ok.

copyf:
	pop	di			|
	pop	si			| restore regs
	mov	bx, ss			|
	mov	ds, bx			| restore segment registers
	mov	es, bx			|
	mov	nofault, #0		| clear	nofault
	ret				|



|***	subroutines to execute instructions not	in C



|**	in (addr)	- input	a word
|**	inb(addr)	- input	a byte
|**	out(addr)	- output a word
|**	outb(addr)	- output a byte

	.globl _in, _inb,_out,_outb

_in:
	mov	bx, sp			| bx is	frame pointer
	mov	dx, *2(bx)		| dx = port
	inw				| input	a word
	ret				|

_inb:
	mov	bx, sp			| bx is	frame pointer
	mov	dx, *2(bx)		| dx = port
	in				| input	a byte
	subb	ah, ah			|
	ret				|

_out:					| don't	use stack, out may change mapping
	mov	bx, sp			| bx is	frame pointer
	mov	dx, *2(bx)		| dx = port
	mov	ax, *4(bx)		| ax = value to	output
	outw				| output a word
	ret				|

_outb:
	mov	bx, sp			| bx is	frame pointer
	mov	dx, *2(bx)		| dx = port
	mov	ax, *4(bx)		| ax = byte to output
	out				| output a byte
	ret				|




|***	_mapwork - Map the special working page
|*
|*	The page just under the	U page is reserved for temporary
|*	use.  The system startup code makes sure that the kernel
|*	data space dosent extend that far.
|*	This spare page	is typically used to access arbitrary
|*	physical memory, such as the U space of	a user other then
|*	the one	mapped into the	real U space.
|*
|*	The work map is	implicltly reserved by running at spl7.
|*	When you lower the priority, you implicitly release the	page.
|*
|*	addr=mapwork(pagenum);
|*
|*		Page 'pagenum' is mapped, and the logical address
|*	of the page is returned.

	.globl	_mapwork
_mapwork:
	mov	bx, sp			| bx is	frame pointer
	movb	al, *MM_KMAP+MMP_ENA+SEGKDATA
	mov	dx, #MM_PROC		| program...
	outw				|	kernel data bank
	mov	ax, *2(bx)		| (ax) = new page
	shl	ax, #1
	shl	ax, #1			| page number to command format
	shl	ax, #1
	xchgb	ah, al
	orb	al, #MM_RD+MM_WR	| make RW
	mov	dx, #PGADRUT		| dx = work page port address
	outw				| map into work	page
	mov	ax, #OFFWRKPG		| return logical address of page
	ret				|




|***	COPYITOD - Copy	user Ispace maps to Dspace map registers
|*
|*	A non-sep user task is setup by	mmuset() completely in the
|*	i-space	registers.  To make the	kernal code simpler, we	will
|*	duplicate those	registers into the d-space registers, so that
|*	the kernal can reference data via d-space, without concern
|*	for u.u_sep.
|*
|*	We do this by switching	to the user's map, and copying each
|*	page port.  Note that all 32 page registers are	copied;	this
|*	is because they	are in the form	<text><data><hole><stack>.
|*
|*      The section of code that runs in the user map must be in the
|*      special data area which is included in all user maps.

	.globl	_copyitod
_copyitod:
	push    di                      | save user regs
	push    si
	mov     cx, #NPAGEPS-MMSEG_D      | # of pages in bank
	mov	bx, _u+U_PROCP		| need user map	#
	movb	al, #P_PNUM(bx)		| u.u_procp->p_num
	shlb	al, *1			| >>1
	shlb	al, *1			| >>2 =	map number in correct bits
	orb	al, #MMP_ENA		| want to map
	xchg    di, ax                  | di = user process map number
	mov	bx, #PGADRUI		| bx holds page-port (I/D ports	same)
	cli				| (no ints while fussing map)
	.byte   CALLI
	.word   citod1,SEGKD

	.data
citod1:					|
	mov	ax, di			| user map value
	orb     al, #1                  | want text bank
	mov	dx, #MM_PROC		| map user text	bank
	outw				|
	mov	dx, bx			| current page-port
	inw				| ax = text page value
	xchg    si, ax                  | save page value
	mov	ax, di			| get user map value
	mov	dx, #MM_PROC		|	to user	DATA bank
	outw				|
	mov	dx, bx			| page-port addr
	xchg    ax, si                  | restore page value
	outw				| set DATA page
	add	bx, #PGDELTA		| point	at next	page
	loop	citod1			| loop until done

|       have three more to go, in the next bank

	mov     bx, #PGZERO
	mov     cx, *3
citod2:                                 |
	mov	ax, di			| user map value
	orb     al, #2                  | want text bank
	mov	dx, #MM_PROC		| map user text	bank
	outw				|
	mov	dx, bx			| current page-port
	inw				| ax = text page value
	xchg    si, ax                  | save page value
	mov	ax, di			| get user map value
	orb     al, #1                  | now switch to...
	mov	dx, #MM_PROC		|	to user	DATA bank
	outw				|
	mov	dx, bx			| page-port addr
	xchg    ax, si                  | restore page value
	outw				| set DATA page
	add	bx, #PGDELTA		| point	at next	page
	loop    citod2                  | loop until done

	mov	dx, #MM_PROC		| need to restore...
	movb	al, *MM_KMAP+MMP_ENA	| kernel map.
	outw				|
	reti
	.text

	sti				| int's	back on
	pop	si			| restore reg-var
	pop	di			| restore reg-var
	ret				|




|***	_mmuzapu - Invalidate all user pages
|*
|*	_mmuzapu is called when	the user mmu registers are to be
|*	reprogrammed.  _mmuzapu	flags all the registers	invalid,
|*	to save	the 'c'	code the effort.  The average task size	is
|*	small, so it is	expected that there will be more invalid
|*	pages than valid.
|*
|*	We do this by switching	to the user map	and zapping the	text and
|*	data portions.	The "cannonical" code we're in stays mapped.
|*
|*      The section of code that runs in the user map must be in the
|*      special data area which is included in all user maps.

	.globl	_mmuzapu
_mmuzapu:
	mov     fumap,*1
	mov     sumap,*1                | polute stats
	push    si
	pushf
	mov	bx, _u+U_PROCP		| u.u_procp
	movb	al, #P_PNUM(bx)		| u.u_procp->p_pnum
	shlb	al, *1			| >>1
	shlb	al, *1			| >>2 =	map # in right bits
	xchg    bx, ax
	orb     bl, #MMP_ENA            | (bx) = bank select
	mov     si, #PGDELTA*3+PGZERO   | (si) = 1st port to program
	mov     cx, #NPAGEPS-3          | (cx) = count (leave 1st 3 in 1st bank)
	cli				| no int's while fussing map(s)
	.byte   CALLI
	.word   mmzap0,SEGKD

	.data
|       zap this bank
|
|       (cx) = count left
|       (bl) = bank selector
|       (si) = first register in this bank

mmzap0:
	mov     dx, #MM_PROC
	mov     ax,bx
	outw                            | select bank
	mov     dx,si
	sub     ax,ax
mmzap1:	outw				| hit it
	add	dx, #PGDELTA		| point	at next.
	loop	mmzap1			| zap entire bank
	mov     si, #PGZERO
	mov     cx, #NPAGEPS
	incb    bl
	testb   bl,*3
	mov     dx,bl                   | BUG BUG FOR HISTOGRAMMING
	andb    dl,*3
	cmpb    dl,*3
	jnz     mmzap0                  | more banks to go

|	Resume running in kernel map

	movb	al, *MM_KMAP+MMP_ENA	| enabled kernel map
	mov	dx, #MM_PROC		| switch to...
	outw				|	kernel map
	reti

	.text
	popf                            | int's back on
	pop     si
	ret				|




|**	mmuppg -- program user process page
|
|       mmuppg(segflg, pgind, pageno, access);
|
|       segflg = MMSEG_D - is in users 65K of data
|                MMSEG_T - is in users text
|       pgind  = page index in user code or data space
|       pageno = physical page to map to
|       access = access permission bits
|
|       Each task has 256K of addressable memory, the 128 pages are
|       grouped into 4 banks.  The bank has to be selected before the
|       proper page can be programmed.  Unfortunately we need to reserve
|       three pages at the low end of the task's map so that the 65K
|       data area has 29 registers in bank 0 and 3 in bank 1.  To
|       simplify life this routine allows one to say "map the nth page
|       of the taks's logical segment code|data to physical page "n".

	.globl	_mmuppg
_mmuppg:
	mov     fumap,*1
	mov     sumap,*1                | polute stats
	mov     bx, _u+U_PROCP
	movb    al, #P_PNUM(bx)         | (al) = u.u_procp->p_pnum
	shlb    al, *1
	shlb    al, *1                  | (al) = map number in correct bits
	orb     al, #MMP_ENA
	mov     bx, sp                  | (bx) = 'frame pointer'
	mov     cx, *2(bx)              | (cx) = map offset
	add     cx, *4(bx)              | (cx) = map reg, 0 - 127
	shl     cx, *1
	shl     cx, *1
	shl     cx, *1
	xchgb   ch, cl                  | (cl) = bank number, (ch) = page
	orb     al, cl                  | (al) = map and bank selector
	subb    cl, cl
	add     cx, #PGZERO             | (cx) = i/o port for page
	mov     dx, *6(bx)              | get page number
	shl     dx, #1
	shl     dx, #1                  | page number to command format
	shl     dx, #1
	xchgb   dh, dl
	orb     dl, *8(bx)              | put access in
	mov     bx,dx                   | (bx) = mmu reg value
	mov	dx, #MM_PROC		| have to switch to user map
	cli				| stack	will be	garbage
	.byte   CALLI
	.word   mmupp1,SEGKD

	.data
	.globl  mmupp1
mmupp1: outw                            | NOW IN USER MAP
	mov     dx, cx                  | (dx) = page-port
	xchg    ax, bx                  | (ax) = page-value
	outw
	mov     dx, #MM_PROC
	movb    al, #MM_KMAP+MMP_ENA
	outw                            | BACK TO KERNEL MAP
	reti

	.text
	sti				| int's	back on
	ret				| done




|**	fixpage	-- fuss	a page number &	access
|
|	val = fixpage(pageno, access)

	.globl	_fixpage
_fixpage:
	mov	bx, sp			| frame	pointer
	mov	ax, *2(bx)		| get page number
	shl	ax, #1
	shl	ax, #1			| page number to command format
	shl	ax, #1
	xchgb	ah, al
	orb	al, *4(bx)		| put access in
	ret				| done.



|***    Floating Point
|
|       The following routines deal with IEEE floating point, either
|       8087 or emulated.


FLGX87  =       _u+U_FPTAG              | emulator symbols
INMX87  =       FLGX87+1
MSKX87  =       INMX87+1
RNBX87  =       MSKX87+1

BASX87  =       RNBX87+1
CURX87  =       BASX87+2
LIMX87  =       CURX87+2

BEGREG  =       LIMX87+2
ENDREG  =       BEGREG+100              | room for 10 registers




|**	SAVFP, RESTFP	Save and restore floating point status
|
|	savfp and restfp save and restore, respectively, the
|	8087 status and registers.  The address passed is the
|	address of the save area in the user per process data area.
|
|       These routines only do the work if
|               1. the hardware exists.  The emulator works
|                  directly out of the u_ save area
|               2. This task is using the hardware
|       The u_fpused flag is set only if both conditions are true.
|
|	savfp(&u.u_fps)
|	restfp(&u.u_fps)

	.text

	.globl  _savfp
_savfp:
	testb   _u+U_FPUSED,*/ff        | using 8087
	je      9$
	mov	bx,sp
	mov     bx,2(bx)                | get argument pointer
	.byte   ESC5,/37                |       FSAVE   (bx)
	movb    _u+U_FPSAVED,*1         | mark saved status
	.byte   WAIT                    |       FWAIT
	testb   _u+U_FPSTAT,*/80        | exception requested?
	je      9$
	call    _fppintr                | process exception
9$:
	ret

	.globl	_restfp
_restfp:
	testb   _u+U_FPUSED,*/ff        | using 8087
	je      9$
	mov	bx,sp
	mov     bx,2(bx)                | get argument pointer
	.byte   WAIT,ESC5,/27           |       FRSTOR  (bx)
	movb    _u+U_FPSAVED,*0                 | mark unsaved status
	.byte   WAIT                    |       FWAIT
9$:
	ret

	.globl  _initfp
_initfp:
	mov     bx,sp
	mov     bx,2(bx)                | get argument pointer
	.byte   ESC3,/E3                |       FINIT
	.byte   WAIT                    |       FWAIT
	.byte   ESC5,/37                |       FNSAVE   (bx)
	.byte   WAIT                    |       FWAIT
	movb    (bx),*/30               | enable exceptions but prec, underflo
	ret



|**     inifpe - initialize floating point emulator
|
|       Called during exec if 8087 is absent
|
|       Note that the fp_cntrl value does not so much control the
|       emulator as merely reflect the hardwired emulator algorithms.

	.globl  _inifpe

_inifpe:
	movb    FLGX87,*0               | clear initial exception flags
	movb    INMX87,*1               | clear indefinite exception mask
	movb    MSKX87,*/3F             | clear other exception mask
	movb    RNBX87,*1               | rounding enabled

	mov     ax,#BEGREG
	mov     BASX87,ax               | base of register chunk
	add     ax,*10
	mov     CURX87,ax               | addr of 1st register
	mov     LIMX87,#ENDREG-10       | addr of last register
	mov     BEGREG,#ENDREG-10

	mov     _u+U_FPCNTRL,#/1200     | emulator control values
	mov     _u+U_FPSTAT,#0          | clear status
	ret





|**     fpesav - Save 8087 and clear floating exception
|
|       When the 8087 generates an exception interrupt we must
|       clear the exception flags before re-enabling interrupts.
|       Just setting the internal 8087 int mask won't do as a 8086
|       wait instruction will trigger the interrupt, anyway. If we were
|       to issue the wait with interrupt disabled, say by calling fpsav()
|       at exception interrupt time, we'd hang the CPU.
|
|       fpesav(&u.u_fps)
|
|       save the contents of the 8087, thus clearing the exception flags
|       in the chip itself.  The caller must clear the exception flags
|       in u.u_fps before a fprest() is done.

|        .globl  _fpesav
|_fpesav:
|        mov     bx,sp
|        mov     bx,2(bx)        | get argument pointer
|        .byte   ESC5,/37        |       FSAVE   (bx)
|        .byte   WAIT            |       FWAIT
|        ret


|
||****
||****	 THE USER STRUCTURE IS IN THE TOP PAGE OF MEMORY
||****	 IT IS DEFINED HERE AND	REFERENCED AS EXTERNAL ELSEWHERE
||****
|
	.data

U_STACK=/FFFE				| top of stack

	.even
mapcs:  .word   0                       | saved unmapped "CS" for debugging



|**     fuword/fubyte  suword/subyte map recordings
|
|       Its very expensive to transfer a piece of the user map into
|       the kernel map area for a fuword/suword kind of operation.
|       Fortunately, theres strong locality for sequential operations so
|       if we remember which user page we have mapped we can speed up
|       susequent references to that page.
|
|       We remember which user page is mapped by storing the high 5 bits
|       of the address in [fs]umap.  (Note that since we only pull this
|       trick for data space routines we don't have to worry about
|       bits above 2^15).  When we change maps or reprogram a map we
|       pollute these cells thus forcing a remaping at the next call
|       to [fs]uword/[fs]ubyte.
|
|       We also pollute the cell if we take a nofault trap so that routines
|       making use of a "premapped" situation don't have to muck with
|       nofault.

fumap:  .word   1
sumap:  .word   1

	.globl  _u
_u=	OFFUSRPG			| 'U' page (see	mmu.h)


	.text

|***	haltcpu	- Halt the system upon normal shutdown.
|

	.globl	_haltcpu
_haltcpu:
	sti				| allow	interrupts
	hlt				| stop for a while
	j	_haltcpu		| interrupts break us loose




|***	monitor	-- trap	to monitor

	.globl	_monitor
_monitor:
	int	#3
	ret


|
||**     grabclock() - special histogram clock processing
||
||       this routine intercepts the clock interrupts, which will
||       be ariving every 10 milliseconds.  Every clock interrupt
||       while in kernel space will cause a histogram record to
||       be counted.  Every 5th clock interrupt will be passed on
||       to the "old" clock vector.
|
|	.globl  _grabclock
|_grabclock:
|	mov     ax,/12*4+0              | (ax) = old clock service vector
|	mov     gcla,ax
|	mov     /12*4+0,#histint
|	ret
|
|	.data
|
||**     histint - high speed clock interrupts come directly here
||
||               stack is system or user, has the
||                       ip, cs, flags
||               on it, only.
|
|	.data                   | in data to execute in all maps
|histint:
|	push    ds
|	push    ax
|	push    bx
|	seg     cs
|	.dataref
|	testb   state,*1
|	jnz     hin1            | am in user mode
|	mov     bx,sp
|	seg     ss
|	mov     ax,*8(bx)
|	add     ax,ax
|	add     ax,ax
|	add     ax,ax
|	add     ax,ax           | (ax) = segment*4
|	seg     ss
|	add     ax,*6(bx)
|	xchg    ax,bx
|	shr     bx,*1
|	shr     bx,*1
|	andb    bl,*/fe
|	mov     ax,#/3000
|	mov     ds,ax
|	inc     (bx)
|hin1:   seg     cs
|	.dataref
|	dec     hista           | see if time to pass it on
|	jnz     hist1           | no
|	seg     cs
|	.dataref
|	mov     hista,*5
|	pop     bx
|	pop     ax
|	pop     ds
|	seg     cs
|	.dataref
|	jmp     @gcla
|
|gcla:   .word   0
|
||       am not going to pass this on to the normal clock routines,
||       we must dismiss the interrupt ourselves
||       Only (cs) is known at this point
|
|hist1:  push    dx
|	mov     dx, #MM_CLRST           | clear...
|	inw				|	<SR,TR>	flags.
|	movb	al, #PIC_EOI		| now do EOI
|	out	PIC_CMD1		| mask doesn't allow more at this level
|	seg     cs
|	.dataref
|	testb	state, #PS_USER		| test state flag in system memory
|	jz      hist2                   | am in system mode
|	mov     dx, #MM_SCSYS           | set dx to...
|	outw				|	turn ON	user mode (ax =	don't care)
|hist2:  pop     dx
|	pop     bx
|	pop     ax
|	pop     ds
|	iret
|
|hista:  .word   5
|histb:  .word   0
|
	.text



||**     mmuoff - turn off mmu and return to caller.
||
||       This is hyper-tricky and does not work, except for a short
||       period of time in very special cases.  Basically,
||       dont use this unless you know what you're doing...
|
|        .globl  _Mapoff,_Mapon
|_Mapoff:
|        pop     ax                      | (ax) = return offset
|        pushf                           | save iflg
|        push    bp                      | save callers (bp)
|        cli                             | no interrupts while playing!
|        mov     mmua,sp                 | save stack in u_ area
|        mov     sp, #MM_BSTACK          | temp boot stack
|        push    ax                      | save return offset
|        .byte   CALLI
|        .word   mapoff,0
|        mov     bp,sp
|        ret
|mmua:   .word   0
|
|_Mapon:                                 | makes "bp" invalid...
|        .byte   CALLI
|        .word   mapon,0
|        pop     ax                      | (ax) = return offset
|        mov     sp,mmua
|        pop     bp                      | caller needs his old (bp) restored
|        popf                            | restore interrupt flag
|        push    ax
|        ret

	 .end    strt
