
/*
 *	<a.out.h> - Declarations for object file headers
 *		and nlist, xlist symbol table structures.
 *
 *	Copyright (C) Microsoft Corporation, 1982
 */

struct  xexec {			/* x.out header */
	unsigned short	x_magic;	/* magic number */
	unsigned short	x_ext;		/* size of header extension */
	long		x_text;		/* size of text segment */
	long		x_data;		/* size of initialized data */
	long		x_bss;		/* size of uninitialized data */
	long		x_syms;		/* size of symbol table */
	long		x_reloc;	/* relocation table length */
	long		x_entry;	/* entry point */
	char		x_cpu;		/* cpu type & byte/word order */
	char		x_relsym;	/* relocation & symbol format */
	unsigned short	x_renv;		/* run-time environment */
};


struct	xext {		/* x.out header extension */
	long	xe_trsize;	/* size of text relocation */
	long	xe_drsize;	/* size of data relocation */
	long	xe_tbase;	/* text relocation base */
	long	xe_dbase;	/* data relocation base */
	long	xe_stksize;	/* stack size (if XE_FS set) */
};


/*
 *      Definitions for xexec.x_magic, HEX (short).
 */

#define ARCMAGIC	0xff65	/* 0177545, archive, same as always */
#define X_MAGIC		0x0206	/* indicates x.out header */


/*
 *      Definitions for xexec.x_cpu, cpu type (char).
 *
 *	b       	set if high byte first in short
 *	 w              set if low word first in long
 *	  cccccc	cpu type
 */

	/* bytes/words are "swapped" if not stored in pdp11 ordering */
#define XC_BSWAP	0x80	/* bytes swapped */
#define XC_WSWAP	0x40	/* words swapped */

#define XC_NONE		0x00	/* none */
#define XC_PDP11	0x01	/* pdp11 */
#define XC_23		0x02	/* 23fixed from pdp11 */
#define XC_Z8K		0x03	/* Z8000 */
#define XC_8086		0x04	/* I8086 */
#define XC_68K		0x05	/* M68000 */
#define XC_Z80		0x06	/* Z80 */
#define XC_VAX		0x07	/* VAX 780/750 */
#define XC_16032	0x08	/* NS16032 */
#define XC_286		0x09	/* iAPX 80286 */
#define XC_CPU		0x3f	/* cpu mask */


/*
 *	Definitions for xexec.x_relsym (char).
 *
 *	rrrr            relocation table format
 *	    ssss        symbol table format
 */

	/* relocation table format */
#define XR_RXOUT	0x00	/* x.out long form, linkable */
#define XR_RXEXEC	0x10	/* x.out short form, executable */
#define XR_RBOUT	0x20	/* b.out format */
#define XR_RAOUT	0x30	/* a.out format */
#define XR_R86REL	0x40	/* 8086 relocatable format */
#define XR_R86ABS	0x50	/* 8086 absolute format */
#define XR_R286ABS	0x60	/* 80286 absolute format */
#define XR_REL		0xf0	/* relocation format mask */

	/* symbol table format */
#define XR_SXOUT	0x00	/* trailing string, struct sym */
#define XR_SBOUT	0x01	/* trailing string, struct bsym */
#define XR_SAOUT	0x02	/* struct asym (nlist) */
#define XR_S86REL	0x03	/* 8086 relocatable format */
#define XR_S86ABS	0x04	/* 8086 absolute format */
#define XR_SUCBVAX	0x05	/* separate string table */
#define XR_SYM		0x0f	/* symbol format mask */


/*
 *      Definitions for xexec.x_renv (short).
 *
 *	vv                  version compiled for
 *	  xxxxxx            extra (zero)
 *
 *	        r           reserved
 *	         t          set if large model text
 *	          d         set if large model data
 *	           o        set if text overlay
 *                  f       set if fixed stack
 *	             p      set if text pure
 *	              s     set if separate I & D
 *		       e    set if executable
 */

#define XE_V2		0x4000		/* up to and including 2.3 */
#define XE_V3		0x8000		/* after version 2.3 */
#define XE_VERS		0xc000		/* version mask */

#define XE_RES		0x0080		/* reserved */
#define XE_LTEXT	0x0040		/* large model text */
#define XE_LDATA	0x0020		/* large model data */
#define XE_OVER		0x0010		/* text overlay */
#define XE_FS		0x0008		/* fixed stack */
#define XE_PURE		0x0004		/* pure text */
#define XE_SEP		0x0002		/* separate I & D */
#define XE_EXEC		0x0001		/* executable */


#define XEXTPOS(xp)	((long) sizeof(struct xexec))
#define XTEXTPOS(xp)	(XEXTPOS(xp) + (long) (xp)->x_ext)
#define XDATAPOS(xp)	(XTEXTPOS(xp) + (xp)->x_text)
#define XSYMPOS(xp)	(XDATAPOS(xp) + (xp)->x_data)
#define XRELPOS(xp)	(XSYMPOS(xp) + (xp)->x_syms)
#define XENDPOS(xp)	(XRELPOS(xp) + (xp)->x_reloc)

#define XRTEXTPOS(xp, ep)	(XRELPOS(xp))
#define XRDATAPOS(xp, ep)	(XRELPOS(xp) + (ep)->xe_trsize)




struct  aexec {			/* a.out header */
	unsigned short	xa_magic;       /* magic number */
	unsigned short	xa_text;        /* size of text segment */
	unsigned short	xa_data;        /* size of initialized data */
	unsigned short	xa_bss;         /* size of unitialized data */
	unsigned short	xa_syms;        /* size of symbol table */
	unsigned short	xa_entry;       /* entry point */
	unsigned short	xa_unused;      /* not used */
	unsigned short	xa_flag;        /* relocation info stripped */
};


/*
 *	Definitions for aexec.xa_magic, OCTAL, obsolete (short).
 */

#define FMAGIC		0407	/* normal */
#define NMAGIC		0410	/* pure, shared text */
#define IMAGIC		0411	/* separate I & D */
#define OMAGIC		0405	/* text overlays */
#define ZMAGIC		0413	/* demand load format */

#define	A_MAGIC1	FMAGIC
#define	A_MAGIC2	NMAGIC
#define	A_MAGIC3	IMAGIC
#define	A_MAGIC4	OMAGIC


#define ATEXTPOS(ap)	((long) sizeof(struct aexec))
#define ADATAPOS(ap)	(ATEXTPOS(ap) + (long) (ap)->xa_text)
#define ARTEXTPOS(ap)	(ADATAPOS(ap) + (long) (ap)->xa_data)
#define ARDATAPOS(ap)	(ARTEXTPOS(ap) + ((long) \
			    ((ap)->xa_flag? 0 : (ap)->xa_text)))
#define ASYMPOS(ap)	(ATEXTPOS(ap) + \
			    (((ap)->xa_flag? 1L : 2L) * \
			((long) (ap)->xa_text + (long) (ap)->xa_data)))
#define AENDPOS(ap)	(ASYMPOS(ap) + (long) (ap)->xa_syms)




struct  bexec {		/* b.out header */
	long	xb_magic;	/* magic number */
	long	xb_text;	/* text segment size */
	long	xb_data;	/* data segment size */
	long	xb_bss;		/* bss size */
	long	xb_syms;	/* symbol table size */
	long	xb_trsize;	/* text relocation table size */
	long	xb_drsize;	/* data relocation table size */
	long	xb_entry;	/* entry point */
};


#define BTEXTPOS(bp)	((long) sizeof(struct bexec))
#define BDATAPOS(bp) 	(BTEXTPOS(bp) + (bp)->xb_text)
#define BSYMPOS(bp)	(BDATAPOS(bp) + (bp)->xb_data)
#define BRTEXTPOS(bp)	(BSYMPOS(bp) + (bp)->xb_syms)
#define BRDATAPOS(bp)	(BRTEXTPOS(bp) + (bp)->xb_trsize)
#define BENDPOS(bp)	(BRDATAPOS(bp) + (bp)->xb_drsize)




/*
 *	nlist symbol table structure, obsolete.
 *
 *	Used to provide compatibility with nlist(3).
 */

struct	nlist {
	char		n_name[8];	/* symbol name */
	int		n_type;		/* type flag */
	unsigned	n_value;	/* value */
};


/*
 *	xlist symbol table structure as used by xlist(3).
 */

struct xlist {
	unsigned short	xl_type;	/* symbol type */
	unsigned short	xl_pad;		/* for miscellaneous use */
	long		xl_value;	/* symbol value */
	char		*xl_name;	/* pointer to asciz name */
};
