
/*
 * Copyright (C) Microsoft Corporation, 1982
 */

/*
 * One file structure is allocated
 * for each open/creat/pipe call.
 * Main use is to hold the read/write
 * pointer associated with each open
 * file.
 *
 *      Modifications
 *
 *      M000    7 Dec 81        EA
 *              Defined a new flag, FSYNC, that designates a synchronous
 *              write - one in which the caller's task waits for the
 *              completion of the write.
 *
 *      M001    6 Jan 82        EA
 *              Added a pointer to the next waiter for a semaphore in the
 *              file structure.
 *	M002	5 Dec 82	JJd
 *		changed f_count from char to unsigned short to fix counting
 *		bug
 */

struct	file
{
	char	f_flag;
	unsigned short f_count;         /* reference count */
	struct inode  *f_inode;         /* pointer to inode structure */
	union {
		off_t	f_offset;	/* read/write character pointer */
		struct chan *f_chan;	/* mpx channel pointer */
		struct file *f_slnk;    /* M001 next waiter for semaphore */
	} f_un;
};

extern struct file file[];	/* The file table itself */

/* flags */
#define	FREAD	01
#define	FWRITE	02
#define	FPIPE	04
#define FMPX	010
#define	FMPY	020
#define	FMP	030
#define	FKERNEL	040
