
/*
 * usart.h
 *	Misc definitions for 534 USART[3].
 *
 * Assumes 534 bse at 0x40.
 *
 * Bob Beck, 12-15-81.
 * Gizmized, 1-82.
 */

/*
 * Port Addresses for:
 * 	SERIAL	8251A
 * 	PIT	8253
 */

#define SER_DATA_PORT        0x46
#define SER_CONTROL_PORT     0x47

/*
 * Control commands for 8251A
 *
 * SER_RESET commands resets the 8251A
 *
 * SER_MODE command sets the 8251A for:
 * 	16X clock
 * 	8 bits
 * 	No parity
 * 	2 stop bits
 *
 * SER_CMD command sets the 8251A for:
 * 	Transmit enable
 * 	DTR on
 * 	Receive enable
 * 	Error reset
 * 	RTS on
 */

#define SER_RESET            0x40
#define SER_MODE             0x4E
#define SER_CMD              0x37

/*
 * Definition of ready bits for 8251A
 */

#define SER_RX_READY         0x02
#define SER_TX_READY         0x01

/*
 * Baud rate selection.  These go into the clock counter.
 */

#define	US_B38400	2
#define	US_B19200	4
#define	US_B9600	8
#define	US_B4800	16
#define	US_B2400	32
#define US_B1800	48
#define	US_B1200	64
#define	US_B600		128
#define	US_B300		256
#define US_B200		384
#define	US_B150		512
#define	US_B110		698
#define	US_B75		1024
#define US_B50		1536
#define US_B0		0
