'\" 	@(#)Document: V2-00-1
'\" 	@(#)Subject: V3.0 SW Dev - Introduction
'\" 	@(#)Writer: Stewart Konzen
'\" 	@(#)Work: 1 week
'\" 	@(#)Target: 1/1
'\" 	@(#)Notes: 
'\" 	@(#)Mods: 
'\"	needs control.def
.ds :? INTRODUCTION
.nr H1 1
.PH "'Introduction''Introduction'"
.H 2 "Overview"
One of the primary uses of the \*(x1 system is as an
environment for software development.
This manual describes the \*(x1 programming environment
and the available tools.
Since nearly all of the \*(x1 system 
is written in the C programming language, 
C is the ideal language for creating new \*(x1 applications. 
However, no attempt is made here to teach C programming.
For that, see the excellent tutorial 
and reference 
.I
The C Programming Language*,
.R
by Brian Kernighan and Dennis Ritchie. 
.FS *
Englewood Cliffs: Prentice-Hall, 1978.
.FE
For more information about the basic concepts and 
software that underlie \*(x1 itself, see the
.I "\*(x2 Fundamentals"
manual.
.P
.H 2 "Manual Organization"
This manual is organized as follows:
.VL 11
.LI "CHAPTER~1:~Introduction"
.sp 1
The chapter you are now reading contains information about
the development of software on the \*(x1 system.
.LI "CHAPTER~2:~Xenix~Programming"
.sp 1
Discusses the standard \*(x1 environment
and how this environment can be accessed 
either from C or from assembly language. 
.LI "CHAPTER~3:~Software Tools"
.sp 1
Describes each of the tools that you
are likely to use either directly or indirectly, in 
programming on the \*(x1 system,
with emphasis on how the the software tools discussed in
this manual fit together.
.LI "CHAPTER~4:~Cc: The C Compiler"
.sp 1
Describes use of the \*(x1 C compiler,
.B cc . 
Also describes the preprocessing, linking, and
assembly stages in compiling C programs to create
executable files.
.LI "CHAPTER~5:~Lint: The C Program Checker"
.sp 1
Describes use of 
.B lint ,
the \*(x1 C program checker.
.B Lint
analyzes C program syntax and language usage, 
reporting anomalies to the user.
.LI "CHAPTER~6:~Make: A Program Maintainer"
.sp 1
Describes use of 
.B make ,
a program for controlling software generation,
update, and installation.
.LI "CHAPTER~7:~ADB: A Program Debugger"
.sp 1
Describes use of the debugger, ADB,
a program for debugging and analyzing programs.
.LI "CHAPTER~8:~As: The \*(x2 Assembler"
.sp 1
Describes how 
.B as ,
the \*(x1 assembler 
can be used to assemble machine language programs
and routines.
.LI "CHAPTER~9:~Lex: A Lexical Analyzer"
.sp 1
Describes use of 
.B lex ,
a lexical analyzer useful in reading input languages.
.LI "CHAPTER~10:~YACC: A Compiler-Compiler"
.sp 1
Describes use of YACC, a utility 
for creating language translators.
Useful in conjunction with 
.B lex .
.LI "APPENDIX~A:~The C Shell"
.sp 1
Describes use of the command interpreter 
called the 
.I C-shell .
The C-shell command language has a syntax similar to
that of the C programming language. It also
provides facilities for command aliasing and 
maintaining a command history.
.LI "APPENDIX~B:~M4"
.sp 1
Describes use of the macro preprocessor, M4.
.LI "APPENDIX~C:~C Program Portability"
.sp 1
Explains how to write C programs that are portable
across different processors and \*(x1 systems.
.LE 1
.H 2 "Notational Conventions"
.XX "notational conventions
Throughout this manual, the following notational 
conventions are used:
.VL 20
.LI "\fBboldface\fR"
.XX "boldface"
Command names are given in boldface
in the text of this manual;
no boldface occurs in displays, except in syntax specifications
for literal text.
For example, 
.B ls ,
.B date ,
and
.B cd
are all the names of commands that you might type at
the keyboard, and therefore all are in boldface.
.XX "Notational conventions"
An exception to this rule occurs for long chapters
about a single command.
In this case, the command name is made less conspicuous
by either underlining or capitalization.
.LI "\fIunderlining\fR"
.XX "underlining"
All filenames and pathnames are underlined.
For example, 
.FN text.file
is a filename
.XX "filenames"
and
.FN /usr/mary
is a pathname.
.XX "pathnames"
Most command arguments are underlined as well,
although in some cases these are in boldface.
Words and phrases also may be underlined for emphasis.
References to entries in the 
.I "\*(x2 Reference Manual"
are underlined and include a section number in parentheses.
For example, 
.IR ls (1)
refers to the entry for the
.B ls 
command in Section 1, 
.Q "Commands" .
.LI "[brackets]
.XX "brackets"
Brackets enclose optional arguments in syntax
specifications.
.LI "<angle-brackets>"
.XX "angle-brackets"
Angle brackets enclose the names of control characters
and special function keys.
Examples are 
.SM <CONTROL-D>,
.SM <CONTROL-S>,
.SM <RETURN>,
.SM <INTERRUPT>,
and
.SM <BKSP>.
.LI "ellipses\^.\^.\^."
.XX "ellipses"
Ellipses are used to indicate one or more entries of
an argument in a syntax specification.
For example, in the following syntax for the 
.B mail 
command, the ellipses indicate that
one or more persons can be sent mail:
.DS I
\fBmail\fP \fIperson\fP \fI.\^.\^.\fP
.DE
.LI "quotation marks"
.XX "quotation marks"
Quotation marks are used to set off multiple keystroke input. 
For example, 
.Q "ls \-la ; date"
is an example of a command line appearing in the body of the text.
.LE
.P
Common abbreviations for ASCII characters are listed below:
.XX "ASCII characters"
.VL 15 5
.LI "<ESC>"
Escape, Control-[
.LI "<RETURN>"
Carriage return, Control-M
.LI <LF>
Newline, Linefeed, Control-J
.LI <BKSP>
Backspace, Control-H
.LI <TAB>
Tab, Control-I
.LI <BELL>
Bell, Control-G
.LI <FF>
Formfeed, Control-L
.LI <SPACE>
Space, 20 hexadecimal 
.LI <DEL>
Delete, 7F hexadecimal
.LE
.rm Li 
.bp
.xp
.TC 2 1 5 0
