.ds :? CC: A C COMPILER
.nr H1 4
.PH "'CC''CC'"
.H 2 "Introduction"
.B Cc
is the command used to invoke the \*(x1 C compiler.
Since the entire \*(x1 system is written in the
C language, 
.B cc 
is the fundamental \*(x1 program development tool.
The emphasis in this chapter is on giving insight into
operation and use of the compiler.
Special emphasis is given to input and output files and
and to the available compiler options.
Familiarity with compilers and
with the C language is presumed.
For more information on programming in C, see
.I
The C Programming Language*, 
.R
by Brian W. Kernighan and Dennis M. Ritchie.
.FS *
Englewood Cliffs: Prentice-Hall, 1978.
.FE
.P
The basic function of the C compiler is to read 
.Q "source" 
files containing functions written in the C
language and translate these C functions into instructions
that can be understood and executed on the 
target microprocessor.
The compilation
process involves several distinct phases,
described below: 
.VL 10 1
.LI "Preprocessing"
.br
In this phase of compilation, your C source program is
examined for macro definitions and include file directives.
Any include files are processed at the point of the include
statement; occurrences of macros are expanded throughout
the text. Normally, standard include files found in the
.I /\|usr/\|include 
directory are included at the beginning
of C programs.  These standard include files are
normally
named with a 
.Q ".h"
extension. For example, the following
statement includes the definitions for functions in the
standard I/O library:
.DS I
#include <stdio.h>
.DE
Note that the angle brackets indicate the file is
presumed to exist in 
.I /\|usr/\|include .
The effects of preprocessing on a set of 
.Q .c 
files can be captured
in corresponding files with 
.Q \-i
extensions
by specifying the 
.B \-P
switch on the
.B cc 
command line.
The 
.B \-E 
switch performs a similar function, sending all
output to the standard output.
Both of these switches are useful for debugging 
when you suspect that an include
file or macro is not expanding as desired. 
.LI "Optimization"
.br
Optimization of generated code can be specified 
on the
.B cc 
command line with the 
.B \-O 
switch. 
This option should be used to increase execution speed
or to decrease the size of the executing program. 
Because programs will take longer to compile with this
option, you may want to use 
.B \-O
only after you have a working debugged program.
.LI "Generation of Assembly Source Code"
.br
The C compiler generates assembly source code that is 
later assembled by the \*(x1 assembler, 
.B as . 
.B Cc 's 
assembly output can be saved in a file by specifying
the 
.B \-S 
switch when the compiler is invoked. 
Assembly source output is saved in a file 
whose name has the 
.Q ".s"
extension.
.LI "Assembly"
.br
To assemble the generated assembly code,
.B cc 
calls 
.B as
to create a file whose name has the filename extension,
.I ".o" .
This 
.Q "dot-oh"
file is used in the next step, linking and loading.
.LI "Linking and Loading"
.br
The final phase in the compilation of a C program is
linking and loading.  
The program responsible for this is the \*(x1 loader,
.B ld .
Loader options can be specified on the 
.B cc
command line. 
These options are discussed later in this chapter in
the section on the loader.
The result of a successful link
is an executable file named
.FN a.out .
.LE
.P 
It is important to realize that all of the above phases
can be controlled at the 
.B cc 
command level; they do not have to be invoked separately.
What normally happens when you execute a 
.B cc 
command is that a sequence of programs processes the original
C source file.  
Each program creates a temporary file
that is used by the next program in the sequence.
The final output is the load image that is loaded into
memory when the final executable file is run.
.H 2 "Invocation Switches"
A list of some of the available switches follows.
Other switches are described in
.IR cc (1S).
.VL 10 1
.LI "\fB\-c\fR"
Suppress the loading phase of the compilation, 
and force an object file to be produced 
even if only one program is compiled.
.LI "\fB\-p\fR"
Arrange for the compiler to produce code
which counts the number of times each routine is called.
Also, if loading takes place, replace the standard startup
routine by one that automatically calls
.IR monitor (3)
at the start and arranges to write out a
.I mon.out
file at normal termination of execution of the object program.
An execution profile can then be generated by
use of
.IR  prof (1).
.LI "\fB\-O\fR"
Invoke an
object-code optimizer.
.LI "\fB\-S\fR"
Compile the named C programs, and leave the
assembler-language output on corresponding files suffixed 
.Q ".s" .
.LI "\fB\-P\fR"
Run only the macro preprocessor and place the result for
each 
.Q ".c"
file in a corresponding 
.Q ".i"
file.
The resulting file has no 
.Q "#"
lines in it.
.LI "\fB\-E\fR"
Run only the macro preprocessor and send the output
to the standard output.
The resulting output has no 
.Q "#"
lines in it
and is 
.I not
acceptable input to 
.B cc .
.LI \fB\-o\fR~~\fIoutput\fR
.br
Give the final output file
the name specified by 
.I output.
If this option is used the file 
.I a.out 
will be left undisturbed.
.LI \fB\-D\fR\fIname=def\fR
.br
Define the
.I name
to the compiler preprocessor,
as if with a
.Q "#define"
in the C source.
If no definition is given, then
.I name 
is assigned the value 1.
.LI \fB\-U\fR\fIname\fR
.br
Remove any initial definition of
.IR name .
.LI \fB\-I\fR\fIdir\fR
.br
Any 
.Q "#include"
files whose names do not begin with 
.Q "/"
and that are enclosed within angle brackets
are searched for, first in the directory of the
file being compiled,
then in directories named in 
.B \-I
options,
and finally in directories given by a standard list.
.LE 1
.P
Other arguments are taken
to be either loader option arguments, or C-compatible
object programs, typically produced by an earlier
.I cc
run,
or perhaps libraries of C-compatible routines
created with the assembler.
These programs, together with the results of any
compilations specified, are loaded (in the order
given) to produce an executable program with the name
.FN a.out.
.H 2 "The Loader"
The \*(x1 loader, 
.B ld ,
plays a fundamental role in the creation of any C program.
For this reason it is discussed as part of 
.B cc ;
however, it can be used as a stand-alone processor of object files.
Note that arguments to 
.B ld
can be given on the 
.B cc 
command line and are part of the syntax of the 
.B cc 
command.
.P
Some of the available loader switches are listed below. 
Except for
.BR \-l ,
they should appear before filename arguments.
Other switches are described in
.IR ld (1S).
.VL 10 1
.LI "\fB\-s\fR"
.Q "Strip"
the output, that is, remove the symbol table
and relocation bits to save space (but impair the
usefulness of the debugger).
This information can also be removed with
.IR strip (1S).
.LI "\fB\-u\fR"
Take the following argument as a symbol and enter
it as undefined in the symbol table.  This is useful
for loading wholly from a library, since initially the symbol
table is empty and an unresolved reference is needed
to force the loading of the first routine.
.LI "\fB\-l\fIx\fR"
This option is an abbreviation for the library name
.RI /lib/lib x .a,
where
.I x
is a string.
If the named library does not exist,
.I ld
tries
.RI /usr/lib/lib x .a .
A library is searched when its name is encountered,
so the placement of a
.B \-l
switch is significant.
.LI "\fB\-x\fR"
Do not preserve local
(non-.globl) symbols in the output symbol table: 
enter only external symbols.
This option saves some space in the output file.
.LI "\fB\-X\fR"
Save local symbols
except for those whose names begin with 
.Q "L" .
This option is used by
.IR cc 
to discard internally generated labels while
retaining symbols local to routines.
.LI "\fB\-n\fR"
Arrange that
when the output file is executed,
the text portion will be read-only and shared
among all users executing the file.
(This switch is not available on all systems.
If not, the 
.B \-i 
switch is available.)
.LI "\fB\-i\fR"
When the output file is executed, the program
text and data areas will live in separate address spaces.
(This switch is not available on all systems.
If not, the 
.B \-n 
switch is available.)
.LI "\fB\-o\fR"
The
.I name
argument after
.B \-o
is used as the name of the
.B ld
output file, instead of
.IR a.out .
.LE 1
.TC 2 1 5 0
