.ds :? ADB: A PROGRAM DEBUGGER
.nr H1 6
.PH "'ADB''ADB'"
.H 2 "Introduction"
ADB is an indispensable tool 
for debugging programs or crashed systems.
It allows you to look at
.FN core
files resulting from aborted programs, print output in a
variety of formats, patch files, and run programs
with embedded breakpoints.
This chapter is an introduction to ADB with examples of its use.
It explains the various formatting options, 
techniques for debugging C programs, and gives examples of printing
file system information, and of patching.
.H 2 "Invocation"
The ADB invocation syntax is as follows:
.DS I
\fBadb\fP \fIobjectfile\fP \fIcorefile\fP
.DE
.P
Here
.FN objectfile
is an executable \*(x1 file and 
.FN corefile 
is a core image file.
Often this will look like:
.DS I
adb a.out core
.DE
or more simply:
.DS I
adb
.DE
where the defaults are 
.FN a.out
and
.FN core ,
respectively.
The filename minus (\-) means ignore this argument as in:
.DS I
adb \- core
.DE
.P
ADB has requests for examining locations in either file.
A question mark (?) request examines the contents of 
.I objectfile;
a slash (/) request examines the 
.I corefile.
The general form of these requests is:
.DS I
.I
address\fB?\fPformat
.R
.DE
or
.DS I
.I
address\fB/\fPformat
.R
.DE
.H 2 "The Current Address \- Dot"
ADB maintains a pointer to the current address, called dot,
similar in function to the current pointer in the editor,
.IR ed (1).
When an address is entered, the current address 
is set to that location, so that:
.DS I
0126?i
.DE
sets dot to octal 126 and prints the instruction
at that address.
The request
.DS I
\&.,10/d
.DE
prints 10 decimal numbers starting at dot.
Dot ends up referring to the address of the last item printed.
When used with the question mark (?) or slash (/) request,
the current address can be advanced by typing a newline; 
it can be decremented by typing a caret (^).
.P
Addresses are represented by expressions.
Expressions are made up of decimal, octal, 
and hexadecimal integers, and symbols from the program under test.
These may be combined with the following operators:
.VL 8 2
.LI + 
Addition
.LI \- 
Subtraction
.LI *
Multiplication
.LI %
Integer division
.LI &
Bitwise AND 
.LI | 
Bitwise inclusive OR
.LI # 
Round up
to the next multiple
.tr ~~
.LI ~ 
Not
.LE
.P
Note that all arithmetic within ADB is 32-bit arithmetic.
When typing a symbolic address for a C program, type either
.Q "name"
or 
.Q "_name" ;
ADB recognizes both forms.
Because ADB will find only one instance of
.Q "name"
and 
.Q "_name" 
(generally the first to appear in the source)
one will mask the other if they both appear in the
same source file.
.H 2 "Formats"
To print data, you can specify a collection of letters and characters
that describe the format of the printout.
Formats are "remembered" in the sense that typing a request without one
will cause the new printout to appear in the previous format.
The following are the most commonly used format letters:
.P
.DS 
	Letter	Format
	------------------------------------------------
	\fBb	\fP1 byte in octal
	\fBc	\fP1 byte as a character
	\fBo	\fP1 word in octal
	\fBd	\fP1 word in decimal
	\fBx	\fP1 word in hexadecimal
	\fBf	\fP2 words in floating point
	\fBi	\fPmachine instruction
	\fBs	\fPa null terminated character string
	\fBa	\fPthe value of dot
	\fBu	\fPone word as unsigned integer
	\fBn	\fPprint a newline
	\fBr	\fPprint a blank space
	\fB^	\fPbackup dot
	------------------------------------------------
.DE
.P
(Format letters are also available for "long" values,
for example, 
.B D 
for long decimal, and 
.B F 
for double floating point.)
.H 2 "Requests"
The general form of a request is:
.DS I
.I
address,count command modifier
.R
.DE
which sets 
.Q "dot"
to 
.I address
and executes the command
.I count
times.
.P
The following table illustrates some general ADB command meanings:
.DS
	Command	Meaning
	-----------------------------------------
	?	Print contents from \fIa.out\fP file
	/	Print contents from \fIcore\fP file
	=	Print value of "dot"
	:	Breakpoint control
	$	Miscellaneous requests
	;	Request separator
	!	Escape to shell
	-----------------------------------------
.DE
.P
ADB catches signals, 
so a user cannot use a quit signal to exit from ADB.
The request $q or $Q (or 
.SM <CONTROL-D> )
must be used to exit from ADB.
.H 2 "Debugging C Programs"
The following subsections describe use of ADB in
debugging the C programs given in the numbered
figures at the end
of this chapter.
Refer to these figures as you work your way through
the examples.
.H 3 "Debugging a Core Image "
Consider the C program in Figure 1.
This program illustrates
a common error made by C programmers.
The object of the program is to change the
lowercase 
.Q "t"
to uppercase in the string pointed to by
.I charp
and then write the character string 
to the file indicated by argument 1.
The bug shown is that the character 
.Q "T"
is stored in the pointer 
.I charp
instead of the string pointed to by
.I charp.
Executing the program 
produces a core file because 
of an out-of-bounds memory reference.
(Note that a core file may not be produced
on all systems.)
.P
ADB is invoked by typing:
.DS I
adb a.out core
.DE
The first debugging request
.DS I
$c
.DE
is used to give a C backtrace through the
subroutines called.
As shown in Figure 2,
only one function,
.I main , 
was called and the arguments 
.I argc 
and 
.I argv 
have hex values 0x2 and
0xffa6 respectively.
Both of these values look
reasonable; 0x2 = two arguments, 
0xffa6 = address on stack
of parameter vector
(what appears to be a third argument is due to the
way the C initializer works).
These values may be different on your system
due to a different mapping of memory.
.P
The next request
.DS I
$r
.DE
prints out the registers including the program
counter and an interpretation of the instruction at that
location.
.P
The request:
.DS I
$e
.DE
prints out the values of all external variables.
.P
A map exists for each file handled by ADB.
The map for the
.I a.out
file is referenced with a question mark (?),
whereas the map for the
.FN core
file is referenced with a slash (/).
Furthermore, a good rule of thumb is to use 
question mark for
instructions and slash for data when looking at programs.
To print out information about the maps, type:
.DS I
$m
.DE
This produces a report of the contents of the maps.
.P
In our example, it is useful to see the
contents of the string pointed to by
.I charp.
This is done by typing
.DS I
*charp/s
.DE
which means use 
.I charp
as a pointer in the
.FN core
file and print the information as a character string.
This printout shows that the character buffer
was incorrectly overwritten and helps identify the error.
Printing the locations around 
.I charp
shows that the buffer is unchanged
but that the pointer is destroyed.
Similarly, we could print information about the
arguments to a function.
For example
.DS I
0xffa6,3/x
.DE
prints the hex values of the three consecutive
cells pointed to by 
.I argv
in the function 
.I main.
Note that these values are the addresses of the arguments
to main.
Therefore: 
.DS I
0xffb6,/s
.DE
prints the ASCII value of the first argument.
Another way to print this value would have been
.DS I
*"/s
.DE
The quotation mark (") means ditto, 
i.e., the last address typed, in this case 
.Q "0xffa6" ;
the star (*) instructs ADB to use the address field of the
.FN core 
file as a pointer.
.P
The request
.DS I
\&.=x
.DE
prints the current address in hex (and not its contents).
This has been set to the address of the first argument.
The current address, dot, is used by ADB to 
.Q "remember" 
its current location.
Dot allows the user 
to reference locations 
relative to the current address, for example:
.DS I
\&.\-10/d
.DE
.H 3 "Multiple Functions"
Consider the C program illustrated in Figure 3.
This program calls functions 
.Q "f" , 
.Q "g" ,
and
.Q "h"
until the stack is exhausted and a core image is produced.
.P
Again, enter ADB by typing
.DS I
adb
.DE
which assumes the names 
.FN a.out
and 
.FN core
for the executable
file and core image file, respectively.
The request
.DS I
$c
.DE
fills a page of backtrace references to 
.I "f" , 
.I "g" ,
and
.I "h" .
Figure 4 shows an abbreviated list.
Typing
.SM <INTERRUPT>
terminates the output and brings you back to the ADB request level.  
Additionally, some versions of ADB
will automatically quit 
after fifteen levels unless told otherwise
with the command:
.DS I
,levelcount$c
.DE
.P
The request
.DS I
,5$c
.DE
prints the five most recent activations.
.P
Notice that each function (
.I "f" , 
.I "g" ,
and 
.I "h" )
has a counter that counts the number of times each
has been called.
.P
The request
.DS I
fcnt/D
.DE
prints the decimal value of the counter for the function
.I f.
Similarly 
.Q "gcnt"
and
.Q "hcnt"
could be printed.
Notice that because 
.Q "fcnt" ,
.Q "gcnt" ,
and
.Q "hcnt"
are
.B int
variables, and on the 8086
.B int
is implemented as a 16-bit value,
to print its value you must use the d format.
.H 3 "Setting Breakpoints"
Consider the C program in Figure 5.
This program, which changes tabs into blanks, is adapted from
.I "Software\0Tools"*
.FS *
Reading: Addison and Wesley Publications, Inc.,
1976.
.FE
by Brian W. Kernighan and P.J. Plauger, pp. 18-27.
.P
We will run this program under the control of ADB (see Figure 6) 
by typing:
.DS I
adb a.out \-
.DE
Breakpoints are set in the program as:
.DS I
address:b  [request]
.DE
The requests
.DS I
settab+5:b
fopen+5:b
tabpos+5:b
.DE
set breakpoints at the start of these functions.
C does not generate statement labels.
Therefore, it is currently not possible 
to plant breakpoints at locations
other than function entry points without knowledge of the code
generated by the C compiler.
The above addresses are entered as
.DS I
symbol+5
.DE
so that they will appear in any
C backtrace, because the first few instructions 
of each function are used
to set up the local stack frame.
Note that some of the functions are from the C library.
.P
To print the location of breakpoints, type:
.DS I 
$b
.DE
The display indicates a
.I count
field.
A breakpoint is bypassed
.I count \-1
times before causing a stop.
The
.I command
field indicates the ADB requests 
to be executed each time the breakpoint is encountered.
In our example no
.I command
fields are present.
.P
By displaying the original instructions at the function
.I settab
we see that 
the breakpoint is set after the 
.B tstb 
instruction, which is the stack probe.
We can display the instructions using the ADB request:
.DS I
settab,5?ai
.DE
This request displays five instructions starting at
.I settab
with the addresses of each location displayed.
Another variation is
.DS I
settab,5?i
.DE
which displays the instructions with only the starting address.
.P
Note that we accessed the addresses from the 
.FN a.out 
file with the question (?) command.
In general, when asking for a printout of multiple items
ADB advances the current address the number of
bytes necessary to satisfy the request. 
In the above example, 
five instructions were displayed and 
the current address was advanced 18 (decimal) bytes.
.P
To run the program type:
.DS I
:r
.DE
To delete a breakpoint, for instance the entry to the function
.I settab,
type:
.DS I
settab+5:d
.DE
To continue execution of the program from the breakpoint type:
.DS I
:c
.DE
.P
Once the program has stopped (in this case at the breakpoint for
.I fopen),
ADB requests can be used to display the contents of memory.
For example
.DS I
$c
.DE
displays a stack trace or
.DS I
tabs,6/4x
.DE
prints six lines of four locations each from the array called
.Q tabs.
By this time (at location
.Q fopen )
in the C program,
.I settab
has been called and should have set a one in every eighth location of 
.Q tabs.
.P
The \*(x1 quit and interrupt signals
act on ADB itself rather than on the program being debugged.
If such a signal occurs 
then the program being debugged is stopped 
and control is returned to ADB.
The signal is saved by ADB and is passed on to the test program if
.DS I
:c
.DE
is typed.
This can be useful when testing interrupt handling routines.
The signal is not passed on to the test program if
.DS I
:c  0
.DE
is typed.
.H 3 "Other Breakpoint Facilities"
.BL
.LI 
Arguments and changes of standard input and output 
are passed to a program as:
.DS I
\fB:r\fP  \fIarg1\fP  \fIarg2\fP \fB...\
\fB<\fP\fIinfile\fP \fB>\fIoutfile\fR
.DE
This request kills any existing program under test and
starts the
.FN a.out
afresh.
.LI 
The program being debugged can be single-stepped
by typing:
.DS I
:s
.DE
If necessary, this request starts up the program being
debugged and stops after executing the first instruction.
.LI 
ADB allows a program to be executed beginning 
at a specific address by typing:
.DS I
address:r
.DE
.LI 
The count field can be used to skip the first 
.I n
breakpoints with:
.DS I
,n:r
.DE
The request
.DS I
,n:c
.DE
may also be used for skipping the first 
.I n
breakpoints when continuing a program.
.sp
.LI 
A program can be continued at an address different 
from the breakpoint by typing:
.DS I
address:c
.DE
.LI
The program being debugged runs 
as a separate process and can be killed by typing:
.DS I
:k
.DE
.LE
.H 2 "Maps"
\*(x2 supports several executable file formats.  
These are used to tell
the loader how to load  the program file.  
Nonshared program files
are the most common and are generated by a C compiler invocation 
such as:
.DS I
cc pgm.c
.DE
.P
A shared file is produced by 
a C compiler command line of the form 
.DS I
cc \-n pgm.c
.DE
.P
ADB interprets these different file formats and
provides access to the different segments 
through a set of maps.
To print the maps type:
.DS I
$m
.DE
.P
In nonshared files, both text (instructions) and data are intermixed.
This makes it impossible for ADB to differentiate data from
instructions and some of the printed symbolic addresses look incorrect;
for example, printing data addresses as 
offsets from routines.
.P
In shared text, 
the instructions are separated from data and the
.DS I
?* 
.DE
accesses the data part of the 
.FN a.out
file.
This request tells ADB 
to use the second part of the map in the
.FN a.out
file.
Accessing data in the 
.FN core 
file shows the data after it was modified 
by the execution of the program.
Notice also that the data segment 
may have grown during program execution.
In shared files the corresponding
.FN core 
file does not contain the program text.
.P
Figure 7 shows the display of three maps
for the same program linked as a nonshared and shared respectively.
The b, e, and f fields are used by ADB to map
addresses into file addresses.
The 
.Q "f1"
field is the
length of the header at the beginning of the file (0x34 bytes
for an 
.FN a.out
file and 02000 bytes for a 
.FN core
file).
The 
.Q "f2"
field is the displacement 
from the beginning of the file to the data.
For unshared files with mixed text and data this is the
same as the length of the header; for shared files this
is the length of the header plus the size of the text portion.
.P
The 
.Q "b"
and 
.Q "e"
fields are the starting and ending locations
for a segment.
Given an address, 
.Q "A" ,
the location in the file (either 
.FN a.out
or
.FN core )
is calculated as:
.DS I
b1\(<=A\(<=e1 =\h'-.5m'> file address = (A\-b1)+f1
b2\(<=A\(<=e2 =\h'-.5m'> file address = (A\-b2)+f2
.DE
A user can access locations by using the ADB defined variables.
The 
.DS I
$v 
.DE
request prints the variables initialized by ADB:
.DS I
b	base address of data segment
d	length of the data segment
s	length of the stack
t	length of the text
m	execution type
.DE
.P
In Figure 7 those variables not present are zero.
These variables can be used in expressions such as
.DS I
<b
.DE
in the address field.
Similarly the value of the variable can be changed 
by an assignment request
such as
.DS I
02000>b
.DE
which sets 
.Q "b"
to octal 2000.
These variables are useful to know if the file under examination
is an executable or 
.FN core
image file.
.P
ADB reads the header of the 
.FN core
image file to find the
values for these variables.
If the second file specified does not
seem to be a 
.FN core
file, or if it is missing, then the header of
the executable file is used instead.
.H 2 "Advanced Usage"
With ADB it is possible to combine formatting requests
to provide elaborate displays.
Below are several examples.
.H 3 "Formatted Dump"
The line 
.DS I
<b,\-1/4o4^8Cn
.DE
prints four octal words followed by their ASCII interpretation
from the data space of the core image file.
Broken down, the request pieces mean:
.VL 10 2
.LI "<b
The base address of the data segment.
.LI "<b,\-1"	
Print from the base address to the end-of-file.
A negative count is used here and elsewhere to loop indefinitely
or until some error condition (like end-of-file) is detected.
.LE
.P
The format 
.Q "4o4^8Cn"
is interpreted as follows:
.VL 10 2
.LI "4o"
Print four octal locations.
.LI "4^"
Backup the current address four locations 
(to the original start of the field).
.LI "8C"
Print eight consecutive characters using an escape convention;
each character in the range octal 0 to 037 
is printed as an at-sign (@) followed 
by the corresponding character in the range octal 0140 to 0177.
An at-sign is printed as 
.Q "@@" .
.LI "n"
Print a newline.
.LE
.P
The request:
.DS I
<b,<d/4o4^8Cn
.DE
could have been used instead to allow printing to stop
at the end 
of the data segment (<d provides the data segment size in bytes).
.P
The formatting requests can be combined with ADB's ability
to read in a script to produce a 
.FN core 
image dump script.
ADB is invoked with the command line
.DS I
adb a.out core < dump
.DE
to read in a script file
containing requests named
.FN dump.
An example of such a script is:
.DS I
120$w
4095$s
$v
=3n
$m
=3n"C Stack Backtrace"
$C
=3n"C External Variables"
$e
=3n"Registers"
$r
0$s
=3n"Data Segment"
<b,\-1/8ona
.DE
.P
The request 
.DS I
120$w 
.DE
sets the width of the output to 120 characters
(normally, the width is 80 characters).
ADB attempts to print addresses as:
.DS I
symbol + offset
.DE
The request 
.DS I
4095$s
.DE
increases the maximum permissible offset
to the nearest symbolic address from 255 (default) to 4095.
The equal sign request 
.RB ( = )
can be used to print literal strings.
Thus,
headings are provided in this
.I dump
program with requests such as:
.DS I
=3n"C Stack Backtrace"
.DE
This spaces three lines and prints the literal string.
The request 
.DS I
$v 
.DE
prints all nonzero ADB variables.
The request 
.DS I
0$s
.DE
sets the maximum offset for symbol matches to zero, thus
suppressing the printing of symbolic labels in favor
of octal values.
Note that this is only done for the printing of the data segment.
The request
.DS I
<b,\-1/8ona
.DE
prints a dump from the base of the data segment 
to the end-of-file
with an octal address field and eight octal numbers per line.
.P
Figure 9 shows the results of some formatting requests
on the C program of Figure 8.
.H 3 "Directory Dump"
Figure 10 illustrates another set of requests to dump
the contents of a directory (which is made up
of an integer 
.I inumber
followed by a 14-character name):
.DS I
adb dir \-
=n8t"Inum"8t"Name"
0,\-1? u8t14cn
.DE
In this example,
.Q u
prints the 
.I inumber 
as an unsigned decimal integer,
.Q "8t"
means that ADB will space to the next
multiple of 8 on the output line, and
.Q "14c"
prints the 14-character filename.
.H 3 "Ilist Dump"
Similarly the contents of the 
.I ilist
of a file system (e.g., 
.I /\^dev\^/\^src\^ )
can be dumped with the following set of 
requests:
.DS I
adb /dev/src \-
02000>b
?m <b
.if n \{\
<b,\-1?"flags"8ton"links,uid,gid"8t3bn",...
\&...size"8tbrdn"addr"8t8un"times"8t2Y2na
\}
.if t \{\
<b,\-1?"flags"8ton"links,uid,gid"8t3bn",size"8tbrdn"addr"8t8un"times"8t2Y2na
\}
.DE
.if n \{\
(Note that the two lines separated by ellipses should be
entered as one line with no intervening space. 
The line is broken here so that it will fit on the page.)\}
In this example the value of the base for the map was changed 
to 02000 by typing 
.DS I
?m<b  
.DE
since that is the start of an 
.I ilist 
within a file system.
The request
.Q "brd"
above was used 
to print the 24-bit size field
as a byte, a space, and a decimal integer.
The last access time and last modify time 
are printed with the 
.Q "2Y"
operator.
Figure 10 shows portions of these requests 
as applied to a directory and file system.
.H 3 "Converting Values"
ADB may be used to convert values from one representation to another.
For example
.DS I
072 = odx
.DE
prints
.DS I
072	58	#3a
.DE
which are the octal, decimal and hexadecimal representations
of 072 (octal).
The format is remembered so that typing
subsequent numbers prints them in the given formats.
Character values can be converted in a similar way; for example
.DS I
\&'a' = co
.DE
prints
.DS I
a	0141
.DE
It may also be used to evaluate expressions.
However, be forewarned
that all binary operators have
the same precedence, a precedence that is lower 
than that for unary operators.
.H 2 "Patching"
Patching files with ADB is accomplished with the 
.I write 
.RB ( w 
or 
.B W ) 
request. 
This is often used in conjunction with the 
.I locate,
.RB ( l
or
.B L )
request.
The request syntax for 
.B l
and 
.B w
are similar:
.DS I
?l value
.DE
The request 
.B l
is used to match on 2 bytes; 
.B L
is used for 4 bytes.
The request 
.B w
is used to write 2 bytes, whereas
.B W
writes 4 bytes.
The 
.I value
field in either 
.I locate
or
.I write
requests
is an expression.
Therefore, decimal and octal numbers, 
or character strings are supported.
.P
In order to modify a file, 
ADB must be called with the 
.B \-w 
switch:
.DS I
adb \-w file1 file2
.DE
When called with this option, 
.FN file1
and 
.FN file2
are created if necessary and opened for both reading and writing.
.P
For example, consider the C program shown in Figure 8.
We can change the word "This" to "The " in the executable file
for this program, 
.I ex7 , 
by using the following requests:
.DS I
adb \-w ex7 \-
?l \'Th\'
?W \'The\'
.DE
.P
The request 
.DS I
?l
.DE
starts at dot and stops at the first match of 
.Q "Th"
having set dot to the address of the location found.
Note the use of the question mark (?)
to write to the 
.FN a.out
file.
The form 
.DS I
?*
.DE
would have been used for a shared file.
.P
More frequently the 
request is typed as:
.DS I
?l 'Th'; ?s
.DE
This locates the first occurrence of 
.Q "Th"
and prints the entire string.
Execution of this request sets dot to the address of the 
characters
.Q "Th" .
.P
As another example of the utility of the patching facility,
consider a C program that has an internal logic flag.
The flag could be set by the user through ADB and the program run.
For example:
.DS I
adb a.out \-
:s arg1 arg2
flag/w 1
:c
.DE
The 
.Q ":s"
request is normally 
used to single-step through a process
or start a process in single-step mode.
In this case it starts
.FN a.out
as a subprocess
with arguments 
.I arg1 
and 
.I arg2.
If there is a subprocess running,
ADB writes to it rather than to the file
so the 
.B w
request causes 
.I flag
to be changed in the memory of the subprocess.
.H 2 "Notes"
Below is a list of some things that users should be aware of:
.AL 1
.LI 
Function calls and arguments are put on the stack by the C
.I save
routine.
Putting breakpoints at the entry point to routines
means that the function appears not to have been called
when the
breakpoint occurs.
.LI 
When printing addresses, ADB uses
either text or data symbols from the 
.FN a.out 
file.
This sometimes causes unexpected symbol names to be printed 
with data (e.g., 
.Q "savr5+022" ).
This does not happen if question mark (?)
is used for text (instructions)
and slash (/) for data.
.LI
Local variables cannot be addressed.
.LE 1
.bp
.H 2 "Figures"
.HU "Figure 1:  C program with pointer bug"
.DS
#include <stdio.h>
struct buf {
	int fildes;
	int nleft;
	char *nextp;
	char buff[512];
	}bb;
struct buf *obuf;

char *charp = "this is a sentence.";

main(argc,argv)
int argc;
char **argv;
{
	char	cc;
	FILE *file;

	if(argc < 2) {
		printf("Input file missing\en");
		exit(8);
	}

	if((file = fopen(argv[1],"w")) == NULL){
		printf("%s : can't open\en", argv[1]);
		exit(8);
	}
	charp = 'T';
printf("debug 1 %s\en",charp);
	while(cc=  *charp++)
		putc(cc,file);
	fflush(file);
}
.DE

.bp
.HU "Figure 2: ADB output for C program of figure 1"
.P
.DS I
.B $c
_main(0x2,0xffa6,0xffac)    from start+0xa7
.B $r
fl     0xf086        ip     0x12e  _main+0x78
cs     0x3000        ds     0x2000
ss     0x2000        es     0x2000
sp     0xff8e        bp     0xff98
si     0xff9c        di     0x10bf
ax     0x0           bx     0x54
cx     0xff4c        dx     0x0
_main+0x77:   inc    010202
.B $e
       fac:       0
       _errno:           0
       _end:      0
       __sobuf:    0
       _obuf:     0
       __lastbu:   0406
       __sibuf:    0
       __stkmax:   0
       Iscadr:           02
       __iob:     01664
       _edata:           0
       _charp:           0124
       _environ:   0177672
       _bb:       0
       Isgadr:           04
.B $m
? map      \`a.out\'
b1 = 0             e1       = 010600        f1 = 040
b2 = 0             e2       = 0             f2 = 010640
/ map      \`\-\'
b1 = 0             e1       = 0100000000    f1 = 0
b2 = 0             e2       = 0             f2 = 0
.B *charp/s
0124:
.B 0xffa6,3/x
0177646:      0xffb6        0x2ffbc              0x0
.B 0xffb6/s
0177666:      a.out
.B .=x
              0xffb6
.B .\-10/d
07777646:     \-64
.B $q
.DE
.bp
.HU "Figure 3:  Multiple function C program "
.DS
int	fcnt,gcnt,hcnt;
h(x,y)
{
	int hi; register int hr;
	hi = x+1;
	hr = x-y+1;
	hcnt++ ;
	hj:
	f(hr,hi);
}
.sp 2
g(p,q)
{
	int gi; register int gr;
	gi = q-p;
	gr = q-p+1;
	gcnt++ ;
	gj:
	h(gr,gi);
}
.sp 2
f(a,b)
{
	int fi; register int fr;
	fi = a+2*b;
	fr = a+b;
	fcnt++ ;
	fj:
	g(fr,fi);
}
.sp 2
main()
{
	f(1,1);
}
.DE
.bp
.HU "Figure 4:  ADB output for C program of Figure 3"
.P
.DS I
.B adb
.B $c
_f(0x2,0x39)	from _h+0x1c
_h(0x38,0x37)	from _g+0x1e
_g(0x39,0x70)	from _f+0x1f
_f(0x2,0x37)	from _h+0x1c
_h(0x36,0x35)	from _g+0x1e
_g(0x37,0x6c)	from _f+0x1f
_f(0x2,0x35)	from _h+0x1c
_h(0x34,0x33)	from _g+0x1e
_g(0x35,0x68)	from _f+0x1f
_f(0x2,0x33)	from _h+0x1c
_h(0x32,0x31)	from _g+0x1e
_g(0x33,0x64)	from _f+0x1f
_f(0x2,0x31)	from _h+0x1c
_h(0x30,0x2f)	from _g+0x1e
.B \s-2<INTERRUPT>\s0
adb
.B ,5$c
_f(0x2,0x39)	from _h+0x1c
_h(0x38,0x37)	from _g+0x1e
_g(0x39,0x70)	from _f+0x1f
_f(0x2,0x37)	from _h+0x1c
_h(0x36,0x35)	from _g+0x1e
.B fcnt/d
04024:		29
.B gcnt/d
04020:		29
.B hcnt/d
06032:		29
.B $q
.DE
.bp
.HU "Figure 5:  C program to decode tabs"
.P
.DS
#include <stdio.h>
#define MAXLINE	80
#define YES		1
#define NO		0
#define TABSP		8
char	input[] = "data";
char	ibuf[518];
int	tabs[MAXLINE];
.sp 2
main()
{
	int col, *ptab;
	char c;

	ptab = tabs;
	settab(ptab);	/*Set initial tab stops */
	col = 1;
	if(fopen(input,ibuf) < 0) {
		printf("%s : not found\en",input);
		exit(8);
	}
	while((c = getch(ibuf)) != -1) {
		switch(c) {
			case '\et':	/* TAB */
				while(tabpos(col) != YES) {
					/* put BLANK */
					putchar(' ');
					col++ ;
				}
				break;
			case '\en':	/*NEWLINE */
				putchar('\en');
				col = 1;
				break;
			default:
				putchar(c);
				col++ ;
		}
	}
}
.sp 2
/* Tabpos return YES if col is a tab stop */
tabpos(col)
int col;
{
	if(col > MAXLINE)
		return(YES);
	else
		return(tabs[col]);
}
.sp 2
/* Settab - Set initial tab stops */
settab(tabp)
int *tabp;
{
	int i;

	for(i = 0; i<= MAXLINE; i++) 
		(i%TABSP) ? (tabs[i] = NO) : (tabs[i] = YES);
}
.sp 2
/* getch(ibuf) - Just do a getc call, but not a macro */
getch(ibuf)
FILE *ibuf;
{
	return(getc(ibuf));
}
.DE
.bp
.HU "Figure 6:  ADB output for C program of Figure 5"
.P
.DS 
.B adb
.B settab+5:b
.B fopen+5:b
.B getch+5:b
.B tabpos+5:b
.B $b
breakpoints
count	bkpt		command
1	_tabpos+0x5
1	_getch+0x5
1	_fopen+0x5
1	_settab+0x5
.B settab,5?ia
_settab:	push	bp
_settab+0x1:	mov	bp,sp
_settab+0x3:	push	di
_settab+0x4:	push	si
_settab+0x5:	jmp	_settab+0x48
_settab+0x8:
.B settab,5?i
_settab:	push	bp
		mov	bp,sp
		push	di
		push	si
		jmp	_settab+0x48
.B :r
a.out: running
breakpoint	_settab+0x5:	jmp	_settab+0x48
.B settab+5:d
.B :c
a.out: running
breakpoint	_fopen+0x5:	call	__findio
.B $c
_fopen(0x1262,0x1886)	from _main+0x21
_main(0x1,0xffa4,0xffa8)	from start+0xa7
.B tabs,6/4x
013746:		0x1	0x0	0x0	0x0	0x0	0x0	0x0	0x0
		0x1	0x0	0x0	0x0	0x0	0x0	0x0	0x0
		0x1	0x0	0x0	0x0	0x0	0x0	0x0	0x0
.B $q
.DE
.bp
.HU "Figure 7:  ADB output for maps"
.P
.DS I
.B adb a.out
.B $m
? map	    \`a.out\'
b1 = 0		     e1	= 03700		  f1 = 040
b2 = 0		     e2	= 0		  f2 = 03740
/ map	    \`\-\'
b1 = 0		     e1	= 0100000000	  f1 = 0
b2 = 0		     e2	= 0		  f2 = 0
.B $v
variables
m = 01006
t = 03700
.B $q
.DE
.bp
.HU "Figure 8:  Simple C program illustrating formatting and patching"
.P
.DS
char	str1[]	= "This is a character string";
int	one	= 1;
int	number	= 456;
long	lnum	= 1234;
float	fpt	= 1.25;
char	str2[]	= "This is the second character string";
main()
{
	one = 2;
}
.DE
.bp
.HU "Figure 9:  ADB output illustrating fancy formats"
.P
.DS
.B "adb a.out.shared core.shared"
.B 0,8/8ona
0:            0      04     030000 02     030000 0      0      0

fac+0x6:      0      064124 071551 064440 020163 020141 064143 071141

_str1+0xe:    061541 062564 020162 072163 064562 063556 0      01

_number:
_number:      0710   0      02322  0      037640 064124 071551 064440

_str2+0x6:    020163 064164 020145 062563 067543 062156 061440 060550

_str2+0x16:   060562 072143 071145 071440 071164 067151 0147   01442

__iob+0x2:    0      01442  01     0      0      0      0402   0

__iob+0x12:   0      0      01006  0      0      0      0      0

__iob+0x22:
.B 0,20/4o4^8Cn
0:            0      04     030000 02     @\`@\`@d@\`@\`0@b@\`
              030000 0      0      0      @\`0@\`@\`@\`@\`@\`@\`
              0      064124 071551 064440 @\`@\`This i
              020163 020141 064143 071141 s a char
              061541 062564 020162 072163 acter st
              064562 063556 0      01     ring@\`@\`@a@\`

_number:      0710   0      02322  0      H@a@\`@\`R@d@\`@\`
              037640 064124 071551 064440  ?This i
              020163 064164 020145 062563 s the se
              067543 062156 061440 060550 cond cha
              060562 072143 071145 071440 racter s
              071164 067151 0147   01442  tring@\`"@c
              0      01442  01     0      @\`@\`"@c@a@\`@\`@\`
              0      0      0402   0      @\`@\`@\`@\`@b@a@\`@\`
              0      0      01006  0      @\`@\`@\`@\`@f@b@\`@\`
              0      0      0      0      @\`@\`@\`@\`@\`@\`@\`@\`
              0      0      0      0      @\`@\`@\`@\`@\`@\`@\`@\`
              0      0      0      0      @\`@\`@\`@\`@\`@\`@\`@\`
              0      0      0      0      @\`@\`@\`@\`@\`@\`@\`@\`
              0      0      0      0      @\`@\`@\`@\`@\`@\`@\`@\`
.B 0,20/4o4^8t8Cna
0:            0      04     030000 02            @\`@\`@d@\`@\`0@b@\`
Iscadr+0x2:   030000 0      0      0             @\`0@\`@\`@\`@\`@\`@\`
fac+0x6:      0      064124 071551 064440        @\`@\`This i
_str1+0x6:    020163 020141 064143 071141        s a char
_str1+0xe:    061541 062564 020162 072163        acter st
_str1+0x16:   064562 063556 0      01            ring@\`@\`@a@\`
_number:
_number:      0710   0      02322  0             H@a@\`@\`R@d@\`@\`
_fpt+0x2:     037640 064124 071551 064440         ?This i
_str2+0x6:    020163 064164 020145 062563        s the se
_str2+0xe:    067543 062156 061440 060550        cond cha
_str2+0x16:   060562 072143 071145 071440        racter s
_str2+0x1e:   071164 067151 0147   01442         tring@\`"@c
__iob+0x2:    0      01442  01     0             @\`@\`"@c@a@\`@\`@\`
__iob+0xa:    0      0      0402   0             @\`@\`@\`@\`@b@a@\`@\`
__iob+0x12:   0      0      01006  0             @\`@\`@\`@\`@f@b@\`@\`
__iob+0x1a:   0      0      0      0             @\`@\`@\`@\`@\`@\`@\`@\`
__iob+0x22:   0      0      0      0             @\`@\`@\`@\`@\`@\`@\`@\`
__iob+0x2a:   0      0      0      0             @\`@\`@\`@\`@\`@\`@\`@\`
__iob+0x32:   0      0      0      0             @\`@\`@\`@\`@\`@\`@\`@\`
__iob+0x3a:   0      0      0      0             @\`@\`@\`@\`@\`@\`@\`@\`
__iob+0x42:
.B 0,10/2b8t^2cn
0:            0      0

Isgadr:              04     0             
              0      060           0

Iscadr:              02     0             
              0      060           0

fac:          0      0
              0      0
              0      0
              0      0

_str1:        0124   0150          Th
.B $q
.DE
.bp
.HU "Figure 10:  Directory and inode dumps"
.P
.DS
.B
adb dir \-
=nt"Inode"t"Name"
0,\-1?ut14cn
.R

                Inode   Name
0:              652     .
                82      ..
                5971    cap.c
                5323    cap
                0       pp
.sp 4
.B
adb /dev/src \-
.B
02000>b
?m<b
.R
new map     \`/dev/src\'
b1 = 02000           e1 = 0100000000      f1 = 0
b2 = 0               e2 = 0               f2 = 0
.B $v
variables
b = 02000
.B
.if n \{\
<b,\-1?"flags"8ton"links,uid,gid"8t3bn"
size"8tbrdn"addr"8t8un"times"8t2Y2na 
(type above two lines all on one line)\}
.if t \{\
<b,\-1?"flags"8ton"links,uid,gid"8t3bn"size"8tbrdn"addr"8t8un"times"8t2Y2na\}
.R
02000:  flags 073145
        links,uid,gid 0163  0164    0141
        size  0162    10356
        addr  28770   8236  25956 27766 25455 8236  25956 25206
        times 1976 Feb 5 08:34:56     1975 Dec 28 10:55:15

02040:  flags 024555
        links,uid,gid 012   0163  0164
        size  0162    25461
        addr  8308    30050 8294  25130 15216 26890 29806 10784
        times 1976 Aug 17 12:16:51    1976 Aug 17 12:16:51

02100:  flags 05173
        links,uid,gid 011   0162  0145
        size  0147    29545
        addr  25972   8306  28265 8308  25642 15216 2314  25970
        times 1977 Apr 2 08:58:01     1977 Feb 5 10:21:44
.DE
.bp
.H 2 "ADB Summary"
.if t .2C
.H 3 "Command Summary"
.VL 0
.LI "Formatted printing"
.VL 25 5
.LI "\fB? \fIformat\fR" 
print from \fIa.out\fR file according to \fIformat\fR
.LI "\fB/ \fIformat\fR" 
print from \fIcore\fR file according to \fIformat\fR
.LI "\fB= \fIformat\fR" 
print the value of \fIdot\fR
.LI "\fB?w\fR expr"
write expression into \fIa.out\fR file
.LI "\fB/w\fR expr"
write expression into \fIcore\fR file
.LI "\fB?l\fR expr"
locate expression in \fIa.out\fR file
.LE 1
.LI "Breakpoint and program control"
.P
.DS I
\fB:b\fR	set breakpoint at \fIdot\fR
\fB:c\fR	continue running program
\fB:d\fR	delete breakpoint
\fB:k\fR	kill the program being debugged
\fB:r\fR	run \fIa.out\fR file under ADB control
\fB:s\fR	single step
.DE
.LI "Miscellaneous printing"
.P
.DS I
\fB$b\fR	print current breakpoints
\fB$c\fR	C stack trace
\fB$e\fR	external variables
\fB$f\fR	floating registers
\fB$m\fR	print ADB segment maps
\fB$q\fR	exit from ADB
\fB$r\fR	general registers
\fB$s\fR	set offset for symbol match
\fB$v\fR	print ADB variables
\fB$w\fR	set output line width
.DE
.LI "Calling the shell"
.DS I
\fB!\fR	call \fIshell\fP to read rest of line
.DE
.LI "Assignment to variables"
.P
.DS I
\fB>\fIname\fR	assign dot to variable or register \fIname\fR
.DE
.LE
.bp
.H 3 "Format Summary"
.DS I
\fBa	\fRthe value of dot
\fBb	\fRone byte in octal
\fBc	\fRone byte as a character
\fBd	\fRone word in decimal
\fBf	\fRtwo words in floating point
\fBi	\fRmachine instruction
\fBo	\fRone word in octal
\fBn	\fRprint a newline
\fBr	\fRprint a blank space
\fBs	\fRa null terminated character string
\fIn\fBt	\fRmove to next \fIn\fR space tab
\fBu	\fRone word as unsigned integer
\fBx	\fRhexadecimal
\fBY	\fRdate
\fB^	\fRbackup dot
\fB"..."\fR	print string
.DE
.H 3 "Expression Summary"
.VL 0
.LI "Expression components"
.P
.DS I
\fBdecimal integer	\fRe.g., 256
\fBoctal integer	\fRe.g., 0277
\fBhexadecimal	\fRe.g., #ff
\fBsymbols   	\fRe.g., flag  _main  main.argc
\fBvariables	\fRe.g., <b
\fBregisters	\fRe.g., <pc <r0
\fB(expression)	\fRexpression grouping
.DE 1
.LI "Dyadic operators"
.P
.DS I
\fB+\fP	add
\fB\(mi\fP	subtract
\fB*\fP	multiply
\fB%\fP	integer division
\fB&\fP	bitwise and
\fB|\fP	bitwise or
\fB#\fP	round up to the next multiple
.DE 1
.LI "Monadic operators"
.P
.tr ~~
.DS I
\s+2\fB~\fP\s0	not
\fB*\fR	contents of location
\fB\(mi\fR	integer negation
.DE
.LE
.fi
.tr ~ 
.TC 2 1 5 0
