.ds :? AS: AN ASSEMBLER
.nr H1 8
.PH "'As''As'"
.H 2 "Introduction"
This document describes the usage and input syntax
of the \*(x1 8086 assembler,
.B as ,
an assembler that
produces an output file containing
relocation information and a complete symbol table.
The output is acceptable to the \*(x1 loader
.IR ld (1S), 
which may be used to combine the outputs of several
assembler runs and to obtain
object programs from libraries.
The output format has been designed
so that if a program contains no unresolved
references to external symbols, it is executable
without further processing.
.P
This chapter does not teach assembly language
programming, nor does it give a detailed description
of 8086 operation codes.
For information on these topics, you will need other
references.
.H 2 "Command Usage"
.B As 
is invoked as follows:
.DS I
.B
as [ -l ] [ -o \fIoutput\fP ] \fIfile\fR
.R
.DE
If the optional 
.B \-l
argument is given, an assembly listing is produced
which includes the source, the assembled (binary)
code, and any assembly errors.  
This name of the listing file has an
.Q .L
extension.
.P
The output of the assembler is by default placed on
the file 
.I a.out 
in the current directory;
The 
.B \-o 
flag causes the output to be placed on the named file.
.H 2 "Lexical Conventions"
Assembler tokens include 
identifiers (alternatively, \*`symbols\*' or \*`names\*'),
constants, and operators.
.H 3 "Identifiers"
An identifier consists of a sequence 
of alphanumeric characters (including
period 
.Q \|\fB.\fR\|
and underscore 
.Q \|\fB\(ul\fR
as alphanumeric)
of which the first may not
be numeric.
Only the first eight characters are significant.  The case of
alphabetics in identifiers is significant.
.H 3 "Constants"
A hex constant consists of a backslash character (/)
followed by a sequence of digits and
one of the letters 
\*`a\*', \*`b\*', \*`c\*',
\*`d\*', \*`e\*', and \*`f\*' 
(any of which may be capitalized).
The letters are interpreted with the
following values:
.DS I
HEX	DECIMAL
a	10
b	11
c	12
d	13
e	14
f	15
.DE
.P
.tr ~~
An octal constant consists of a series of digits,  
preceded by the tilde character.  
.tr ~ 
The digits must be in the range 0-7.
.P
A decimal constant consists simply of a sequence of digits. 
The magnitude of the constant should be
representable in 15 bits; i.e., be less than 32,768.
.H 3 "Blanks"
Blank and tab characters
may be freely interspersed between tokens, but may
not be used within tokens (except in character constants).
A blank or tab is required to separate adjacent
identifiers or constants not otherwise separated.
.H 3 "Comments"
The vertical bar (\||\|) introduces a comment, which extends
to the end of the line on which it appears.
Comments are ignored by the assembler.
.H 2 "Segments"
Assembled code and data
fall into three segments:
the 
.I text 
segment, 
the 
.I data
segment, and the 
.I bss
segment.
The 
.I text 
segment is the one in which the assembly begins,
and it is the one into which instructions are typically placed.
The \*(x1 system will, if desired,
enforce the purity of the text segment of programs by
trapping write operations into it.
Object programs produced by the assembler must be processed
by the link editor 
.IR ld (1S)
(using its 
.B \-i
flag)
if the text segment is to be write-protected.
A single copy of the text
segment is shared among all processes
executing such a program.
.P
The data segment is available for storing
data or instructions that may
be modified during execution.
Anything that may be stored in the text segment may be put
into the data segment.
In programs with write-protected, shareable text segments,
the data segment contains the initialized but variable
parts of a program.
If the text segment is not pure, the data segment begins
immediately after the text segment.
If the text segment is pure, the data segment is in an
address space of its own, starting at location zero (0).
.P
The bss 
segment may not contain any explicitly initialized code
or data.
The length of the bss segment (like that of text or data)
is determined by the high-water mark of the location counter
within it.
The bss segment is actually an extension of
the data segment and begins immediately after it.
At the start of execution of a program, the bss 
segment is set to 0.
The advantage in using the bss segment
for storage that starts off empty is that the initialization
information need not be stored in the output file.
For more information, 
see the discussion of the 
.B bss
directive.
.H 2 "The Location Counter"
The special symbol, \*`dot\*' (\|.\|), is the location counter.
Its value at any time is the offset
within the appropriate segment from the start of
the statement in which it appears.
The location counter may be assigned to,
with the restriction that the
current segment may not change.
Furthermore,
the value of dot may not decrease.
If the effect of the assignment is 
to increase the value of dot, then
the required number of null bytes is generated.
.H 2 "Statements"
A source program is composed of a sequence of statements.
Statements are separated by newlines.
There are four kinds of statements: 
.VL 10 5
.LI "null statements"
.LI "expression statements"
.LI "assignment statements"
.LI "keyword statements"
.LE
.P
The format for most 8086 assembly language source statements is:
.DS I
.B
[\fIlabelfield\fP] op-code [\fIoperandfield\fP] [\fIcomment\fP]
.R
.DE
Any kind of statement may be preceded by one or more labels.
.H 3 "Labels"
There are two kinds of labels:
name labels and numeric labels.
A name label consists of an identifier followed
by a colon (\|:\|).
The effect of a name label is to assign the current
value and type of the location counter to the name.
An error is indicated in pass 1 if the
name is already defined;
an error is indicated in pass 2 if the
value assigned changes the definition
of the label.
.P
A numeric label consists of a string of 
digits 0 to 9 and a dollar-sign (\|$\|)
followed by a \fIcolon\fR (\|:\|). 
Such a label serves to define local
symbols of the form 
.DS I
\fIn\fR\|$\|
.DE
where 
.I n
is the digit of the label.
The scope of the numeric label is the labeled block in
which it appears.  As an example, the label \*`9$\*' is
defined only between the labels 
.I label1
and 
.I label2 :
.DS I
label1:
9$:	  .byte 0
	  .
	  .
	  .
label2:	  .word a
.DE
As in the case of name labels, a numeric label assigns
the current value and type of dot to the symbol.
.H 3 "Null statements"
A null statement is an empty statement 
(which may, however, have labels and a comment).
A null statement is ignored by the assembler.
Common examples of null statements are empty
lines or lines containing only a label.
.H 3 "Expression statements"
An expression statement consists of an arithmetic
expression not beginning with
a keyword.
The assembler computes its
value
and places it in the output stream, together with the
appropriate relocation bits.
.H 3 "Assignment statements"
An assignment statement consists of an identifier, 
an equal sign (\|=\|),
and an expression.
The value and type of the expression are assigned to
the identifier.
It is not required that the type or value be
the same in pass 2 as in pass 1, nor is it an
error to redefine any symbol by assignment.
.P
Any external attribute of an expression is lost across an assignment.
This means that it is not possible to declare a global
symbol by assigning to it, and that it is impossible
to define a symbol to be offset from a nonlocally
defined global symbol.
.P
As mentioned,
it is permissible to assign to the
location counter.
It is required, however, that the type of
the expression assigned be of the same type
as dot,
and it is forbidden to decrease the value
of dot.
In practice, 
the most common assignment to dot has the form
.DS I
\&.\|=\|.\|+\|\fIn\fR
.DE
for some number 
.I n ;
this has the effect of generating
.I n 
null bytes.
.H 3 "Keyword statements"
Keyword statements are numerically the most common type,
since most machine instructions are of this sort.
A keyword statement begins with one of the many predefined
keywords of the assembler;
the syntax of the remainder depends on the keyword.
All the keywords are listed below with the syntax they require.
.H 2 "Expressions"
An expression is a sequence of symbols representing a value.
Its constituents are identifiers, constants, and operators.
Each expression has a type.
.P
Arithmetic
is two's complement.  
All operators have equal precedence, and expressions
are evaluated
strictly left to right.
.H 3 "Expression operators"
The operators are:
.DS I
Operator	Description

  (blank)	Same as +
  +		Addition
  \-		Subtraction
  *		Multiplication
  /		Division
  ^		Logical OR
  &&		Logical AND
  !!		Logical NOT
  >		Right Shift
  <		Left Shift 
.DE
.H 3 "Types"
The assembler deals with expressions, each
of which may be of a different 
.I type .
Most types
are attached to the keywords and are used to select the
routine which treats that keyword.  The types likely
to be met explicitly are:
.VL 10 1
.LI undefined 
.br
Upon first encounter, each symbol is undefined.
It may become undefined if it is assigned an undefined expression.
.LI "undefined external"
.br
A symbol which is declared 
.B \&.globl 
but not defined
in the current assembly is an undefined
external.
If such a symbol is declared, the link editor 
.IR ld (1S)
must be used to load the assembler's output with
another routine that defines the undefined reference.
.LI absolute 
.br
An absolute symbol is defined ultimately from a constant.
Its value is unaffected by any possible future applications
of the link-editor to the output file.
.LI text 
.br
The value of a text symbol is measured
with respect to the beginning of the text segment of the program.
If the assembler output is link-edited, its text
symbols may change in value
since the program need
not be the first in the link editor's output.
Most text symbols are defined by appearing as labels.
At the start of an assembly, the value of dot is text 0.
.LI "data" 
.br
The value of a data symbol is measured
with respect to the origin of the data segment of a program.
Like text symbols, the value of a data symbol may change
during a subsequent link-editor run,
since previously loaded programs may have data segments.
After the first \fI.data\fR statement, 
the value of dot is data 0.
.LI "bss"
.br
The value of a bss symbol is measured from
the beginning of the 
bss segment of a program.
Like text and data symbols, the value of a bss symbol
may change during a subsequent link-editor
run, since previously loaded programs may have bss segments.
After the first 
.B \&.bss 
statement, 
the value of dot is bss 0.
.LI "external absolute, text, data, or bss"
.br
Symbols declared 
.B .globl
but defined within an assembly as absolute, 
text, data, or bss
symbols may be used exactly as if they were not
declared 
.B .globl ; 
however, 
their value and type are available
to the link editor so that the program may be loaded with others
that reference these symbols.
.LI "other types"
.br
Each keyword known to the assembler has a type that
is used to select the routine which processes
the associated keyword statement.
The behavior of such symbols
when not used as keywords is the same as if they were absolute.
.LE
.H 3 "Type Propagation in Expressions"
When operands are combined by expression operators,
the result has a type that depends on the types
of the operands and on the operator.
The rules involved are complex, but
are intended to be sensible and predictable.
For purposes of expression evaluation the
important types are:
.DS I
undefined
absolute
text
data
bss
undefined external
other
.DE
The combination rules are as follows:
.BL 1
.LI
If one of the operands is undefined, the result is undefined.
.LI
If both operands are absolute, the result is absolute.
.LI
If an absolute is combined with one of the other types
mentioned above, the result has the other type.
.LI
If two operands of other type are combined,
the result has the numerically larger type.  
.LI
An other type combined with an explicitly
discussed type other than absolute acts like an absolute.
.LE
.P
Further rules applying to particular operators
are:
.VL 5 1
.LI +
If one operand is text-, data-, or bss-segment
relocatable, or is an undefined external,
the result has the postulated type and the other operand
must be absolute.
.LI \-
If the first operand is a relocatable
text-, data-, or bss-segment symbol, the second operand
may be absolute (in which case the result has the
type of the first operand);
or the second operand may have the same type
as the first (in which case the result is absolute).
If the first operand is external undefined, the second must be
absolute.
All other combinations are illegal.
'/"	.LI ^
./"	This operator follows no other rule than
'/"	that the result has the value
'/"	of the first operand and the type of the second.
.P
.LI others
.br
It is illegal to apply these operators to any but absolute
symbols.
.LE
.H 2 "Assembler Directives"
.B As
supports a number of assembler directives (also called 
.Q "Pseudo-operations" 
or 
.Q pseudo-ops ).
The keywords listed below introduce
statements that
'/"	generate data in unusual forms or
influence the later operations of the assembler.
The metanotation
.DS I
.B
[ \fIitem\fP ] ...
.R
.DE
means that 0 or more instances of the given 
.I item 
may appear.
Also, boldface tokens are literals, italic words
are substitutable.
.H 3 ".even"
If the location counter is odd, 
it is advanced by one
so the next statement will be assembled
at a word boundary.  
This is useful for forcing storage allocation
to be on a word boundary after a 
.B .byte 
or 
.B .ascii
directive.
.H 3 ".float, .double"
.DS I
.B
\&.float	\fIfloat\fR
.R
.DE
The 
.B .float 
pseudo operation 
accepts as its operand an optional string of tabs and spaces,
then an optional sign, then a string of digits optionally containing a
decimal point, them an optional \*`e\*' or \*`E\*', 
followed by an
optionally signed integer.  
The string is interpreted as a floating point number.  
The difference between 
.B .float 
and
.B \&.double
is in the number of bytes for the result.  
The
.B .float
sets aside four bytes, while 
.B .double
sets aside eight bytes.
.H 3 ".globl"
.DS I
.B
\&.globl  \fIname\fP  [ , \fIname\fP]  ...
.R
.DE
.P
This statement makes the 
.I names 
external.
If they are otherwise defined (by assignment or
appearance as a label)
they act within the assembly exactly as if
the 
.B .globl
statement were not given; however,
the link editor 
.IR ld (1S)
may be used to combine this routine with other routines that refer
to these symbols.
.P
Conversely, if the given symbols are not defined
within the current assembly, the link editor
can combine the output of this assembly
with that of others which define the symbols.
It is possible to force
the assembler to make all otherwise
undefined symbols external.
.H 3 ".text, .data, .bss"
These three pseudo-operations cause the
assembler to begin assembling into the text, data, or
bss segment, respectively.
Assembly starts in the text segment.
It is forbidden to assemble any
code or data into the bss segment, but symbols may
be defined and dot
moved about by assignment.
.H 3 ".comm"
The format of the 
.B .comm 
statement is
.DS I
\&.comm	ARRAY
.DE
.P
Provided the 
.I name
is not defined elsewhere,
this statement is equivalent to
.B \&.globl .  
That is, the type of 
.I name
is \*`undefined external\*', and its size is 
.I expression .
In fact the 
.I name 
behaves in the current assembly just like an undefined external.
However, the link-editor 
.I ld 
has been special-cased
so that all external symbols that are not
otherwise defined, and that have a nonzero
value, are defined to lie in the bss
segment, and enough space is left after the
symbol to hold 
.I expression
bytes.
All symbols which become defined in this way
are located before all the explicitly defined
bss-segment locations.
.H 3 ".insrt"
The format of a 
.B .insrt
is:
.DS I
.B
\&.insrt "\fIfilename\fP"
.R
.DE
.P
where 
.I filename 
is any valid \*(x1 filename.  
Note that the 
.I filename 
must be enclosed within double quotation marks.
.P
The assembler attempts to open this file for input.  
If it succeeds, 
source lines are read from it until the end of file
is reached.  
If
.B as
is unable to open the file, the following error message is printed:
.DS I
Cannot open insert file
.DE
.P
This statement is useful for including 
a standard set of comments or symbol
assignments at the beginning of a program.  
It is also useful for breaking up a large source program 
into easily manageable pieces.
.P
The maximum depth of nexted insertions with 
.B .insrt
is ten.
.P
System call names are not predefined.  
They may be found in the file
.I "/usr/include/sys.s".   
.H 3 ".ascii, .asciz"
The 
.B .ascii 
directive translates character strings into
their 7-bit ASCII (represented as 8\-bit bytes) equivalents for
use in the source program.  
The format of the 
.B .ascii
directive is as follows:
.DS I
.B
\&.ascii     /\fIstring\fP/
.R
.DE
where 
.I string 
contains any character valid in a character constant.  
Obviously, a 
.I newline 
must not appear within the character
string. 
(It can be represented by the escape sequence 
.Q "\en" ).
Note that the slash is the delimter character.
This may be any be any character
.I not 
appearing in 
.I character-string .
.P
Several examples follow:
.DS I
Hex Code Generated		Statement:

22 68 65 6C 6C 6F 20 74		.ascii  /"hello there"/
68 65 72 65 22

77 61 72 6E 69 6E 67 20		.ascii "Warning-\e007\e007 \en" 
2D 07 07 20 0A

61 62 63 64 65 66 67		.ascii *abcdefg*
.DE
.P
The
.B .asciz
directive is equivalent to the
.B .ascii
directive with a zero (null)
byte automatically inserted as the final character of the string.  
Thus, when a list or text string is to be printed, 
a search for the null
character can terminate the string.  
Null terminated strings are 
used as arguments to some \*(x1 system calls.
.H 3 ".list, .nlist"
These pseudo\-directives control the assembler output listing.   
These, in effect, temporarily override the 
.B \-l 
switch to the assembler.    
This is useful when certain portions of the assembly output is
not necessarily desired on a printed listing.
.DS I
\&.list  \fITurns the listing on\fP
\&.nlist \fITurns the listing off\fP
.DE
.H 3 ".blkb, .blkw"
The 
.B .blkb
and 
.B .blkw
directives are used to reserve blocks of storage: 
.B .blkb
reserves bytes, 
.B .blkw 
reserves words.
.P
The format is:
.DS I
.B
\&.blkb	[\fIexpression\fP]
\&.blkw	[\fIexpression\fP]
.R
.DE
where 
.I expression 
is the number of bytes or words to reserve.  
If no argument is given a value of 1 is assumed.  
The expression must be absolute, and defined during pass 1.  
.P
This is equivalent to 
the statement 
.DS I
\fB\&.\|=\|.\^+\^\fIexpression\fR 
.DE
but has a much more transparent meaning.
.H 3 ".byte, .word"
The 
.B .byte 
and 
.B .word 
directives are used to reserve bytes and
words and to initialize them with certain values.
.P
The format is:
.DS I
\&.byte	[\fIexpression\fP]
\&.word	[\fIexpression\fP]
.DE
The 
.B .byte 
directive reserves one byte 
for each expression in the operand field and
initializes the value of the byte to be the low-order byte of the 
corresponding expression. 
.P
The semantics for 
.B \&.word 
are identical, except that 16-bit
words are reserved and initialized.
.H 3 ".end"
The 
.B .end 
directive indicates the physical end 
of the source program.
The format is:
.DS I
.B
\&.end	[\fIexpression\fP]
.R
.DE
where 
.I expression 
is an optional argument which, 
if present, indicates the
entry point of the program, i.e., the starting point for execution.
If the entry point of a program is not specified during assembly,
it defaults to zero.
.P
Every source program must be terminated with a
.B \&.end\fR 
statement.  
Inserted files that contain a
.B \&.end\fR 
statement will terminate assembly 
of the entire program, not just the inserted portion.
.H 2 "Machine Instructions"
The 8086 instructions treat different types of operands uniformly.  
Nearly every instruction can operate on either byte or word data.    
In the table that follows, with some exceptions, 
an instruction that operates on a byte
operand will have a \*`b\*' suffix on the opcode.
.P
The 8086 instruction mnemonics which follow are implemented by the
Microsoft 8086 assembler described in this section.  
Some of the opcodes are not found in any other 8086 manual;
for example, the some of the branch instructions
are specific to this assembler.
These branch instructions expand 
into a jump on the inverse of the condition specified, 
followed by an an unconditional intra-segment jump.  
The operand field format for the branch opcodes is the same
as the operand field for the jump long opcodes.    
The opcodes that are implemented only
in this assembler are annotated by an asterisk, and are
fully defined and described in this document.
.bp
.ce 1
8086 Assembler Opcodes 
.SP 1
.DS I
Opcode	Description	

aaa	ascii adjust for addition		
aad	ascii adjust for division	
aam	ascii adjust for multiply
aas	ascii adjust for subtraction
adc	add with carry
adcb	add with carry
add	add
addb	add
and	logical AND
andb	logical AND
*beq	long branch equal
*bge	long branch grt or equal
*bgt	long branch grt
*bhi	long branch on high
*bhis	long branch high or same
*ble	long branch les or equal
*blo	long branch on low
*blos	long branch low or same
*blt	long branch less than
*bne	long branch not equal
*br	long branch
call	intra segment call
calli	inter segment call
cbw	convert byte to word		
clc	clear carry flag	
cld	clear direction flag
cli	clear interrupt flag		
cmc	complement carry flag	
cmp	compare
cmpb	compare
cmps	compare string	
cmpsb	compare string	
cwd	covert word to double word	
daa	decimal adjust for addition	
das	decimal adjust for subtraction 
dec	decrement by one
decb	decrement by one
div	division unsigned
divb	division unsigned
hlt	halt				
idiv	integer division
idivb	integer division
imul	integer multiplication
imulb	integer multiplication
in	input byte
inc	increment by one
incb	increment by one
int	interrupt
into	interrupt if overflow		
inw	input word
iret	interrupt return
j	short jump
ja	short jump if above
jae	short jump if above or equal
jb	short jump if below
jbe	short jump if below or equal
jcxz	short jump if CX is zero
je	short jump on equal
jg	short jump on greater than
jge	short jump greater than or equal
jl	short jump on less than
jle	short jump on less than or equal
jmp	jump
jmpi	inter segment jump
jna	short jump not above
jnae	short jump not above or equal
jnb	short jump not below
jnbe	short jump not below or equal
jne	short jump not equal
jng	short jump not greater
jnge	short jump not greater or equal
jnl	short jump not less
jnle	short jump not less or equal
jno	short jump not overflow
jnp	short jump not parity
jns	short jump not sign
jnz	short jump not zero
jo	short jump on overflow
jp	short jump if parity
jpe	short jump if parity even
jpo	short jump if parity odd
js	short jump if signed
jz	short jump if zero
lahf	load AH from flags			
lds	load pointer using DS
lea	load effective address
les	load pointer using ES
lock	lock bus				
lodb	load string byte
lodw	load string word
loop	loop short label
loope	loop if equal
loopne	loop if not equal
loopnz	loop is not zero
loopz	loop if zero
mov	move
movb	move byte
movs	move string
movsb	move string byte
mul	multiplication unsigned
mulb	multiplication unsigned
neg	negate
negb	negate
nop	no op					
not	logical NOT
notb	logical NOT
or	logical OR
orb	logical OR
out	output byte
outw	output word
pop	pop from stack
popf	pop flag from stack
push	push onto stack
pushf	push flags onto stack
rcl	rotate left through carry
rclb	rotate left through carry
rcr	rotate right through carry
rcrb	rotate right through carry
rep	repeat string operation
repnz	repeat string operation not zero
repz	repeat string operation while zero
ret	return from procedure
reti	return from intersegment procedure
rol	rotate left
rolb	rotate left
ror	rotate right
rorb	rotate right
sahf	store AH into flags
sal	shift arithmetic left
salb	shift arithmetic left
sar	shift arithmetic right
sarb	shift arithmetic right
sbb	subtract with borrow
sbbb	subtract with borrow
scab	scan string
shl	shift logical left
shlb	shift logical left
shr	shidr logical right
shrb	shidr logical right
stc	set carry flag				
std	set direction flag			
sti	set interrupt enable flag		
stob	store byte string
stow	store word string
sub	subtraction
subb	subtraction
test	test
testb	test
wait	wait while TEST pin			
xchg	exchange
xchgb	exchange
xlat	translate
xor	xclusive OR
xorb	xclusive OR
.DE
.H 2 "Addressing Modes"
The 8086 assembler provides many different ways 
to access instruction operands.  
Operands may be contained in registers, within the instruction 
itself, in memory, 
or in I/O ports.  In addition, the addresses of memory and I/O
port operands can be calculated in several different ways.
.H 3 "Register Operands"
Instructions that specify only register operands are generally the most
compact and fastest executing of all the instruction forms.  
This is because the register \*`addresses\*' are encoded 
in the instructions with just a few bits, 
and because these operations are performed entirely within the CPU.  
Registers may serve as source operands, destination operands, or both.
Examples of register addressing follow:
.DS I
sub	cx,di
mv	ax,/3*4		
mv	/3*4/,ax
mov	ax,*1
.DE
.H 3 "Immediate Operands"
Immediate operands are constant data contained in an instruction.  
The data may be either 8 or 16 bits in length.  
Immediate operands can be
accessed quickly because they are available directly 
from the instruction
queue.
It is possible that no bus cycles
will be needed to obtain an immediate operand.  
An immediate operand is always a constant value and can only be
used as a source operand.  
.P
The assembler can accept both 8 and 16 bit operands.  
It does not perform any checking on the operand size, 
but determines the size of the operand by the following symbols:
.DS I
*expr	an 8 bit immediate
#expr	a 16 bit immediate
.DE
Examples of immediate addressing follow:
.DS I
mov	cx,*PAGSIZ/2
mov	cx,#PAGSIZ/2
mov	map,#PAGSIZ/2
mov	map,*PAGSIZ/2
.DE
.H 2 "Memory Addressing Modes"
When reading or writing a memory operand, 
a value called the 
.I offset 
is required.  
This offset value, also called the 
.I effective~address
is the operand's distance in bytes from the beginning 
of the segment in which it resides. 
.H 3 "Direct Addressing"
Direct addressing is the simplest memory addressing mode since no
registers are involved.  
The 
.I "effective\0address"
is taken
directly from the displacement field of the instruction.  
It is typically used to access simple (scalar) variables.
Examples of direct addressing follow:
.DS I
push	*6(bp) 
mov	cx,#256
add	si,*4
.DE
.H 3 "Register Indirect Addressing"
The effective address of a memory operand may be taken from a
base or index register.  
One instruction can operate on many different
memory locations if the value in the base or index register is updated
appropriately.  
Indirect addressing is denoted by an ampersand (@) 
preceding the operand.  
Examples of indirect addressing follow:
.DS I
popl	rr0,@r15
calli	@moncall
.DE
.H 3 "Based Addressing"
In based addressing, 
the effective address is the sum of a displacement
value and the content of register 
.B bx
or 
.B bp .  
Based addressing
also provides a straightforward way 
to address structures which may be
located in different places in memory.  
A base register can be pointed at the
base of the structure and elements of the structure 
addressed by their 
displacements from the base.  
Different copies of the same structure can
be accessed by simply changing the base register.
An example of based addressing follows:
.DS I
mov	*2(si),#/1000
.DE
.H 3 "Indexed Addressing"
In indexed addressing, the effective address is calculated 
from the sum of a displacement plus the content of an index register.  
Indexed addressing often is used to access elements in an array.  
The displacement locates
the beginning of the array, 
and the value of the index register selects one element.  
Since all array elements are the same length, simple
arithmetic on the index register will select any element.  
An example of indexed addressing follows:
.DS I
mov	#_cat,(bx)
.DE
.H 3 "Based Indexed Addressing"
Based indexed addressing generates an effective address 
that is the sum of a base register, an index register, 
and a displacement.  
Based indexed addressing is a very flexible mode 
because two address components
can be varied at execution time.
.P
Based indexed addressing provides a convenient way for a procedure to
address an array allocated on a stack.  
Register 
.B bp
can contain
the offset of a reference point on the stack, typically the top of the
stack after the procedure has saved registers and allocated local 
storage.  
The offset of the beginning of the array from the
reference point can be expressed by a displacement value, 
and an index
register can be used to access individual array elements.
Examples of based indexed addressing follow:
.DS I
mov	(bx)(dx),_sym
mov	*2(bx)(dx),_sym
mov	#2(bx)(dx),_sym
.DE
.H 2 "Diagnostics"
When syntactic errors occur, 
the line number and the file in which they
occur is displayed.  Errors in pass 1 cause cancellation of pass 2.
.DS I
***ERROR*** syntax error, line \fInnn\fP
file: \feee\fP errors
.DE
.P
where 
.I nnn 
represents the line number(s) in error, and
.I eee 
represents the total number of errors.  
.hc %
.tr ~ 
.TC 2 1 5 0
