.aX
.nr H1 0
.H 1 "Appendix A: The C-shell"
.PH "'Appendix A''Appendix A'"
The C-shell program
is an alternate command language interpreter.
Most of the features unique to
the C-shell are designed more for the interactive \*(x1 user.
Other features have been 
incorporated to make writing C-shell procedures easier.
.P
The name of the command that invokes the C-shell is
.I csh ,
whose primary purpose
is to translate command lines 
typed at a terminal into
system actions, 
such as invocations of other programs.
.tr ~~
.H 2 "Shell Startup and Termination"
When you login, the either the regular shell or the
C-shell is started by the system in your
.I home
directory and begins by reading commands from a file
in this directory:
.FN \&.profile
for the regular shell and 
.FN \&.cshrc
for the C-shell.
All C-shells which you start during your terminal session 
read commands from this file.
We will later see what kinds of commands are usefully placed here.
For now, we need not have this file 
and the C-shell does not complain about its absence.
.P
A 
.I "login C-shell" ,
executed after you login to the system,
after it reads commands from
.FN \&.cshrc,
reads commands from the file
.FN \&.login
also in your home directory.
This file contains commands that you wish to execute
each time you login to the \*(x1 system.
A typical
.FN \&.login
file might look something like this:
.DS I
set ignoreeof
set mail=(/usr/spool/mail/bill)
echo "${prompt}users" ; users
alias ts \e
	\'set noglob ; eval \`tset \-s \-m dialup:c100rv4pna \e
	\-m plugboard:?hp2621nl \!*\`\';
ts; stty intr ^C kill ^U crt
set time=15 history=10
if (\-e $mail) then
	echo "${prompt}mail"
	mail
endif
.DE
.P
This file contains several commands 
to be executed by \*(x1 at each login.
The first is a
.I set
command that is interpreted directly by the C-shell.  
It sets the C-shell variable
.I ignoreeof
which shields the C-shell from log off if 
.SM <CONTROL-D>
is hit.
Instead of 
.SM <CONTROL-D> ,
the
.B logout
command is used to log off the system.
By setting the
.I mail
variable, the C-shell is notified that it is to watch
for incoming mail and notify you if new mail arrives.
.P
Next the C-shell variable 
.I time 
is set to 15 causing the C-shell to automatically
print out statistics lines for commands 
that execute for at least 15 seconds of 
.SM CPU
time.  
The variable 
.Q "history"
is set to 10 indicating that
the C-shell will remember 
the last 10 commands typed in its 
.Q "history list" ,
(described later).
.P
Next, an 
.I alias ,
.Q "ts" ,
is created that executes a
.B tset
command setting up the modes of the terminal.
The parameters to
.B tset
indicate the kinds of terminal 
normally used when not on a hardwired port.  
Then 
.Q "ts"
is executed, and the
.B stty
command is used to change the interrupt character to 
.SM <CONTROL-C>
and the line kill character to 
.SM <CONTROL-U> .
.P
Finally, if a mailbox file exists, 
then the
.B mail 
program is invoked.
.P
When the 
.B mail 
programs finishes, the C-shell finishes processing the
.FN \&.login
file and begins reading commands from the terminal, 
prompting for each with:
.DS I
% 
.DE
When you log off (by giving the 
.B logout
command) the C-shell
prints 
.DS I
logout
.DE
and executes commands from the file 
.FN \&.logout
if it exists in your home directory.
After that, 
the C-shell terminates and \*(x1 logs
you off the system.
.H 2 "Shell Variables"
The C-shell maintains a set of
.I variables.
For example in the above discussion, the variables
.I history
and
.I time
had the values 10 and 15.
Each C-shell variable has as its value an array of
zero or more
.I strings.
C-shell variables may be assigned values by the 
.B set
command,  
which has
several forms, the most useful of which was given above and is
.DS I
set \fIname\fP=\fIvalue\fP
.DE
.P
C-shell variables may be used to store values that are to
be used in commands later through a substitution mechanism.
The C-shell variables most commonly referenced are, 
however, those that the C-shell itself refers to.
By changing the values of 
these variables one can directly affect the
behavior of the C-shell.
.P
One of the most important variables is the variable,
.I path.
This variable contains a list of directory names.
When you type a command name at your terminal,
the C-shell examines each named directory in turn,
until it finds an executable file whose name
correpsonds to the name you typed.
The
.B set
command with no arguments
displays the values of all variables currently defined 
in the C-shell.
The default value for path can be shown by
.I set :
.DS I
argv	()
cwd	/usr/bill
home	/usr/bill
path	(. /bin /usr/bin)
prompt	%
shell	/bin/csh
status	0
term	c100rv4pna
user	bill
.DE
.P
This output indicates that the variable 
.Q path 
begins with the current directory indicated by dot (\|.\|)
and then 
.FN /bin ,
and 
.FN /usr/bin .
Your own local commands may be in dot.
Normal \*(x1 commands 
live in 
.FN /bin 
and 
.FN /usr/bin .
.P
Often a number of locally developed 
programs on a system reside in the directory
.FN /usr/local .
If you want all C-shells that you invoke to have
access to these new programs, place the command
.DS I
set path=(. /bin /usr/bin /usr/local)
.DE
in the 
.FN \&.cshrc
file in your home directory.
Try doing this and then logging out and back in. 
Then type
.DS I
set
.DE
again to see that the value assigned to
.I path
has changed.
.P
You should be aware that 
when you login,
the C-shell examines each directory
that you insert into your path 
and determines which commands are contained there,  
except for the current directory, dot,
which the C-shell treats specially,
This means that if commands are added 
to a directory in your search path 
.I after
you have started the C-shell, 
they will not necessarily be found.
If you wish to use a command 
which has been added after you have logged in,
you should give the command
.DS I
rehash
.DE
to the C-shell, which causes 
it to recompute its internal table of command
locations, so that it will find the newly added command.
Since the C-shell has to look 
in the current directory on each command anyway,
placing it at the end of the path 
specification usually works best
and reduces overhead.
.P
Other useful built in variables are the variable
.I home
which shows your home directory,
.I cwd
which contains your current working directory,
and
.I ignoreeof
which can be set in your
.FN \&.login
file to tell the C-shell not to exit 
when it receives an end-of-file from
a terminal.
The variable 
.I ignoreeof
is one of several variables 
whose value the C-shell does not care about;
the C-shell is only concerned with whether these
variables are
.I set
or
.I unset.
Thus, to set 
.I ignroeeof 
you simply type
.DS I
set ignoreeof
.DE
and to unset it type
.DS I
unset ignoreeof
.DE
This gives the variable 
.I ignoreeof
no value, but none is desired or required.
.P
Finally, some other useful built-in C-shell variables 
are
.I noclobber
and
.I mail.
The metasyntax
.DS I
>filename
.DE
which redirects the standard output of a command
just as in the regular shell,
overwrites and destroys the previous contents of the named file.
In this way, 
you may accidentally overwrite a file which is valuable.
If you prefer that the C-shell not overwrite files in this
way you can
.DS I
set noclobber
.DE
in your
.FN \&.login
file.
Then typing
.DS I
date > now
.DE
causes an error message if 
the file
.Q "now"
already exists.
You can type
.DS I
date >! now
.DE
if you really want to overwrite the contents of 
.FN now .
The 
.Q ">!"
is a special metasyntax indicating that overwriting or 
.Q "clobbering"
the file is ok.
(The space between the exclamation (!) and 
the word 
.Q "now"
is critical here, as 
.Q "!now"
would be an invocation of the history
mechanism, described below, and have a totally different effect.)
.H 2 "The C-Shell's History List"
The C-shell can maintain a history list
into which it places the text of previous commands.
It is possible to use a notation 
to reuse commands, or words
from commands, in forming new commands.
This mechanism can be used to repeat previous commands or to
correct minor typing mistakes in commands.
.P
The following figure gives a sample session 
involving typical usage of the
history mechanism of the C-shell.
Boldface indicates user input:
.DS I
.RB % " cat bug.c"
main()

{
	printf("hello);
}
.RB % " cc !$"
cc bug.c 
"bug.c", line 4: newline in string or char constant
"bug.c", line 5: syntax error
.RB % " ed !$"
ed bug.c 
29
.B 4s/);/"&/p
        printf("hello");
.B w
30
.B q
.RB % " !c"
cc bug.c 
.RB % " a.out"
hello% !e
.B ed " bug.c"
30
.B 4s/lo/lo\e\en/p
        printf("hello\en");
.B w
32
.B q
.RB % " !c \-o bug"
cc bug.c \-o bug
.RB % " size a.out bug"
a.out: 2784+364+1028 = 4176b = 0x1050b
bug: 2784+364+1028 = 4176b = 0x1050b
.RB % " ls \-l !*"
ls \-l a.out bug
\(mirwxr\(mixr\(mix 1 bill       3932 Dec 19 09:41 a.out
\(mirwxr\(mixr\(mix 1 bill       3932 Dec 19 09:42 bug
.RB % " bug"
hello
.RB % " num bug.c | spp"
spp: Command not found.
.RB % " ^spp^ssp"
num bug.c | ssp 
    1	main()
    3	{
    4		printf("hello\en");
    5	}
.RB % " !! | lpr"
num bug.c | ssp | lpr
% 
.DE
.P
In this example, 
we have a very simple C program that has a bug or two
in the file 
.FN bug.c , 
which we 
.B cat
out on our terminal.  
We then try to run the C compiler on it, 
referring to the file again as 
.Q "!$" ,
meaning the last argument to the previous command.  
Here the exclamation mark (!) is the
history mechanism invocation metacharacter, 
and the dollar sign ($) stands for the last
argument, by analogy to the dollar sign in the editor 
which stands for the end-of-line.
The C-shell echoed the command, 
as it would have been typed without use of
the history mechanism, and then executed the
command.
The compilation yielded error diagnostics, 
so we now edit the
file we were trying to compile, fix the bug, 
and run the C compiler again,
this time referring to this command simply as 
.Q "!c" , 
which repeats the last
command that started with the letter 
.Q "c" .  
If there were other
commands beginning with  the letter
.Q "c"
executed recently,
we could have said 
.Q "!cc"
or even
.Q "!cc:p"
which prints the last command starting with 
.Q "cc"
without executing it, so that you can check to 
see whether you really want to execute a given
command.
.P
After this recompilation, 
we ran the resulting 
.FN a.out
file, and then
noting that there still was a bug, ran the editor again.  
After fixing the program we ran the C compiler again, 
but tacked onto the command an extra 
.Q "\-o bug"
telling the compiler to place the resultant binary in
the file 
.FN bug 
rather than 
.FN a.out .  
In general, the history mechanisms
may be used anywhere 
in the formation of new commands, and other characters
may be placed before and after the substituted commands.
.P
We then ran the 
.B size 
command to see how large the binary program images
we have created were, 
and then we ran an 
.Q "ls \-l"
command with the same argument
list, denoting the argument list:
.DS I
!*
.DE
Finally, we ran the program 
.FN bug 
to see that its output is indeed correct.
.P
To make a numbered listing of the program, 
we ran the 
.B num 
command on the file 
.FN bug.c .
In order to filter out blank lines in the output of 
.B num 
we ran the output through a filter 
.B ssp , 
but misspelled it as 
.Q "spp" .  
To correct this we used a C-shell substitute, 
placing the old text and new text between caret
(^) characters.  
This is similar to the substitute command in the editor.
Finally, we repeated the same command with 
.DS I
!! 
.DE
but sent its output to the line printer.
.P
There are other mechanisms available for repeating commands.  
The 
.B history
command prints out a numbered list of previous commands.
You can then refer to these commands by number.
There is a way to refer to a previous command
by searching for a string which appeared in it, and there are other,
less useful, ways to select arguments to include in a new command.
A complete description of all these mechanisms
is given in the C-shell manual page in the 
.I "\*(x2 Reference Manual".
.H 2 "Aliases"
The C-shell has an alias
mechanism which can be used to make transformations on commands
immediately after they are input.
This mechanism can be used to simplify the commands you type,
to supply default arguments to commands,
or to perform transformations on commands and their arguments.
The alias facility is similar to a macro facility.
Some of the features obtained by aliasing can be obtained also
using C-shell command files, 
but these take place in another instance
of the C-shell and cannot directly 
affect the current C-shells environment
or involve commands such as
.I cd
which must be done in the current C-shell.
.P
As an example, 
suppose that there is a new version of the mail program
on the system called 
.Q "newmail"
you wish to use, rather than the 
standard mail program called
.Q "mail" .
If you place the C-shell command
.DS I
alias mail newmail
.DE
in your
.FN \&.cshrc
file, the C-shell will transform an input line of the form
.DS I
mail bill
.DE
into a call on 
.Q "newmail" .
More generally, suppose you wish the command 
.B ls 
to always show sizes of files, that is, to always use
the 
.B \-s 
switch.
In this case, you can use the 
.B alias 
command to do
.DS I
alias ls ls \-s
.DE
or even
.DS I
alias dir ls \-s
.DE
creating a new command 
named 
.Q "dir" .
If we then type
.DS I
dir ~bill
.DE
the C-shell translates this to
.DS I
ls \-s /usr/bill
.DE
.P
Thus the
.B alias
command can be used to provide short names for commands,
to provide default arguments,
and to define new short commands in terms of other commands.
It is also possible to define aliases that contain multiple
commands or pipelines, showing where the arguments to the original
command are to be substituted using the facilities of the
history mechanism.
Thus the definition
.DS I
alias cd \'cd \e!* ; ls \'
.DE
specifies an
.B ls
command after each
.B cd
command.
We enclosed the entire alias definition in single
quotation marks (\|\'\|) to prevent
most substitutions from occurring and to prevent
the semicolon (;) from being recognized as a metacharacter.
The exclamation mark (!) is escaped with a backslash
(\e) to prevent it from being interpreted
when the alias command is typed in.
The 
.Q "\e!*"
here substitutes the entire argument 
list to the pre-aliasing
.B cd
command; no error is given if there are no arguments.
The semicolon separating commands is used here
to indicate that one command is to be done and then the next.
Similarly the definition
.DS I
alias whois \'grep \e!^ /etc/passwd\'
.DE
defines a command that looks up 
its first argument in the password file.
.P
.B Warning:
The C-shell currently reads the
.FN \&.cshrc
file each time it starts up.  
If you place a large number of aliases
there, C-shells will tend to start slowly.  
You should try to limit the number of
aliases you have to a reasonable number;
10 or 15 is reasonable,
50 or 60 causes a noticeable delay 
in starting up C-shells, and makes
the system seem sluggish 
when you execute commands from 
within the editor and other programs.
.H 2 "More Redirection; >> and >&"
There are a few more notations useful to the terminal user
that have not yet been introduced.
In addition to the standard output, commands also have a
.I "diagnostic output"
that is normally directed to the terminal 
even when the standard output
is redirected to a file or a pipe.
It is occasionally desirable to direct the diagnostic output along with
the standard output.
For instance, if you want to redirect 
the output of a long running command
into a file and wish to have a record 
of any error diagnostic it produces you can type
.DS I
command >\|& file
.DE
The 
.Q ">\|&"
here tells the C-shell to route both the diagnostic output 
and the standard output into 
.FN file .
Similarly you can give the command
.DS I
command |\|& lpr
.DE
to route both standard and diagnostic output through the pipe
to the line printer.
The form
.DS I
command >&! file
.DE
is used when
.I noclobber
is set and
.I file
already exists.
.P
Finally, use the form
.DS I
command >> file
.DE
to append output to the end of an existing file.
If
.I noclobber
is set, then an error results if
.I file
does not exist, otherwise the C-shell creates
.I file .
The form
.DS I
command >>! file
.DE
lets you append to a file even if it does not exist
and
.I noclobber
is set.
.H 2 "Jobs: Background and Foreground"
When one or more commands
are typed together as a pipeline or as 
a sequence of commands separated by semicolons, a single
job is created by the C-shell consisting of 
these commands together as a unit.
Single commands without pipes or semicolons 
create the simplest jobs.
Usually, every line typed to the C-shell creates a job.
Some lines that create jobs (one per line) are
.DS I
sort < data
ls \-s | sort \-n | head \-5
mail harold
.DE
.P
If the ampersand metacharacter (&) is typed
at the end of the commands, 
then the job is started as a background job.  
This means that the C-shell does not wait for the
job to finish, but instead,
immediately prompts for another command.  
The job runs in the background
at the same time that normal jobs, called
foreground jobs, 
continue to be read and executed by the C-shell.
Thus
.DS I
du > usage &
.DE
runs the
.B du
program, which reports on the disk usage 
of your working directory,
puts the output into the file 
.FN usage 
and returns immediately with a prompt 
for the next command without out waiting for
.B du
to finish.  
The
.B du
program continues executing 
in the background until it finishes, 
even though you can type and execute more commands in the mean time.
Background jobs are unaffected by any signals 
from the keyboard such as the 
.SM <INTERRUPT> 
or 
.SM <QUIT>
signals.
.P
The
.B kill
command terminates a background job immediately.
Normally, this is done by specifying the process number
of the job you want killed.
Process numbers can be found with the 
.B ps
command.
.H 2 "Useful Built-In Commands"
We now give a few of the useful built-in commands of the C-shell 
describing how they are used.
.P
The
.B alias
command described above is used 
to assign new aliases and to display existing aliases.
If given no arguments, 
.B alias 
prints the list of current aliases.
It may also be given one argument, such as
to show the current alias for a given string of
characters. 
For example
.DS I
alias ls
.DE
prints the current alias for the string 
.Q ls .
.P
The
.B history
command dispalsy the contents of the history list.
The numbers given with the history events can be used to reference
previous events that are difficult to reference contextually.
There is also a C-shell variable named
.I prompt.
By placing an exclamation mark (!) in its value the C-shell 
will there substitute
the number of the current command in the history list.
You can use this number to refer 
to a command in a history substitution.
For example, you could type:
.DS I
set prompt=\'\e! % \'
.DE
Note that the exclamation mark (!) had to be
escaped here even within backslashes.
.P
The
.B logout
command is used to terminate a login C-shell that has
.I ignoreeof
set.
.P
The
.B rehash
command causes the C-shell to recompute a table of 
where commands are
located.  
This is necessary if you add a command to a directory
in the current C-shell's search path and wish the C-shell to find it,
since otherwise the hashing algorithm may tell the C-shell that the
command wasn't in that directory when the hash table was computed.
.P
The
.B repeat
command is used to repeat a command several times.
Thus to make 5 copies of the file
.FN one
in the file
.FN five
you could type:
.DS I
repeat 5 cat one >> five
.DE
.P
The
.B setenv
command can be used
to set variables in the environment.
Thus
.DS I
setenv TERM adm3a
.DE
sets the value of the 
environment variable 
.Q TERM 
to 
.Q "adm3a" .
The program
.B printenv
exists to print out the environment.
For example, its output might look like this:
.DS I
HOME=/usr/bill
SHELL=/bin/csh
PATH=:/usr/ucb:/bin:/usr/bin:/usr/local
TERM=adm3a
USER=bill
.DE
.P
The
.B source
command is used to force 
the current C-shell to read commands from a file.
Thus
.DS I
source .cshrc
.DE
can be used after editing in a change to the
.FN \&.cshrc
file that you wish to take effect before the next time you login.
.P
The
.B time
command is used to cause a command to be timed no matter how much
\s-2CPU\s0 time it takes.
Thus
.DS I
time cp /etc/rc /usr/bill/rc
.DE
displays:
.DS I
0.0u 0.1s 0:01 8%
.DE
Similarly
.DS I
time wc /etc/rc /usr/bill/rc
.DE
displays:
.DS I
     52    178   1347 /etc/rc
     52    178   1347 /usr/bill/rc
    104    356   2694 total
0.1u 0.1s 0:00 13%
.DE
This indicates that the
.FN cp
command used a negligible amount of user time (u)
and about 1/10th of a second system time (s); 
the elapsed time was 1 second (0:01).
The word count command,
.B wc ,
on the other hand, used 0.1 seconds 
of user time and 0.1 seconds of system
time in less than a second of elapsed time.
The percentage 
.Q "13%"
indicates that over 
the period when it was active
the command 
.B wc 
used an average of 13 percent of the available 
.SM CPU
cycles of the machine.
.P
The
.B unalias
and
.B unset
commands are used
to remove aliases and variable definitions from the C-shell. 
The command
.B unsetenv
removes variables from the environment.
.H 2 "Shell Control Structures and Command Scripts"
It is possible to place commands in files and to cause C-shells to be
invoked to read and execute commands from these files,
which are called
C-shell scripts.
We here detail those features of 
the C-shell useful to the writers of such scripts.
.P
It is important to first note what C-shell scripts are
.I not
useful for.
There is a program called
.B make
which is very useful for maintaining a group of related files
or performing sets of operations on related files.
For example, a large program consisting of one or more files
can have its dependencies described in a
.I makefile
which contains definitions of the commands used to create these
different files when changes occur.
Definitions of the means for printing listings, 
cleaning up the directory
in which the files reside, and installing the resultant programs
are easily, and most appropriately placed in this
.I makefile.
This format is superior and 
preferable to maintaining a group of C-shell
procedures to maintain these files.
.P
Similarly when working on a document a
.I makefile
may be created, 
which defines how different versions of the document
are to be created and which options of
.B nroff
or
.B troff
are appropriate.
.H 3 "Invocation and the argv Variable"
A
.B csh
command script may be interpreted by saying
.DS I
csh script ...
.DE
where
.I script
is the name of the file containing a group of
C-shell commands and
.Q "\&..."
is replaced by a sequence of arguments.
The C-shell places these arguments in the variable
.I argv
and then begins to read commands from the script.
These parameters are then available through the same mechanisms
that are used to reference any other C-shell variables.
.P
If you make the file
.FN script
executable by doing
.DS I
chmod 755 script
.DE
or
.DS I
chmod +x script
.DE
and then place a C-shell comment 
at the beginning of the C-shell script
(i.e., begin the file with a number sign (#)\|)
then a 
.FN /bin/csh 
will automatically be invoked to execute 
.FN script
when you type
.DS I
script
.DE
If the file does not begin with a number sign (#) 
then the standard shell
.FN /bin/sh 
will be used to execute it.
This allows you to convert your older C-shell scripts to use
C-shell at your convenience.
.H 3 "Variable Substitution"
After each input line is broken into words and history substitutions
are done on it, the input line is parsed into distinct commands.
Before each command is executed a mechanism know as
variable substitution is performed on these words.
Keyed by the dollar sign ($), 
this substitution replaces the names
of variables by their values.
Thus
.DS I
echo $argv
.DE
when placed in a command script 
would cause the current value of the variable
.I argv
to be echoed to the output of the C-shell script.
It is an error for
.I argv
to be unset at this point.
.P
A number of notations are provided 
for accessing components and attributes of variables.
The notation
.DS I
$?name
.DE
expands to 1 if name is
.I set
or to 0
if name is not
.I set.
It is the fundamental mechanism used for checking whether particular
variables have been assigned values.
All other forms of reference to undefined variables cause errors.
.P
The notation
.DS I
$#name
.DE
expands to the number of elements in the variable
.I name.
To illustrate, examine the following terminal session,
where input is in boldface:
.DS I
.RB % " set argv=(a b c)"
.RR % " echo $?argv"
1
.RB % " echo $#argv"
3
.RB % " unset argv"
.RB % " echo $?argv"
0
.RB % " echo $argv"
Undefined variable: argv.
.B %
.DE
.P
It is also possible to access the components of a variable
that has several values.
Thus
.DS I
$argv[1]
.DE
gives the first component of
.I argv
or in the example above 
.Q "a" .
Similarly
.DS I
$argv[$#argv]
.DE
would give 
.Q "c" ,
and
.DS I
$argv[1\-2]
.DE
would give:
.DS I
a b
.DE
Other notations useful in C-shell scripts are
.DS I
$\fIn\fR
.DE
where 
.Q "n"
is an integer as a shorthand for
.DS I
$argv[\fIn\fR\|]
.DE
the n'th
parameter and
.DS I
$*
.DE
which is a shorthand for
.DS I
$argv
.DE
The form
.DS I
$$
.DE
expands to the process number of the current C-shell.
Since this process number is unique in the system,
it is often used in generation of unique temporary filenames.
The form
.DS I
$<
.DE
is quite special and is replaced by the next line of input read from
the C-shell's standard input (not the script it is reading).  
This is useful for writing C-shell scripts that are interactive, 
reading commands from the terminal, 
or even writing a C-shell script that
acts as a filter, reading lines from its input file. 
Thus, the sequence
'\"	system three difference \c
.DS I
echo -n \'yes or no?\'
set a=($<)
.DE
writes out the prompt 
.DS I
yes or no? 
.DE
without a newline and then
reads the answer into the variable 
.Q "a" .
In this case 
.Q "$#a"
is 0 if either a blank line or 
.SM <CONTROL-D>
is typed.
.P
One minor difference between 
.Q "$\fIn\fR"
and 
.Q "$argv[\fIn\fR\|]"
should be noted here.
The form
.Q "$argv[\fIn\fR\|]"
will yield an error if
.I n
is not in the range
1\-$#argv
while 
.Q "$n"
will never yield an out of range subscript error.
This is for compatibility 
with the way older shells handled parameters.
.P
Another important point is that it is never an error 
to give a subrange
of the form 
.Q "n\-" ;
if there are less than 
.Q "n"
components of the given variable then no words are substituted.
A range of the form 
.Q "m\-n" 
likewise returns an empty vector without giving
an error when 
.Q "m"
exceeds the number of elements of the given variable,
provided the subscript 
.Q "n"
is in range.
.H 3 "Expressions"
To construct useful C-shell scripts,
the C-shell
must be able to evaluate expressions based on the
values of variables.
In fact, all the arithmetic operations 
of the language C are available
in the C-shell with the same precedence that they have in C.
In particular, 
the operations 
.Q "=="
and 
.Q "!="
compare strings and 
the operators 
.Q "&&"
and 
.Q "|\|\||"
implement the boolean AND and OR operations.
The special operators 
.Q "=~"
and 
.Q "!~"
are similar to 
.Q "==" 
and 
.Q "!="
except that the string on the right side 
can have pattern matching characters
(like *, ? or [ and ]) 
and the test is determines whether the string on the left matches
the pattern on the right.
.P
The C-shell also allows file enquiries of the form
.DS I
\-? filename
.DE
where question mark (?) is replaced 
by a number of single characters.
For example, the expression primitive
.DS I
\-e filename
.DE
tell whether the file
.FN filename
exists.
Other primitives test for read, 
write and execute access to the file,
whether it is a directory, or has nonzero length.
.P
It is possible to test whether a command terminates normally,
by using a primitive of the form 
.DS I
{ \fIcommand\fP } 
.DE
which returns true, i.e., 1 if the command
succeeds exiting normally with exit status 0, or 0 if the command
terminates abnormally or with exit status nonzero.
If more detailed information about the execution status of a command
is required, it can be executed and the 
.Q "status" 
variable examined in the next command.
Since 
.Q "$status"
is set by every command, it is value is always changing.
.P
For the full list of expression components, 
see the 
.I "\*(x2 Reference Manual"
and
.IR csh (1S).
.H 3 "Sample C-Shell Script"
A sample C-shell script follows that uses the expression mechanism
of the C-shell and some of its control structures:
.DS I
% cat copyc
#
# Copyc copies those C programs in the specified list
# to the directory ~/backup if they differ from the files
# already in ~/backup
#
set noglob
foreach i ($argv) 

        if ($i !~ *.c) continue  # not a .c file so do nothing

        if (! \-r ~/backup/$i:t) then
                echo $i:t not in backup... not cp\e\'ed
                continue
        endif

        cmp \-s $i ~/backup/$i:t # to set $status

        if ($status != 0) then
                echo new backup of $i
                cp $i ~/backup/$i:t
        endif
end
.DE
.P
This script makes use of the
.B foreach
command, which causes the C-shell to execute the commands between the
.B foreach
and the matching
.B end
for each of the values given between parentheses
with the named variable, 
in this case 
.Q "i"
set to successive values in the list.
Within this loop we may use the command
.B break
to stop executing the loop 
and
.B continue
to prematurely terminate one iteration
and begin the next.
After the
.B foreach
loop the iteration variable
(\fIi\fR in this case)
has the value at the last iteration.
.P
We set the variable
.I noglob
here to prevent filename expansion of the members of
.I argv.
This is a good idea, in general, if the arguments to a C-shell script
are filenames which have already been expanded or if the arguments
may contain filename expansion metacharacters.
It is also possible to quote each use of a 
.Q "$"
variable expansion,
but this is harder and less reliable.
.P
The other control construct used here is a statement of the form
.DS I
\fBif\fR ( expression ) \fBthen\fR
	command
	...
\fBendif\fR
.DE
The placement of the keywords here is
.I not
flexible due to the current implementation of the C-shell.
The following two formats are not acceptable to the C-shell:
.DS I
\fBif\fR (expression) # Won't work!
\fBthen\fR
	command
	...
\fBendif\fR
.DE
and
.DS I
\fBif\fR (expression) \fBthen\fR command \fBendif\fR # Won't work
.DE
.P
The C-shell does have another form of 
the if statement of the form
.DS I
\fBif\fR ( expression ) \fBcommand\fR
.DE
which can be written
.DS I
\fBif\fR ( expression ) \e
	command
.DE
.P
Here we have escaped the newline for the sake of appearance.
The command must not involve 
.Q "\||\|" , 
.Q "&"
or 
.Q ";"
and must not be another control command.
The second form requires the final backslash (\e) to
.B immediately
precede the end-of-line.
.P
The more general
.B if
statements above also admit a sequence of
.B else\-if
pairs followed by a single
.B else
and an
.B endif,
for example:
.DS I
\fBif\fR ( expression ) \fBthen\fR
	commands
\fBelse\fR \fBif\fR (expression ) \fBthen\fR
	commands
\&...

\fBelse\fR
	commands
\fBendif\fR
.DE
.P
Another important mechanism used in C-shell scripts is the colon
(:) modifier.
We can use the modifier 
.Q ":r"
here to extract the root 
of a filename or
`:e' to extract the
.I extension.
Thus if the variable
.Q "i"
has the value
.FN /mnt/foo.bar
then
.DS I
echo $i $i:r $i:e
.DE
produces
.DS I
/mnt/foo.bar /mnt/foo bar
.DE
This shows how the 
.Q ":r"
modifier strips off the trailing 
.Q ".bar"
and the 
.Q ":e"
modifier leaves only the 
.Q "bar" .
Other modifiers take off the last component of a pathname leaving
the head 
.Q ":h"
or all but the last component of 
a pathname leaving the tail 
.Q ":t" .
These modifiers are fully described in the
.IR csh (1S)
entry in the 
.I "\*(x2 Reference Manual" .
It is also possible to use the
command substitution mechanism described 
in the next major section to perform modifications
on strings to then reenter the C-shells environment.
Since each usage of this mechanism 
involves the creation of a new process,
it is much more expensive 
to use than the colon (:) modification mechanism.
(It is also important to note that
the current implementation of the C-shell 
limits the number of colon modifiers
on a 
.Q "$"
substitution to 1. 
Thus
.DS I
% echo $i $i:h:t
.DE
produces
.DS I
/a/b/c /a/b:t
.DE
and does not do what you might expect.
.P
Finally, we note that the number sign character (#) 
lexically introduces a C-shell
comment in C-shell scripts (but not from the terminal).
All subsequent characters on the input line after a 
number sign are discarded by the C-shell.
This character can be quoted using 
.Q "\'"
or 
.Q "\e"
to place it in an argument word.
.H 3 "Other Control Structures"
The C-shell also has control structures
.B while
and
.B switch
similar to those of C.
These take the forms
.DS I
\fBwhile\fR ( expression )
	commands
\fBend\fR
.DE
and
.DS I
\fBswitch\fR ( word )

\fBcase\fR str1:
	commands
	\fBbreaksw\fR

\& ...

\fBcase\fR strn:
	commands
	\fBbreaksw\fR

\fBdefault:\fR
	commands
	\fBbreaksw\fR

\fBendsw\fR
.DE
For details see the manual section for
.IR csh (1S).
C programmers should note that we use
.B breaksw
to exit from a
.B switch
while
.B break
exits a
.B while
or
.B foreach
loop.
A common mistake to make in C-shell scripts is to use
.B break
rather than
.B breaksw
in switches.
.P
Finally, the C-shell allows a
.B goto
statement, with labels looking like they do in C:
.DS I
loop:
	commands
	\fBgoto\fR loop
.DE
.H 3 "Supplying Input to Commands"
Commands run from C-shell scripts receive by default the standard
input of the C-shell which is running the script.
This is different from previous C-shells running
under \*(x1. 
It allows C-shell scripts to fully participate in pipelines, 
but mandates extra notation for commands which are to take
inline data.
.P
Thus we need a metanotation for supplying inline data to commands in
C-shell scripts.
As an example, consider this script which runs the editor to
delete leading blanks from the lines in each argument file:
.DS I
# deblank \-\- remove leading blanks
foreach i ($argv)
ed \- $i << \'EOF\'
1,$s/^[ ]*//
w
q
\&\'EOF\'
end
.DE
The notation 
.DS I
<< \'EOF\'
.DE
means that the standard input for the
.B ed
command is to come from the text in the C-shell script file
up to the next line consisting of exactly EOF.
The fact that the EOF is enclosed in single quotation
marks (\|\'\|), i.e., it is quoted,
causes the C-shell to not perform 
variable substitution on the intervening lines.
In general, if any part of the word following the 
.Q "<<"
which the
C-shell uses to terminate the text to be given to the command is quoted
then these substitutions will not be performed.
In this case since we used the form 
.Q "1,$"
in our editor script
we needed to insure that this dollar sign was 
not variable substituted.
We could also have insured this by preceding the 
dollar sign ($) with a backslash (\|\e\|), i.e.:
.DS I
1,\e$s/^[ ]*//
.DE
but quoting the EOF terminator is a more reliable 
way of achieving the same thing.
.H 3 "Catching Interrupts"
If our C-shell script creates temporary files, we may wish to catch
interruptions of the C-shell script so that 
we can clean up these files.  We can then do
.DS I
onintr label
.DE
where
.I label
is a label in our program.
If an interrupt is received the C-shell will do a
.Q "goto label"
and we can remove the temporary files and then do an
.I exit
command (which is built in to the C-shell)
to exit from the C-shell script.
If we wish to exit with a nonzero status we can write
.DS I
exit (1)
.DE
to exit with status 1.
.H 3 "Other Features"
There are other features of the C-shell useful to writers of C-shell
procedures.
The
.I verbose
and
.I echo
options and the related
.B \-v
and
.B \-x
command line options can be used 
to help trace the actions of the C-shell.
The
.B \-n
option causes the C-shell only to read commands and not to execute
them and may sometimes be of use.
.P
One other thing to note is that
the C-shell
will not execute C-shell scripts which do not begin with the
number sign character (#), 
that is C-shell scripts that do not begin with a comment.
Similarly, the 
.FN /bin/sh 
on your system may well defer to 
the C-shell to interpret C-shell scripts that begin with the
number sign (#).
This allows C-shell scripts for both C-shells to live in harmony.
.P
There is also another quotation mechanism using the
quotation mark ("), 
which allows only some of the expansion mechanisms we have so far 
discussed to occur on the quoted string and 
serves to make this string into a single word
as the single quote (\|\'\|) does.
.H 2 "Loops At The Terminal"
It is occasionally useful to use the
.B foreach
control structure at the terminal to aid in performing a number
of similar commands.
For instance, if there were
three C-shells in use on a particular system,
.FN /bin/sh ,
.FN /bin/nsh ,
and
.FN /bin/csh ,
you could count the number of persons 
using each C-shell by using the following commands:
.DS I
grep \-c csh$ /etc/passwd
grep \-c nsh$ /etc/passwd
grep \-c \-v sh$ /etc/passwd
.DE
Since these commands are very similar we can use
.B foreach
to do this more easily.
Input is in boldface:
.DS I
.RB $ " foreach i (\'sh$\' \'csh$\' \'\-v sh$\')"
.RB ? " grep \-c $i /etc/passwd"
.RB ? " end"
.DE
Note here that the C-shell prompts for
input with 
.Q "? "
when reading the body of the loop.
This occurs only when the 
.B foreach
command is entered interactively.
.P
Also useful with loops are variables that contain 
lists of filenames or other words.
For example, examine the following terminal session:
.DS I
.RB % " set a=(\`ls\`)"
.RB % " echo $a"
csh.n csh.rm
.RB % " ls"
csh.n
csh.rm
.RB % " echo $#a"
2
.DE
The
.B set
command here gave the variable 
.Q "a"
a list of all the filenames in the current directory as value.
We can then iterate over these names to perform any chosen function.
.P
The output of a command within back quotation marks (\|\`\|)
is converted by the C-shell to a list of words.
You can also place the quoted string within double
quotation marks (")
to take each (nonempty) line as a component of the variable.
This prevents the lines from being split 
into words at blanks and tabs.
A modifier 
.Q ":x"
exists 
which can be used later to expand each component
of the variable into another variable by splitting 
the original variable into separate words
at embedded blanks and tabs.
.H 2 "Braces { ... } in Argument Expansion"
Another form of filename expansion, alluded
to before involves the characters, 
.Q "{"
and 
.Q "}" .
These characters specify that the contained strings, 
separated by commas (,)
are to be consecutively substituted into the containing characters
and the results expanded left to right.
Thus
.DS I
A{str1,str2,...strn}B
.DE
expands to
.DS I
Astr1B Astr2B ... AstrnB
.DE
This expansion occurs before the other filename expansions, and may
be applied recursively (i.e., nested).
The results of each expanded string are sorted separately, left
to right order being preserved.
The resulting filenames are not required to exist if no other expansion
mechanisms are used.
This means that this mechanism can be used 
to generate arguments which are not filenames, 
but which have common parts.
.P
A typical use of this would be
.DS I
mkdir ~/{hdrs,retrofit,csh}
.DE
to make subdirectories 
.FN hdrs , 
.FN retrofit
and 
.FN csh
in your home directory.
This mechanism is most useful when the common prefix is longer
than in this example:
.DS I
chown root /usr/{ucb/{ex,edit},lib/{ex?.?*,how_ex}}
.DE
.H 2 "Command substitution"
A command enclosed in back quotation marks (\|\`\|) is replaced, 
just before filenames are expanded, 
by the output from that command.
Thus, it is possible to do
.DS I
set pwd=\`pwd\`
.DE
to save the current directory in the variable
.Q "pwd"
or to do
.DS I
vi \`grep \-l TRACE *.c\`
.DE
to run the editor
.B vi
supplying as arguments those files whose names end in 
.Q ".c"
which have the string 
.Q "TRACE"
in them.
Command expansion also occurs in input redirected with 
.Q "<<"
and within quotations (").
Refer to 
.IR csh (1S)
in the
.I "\*(x2 Reference"
manual for more information.
.H 2 "Other Details Not Covered Here"
In particular circumstances it may be necessary to know the exact
nature and order of different substitutions performed by the C-shell.
The exact meaning of certain combinations of quotations is also
occasionally important.
These are detailed fully in its manual section.
.P
The C-shell has a number of command line option flags mostly of use
in writing \*(x1 programs and debugging C-shell scripts.
See
.IR csh (1S)
in the
.I "\*(x2 Reference Manual"
for a list of these options.
.H 2 "Special Characters"
The following table lists the special characters of
.I csh
and the \*(x1 system. 
A number of these characters also have special meaning in expressions.
See the
.I csh
manual section
for a complete list.
.ta .75i 1.5i 2.25i
.P
Syntactic metacharacters
.DS I
;	Separates commands to be executed sequentially
|	Separates commands in a pipeline
( )	Brackets expressions and variable values
&	Follows commands to be executed without 
	waiting for completion
.DE
.P
Filename metacharacters
.DS I
/	Separates components of a file's pathname
\.	Separates root parts of a filename from extensions
?	Expansion character matching any single character
*	Expansion character matching any sequence of characters
[ ]	Expansion sequence matching any single character 
	from a set of characters
~	Used at the beginning of a filename to indicate 
	home directories
{ }	Used to specify groups of arguments with common parts
.DE
.P
Quotation metacharacters
.DS I
\e	Prevents meta-meaning of following single character
\'	Prevents meta-meaning of a group of characters
"	Like \', but allows variable and command expansion
.DE
.P
Input/output metacharacters
.DS I
<	Indicates redirected input
>	Indicates redirected output
.DE
.P
Expansion/Substitution Metacharacters
.DS I
$	Indicates variable substitution
!	Indicates history substitution
:	Precedes substitution modifiers
^	Used in special forms of history substitution
\`	Indicates command substitution
.DE
.P
Other Metacharacters
.DS I
#	Begins scratch filenames; indicates C-shell comments
\-	Prefixes option (flag) arguments to commands
.DE
