'
' #P4
' A. T. Short, 9/82
' Copyright (c) Microsoft Corporation 1982
'
' %W% %H%	%Q%
'
.aX
.nr H1 2
.H 1 "APPENDIX C: C Language Portability"
.PH "'Appendix C''Appendix C'"
The C language is defined in the appendix to 
.I "The C Programming Language" ,
by Kernighan and Ritchie.
This definition leaves many details to be decided 
by individual implementations of the language. 
It is those incompletely
specified features of the language that detract from its
portability and that should be studied when attempting to
write portable C code.
.P
Most of the issues affecting C portability arise from differences
in either target machine hardware or compilers. 
C was designed to
compile to efficient code 
for the target machine (initially a PDP-11)
and so many of the language features not precisely defined are those
that reflect a particular machine's hardware characteristics.
.P
This document highlights the various aspects of C that may
not be portable across different machines and compilers. 
It also briefly discusses the portability 
of a C program in terms of its
environment, which is determined by the system calls and library
routines it uses during execution, file pathnames it requires,
and other items not guaranteed to be constant across different systems.
.P
The C language has been implemented on many different computers with
widely different hardware characteristics, varying from small 8-bit
microprocessors to large mainframes. 
This document is largely concerned
with the portability of C code in the \*(x1 programming environment.
This is a more restricted problem to consider since all \*(x1 systems
to date run on hardware with the following basic characteristics:
.P
.DL
.LI
ASCII character set
.LI
8-bit bytes
.LI
2-byte or 4-byte integers
.LI
Two's complement arithmetic
.LE
.P
None of these features is required by the formal definition of the
language, nor is it true of all implementations of C. 
However, the remainder of this document is largely devoted 
to those systems where these basic assumptions hold.
.P
The C language definition contains no specification of how input
and output is performed. 
This is left to system calls and library
routines on individual systems. 
Within \*(x1 systems there are a
large number of system calls and library routines that can be
considered portable. 
These are described briefly in a later section.
.P
This document is not intended as a C language primer, for that
.I "The C Programming Language"
should be used. 
It is assumed here that the reader is familiar with
C, and with the basic architecture of common microprocessors.
.H 2 "Source Code Portability"
We are concerned here with source code portability, which means 
that programs can be compiled and run successfully on different
machines without alteration.
.P
Programs can be written to achieve this goal using several techniques.
The first is to avoid using inherently nonportable language features.
Secondly, any nonportable interactions with the environment, such as
I/O to nonstandard devices should be isolated, and possibly passed
as an argument to the program at run time. 
For example programs should
not, in general, contain hard-coded file pathnames 
except where these are
commonly understood to be portable 
(an example might be
.IR /etc/passwd ).
.P
Files required at compile time (i.e., include files) may also introduce
nonportability if the pathnames are not the same on all machines.
However in some cases the use of include files to contain machine
parameters can be used to make the source code itself portable.
.H 2 "Machine Hardware"
As mentioned earlier, most nonportable features of the C language
are due either to hardware differences in the target machine or
to compiler differences. 
This section lists the more common hardware
differences encountered on \*(x1 systems and some language features
to beware of.
.H 3 "Byte Length"
The length of the
.B char
data type is not defined in the language, other than that it must be
sufficient to hold all members of the machine's character set as
positive numbers. Within the scope of this document we will
consider only 8-bit bytes, since this is the byte size
on all \*(x1 systems.
.H 3 "Word Length"
The definition of C makes no mention of the size of the basic data
types for a given implementation. 
These generally follow the most
natural size for the underlying machine. 
It is safe to assume that
.B short
is no longer than
.BR long .
Beyond that no assumptions are portable. 
For example on the PDP-11
.B short
is the same length as
.BR int ,
whereas on the VAX
.B long
is the same length as
.BR int .
.P
Programs that need to know the size of a particular data type
should avoid hard-coded constants where possible. 
Such information can usually be written in a fairly portable way. 
For example the maximum positive integer (on a two's complement
machine) can be obtained with:
.DS I
#define MAXPOS	((int)(((unsigned)~0) >> 1))
.DE 
.P
This is usually preferable to something like:
.P
.DS I
#ifdef PDP11
#define MAXPOS 32767
#else
	...
#endif
.DE
.P
Likewise to find the number of bytes in an
.B int
use
.B sizeof(int)
rather than 2, 4, or some other nonportable constant.
.H 3 "Storage Alignment"
The C language defines no particular layout for storage of data
items relative to each other, or for storage of elements of
structures or unions within the structure or union.
.P
Some CPU's, such as the PDP-11 and M68000 require that
data types longer than one byte be aligned on even byte address
boundaries. 
Others, such as the 8086 and VAX-11 have no such
hardware restriction. 
However, even with these machines, 
most compilers generate code that aligns words, structures,
arrays and long words, on even addresses, or even long word
addresses. 
Thus, 
on the VAX-11, the following code sequence
gives '8', even though the VAX hardware can access an
.B int
(a 4-byte word) on any physical starting address:
.DS I
struct s_tag {
	char c;
	int  i;
};
printf("%d\en",sizeof(struct s_tag));
.DE
.P
The principal implications of this variation
in data storage are twofold: 
.DL
.LI data accessed as nonprimitive
data types is not portable, and 
.LI 
neither is code that
makes use of knowledge of the layout on a particular
machine.
.LE
.P
Thus unions containing structures are nonportable if the
union is used to access the same data in different ways. 
Unions are only likely to be portable if they are used simply to have
different data in the same space at different times. 
For example,
if the following union were used to obtain four bytes 
from a long word, there's no chance of the code being portable:
.DS I
union {
	char c[4];
	long lw;
} u;
.DE
.P
The
.I sizeof
operator should always be used when reading and writing structures:
.DS I
struct s_tag st;

   ...

write(fd, &st, sizeof(st));
.DE
.P
This ensures portability of the source code. It does NOT produce a
portable data file. 
Portability of data is discussed in a later section.
.P
Note that the
.I sizeof
operator returns the number of bytes an object would occupy in
an array. 
Thus on machines where structures are always aligned to
begin on a word boundary in memory, the
.I sizeof
operator will include any necessary padding for this in the
return value,
even if the padding occurs after all useful data in the structure.
This occurs whether or not the argument is actually
an array element.
.H 3 "Byte Order in a Word"
The variation in byte order in a word between machines
affects the portability of
data between machines more than the portability of source code.
However any program that makes use of knowledge of the internal
byte order in a word is not portable. 
For example, on some
PDP-11 systems there is an include file
.FN misc.h
that contains the following structure declaration:
.P
.DS I
/*
* structure to access an
* integer in bytes
*/
struct {
	char	lobyte;
	char	hibyte;
};
.DE
.P
With certain less restrictive compilers this could be used
to access the high and low order bytes of an integer separately,
and in a completely nonportable way. 
The correct way to do this
is to use mask and shift operations to extract the required byte:
.P
.DS I
#define LOBYTE(i) (i & 0xff)
#define HIBYTE(i) ((i >> 8) & 0xff)
.DE
.P
Note that even this is only applicable to machines with two
bytes in an
.B int.
.P
One result of the byte ordering problem is that the
following code sequence will not always perform as
intended:
.DS I
int c = 0;

read(fd, &c, 1);
.DE
.P
On machines where the low order byte is stored first,
the value of
.I c
will be the byte value read. 
On other machines the byte is read
into some byte other than the low order one, 
and the value of
.I c
is different.
.H 3 "Bitfields"
Bitfields are not implemented in all C compilers.
When they are, a number of restrictions apply:
.P
.DL
.LI
No field may be larger than an
.BR int .
.LI
No field will overlap an
.B int
boundary. If necessary the compiler will leave
gaps and move to the next
.B int
boundary.
.LE
.P
The C language makes no guarantees about whether fields are assigned
left to right, or right to left in an
.BR int .
Thus while bitfields may be useful for storing flags, and other
small data items, their use in unions to disect bits from other
data is definitely nonportable.
.P
To ensure portability no individual field should exceed 16 bits.
.H 3 "Pointers"
The C language is fairly generous in allowing manipulation
of pointers, to the extent that most compilers will not object
to nonportable pointer operations. The
.I lint
program is particularly useful for detecting questionable
pointer assignments and comparisons.
.P
The common nonportable use of pointers is where a pointer
to one data type is cast to be a pointer to a different
data type. This almost always makes some assumption about
the internal byte ordering and layout of the data type, and
is therefore nonportable. For example, in the following code,
the ordering of the bytes from the
.B long
in the byte array is not portable:
.P
.DS I
char c[4];
long *lp;

lp = (long *)&c[0];
*lp = 0x12345678L;
.DE
.P
The
.I lint
program will issue warning messages about such uses of pointers.
Very occasionally it is necessary and valid to write code like this. An
example is when the
.IR malloc ()
library routine is used to allocate memory for something other
than type
.BR char .
The routine is declared as type
.B "char\0*"
and so the return value has to be cast to the type to be stored
in the allocated memory. If this type is not
.BR "char\0*"
then
.I lint
will issue a warning concerning illegal type conversion. In
addition, the
.IR malloc ()
routine is written to always return a starting address suitable
for storing all types of data, but
.I lint
does not know this, so it gives a warning about
possible data alignment problems too. In the following example,
.IR malloc ()
is used to obtain memory for an array of 50 integers. The code
will attract a warning message from
.IR lint .
There is nothing that can be done about this.
.DS I
extern char *malloc();
int *ip;

ip = (int *)malloc(50);
.DE
.H 3 "Address Space"
The address space available to a program running under \*(x1
varies considerably from system to system. On a small PDP-11
there may be only 64k bytes available for program and data
combined (although this can be increased - see
.IR 23fix (1)).
Larger PDP-11's, and some 16 bit microprocessors allow 64k bytes
of data, and 64k bytes of program text. Other machines may
allow considerably more text, and possibly more data as well.
.P
Large programs, or programs that require large data areas may
have portability problems on small machines.
'\"	.P
'\"	\*(x1 3.0 has a
'\"	.IR ulimit (2)
'\"	system call which returns the maximum allowed argument to the
'\"	.IR brk (2)
'\"	system call. This may be useful to avoid hard-coding maximum
'\"	run time memory allocations.
.H 3 "Character Set"
We have said that we are concerned here mainly with the ASCII
character set. The C language does not require this however.
The only requirements are:
.P
.DL
.LI
All characters fit in the
.B char
data type.
.LI
All characters have positive values.
.LE
.P
In the ASCII character set, all characters have values between
zero and 127. Thus they can all be represented in 7 bits, and
on an 8 bits per byte machine are all positive regardless of whether
.B char
is treated as signed or unsigned.
.P
There is a set of macros defined under \*(x1 in the header file
.I /usr/include/ctype.h
which should be used for most tests on character quantities.
Not only do they provide some insulation from the internal structure
of the character set, their names are more meaningful than the
equivalent line of code in most cases, Compare
.DS I
if(isupper(c))
.DE 1
to
.DS I
if((c >= 'A') && (c <= 'Z'))
.DE
.P
With some of the other macros, such as
.IR isxdigit ()
to test for a hex digit, the advantage is even greater. Also,
the internal implementation of the macros makes them more
efficient than an explicit test with an 'if' statement.
.H 2 "Compiler Differences"
There are a number of C compilers running under \*(x1. On PDP-11
systems there is the so called "Ritchie" compiler.
Also on the 11, and
on most other systems, there is the Portable C Compiler.
.H 3 "Signed/Unsigned char, Sign Extension"
The current state of the signed versus unsigned
.B char
problem is best described as unsatisfactory. 
The problem is
completely explained and discussed in 
.I "Sign Extension and Portability in C" , 
Hans Spiller, Microsoft 1982,
so that material is not repeated here.
.P
The sign extension problem is one of the more serious barriers to
writing portable C, and the best solution at present is to write
defensive code that does not rely 
on particular implementation features. 
The above paper suggests some ways.
.H 3 "Shift Operations"
The left shift operator,
.B <<
shifts its operand a number of bits left,
filling vacated bits with zero. 
This is a so-called logical shift.
.P
The right shift operator,
.B >>
when applied to an unsigned quantity,
performs a logical shift operation. When applied to a signed
quantity, the vacated bits may be filled with zero (logical shift)
or with sign bits (arithmetic shift). 
The decision is implementation
dependent, and code 
that uses knowledge of a particular
implementation is nonportable.
.P
The PDP-11 compilers use arithmetic right shift. Thus to avoid
sign extension it is necessary to either shift and mask out the
appropriate number of high order bits, or to use a divide operator
that avoids the problem completely:
.DS I
char c;

For  c >> 3;	use:	(c >> 3) & 0x1f;
		or:	c / 8; 
.DE
.H 3 "Identifier Length"
The use of long identifier names will cause portability problems
with some compilers. 
There are three different cases to be aware of:
.P
.DL
.LI
C Preprocessor Symbols.
.LI
C Local Symbols.
.LI
C External Symbols.
.LE
.P
The loader used may also place a restriction on the number of
unique characters in C external symbols.
.P
Symbols unique in the first six characters are unique to most
C language processors.
.P
On some non-\*(x1 C implementations, uppercase and lowercase letters
are not distinct in identifiers.
.H 3 "Register Variables"
The number and type of register variables in a function depends on
the machine hardware and the compiler. Excess and invalid register
declarations are treated as nonregister declarations
and should not
cause a portability problem. 
On a PDP-11, up to three register declarations
are significant, and they must be of type
.BR int ,
.BR char ,
or pointer. 
While other machines and compilers may
support declarations such as
.DS I
register unsigned short
.DE
this should not be relied upon.
.P
Since the compiler ignores excess register keywords, register type
variables should always be declared in their importance of being
register type. 
Then the ones the compiler ignores will be the least important.
.H 3 "Type Conversion"
The C language has some rules for implicit type conversion;
tt also allows explicit type conversions by type casting. 
The most common portability problem arising 
from implicit type conversion is unexpected
sign extension. 
This is a potential problem whenever something of type
.B char
is compared with an
.B int .
.P
For example
.DS I
char c;

if(c == 0x80)
	...
.DE
.P
will never evaluate true on a machine which sign extends since
.Q c
is sign extended before the comparison with 0x80, an
.B int .
.P
The only safe comparison between
.B char
type and an
.B int
is the following:
.DS I
char c;

if(c == 'x')
	...
.DE
.P
This is reliable since C guarantees all characters to be positive.
The use of hard-coded octal constants is subject to sign extension.
For example the following program prints
.Q ff80
on a PDP-11:
.DS I
main()
{
	printf("%x\n",'\e200');
}
.DE
.P
Type conversion also takes place when arguments are passed to
functions. Types
.B char
and
.B short
become
.BR int .
Once again machines that sign extend
.B char
can give surprises. 
.ne 1i
For example the following program gives
-128 on some machines:
.DS I
char c = 128;
printf("%d\en",c);
.DE
.P
This is because
.Q c
is converted to
.B int
before passing on the stack to the function. 
The function
itself has no knowledge of the original type of the argument,
and is expecting an
.BR int .
The correct way to handle this is to code defensively and
allow for the possibility of sign extension:
.DS
char c = 128;
printf("%d\en", c & 0xff);
.DE
.H 3 "Functions With Variable Number of Arguments"
Functions with a variable number of arguments present a particular
portability problem if the type of the arguments is variable too.
In such cases the code is dependent upon the size of various data
types.
.P
In \*(x1 there is an include file,
.IR /usr/include/varargs.h ,
that contains macros for use in variable argument functions to
access the arguments in a portable way:
.DS 
 typedef char *va_list;
 #define va_dcl int va_alist;
 #define va_start(list) list = (char *) &va_alist
 #define va_end(list)
 #define va_arg(list,mode) ((mode *)(list += sizeof(mode)))[-1]
.DE
.FG "File: /usr/include/varargs.h"
.P
The va_end() macro is not currently required.
The use of the other macros will be demonstrated
by an example of the
.IR fprintf ()
library routine. This has a first argument of type
.B "FILE *" ,
and a second argument of type
.BR "char *" .
Subsequent arguments are of unknown type and number at compilation
time. They are determined at run time by the contents of the control
string, argument 2.
.P
The first few lines of
.IR fprintf ()
to declare the arguments and find the output file and control string
address could be:
.DS
 #include <varargs.h>
 #include <stdio.h>

 int
 fprintf(va_alist)
 va_dcl;
 {
 	va_list ap;	/* pointer to arg list	 */
 	char *format;
 	FILE *fp;

 	va_start(ap);	/* initialize arg pointer */
 	fp = va_arg(ap, (FILE *));
 	format = va_arg(ap, (char *));

 		...
 }
.DE
.P
Note that there is just one argument declared to
.IR fprintf ().
This argument is declared by the va_dcl macro to be type
.BR int ,
although its actual type is unknown at compile time. The
argument pointer,
.IR ap ,
is initialized by 
.IR va_start ()
to the address of the first argument.
Successive arguments can be picked from the stack so long as their
type is known using the 
.IR va_arg ()
macro. This has a
.B type
as its second argument, and this controls what data is removed from
the stack, and how far the argument pointer,
.IR ap ,
is incremented.
In
.IR fprintf (),
once the control string is found, the type of subsequent arguments is
known and they can be accessed sequentially by repeated calls to va_arg().
For example, arguments of type
.BR double ,
.BR "int *" ,
and
.BR "short" ,
could be retrieved as follows:
.P
.DS
	double dint;
	int *ip;
	short s;

	dint = va_arg(ap, double);
	ip = va_arg(ap, (int *));
	s = va_arg(ap, short);
.DE
.P
The use of these macros makes the code more portable, although it does
assume a certain standard method of passing arguments on the stack. In
particular no holes must be left by the compiler, 
and types smaller than
.B int
(e.g.,
.BR char ,
and
.B short
on long word machines)
must be declared as
.BR int .
.H 3 "Side Effects, Evaluation Order"
The C language makes few guarantees about the order of evaluation
of operands in an expression, or arguments to a function call. Thus
.DS
	func(i++, i++);
.DE
.P
is extremely nonportable, and even
.P
.DS
	func(i++);
.DE
.P
is unwise if
.IR func ()
is ever likely to be replaced by a macro, since the macro may use
.I i
more than once. 
There are certain \*(x1 macros commonly used in
user programs; these are all guaranteed 
to only use their argument
once, and so can safely be called 
with a side-effect argument.
The commonest examples are
.IR getc (),
.IR putc (),
.IR getchar (),
and
.IR putchar ().
.P
Operands to the following operators are guaranteed to be evaluated
left to right:
.DS 
.B
	,	&&	||	?	:
.R
.DE
.P
Note that the comma operator here is a separator for two
C statements.
A list of items separated by commas in a declaration list
are not guaranteed to be processed left to right. Thus the
declaration
.DS
	register int a, b, c, d;
.DE
.P
on a PDP-11 where only three register variables may be declared
could make any three of the four variables register type,
depending on the compiler. The correct declaration is to decide
the order of importance of the variables being register type, and
then use separate declaration statements, since the order of
processing of individual declaration statements is guaranteed to
be sequential:
.DS
	register int a;
	register int b;
	register int c;
	register int d;
.DE
.P
For the same reason declaration initializations of the following
type are unwise:
.DS
	int  a = 0, b = a;
.DE
'\"	.H 3 "New Language Features"
'\"	There are several "new" features to the C language which are
'\"	not supported by all compilers, and are therefore not guaranteed
'\"	to be portable. These are detailed in 
'\"	Appendix D, 
'\"	.Q "Recent Changes To C" .
'\"	.P
'\"	For example, some compilers support
'\"	.Q "structure assignment"
'\"	statements of the following forms:
'\"	.DS I
'\"	struct s_tag s1, s2, *sp1, *sp2;
'\"	
'\"		...
'\"		s2   =  s1;
'\"		*sp2 =  *sp1;
'\"	.DE
'\"	.P
'\"	A related extension to C allows the passing of structures as arguments
'\"	to functions, and the returning of structures as function return
'\"	values.
'\"	.P
'\"	Some recent compilers support the
'\"	.B void
'\"	data type. This means 'no type' and is used for type casting
'\"	function calls when the return value is not required. It is
'\"	useful for reducing unnecessary comments from
'\"	.IR lint .
'\"	For example on some systems the library routine
'\"	.I printf
'\"	is declared as being type
'\"	.BR int ,
'\"	yet few programs wish to examine the return value. This will
'\"	attract a comment from
'\"	.I lint
'\"	unless the return value is made type
'\"	.BR void ,
'\"	for example:
'\"	.DS I
'\"	(void)printf("hello world\en");
'\"	.DE
'\"	.P
'\"	On those \*(x1 systems which do not have the
'\"	.B void
'\"	type, code containing it can be compiled 
'\"	by placing the following statement in a header file:
'\"	.DS I
'\"	typedef int void;
'\"	.DE
'\"	.P
'\"	This does not prevent comments from lint about ignored return values,
'\"	it just enables code using
'\"	.B void
'\"	to be compiled.
.H 2 "Program Environment Differences"
Most nontrivial programs make system calls and use library routines
for various services. The sections below indicate some of those
routines that are not always portable, and those that
particularly aid portability.
.P
We are concerned here primarily with portability under the \*(x1
operating system. 
Many of the \*(x1 system calls are specific to
that particular operating system environment and are not present
on all other operating system implementations of C. 
Examples of this are
.IR getpwent ()
for accessing entries in the \*(x1 password file, and
.IR getenv ()
which is specific to the \*(x1 concept of a process's environment.
.P
Any program containing hard-coded pathnames to files or
directories, or user id's, login names, terminal lines or other
system dependent parameters is nonportable. 
These types of constant
should be in header files, 
passed as command line arguments, 
obtained from the environment, 
or by using the \*(x1
.I default
parameter library routines
.IR dfopen (),
and
.IR dfread ().
.P
Within \*(x1, most system calls and library routines are portable
across different implementations and \*(x1 releases. 
However, a few routines have changed in their user interface.
'\"	.H 3 "System Calls"
'\"	.VL 12 2
'\"	.LI "ioctl"
'\"	This system call is used to alter the characteristics 
'\"	of a terminal
'\"	line (baud rate, erase/kill processing, etc.). 
'\"	The routine was
'\"	enhanced in \*(x1 Release 3, 
'\"	and code from previous \*(x1 systems
'\"	will require some alteration.
'\"	.LI "open"
'\"	In \*(x1 Release 3, 
'\"	this system call has been enhanced to handle
'\"	FIFO's, and other functional improvements, 
'\"	including setting a file
'\"	up for subsequent nonblocking reads.
'\"	.LE
.H 3 "Libraries"
The various \*(x1 library routines are generally portable
among \*(x1 systems; however, note the following:
.P
.VL 10 1 
.LI "printf"
The members of the printf family,
.IR printf ,
.IR fprintf ,
.IR sprintf ,
.IR sscanf ,
and
.IR scanf
have changed in several small ways during the evolution of \*(x1,
and some features are not completely portable. 
The return values
from these routines cannot be relied upon to have the same meaning
on all systems. 
Certain of the format conversion characters have
changed their meanings, in particular those
relating to uppercase and lowercase
in the output of hexadecimal numbers, and the specification of
.B long
integers on 16-bit word machines. 
The reference manual page for
.IR printf (3S)
contains the correct specification for the routines.
.LE
.H 2 "Portability of Data"
Data files are almost always nonportable across different machine
CPU architectures. As mentioned above, structures, unions, and
arrays have varying internal layout and padding requirements on
different machines. In addition, byte ordering within words and
actual word length may differ.
.P
The only way to get close to data file portability is to write
and read data files as one dimensional character arrays. This
avoids alignment and padding problems if the data is written
and read as characters, and interpreted that way. 
Thus ASCII text files can usually 
be moved between different machine types
without too much problem.
.H 2 "Lint"
For a complete description of
.IR lint (1)
see the discussion in a following chapter.
.P
.I Lint
is a C program checker which attempts to detect features of a
collection of C source files which are nonportable or even
incorrect C. One particular advantage over any compiler checking
is that
.I lint
checks function declaration and usage across source files. Neither
compiler nor loader do this.
.P
.I Lint
will generate warning messages about nonportable pointer
arithmetic and dubious assignments and type conversions.
Passage unscathed through
.I lint
is not a guarantee that a program is completely portable.
.nr Hu 1
.nr a 0
.nr Hc 1
.H 2 "Byte Ordering Summary"
The following conventions are used below: 
.VL 5 1
.LI a0 
The lowest
physically addressed byte of the data item. 
'a1' has a byte address
a0 + 1, and so on.
.LI b0 
the least significant byte of the data item, 'b1'
being the next least significant, and so on.
.LE
.P
Note that any program which actually makes use of the following
information is guaranteed to be nonportable!
.P
.DS I

+---------+		+-------------------+
| b0 | b1 |		| b2 | b3 | b0 | b1 |
+---------+		+-------------------+
  a0   a1		  a0   a1   a2   a3

type short		      type long
----------		      ---------
.DE
.FG "PDP-11 Byte Ordering"
.P
.DS I

+---------+		+-------------------+
| b0 | b1 |		| b0 | b1 | b2 | b3 |
+---------+		+-------------------+
  a0   a1		  a0   a1   a2   a3

type short		      type long
----------		      ---------
.DE
.FG "VAX-11 Byte Ordering"
.P
.DS I

+---------+		+-------------------+
| b0 | b1 |		| b2 | b3 | b0 | b1 |
+---------+		+-------------------+
  a0   a1		  a0   a1   a2   a3

type short		      type long
----------		      ---------
.DE
.FG "8086 Byte Ordering"
.P
.DS I

+---------+		+-------------------+
| b1 | b0 |		| b3 | b2 | b1 | b0 |
+---------+		+-------------------+
  a0   a1		  a0   a1   a2   a3

type short		      type long
----------		      ---------
.DE
.FG "M68000 Byte Ordering"
.P
.DS I

+---------+		+-------------------+
| b1 | b0 |		| b3 | b2 | b1 | b0 |
+---------+		+-------------------+
  a0   a1		  a0   a1   a2   a3

type short		      type long
----------		      ---------
.DE
.FG "Z8000 Byte Ordering"
.nr Hc 0
