.ds :? SCCS Interface Program
.PH "''''"
.OH "'\s9\f2\*(:?\fP''\\\\nP\s0'"
.EH "'\s9\\\\nP''\f2\*(:?\^\fP\s0'"
.nr Pt 0
.nr Hs 3
.nr Hi 0
.nr Hu 3
.nr Hb 3
.if n .ds d " -- 
.if t .ds d \(em
.ds s \s-1SCCS\s+1
.ds s) S\s-1CCS\s+1
.ds p \s-1UNIX\s+1
.ds p) P\s-1WB/UNIX\s+1
.ds i \s-1SID\s+1
.ds i) S\s-1ID\s+1
.ds k \s-1ID\s+1
.ds k) I\s-1D\s+1
.ds u \s-1UNIX\s+1
.ds u) U\s-1NIX\s+1
.ds s] \s-1SCCS\s+1
.ds s} S\s-1CCS\s+1
.ds a \s-1ASCII\s+1
.tr ~
.ds . \fB.\fP
.de dT
.cc :
\*.
:cc .
..
.tr ~
.nr Pt 0
.ND "April 1, 1980"
.TL "39382-930, 49579-980" 39382-900
Function and Use of an \*(s}
Interface Program
.AU "L. E. Bonanni" LEB PY 3781 4382 2F-223
.AU "A. Guyton \s-2(4/1/80 revision)\s+2" AG PY 3646 4162 2G-207 3646-800401.01MF
.AS 2
This memorandum discusses the use of a Source Code Control System
Interface Program to allow more than one user to
use \*s commands upon the same set of files.
.AE
.NS 1
Center 364 Supervision
Department 3781 Supervision
B\s-1TL\s+1 P\s-1WB\s+1, U\s-1NIX\s+1 Administrators
.NE
.MT 4
.HM I A 1
.nr Hi 0
.H 1 "Introduction"
In order to permit \*p*
.FS *
UNIX is a Trademark of Bell Laboratories.
.FE
users with different user identification numbers (user \*ks)
to use \*s commands upon the same files, an \*s interface program is
provided to temporarily grant the necessary file access permissions to
these users.
This memorandum discusses
the creation and use of
such an interface program.
This memorandum replaces an earlier version dated March 1, 1978.
.H 1 "Function"
When only one user 
uses \*s,
the real and effective user \*ks are the same, and that user \*k owns the
directories containing \*s files.
However, there are situations (for example, in large software
development projects) in which it is practical
to allow more than one user to make changes
to the same set of \*s files.
In these cases, one user 
must be chosen as the ``owner'' of the \*s files
and be the one who will ``administer'' them
(e.g., by using the
.I admin
command).
This user is termed the
.I "\*s administrator"
for that project.
Since other users of \*s do not have the same privileges and
permissions as the \*s administrator, they are not able to execute
directly those commands that
require write permission in the directory containing the \*s files.
Therefore, a project-dependent program is required to
provide an interface to the
.I get,
.I delta,
and, if desired,
.I rmdel ,
.I cdc ,
and
.I unget
commands.\*F~
.FS
Other \*s commands either do not require write permission in the
directory containing \*s files or are (generally) reserved for use
only by the administrator.
.FE
.P
The interface program must be owned by the \*s administrator,
must be executable by non-owners,
and must
have the
.I set~user~\*k~on~execution
bit on (see
.I chmod\^ (1)\*F),
.FS
All references of the form
.I name\^ (\f2N\|\fP)
refer to item
.I name
in section
.I N
of the
.I "UNIX User's Manual."
.FE
so that, when executed, the
.I "effective"
user \*k is the user \*k of the administrator.
This program's function is to invoke the desired \*s command
and to cause it to
.I inherit
the privileges of the \*s administrator for the duration of
that command's execution.
In this manner, the owner of an \*s file (the administrator)
can modify it at will.
Other users whose
.I login
names are in the
.I "user list" \*F
.FS
This is the list
of login names of
users who are allowed to modify an \*s file
by adding or removing deltas.
The login names are specified using the
.I admin\^ (1)
command.
.FE
for that file (but who are
.I not
its owners)
are given the necessary permissions only for the duration of the
execution of the interface program,
and are thus able to modify the \*s files only through the use of
.I delta
and, possibly,
.I rmdel
and
.I cdc .
.H 1 "A Basic Program"
When a \*u program is executed
it is passed (as argument 0) the
.I name
by which it is invoked,
followed by any additional user-supplied arguments.
Thus, if a program is given a number of
.I links
(names), it may alter its processing depending upon which link is
used to invoke it.
This mechanism is used by an \*s interface program to determine which
\*s command it should subsequently invoke (see \fIexec\fP(2)).
.P
A generic interface program
(``inter.c'', written in C)
is shown in Attachment I.
Note the reference to the (unsupplied) function ``filearg''.
This is intended to demonstrate that the interface program may also
be used as a pre-processor to \*s commands.
For example, function ``filearg'' could be used to modify file
arguments to be passed to the \*s command by supplying the
.I full
pathname of a file, thus avoiding extraneous typing by the user.
Also, the program could supply any additional (default)
keyletter arguments desired.
.H 1 "Linking and Use"
In general,
the following demonstrates the steps to be performed by the \*s
administrator to create the \*s interface program.
It is assumed, for the purposes of the discussion, that
the interface program ``inter.c'' resides in directory
``/x1/xyz/sccs''.
Thus, the command sequence:
.DS 1
cd  /x1/xyz/sccs
cc  \fB.\|.\|.\fP  inter.c  -o  inter  \fB.\|.\|.\fP
.DE
compiles ``inter.c''
to produce the executable module ``inter''
(the ellipses represent other arguments that may be required).
The proper mode and the
.I set~user~\*k~on~execution
bit are set by executing:
.DS 1
chmod  4755  inter
.DE
Finally, new links are created, by (for example):\*F
.FS
The names of the links may be arbitrary,
provided the interface program is able to determine from them
the names of \*s commands to be invoked.
.FE
.DS 1
ln  inter  get
ln  inter  delta
ln  inter  rmdel
.DE
Subsequently,
.I any
user whose shell parameter PATH (see
.I sh\^ (1))
specifies directory
``/x1/xyz/sccs'' as the one to be searched first for
executable commands, may execute, for example:
.DS 1
get  \(eme  /x1/xyz/sccs/s\*.abc
.DE
from any directory to
invoke the interface program (via its link ``get'').
The interface program then
executes ``/usr/bin/get'' (the actual \*s
.I get
command) upon the named file.
As previously mentioned, the interface program could be used to supply
the pathname ``/x1/xyz/sccs'', so that the user would only have to
specify:
.DS 1
get  \(eme  s\*.abc
.DE
to achieve the same results.
.H 1 "Conclusion"
An \*s interface program is used to permit users
having different user \*ks to use \*s commands upon the same
files.
Although this is its primary purpose,
such a program may also be used as a pre-processor
to \*s commands
since it can
perform operations upon its arguments.
.SG
.NS 3
Attachment I -- \*(s) Interface Program ``inter.c''
.NE
.PH "''Attachment I''"
.bp
~
.SP 5
.tl ,,\*(s) Interface Program ``inter.c'',,
.SP 2
.DS
main(argc, argv)
int argc;
char *argv[\|];
{
	register int i;
	char cmdstr[\s-1LENGTH\s+1]

	/*
	Process file arguments (those that don't begin with `\(em').
	*/
	for (i = 1; i < argc; i+\h'-0.4n'+)
		if (argv[\^i\^][0] != \(aa\(em\(aa)
			argv[\^i\^] = filearg(argv[\^i\^]);

	/*
	Get `simple name' of name used to invoke this program
	(i.e., strip off directory-name prefix, if any).
	*/
	argv[0] = sname(argv[0]);

	/*
	Invoke actual \*s command, passing arguments.
	*/
	sprintf(cmdstr, "/usr/bin/%s", argv[0]);
	execv(cmdstr, argv);
}
.DE
.sp 2
.I "April 1980"
