.\"	chapter 1
.nr H1 0
.H 1 "Introduction"
Often, people who type memos, write technical reports, 
or prepare documentation, are somewhat reluctant to adapt to the computer. 
The technology may seem overwhelming, the documentation opaque, and the text 
processing techniques unfamiliar and awkward. 
This volume is geared not only to providing a clear, reassuring introduction 
to the text processing tools available on \*(x1, but also to giving you 
a practical orientation toward text processing as a
powerful tool for greatly enhancing writing productivity.
The emphasis here, therefore, is both on describing each tool in detail and 
suggesting its best application to the task at hand. 
Strategies are offered for using \*(x1 to maximum advantage in the overall 
preparation of a manuscript through every phase, whether it be efficiently 
entering and editing text, scrutinizing the finished work for spelling errors, 
formatting the final output, or maintaining multiple versions of your text
through successive revisions. 
.P
All \*(x1 users depend heavily on many of the programs and
utilities introduced in this volume. 
Programmers, for example, use the same text editors and file comparison 
utilities discussed here to write and revise programs. 
As a text processing user, however, you may find 
that you use \*(x1 almost solely for the tools 
described here: editors, text formatting programs, and the
various pattern recognition and file comparison utilities. 
A wealth of new text processing possibilities are presented with \*(x1, and  
because there is so much information to absorb, this may at first seem to you 
like an impediment, rather than an aid, to getting the work done. 
.P
It is, of course, essential that you learn as much as possible about \*(x1 
tools, and practice using the various commands and functions immediately.
You should already be familiar with
the material covered in the
.I
\*(x1 Fundamentals
.R
manual, particularly the following topics:
.BL
.LI
commonly used \*(x1 commands
.LI
the \*(x1 file structure
.LI
the \*(x1 shell programming language 
.LI
at least one of the \*(x1 text editors, preferably
.B vi . 
.LE
.P
The best approach is to read through this volume first and decide 
which editors, utilities, and formatters best suit your needs.
Then learn selectively, but thoroughly, those tools which are most 
appropriate. 
As you use \*(x1 more extensively, you will develop a feel for which
functions work best in which situations, and you will find new ways 
to make the writing process more efficient. 
As you gain greater dexterity with particular commands, you will be 
continually amazed at how powerful the editors and related tools can be.
.H 2 "Life Cycle of a Document"
Every document, even the briefest memo, goes through several phases before
it is complete.
First, the body of the text must be entered, using one of your text editors.
Normally, at the same time you will insert the commands, or \*`macros\*', 
which 
specify in detail to the formatting programs how the final output should look. 
In addition to checking your work for mistakes and spelling errors,
you may need to go through an extensive revision process--the global 
substitution of one name or term for another, for instance, or the 
reorganization
of your manuscript using a \*`cut and paste\*' technique.
Depending on the size and scope of your project, you may also need to
compare text variants and maintain several versions of your documents.
Finally, you will be creating formatted output, whether it be a one-page
business letter produced on an ordinary lineprinter or a book-length
manuscript communicated directly to a phototypesetter.
.P
\*(x1 provides all the necessary tools to see you through every phase 
of document preparation, in many cases offering you several alternative
approaches to each task. 
As you read this manual, keep in mind that it is itself an example of \*(x1
text processing: every tool discussed here was used in its production.
The first five chapters were formatted with the \*(x1 text formatting program
.B nroff ,
using a Diablo (tm) printer.
The papers in the last section demonstrate the capabilities of 
.B troff,
a version of
.B nroff
which produces output directly to phototypesetter. 
.H 2 "Outline of this Volume"
.VL 10 1
.LI "INTRODUCTION"
.br
The concept of text processing and the overall structure of the volume is 
outlined in the chapter you are now reading.
.sp
.LI "TEXT EDITING"
.br
Since it is assumed that you are already familiar with the concept of text 
editing, and in particular with the the screen-oriented \*(x1 editor,
.B vi,
this chapter reviews some of the features of the line-oriented editor, 
.B ed.
focusing on the concept of the \*`regular expression\*'.
This chapter emphasizes the comparison of the various interactive editing tools,
to help you determine which one will be most useful to the task at hand.
.sp
.LI "PATTERN RECOGNITION AND FILE COMPARISON TOOLS"
.br
This chapter introduces a variety of \*(x1 programs which allow you to do the 
following: 
.BL
.LI
search individual files or groups of files for recurring patterns
.LI
make extensive changes to large files, or groups of files, on a 
non-interactive, or \*`batch\*', basis
.LI
compare and contrast the contents of two or more files 
.LE
.P
Although these tools have functions outside
the text processing environment (e.g., in the writing and editing 
of program text), they are of special use to the writer in making global 
changes and comparing versions of text quickly and efficiently.
Because several of these programs may be used interchangeably,
knowing which one will do the job at hand best 
is a large part of understanding their use. 
These programs streamline complicated editing command procedures, locate 
variations among several versions of text,
and can be used to process many text files at once.
These include: 
.BL
.LI
the batch editor,
.B sed 
.LI
the pattern recognition tools of the
.B grep
family:
.B grep ,
.B fgrep ,
and
.B egrep ,
.LI
the
.B awk
program
.LI
the file comparison programs 
.B diff,
.B diff3,
and
.B comm
.LE
.bp
.LI "DOCUMENT PREPARATION AND TEXT FORMATTING"
.br
This chapter focuses on strategies for generating long
manuscripts or documents, including hints on managing
files and doing "cut and paste" editing on existing
text. It also introduces the 
.B spell
program which searches for spelling and typographical errors
in your working drafts.
The use of the various macro packages, formatters, and
specialized formatting tools available with \*(x1 are discussed.
These include:
.BL
.LI
the
.B ms
macro package of formatting requests which allows the user to design formats 
simply, without having to learn the \*(x1 formatting packages. 
.LI
the two \*(x1 text formatting packages, 
.B nroff
and
.B troff ,
which produce output for the lineprinter and typesetter, respectively. 
These simplify the production of technical reports, memoranda, formal papers,
and documentation.
.LI
some specialized formatting programs that aid in document preparation,
including
.B eqn
which integrates mathematical symbols and equations 
into the text of a document,
.B tbl
which formats tabular material,
and
.B refer ,
which prepares bibliographic citations from a database.
.LE
.TC
