.\"	chapter 2
.nr H1 1
.H 1 "Using the Text Editor ed"
All users of computer systems rely heavily on 
text editing, whether their work is 
programming, preparing data, or writing documentation. 
If you are involved in text processing applications--typing
memos, writing technical reports, or preparing documentation--you may be 
working almost solely with the editing tools.
Therefore, it is extremely important that you learn as much
as possible about the editing tools available on the
system, and practice using the various commands and
functions. 
The better your understanding of which tools work best in which situations 
and the more dexterity you develop using particular
commands, the more powerfully you can make the editors and related
tools work for you.
.P
In practice, you will probably prefer to do most routine editing work 
with a single editor.
Although many of the \*(x1 tools described in this volume 
have features and commands in common, it can be awkward and confusing
to switch back and forth. 
It is suggested, therefore, that you become
comfortable and proficient with one editor, and use the others
in a supplementary way when they seem appropriate to a special need. 
Generally
.B vi,
the interactive, screen-oriented editor,
is the best choice, used along with the line-oriented search and substitution
commands from
.B ed
or 
.B ex.
An extensive introduction to
.B vi
is offered in the
.I
\*(x1 Fundamentals
.R
manual.
However, if you are using \*(x1 on a small \*(x1 system you may not have the
facilities of
.B vi
available to you. 
In this case, you will need to rely quite heavily on 
.B ed
to do most of your work.
.P
The emphasis in this chapter is on comparing and contrasting
the features of several editing tools, in order to help
you select those most appropriate to the task at hand.
The \*(x1 editor discussed here is \fBed\fR, the interactive 
line editor, but keep in mind that many of these features are also
available with \fBex\fR.
A tutorial for 
.B ed
is also presented in 
.I
\*(x1 Fundamentals. 
.R
.H 2 "Comparing and Contrasting XENIX Editing Tools"
In many respects the capabilities of all \*(x1 editing tools overlap. 
The line-oriented editors,
.B ed
and
.B ex,
are more appropriate for instantaneous entry, deletion and
simple modification of text, especially when you wish to 
specify line ranges in which the changes need to be made.
.B Sed , 
a batch editor which can run from prepared scripts,
is more appropriate when uniform changes must be made
in large files or groups of files, or when the sequence
of editing commands needed to make the changes becomes
complex. 
.B Sed
may be used interchangeably, to some extent, with
.B ed
editing scripts and the pattern recognition language,
.B awk.
.B Sed
and
.B awk
have the advantage of operating in a \*`batch\*' mode.
Files can be processed during off-peak hours and
the editing commands can be stored as \*`scripts\*' for future use.
However, like any batch operation, you do not have the option to verify or
confirm changes to your files as they occur. 
Both
.B sed
and
.B awk
are discussed extensively in the next chapter.
.P
Most of the tools introduced in Chapter Two and Three
share in common the concept of searching for \*`regular expressions\*'.
These include the editors
.B sed,
.B ed,
.B ex,
.B awk,
and
the very useful utility 
.B grep.
A regular expression 
specifies a set of strings of characters to be matched
by a pattern found in the text. 
You may also see the term \*`context address\*' used instead.
In practical terms, these are the patterns you will be asking 
the editor to search and substitute for when you are making 
changes in your text.
The class of regular expressions recognized by all of these editing
tools (unless otherwise indicated) includes the following:
.AL 1
.LI
Any ordinary character (i.e., not one of those discussed below)
is a regular expression, and matches itself.
.LI
A caret (^) at the beginning of a regular expression
matches the null character at the beginning of a line.
.LI
A dollar sign ($) at the end of a regular expression
matches the null character at the end of a line.
.LI
A period (.) matches any character except the terminal newline
of the pattern space.
.LI
A regular expression followed by an asterisk (*) matches any
number (including 0) of adjacent occurrences of the regular
expression it follows.
.LI
A string of characters in square brackets ([]) matches any character
in the string, and no others.
If, however, the first character of the string is a caret (^),
the regular expression matches any character except
the characters in the string and the terminal newline of the pattern space.
.LI
A concatenation of regular expressions is also a regular expression.
It matches the concatenation of strings equivalent to the 
components of the concatenated regular expressions.
.LI
A regular expression between the sequences \*`\e(\*' and \*`\e)\*' is
identical in effect to the regular expression without these sequences, but has
other effects which are described in the next item. 
.LI
The expression \*`\ed\*' means the same string of characters matched
by an expression enclosed in \*`\e(\*' and \*`\e)\*'
earlier in the same pattern.
Here \*`d\*' is a single digit;
the string specified is that beginning with the
\fBd\|\fRth
occurrence of \*`\e(\*' counting from the left.
For example, the expression
\*`^\e(.*\e)\e1\*' matches a line beginning with
two repeated occurrences of the same string.
.LE
.P
To use one of the special characters (^ $ . * [ ] \e /) literally to
match an occurrence of itself in the input, precede the
special character by a backslash \*`\e\*'.
For a regular expression to \*`match\*' the input requires that
the whole pattern within the address match some
portion of the pattern space.
The use of these pattern matches for specific applications
is discussed along with the individual functions of each editor or \*(x1
utility. 
.H 2 "Ed"
.B Ed
is one of the line-oriented text editors on the \*(x1 system. 
It is used primarily to create and modify any text interactively,
whether it is a document, a program, or data for a program.
The most frequently used commands are reviewed here,
followed by a discussion of editing techniques that may be especially useful
to you in text processing applications.
You should also refer to the
.B ed
tutorial in the 
.I
\*(x1 Fundamentals 
.R
manual.
.P
Since there are often several alternative procedures for
accomplishing the same editing task, with varying degrees of
efficiency, this section provides explanations and examples
of how to use 
.B ed
with less effort and greater speed.
This section also
covers the topics of using special characters in 
search and substitute commands, line addressing, global commands,
and line moving and copying.
.H 3 "Commands and Line Numbers"
The general form of
.B ed
commands is the command name, sometimes preceded by one or two line numbers. 
In the case of the commands 
.B e ,
.B r ,
and
.B w ,
a filename also follows the command.
Only one command is allowed per line, but a
\fBp\fR command may follow any other command (except the \fBe,\fR \fBr\fR, 
\fBw\fR, and \fBq\fR commands).
These commands available are:
.VL 10 5 
.LI "\fBa\fR" 
Append, or add, lines to the buffer at line dot (the current line)
unless you specify a different line. Appending continues until
you type a period on a new line,
and dot is set to the last line appended.
.LI "\fBc\fR" 
Change the specified lines to the new text which follows the command.
The new lines are terminated by a period on a newline, as with
the command
.B a. 
If no lines are specified, replace line dot.
Dot is set to the last line changed.
.LI "\fBd\fR"
Delete the lines specified. If none are specified, delete line dot.
Dot is set to the first undeleted line, unless \*`$\*'
is deleted, in which case dot is set to \*`$\*'.
.LI "\fBe\fR" 
Edit a new file.
Any previous contents of the buffer are thrown away, so a
\fBw\fR command must be given beforehand to save other files.
.LI "\fBf\fR" 
Print remembered filename.
If a name follows \fBf\fR, then the remembered name is set to it.
.LI "\fBg\fR" 
The command
.DS I
g/---/commands
.DE
will execute the commands on all those lines in the file that contain
.I --- ,
which can be any context search expression.
.LI  "\fBi\fR" 
Insert lines before specified line (or the value of dot)
until a single period is typed on a new line.
Dot is set to the last line inserted.
.LI "\fBm\fR" 
Move lines specified to after the line named after
.B m .
Dot is set to the last line moved.
.LI "\fBp\fR" 
Print specified lines.
If none are specified, print the line specified by dot.
A single line number is equivalent to the \fBp\fR command followed by a
line number.
A single <RETURN> prints the next line.
.LI  "\fBq\fR" 
Quit
.B ed .
This wipes out all text in the buffer if given twice in a row without a
\fBw\fR command.
.LI "\fBr\fR" 
Read a file into buffer at the end of the file, unless otherwise specified.
Dot is set to the last line read.
.LI "\fBs\fR" 
The command
.DS I
s/string1/string2/
.DE
substitutes the characters \*`string2\*' for \*`string1\*'
in the specified lines.
If no lines are specified, the substitution takes place
only on the line specified by dot.
Dot is set to the last line in which a substitution took place, 
which means that if no substitution takes place, 
dot remains unchanged.
The \fBs\fR command changes only the first occurrence of
\*`string1\*' on a line; to change all of them, type a
\fBg\fR after the final slash.
.LI "\fBv\fR" 
The command
.DS I
v/---/commands
.DE
executes commands on all those lines in the file that do not contain 
\*`---\*'.
.LI "\fBw\fR" 
Writes the buffer onto a file. Dot remains unchanged.
.LI "\fB.=\fR" 
Prints the value of dot.
An equal sign by itself prints the value of \*`$\*'.
.LI "\fB!\fR"
The line
.DS I
!command-line
.DE
causes the command-line to be executed as a \*(x1 command.
.LI "/string/"
.br
Context search.
Search for next line which contains
this string of characters and print it.
Dot is set to the line where string was found.
Search starts at \*`\&.+1\*', wraps around from
\*`$\*' to 1, and continues to dot, if necessary.
.LI "?string?"
.br 
Context search in reverse direction.
Start search at \*`\&.\-1,\*' scan to 1, wrap around to \*`$\*'.
.LE  
.HU "The List command: l"
.br
.B Ed
provides two commands for printing the contents of lines.
One of these is \fBp\fR, in combinations like
.DS I
1,$p
.DE
which prints all the lines in the file,
or
.DS I
s/abc/def/p
.DE
to change \*`abc\*' to \*`def\*' on the current line.
Less familiar is the list command \fBl\fR (the letter l) 
which makes visible characters that are normally invisible,
such as tabs and backspaces.
The \fBl\fR prints any existing tabs in a line as \*`>\*' and each backspace 
as \*`<\*'.
This makes it much easier to correct typing mistakes
when extra spaces are adjacent to tabs, or when backspaces are followed by a 
space.
.P
The 
.B l
command also folds long lines, that is, it prints 
any line that exceeds 72 characters on multiple lines;
each printed line except the last is terminated by a backslash \*`\e\\*',
to indicate that it was folded.
This overcomes the limitation of your terminal screen width.
.P
Occasionally, the \fBl\fR
command will print in a line a string of numbers preceded by a backslash,
making visible characters that normally do not print,
such as form feed, vertical tab, or bell. 
These combinations are a single character
with special meanings on some terminals.
.HU "The Substitute Command: \fBs\fR"
.br
The substitute command  
.B s 
changes the contents of individual lines,
and is probably the most complicated and powerful 
.B ed 
command.
The simplest use of \fBs\fR is with the trailing
.B g . 
.P
In the following examples,
.DS I
s/this/that/
.DE
and
.DS I
s/this/that/g
.DE
the first replaces the first \*`this\*' on the line with \*`that\*'.
If there is more than one \*`this\*' on the line,
the second form (with the trailing 
.B g ) 
changes all occurrences of \*`this\*'. 
Either form of the 
.B s 
command can be followed by
.B p 
or 
.B l
to \*`print\*' or \*`list\*' the contents of the line:
.DS I
s/this/that/p
s/this/that/l
s/this/that/gp
s/this/that/gl
.DE
are all slight variations.
.P
Any 
.B s
command can be preceded by one or two line numbers
to specify that the substitution is to take place
on a group of lines. Thus
.DS I
1,$s/mispell/misspell/
.DE
changes the first occurrence of
\*`mispell\*' to \*`misspell\*' in each line of the file.
But
.DS I
1,$s/mispell/misspell/g
.DE
changes every occurrence in each line.
.P
If a 
.B p 
or 
.B l
is added to the end of any of these substitute commands,
only the last line changed will be printed, not all the lines.
.HU "The Undo Command: u"
.br
If a substitution in a line is incorrect, the \*`undo\*' command 
.B u
will \*`undo\*' the last substitution.
The last line that was substituted can be restored to
its previous state by typing the command
.B u .
.H 3 "Special Characters"
There are several special characters which facilitate
searching and substitution in 
.B ed,
but their usage may be confusing in some contexts.
Read the accompanying examples carefully.
.HU "The Metacharacter Dot (.)"
.br
Certain characters have special meanings
when they occur in the left side of a substitute command,
or in a search for a particular line.
These special characters are called \*`metacharacters\*'.
One of these is the period (.).
On the left side of a substitute command,
or in a search with /.../, 
\*`.\*'
stands for any single character. Thus the search
.DS I
/x.y/
.DE
finds any line where \*`x\*' and \*`y\*' occur separated by
a single character, as in
.DS I
x+y
x-y
x y
xzy
.DE
.P
Since \*`.\*' matches any single character,
it can be used to delete or substitute special characters printed by
.B l .
If a line printed with the 
.B l
command, appears as
.DS I
th\07is
.DE
which represents the bell character,
.DS I
s/\07//
.DE
will not delete it. 
Retyping the entire line is inefficient.
The metacharacter \*`.\*' used in the following way
.DS I
s/th.is/this/
.DE
will do the job.
The 
.B .
matches whatever character is between the \*`h\*' 
and the \*`i\*', even if it is invisible.
.P
Since 
.B .
matches any character, the command
.DS I
s/./,/
.DE
converts the first character on a line to a comma \*`,\*';
it does not search for a period and change it to a comma.
.P
Note that like other special characters, the \*`.\*'
may have several meanings, depending on its context.
This line demonstrates three different meanings:
.DS I
\&.s/././
.DE
The first period is the current line number, which is called \*`dot\*'.
The second \*`.\*' is a metacharacter that matches any single 
character on that line.
The third \*`.\*' is the literal period.
On the right side of a substitution, \*`.\*' is not special.
.HU "The Backslash: \e\"
.br
Sometimes a period is really the character to be matched.
To convert the line
.DS I
Now is the time.
.DE
into
.DS I
Now is the time?
.DE
use the backslash (\e\).
The backslash negates any special meaning that the next character
might have. 
In this case, \*`\e\.\*' converts the \*`.\*' from a \*`match anything\*'
into a literal period, so the period in
.DS I
Now is the time\*.
.DE
can br replaced using the command:
.DS I
s/\./?/
.DE
The pair of characters \*`\e\.\*' is treated as a single literal period.
.P
The backslash can also be used when searching for lines
that contain a special character.
The following example looks for a line that contains
.DS I
\&.DE
.DE
at the start of a line.
The search
.DS I
/.DE/
.DE
will also find lines like
.DS I
JADE 
FADE 
MADE 
.DE
because the \*`.\*' matches each of the letters \*`A\*'.
But the search 
.DS I
/\.DE/
.DE
will also find lines that contain \*`\e.DE\*'.
.P
The backslash is also used to turn off special meanings for
characters other than \*`.\*'.
For example, consider finding a line that contains a backslash.
The search
.DS I
/\e\/
.DE
will not work, because the \*`\e\*' isn't a literal backslash, 
but instead means that the second \*`/\*' no longer delimits the search.
By preceding the backslash with another backslash,
a literal backslash can be searched.
Thus 
.DS I
/\e\\e\/
.DE
does work.
Search for a forward slash \*`/\*' with
.DS I
/\e\//
.DE
The backslash turns off the special meaning of the immediately 
following \*`/\*' so that
it doesn't terminate the /.../ construction prematurely.
.P
For example, some substitute commands which will convert the line
.DS I
\e\x\e\.\e\y
.DE
into the line
.DS I
\e\x\e\y
.DE
are:
.DS I
s/\e\\e\\e\.//
s/x../x/
s/..y/y/
.DE
.P
Any character can delimit the components of an 
.B s
command. 
Slashes are only essential in context searching.
For instance, in a line that contains several slashes already, like
.DS I
//exec //sys.fort.go // etc...
.DE
a colon might be a better choice of delimiter.
To delete all the slashes, type
.DS I
s:/::g
.DE
.P
If \*`#\*' and \*`@\*' are the character erase and line 
kill characters on your terminal,
it is necessary to type \*e# and \*e@. 
When adding text with the commands 
.B a ,
.B i ,
and
.B c ,
the backslash is not special; use only the backslashes actually required.
.HU "The Caret (^)"
.br
The caret (^) stands for the beginning of the line.
For example, searching for a line that begins with \*`the\*', the command
.DS I
/the/
.DE
will probably locate several lines that contain \*`the\*' in any position.
Using
.DS I
/^the/
.DE
instead the context is specified. 
.P
The other use of \*`^\*' is to insert something at the beginning of a line:
.DS I
s/^/ /
.DE
places a space at the beginning of the current line.
.P
Metacharacters can also be combined. To search for a line that contains 
only the characters
.DS I
\&.PP
.DE
the command
.DS I
/^\e\.PP$/
.DE
can be used.
.HU "The Asterisk (*)"
.br
It is possible to replace all the spaces between \*`x\*' and \*`y\*'
with a single space in a line that looks like this:
.DS I
text x                y text 
.DE
where 
.I text 
stands for lots of text,
and there is an indeterminate number of spaces between the
\*`x\*' and the \*`y\*'. 
You need not retype the whole line.
.P
The metacharacter asterisk (*) following any character
stands for any number of consecutive occurrences of that character.
To refer to all the spaces at once, use
.DS I
s/x *y/x y/
.DE
The construction \*`~*\*' means \*`as many spaces as possible\*'.
Thus \*`x~*y\*' means \*`an x, as many spaces as possible, then a y\*'.
The asterisk can be used with any other character.
If the original example was 
.DS I
text  x--------y  text 
.DE
instead, then all \*`\e\-\*' signs could be replaced by a single space
with the command
.DS I
s/x-*y/x y/
.DE
.P
To change
.DS I
Now is the time for all good men ....
.DE
into
.DS I
Now is the time.
.DE
try the following to delete everything after \*`for\*':
.DS I
s/for.*/./
.DE
.P
The asterisk should be used very carefully. 
Note especially that \*`as many as possible\*' occurrences includes 
zero occurrences.
If a line contains
.DS I
xy text x  y text
.DE
the editing command
.DS I
s/x *y/x y/
.DE
means that the first
\*`xy\*' matches this pattern, for it consists of an \*`x\*', zero spaces, 
and a \*`y\*'.
The result is that the substitute acts on the first \*`xy\*',
and does not touch the later one that actually contains some intervening spaces.
To avoid this, specify one or more spaces, using a pattern like
.DS I
/x  *y/
.DE
which means \*`an x, a space, then as many more spaces as possible, 
then a y\*'. 
.P
Beware of matching \*`*\*' with zero occurrences.
The command
.DS I
s/x*/y/g
.DE
when applied to the line
.DS I
abcdef
.DE
produces
.DS I
yaybycydyeyfy
.DE
which is almost certainly not what was intended.
Because zero is a legal number
of matches, and there is no \*`x\*' at the beginning of the line,
a \*`y\*' is substituted.
Again, y is substituted between the \*`a\*' and the \*`b\*' and so on.
To avoid zero matches, write
.DS I
s/xx*/y/g
.DE
\*`xx*\*' means one or more \*`x\*'.
.HU "Brackets: [ ]"
.br
When deleting any numbers that appear at the beginning of all lines of a file,
it is possible to use a series of commands like
.DS I
1,$s/^1*//
1,$s/^2*//
1,$s/^3*//
.DE
and so on, but this is a lengthy process. 
.P
To remove all the digits on one pass, use brackets ([ ]).
The construction
.DS I
[0123456789]
.DE
matches any single digit.
The entire expression is called a \*`character class\*'.
The pattern \*`[0123456789]*\*' matches zero or more digits, so
.DS I
1,$s/^[0123456789]*//
.DE
deletes all digits from the beginning of all lines.
.P
Any characters can appear within a character class, except special characters.
Even the brackets have no special meaning.
To search for special characters, for example, try: 
.DS I
/[.\e\$^[]/
.DE
Within [...], the \*`[\*' is not special.  
To get a \*`]\*' into a character class, make it the first character.
The digits can be abbreviated as [0-9];
similarly, [a-z] stands for the lowercase letters, and [A-Z] for uppercase.
.P
Also, a class that means \*`none of the following characters\*' can 
be specified using a \*`^\*'.
For example,
.DS I
[^0-9]
.DE
stands for any character except
a digit.  
To find a first line that doesn't begin with a tab or space, use:
.DS I
/^[^(space)(tab)]/
.DE
.P
Within a character class, the caret has a special meaning 
only if it occurs at the beginning.
.HU "The Ampersand (&)"
.br
The ampersand (&) is used primarily to save typing.
To change
.DS I
Now is the time
.DE
to 
.DS I
Now is the best time
.DE
without repeating the word \*`the\*', the ampersand can be used.
On the right
side of a substitution, the ampersand means \*`whatever was just matched\*'. 
In  
.DS I
s/the/& best/
.DE
\*`&\*' stands for \*`the\*'.
This can save typing and potential errors in complicated text.
For example, to parenthesize a line, regardless of its length, type:
.DS I
s/.*/(&)/
.DE
.P
The ampersand can occur more than once on the right side:
.DS I
s/the/& best and & worst/
.DE
makes
.DS I
Now is the best and the worst time
.DE
and
.DS I
s/.*/&? &!!/
.DE
converts the original line into
.DS I
Now is the time? Now is the time!!
.DE
.P
To get a literal ampersand, the backslash is used to turn off 
the special meaning. For example,
.DS I
s/ampersand/\e\\e&/
.DE
converts the word into the symbol.
Notice that \*`&\*' is not special on the left side of a substitution, 
only on the right side.
.H 3 "Substituting Newlines"
.B Ed
provides a facility for splitting a single line 
into two or more shorter lines by inserting a newline.
As the simplest example, suppose a line has gotten unmanageably long
because of editing. If it looks like
.DS I
text    xy   text 
.DE
it can be broken between the \*`x\*' and the \*`y\*' as follows:
.DS I
s/xy/x\e\
y/
.DE
This is actually a single command, although it is typed on two lines.
Since the backslash turns off special meanings, the backslash at the end of 
a line makes the newline there no longer special.
.P
A single line can be made into several lines using this same mechanism.
For example, consider underlining the word \*`very\*' in a long line
by putting \*`very\*' onto a separate line, and preceding it by the
formatting command \*`.I\*':
.DS I
text [a very big] text
.DE
The command
.DS I
s/very/\e\
.I\e\
very\e\
/
.DE
converts the line into four shorter lines, preceding the 
word \*`very\*' by the line
\*`.I\*',
and eliminating the spaces around \*`very\*', all at the same time.
When a newline is substituted in a string, dot is left 
pointing at the last line created.
.H 3 "Joining Lines"
Lines may also be joined together, using the 
.B j
command instead of the  
.B s 
command.
Given the lines
.DS I
Now is
 the time
.DE
and supposing that dot is set to the first line, the 
.B j
command
joins them together. No blanks are added, because a blank 
was included at the beginning of the second line.
.P
All by itself, a 
.B j
command joins the lines signified by dot and dot~+~1.
However, any contiguous set of lines can be joined.
Just specify the starting and ending line numbers.
For example,
.DS I
1,$jp
.DE
joins all the lines into one long line and prints it.
.H 3 "Line Addressing in the Editor"
It is important to understand how line addressing works in order 
to specify which lines will be affected by editing commands.
Constructions like 
.DS I
1,$s/x/y/
.DE
specify a change on all lines.
Using a single newline or typing <RETURN> to print the next line, with
.DS I
/thing/
.DE
will find a line that contains \*`thing\*'.
You can also use
.DS I
?thing?
.DE
to scan backwards
for the previous occurrence of \*`thing\*', a useful feature if the item 
is above the current line.
The slash and question mark are the only characters 
which delimit a context search, although 
almost any character can be used in a substitute command.
.HU "Address Arithmetic"
Once you understand the principle of moving forwards and backwards
through the lines of your file,
the next step is to combine the line numbers and locations like \*`.\*', 
\*`$\*', \*`/.../\*' and \*`?...?\*'
with \*`+\*' and \*`-\*' to specify addresses. 
Thus
.DS I
$-1
.DE
is a command which prints the next to the last line of
the current file, one line before line \*`$\*'.
For example,
.DS I
$-5,$p
.DE
prints the last six lines of a file.
As another example,
.DS I
\&.-3,.+3p
.DE
prints from three lines before the current line to three lines after,
to provide context. The \*`+\*' can be omitted:
.DS I
\&.-3,.3p
.DE
is identical in meaning.
.P
Using \*`-\*' and \*`+\*' as line numbers by themselves saves typing effort.
You move back up one line in the file for each minus sign:
.DS I
---
.DE
moves up three lines, as does \*`-3\*'.
Since \*`\-\*' is shorter than \*`\*.\-1\*', constructions like
.DS I
-,.s/bad/good/
.DE
are useful. This changes \*`bad\*' to \*`good\*' on the previous line and
on the current line.
The characters \*`+\*' and \*`\-\*' can be used in combination with 
searches using \*`/.../\*' and \*`?...?\*',
and with \*`$\*'. The search
.DS I
/thing/--
.DE
finds the line containing \*`thing\*', and positions the
current line two lines before it.
.HU "Repeated Searches"
Suppose the search
.DS I
/horrible thing/
.DE
finds the wrong horrible thing, and it is necessary to repeat the search.
Instead of retyping the search, use
.DS I
//
.DE
as shorthand for \*`the previous thing that was searched for\*'
This can be repeated as many times as necessary.
The command
.DS I
??
.DE
searches for the same thing, but in the reverse direction.
.P
\*`//\*' can be used as the left side of a substitute command, to mean
\*`the most recent pattern\*':
.DS I
/horrible thing/
 ... ed prints line with \*`horrible thing\*' ...
s//good/p
.DE
To go backwards and change a line, use
.DS I
??s//good/
.DE
Of course, the \*`&\*' on the right side of a substitution can
still be used to stand for whatever got matched. The command:
.DS I
//s//& &/p
.DE
finds the next occurrence of whatever was searched last,
replaces it by two copies of itself,
then prints the line to verify that the substitution worked.
.HU "Default Line Numbers and the Value of Dot"
To speed up editing, know what lines will be affected
by a command if no lines are specified,
and what the current line will be when a command finishes.
A search command like
.DS I
/thing/
.DE
makes the current line the next line that contains \*`thing\*'.
Then no address is required with commands like 
.B s
to make a substitution on that line, 
.B p
to print it, 
.B l
to list it, 
.B d
to delete it, 
.B a
to append text after it, 
.B c
to change it, or 
.B i
to insert text before it.
If the search was unsuccessful the position remains unchanged.
This is also true if the current position was the only occurrence of 
\*`thing\*'.
The same rules hold for searches that use \*`?...?\*'.
The delete command
.B d 
leaves dot pointing at the line that followed the last deleted line.
When line \*`$\*' gets deleted, however, dot points at the new line \*`$\*'.
.P
The line-changing commands 
.B a ,
.B c ,
and
.B i
by default all affect the current line. 
If no line number is specified, 
.B a
appends text after the current line,
.B c
changes the current line, and 
.B i
inserts text before the current line.
The editing commands 
.B a ,
.B c ,
and
.B i
point at the last line entered when appending, changing or inserting is over.
For example, 
.DS I
a
text 
botch   (minor error)
\&.
s/botch/correct/  (fix botched line)
a
more text 
\&.
.DE
works without specifying any line number for the substitute 
command or the second append command, as does the following: 
.DS I
a
text 
horrible botch  (major error)
\&.
c	(replace entire line)
fixed up line 
.DE
.P
The 
.B r
command will read a file into the text being edited,
at the end if no address is given, or after the specified line.
In either case, dot points at the last line read in. Remember that 
.DS I
0r
.DE
will read a file in at the beginning of the text.
\*`0a\*' or \*`1i\*' can be used to start adding text at the beginning
of the file.
.P
The 
.B w
command writes out the entire file. One line number preceding a 
.B w
command writes that line.
A command preceded by two line numbers, writes that range of lines.
The 
.B w
command does not change dot. 
The current line remains the same, regardless of what lines are written.
Since the 
.B w
command is so easy to use,
it should be used periodically while editing
in case of system crashes or disastrous errors. 
.P
When using the
.B s 
command, the current position is the last line changed;
if there are no changes, then the position is unchanged.
To illustrate, suppose that there are three lines in the buffer, 
and the line given by dot is the middle one:
.DS I
x1
x2
x3
.DE
Then the command
.DS I
-,+s/x/y/p
.DE
prints the third line, which is the last one changed.
If the three lines had been
.DS I
x1
y2
y3
.DE
and the same command had been issued while dot pointed
at the second line, then the result
would be to change and print only the first line,
and that is where dot would be set.
.HU "Semicolon (;)"
Searches with \*`/.../\*' and \*`?...?\*' start at the current line and move
forward or backward, respectively, 
until they either find the pattern or get back to the current line.
This may not be the desired result, as in the following example:
.DS I
 .
 .
 .
 ab
 .
 .
 .
 bc
 . 
 .
.DE
Starting at line 1, 
.DS I
/a/,/b/p
.DE
does not print all the lines from \*`ab\*' to \*`bc\*' inclusive.
Both searches (for \*`a\*' and for \*`b\*')
start from the same point, and both find the line that contains \*`ab\*'.
The result is a single line.
.P
Worse, if there had been a line with a \*`b\*' in it
before the \*`ab\*' line, the print command
would be in error, since the second line number
would be less than the first, and it is illegal to
try to print lines in reverse order.
The comma separator
for line numbers doesn't set dot as each address is processed;
each search starts from the same place.
.P
In 
.B ed ,
the semicolon (;) is like the comma, except that semicolon resets dot 
at each current address as it is being evaluated.
In effect, the semicolon moves the location of dot.  
Thus in the example above, the command
.DS I
/a/;/b/p
.DE
prints the range of lines from \*`ab\*' to \*`bc\*',
because after the \*`a\*' is found, dot is set to that line,
and then \*`b\*' is searched for, starting beyond that line.
This ability is useful when searching the text for the second occurrence of 
\*`thing.\*' 
Instead of
.DS I
/thing/
//
.DE
which prints the first occurrence as well as the second, use:
.DS I
/thing/;//
.DE
This command finds the first occurrence of \*`thing,\*' sets
dot to that line, then finds the second occurrence and prints only that.
.P
Closely related to this example is the search for the second previous
occurrence of \*`something\*', as in
.DS I
?something?;??
.DE
To find the first occurrence of
\*`something\*' in a file, starting at an arbitrary place within the file,
it is not sufficient to use 
.DS I
1;/thing/
.DE
because this begins the search on line two, missing \*`thing\*' if it occurs 
on line 1.
But it is possible to use
.DS I
0;/thing/
.DE
for this starts the search at line 1.
.HU "Interrupting the Editor"
Note that interrupting the editor can cause uncertain results.
If the interrupt, delete, rubout, or break keys are used while
a command is being executed, the file is restored as much as possible 
to its state before the command began.
Naturally, some changes are irrevocable.
An interrupted read or write to a file, as well as substitutions or deletions 
will be stopped unpredictably. Dot may or may not be changed.
An interrupt while printing will not change the value of 
dot until the printing is done.
.H 3 "Global Commands"
The global commands 
.B g
and
.B v
are used to perform one or more editing commands on all lines that 
may or may not contain a specified pattern.
For example, the command
.DS I
g/XENIX/p
.DE
prints all lines that contain the word \*`XENIX\*'.
The pattern that goes between the slashes can be anything
that could be used in a line search or in a substitute command;
exactly the same rules and limitations apply.
As another example
.DS I
g/^\e\./p
.DE
prints all the formatting commands in a file (lines that begin with \*`.\*').
.P
The 
.B v
command is identical to the 
.B g 
command except that it operates on those lines that do not contain an 
occurrence of the pattern.
For example
.DS I
v/^\e\./p
.DE
prints all the lines that don't begin with \*`.\*', a command which would
be useful if you wanted to remove all the formatting macros from the
lines of actual text.
.P
Any command may follow a
.B g
or
.B v
command. 
For example, the following command deletes all lines that begin with \*`.\*':
.DS I
g/^\e\./d
.DE
This command deletes all empty lines:
.DS I
g/^$/d
.DE
Probably the most useful command that can follow a global command is the
substitute command; it can make a change
and print each affected line for verification.
For example, the word \*`Xenix\*' could be changed to \*`XENIX\*'
globally, and simultaneously verified with
.DS I
g/Xenix/s//XENIX/gp
.DE
Notice that \*`//\*' in the substitute command means
\*`the previous pattern,\*' in this case, \*`Xenix\*'.
The 
.B p
command is done on each line that matches the pattern,
not just those on which a substitution took place.
.P
The global command makes two passes over the file.
On the first pass, all lines that match the pattern are marked.
On the second pass, each marked line is examined in turn,
dot is set to that line, and the command executed.
This means it is possible for the command that follows a
.B g
or
.B v
command to use addresses, set dot, or perform other functions quite freely.
The command
.DS I
g/^\e\.P/+
.DE
prints the line that follows each \*`.P\*' command.
Remember that \*`+\*' means \*`one line past dot\*' and
.DS I
g/topic/?^\e\.H?1
.DE
searches for each line that contains \*`topic,\*' scans backwards until it finds
a line that begins with \*`.H\*' (a heading) and prints the line that follows 
the formatting command,
thus showing the headings under which \*`topic\*' is mentioned.
Finally,
.DS I
g/^\.EQ/+,/^\.EN/-p
.DE
prints all the lines that lie between
lines beginning with \*`.EQ\*' and \*`.EN\*' formatting commands.
The 
.B g
and
.B v 
commands can also be preceded by line numbers, in which case the only lines 
searched are those in the range specified.
.HU "Multiline Global Commands"
It is possible to perform more than one command under the control of a
global command, although the syntax may be awkward. 
For example,
suppose you want to change \*`x\*' to \*`y\*' and \*`a\*' to \*`b\*' on all 
lines that contain \*`thing\*'. The command
.DS I
.nf
g/thing/s/x/y/\e\
s/a/b/
.DE
is sufficient.
The \*`\e\\*' signals the
.B g 
command that the set of commands continues on the next line;
it terminates on the first line that does not end with \*`\e\\*'.
A substitute command cannot be used to insert a newline within a 
.B g
command.
.P
The command
.DS I
g/x/s//y/\e\
s/a/b/
.DE
does not work as expected.
The remembered pattern is the last pattern actually executed,
so sometimes it will be \*`x\*' as expected, and sometimes it will be \*`a\*'.
The pattern must be spelled out, like this:
.DS I
g/x/s/x/y/\e\
s/a/b/
.DE
.P
It is also possible to execute 
.B a ,
.B c ,
and
.B i
commands under a global command; as with other multiline constructions,
add a \*`\e\\*' at the end of each line except the last.
Thus, to add \*`.nf\*' and \*`.sp\*' macros before each \*`.EQ\*' line, type:
.DS I
 g/^\e\.EQ/i\e\
 .nf\e\
 .sp
.DE
There is no need for a final line containing \*`.\*' to terminate the 
.B i
command, unless there are further commands being done under the global command.
.H 3 "Cut and Paste with the Editor"
Sometimes the best approach to doing cut and paste work with files is
to use the familiar \*(x1 commands for copying, changing filenames,
removing files, and putting two or more files together. 
Often, however, it is necessary to manipulate parts of files,
individual lines, or groups of lines.
.B Ed
offers several techniques for doing this work conveniently.
.HU "Filenames"
.br
The commands 
.B r
and
.B w
are the two essential commands for \*`read\*' and \*`write\*'.
There is also the \*`edit\*' command 
.B e .
Within
.B ed ,
the command
.DS I
e  newfile
.DE
allows the user to change current working files. 
This works the same way as using the 
.B q
command, then reentering
.B ed
with a new filename.
The only difference is 
that if a pattern is remembered, then a command like
.B //
will still work.
.P
The command
.DS I
ed  file
.DE
remembers the name of the file, and any subsequent
.B e ,
.B r ,
or
.B w
commands that don't contain a filename will refer to this remembered file.
Thus,
.DS I
ed  file1
     (editing)
w    (writes back in file1)
e   file2     (edit new file, without leaving editor)
     (editing on file2)
w    (overwrites file2)
.DE
makes a series of changes to various files without ever leaving
.B ed
and without requiring you to type the name of any file more than once.
This is extremely useful when making changes in several files at once.
.P
The 
.B f
command without a filename will give the name of the remembered file.
The name of the remembered filename can also be changed with 
the
.B f 
command.
A useful sequence is
.DS I
ed  precious
f  junk
(editing)
.DE
which gets a copy of the file 
.I precious , 
then uses the 
.B f 
command to guarantee that a careless 
.B w
command won't overwrite the original.
.HU "Inserting One File into Another"
.br
To insert the file called 
.I table 
in a file called 
.I memo
just after the reference to Table 1, edit 
.I memo , 
find \*`Table 1,\*' and add the file 
.I table 
after the reference to the table
.DS I
ed  memo
/Table 1/
Table 1 shows that ... [response from ed]
.r  table
.DE
The critical line is the last one.
The command asks for the file to be read in right after line dot.
An
.B r 
command without any address adds lines at the end, so it is the same as
.B $r .
.HU "Writing Out Part of a File"
.br
It is possible to write out part of the file being edited.
For example, if you wanted to create a separate file
for the table from the previous example,
in order to format and test it separately, use:
.DS I
\&.TS
 [lots of stuff]
\&.TE
.DE
which is the way a table is set up for the
.B tbl
program.
To isolate the table in a separate file called \*`table\*',
first find the start of the table (the \*`.TS\*' line), then write out 
that part:
.DS I
 /^\e\.TS/
 .TS  [ed prints the line it found]
 .,/^\e\.TE/w table
.DE
or do it all at once with
.DS I
/^\e\.TS/;/^\e\.TE/w table
.DE
.P
The 
.B w
command can write out a group of lines, instead of the whole file,
or even a single line.
.HU "Moving Lines Around"
.br
Sometimes it is useful to move a paragraph from its present position in the
document. 
One method is to write the paragraph onto a temporary file,
delete it from its current position, then read in the temporary file at the end.
Assuming that the current line is the \*`.P\*' macro that begins
the paragraph, this is the sequence of commands:
.DS I
\&.,/^\.P/-w temp
\&.,//-d
$r temp
.DE
That is, from the current line \*`.\*' until one line before the next \*`.P\*'
write onto
.I temp . 
Then, delete the same lines.
Finally, read the file 
.I temp
in at the end.
.P
An easier way to do this is to use the move command, 
.B m
that 
.B ed
provides to perform the whole set of operations at once,
without using any temporary files.
The 
.B m
command is like many other
.B ed
commands in that it takes up to two line numbers in front
of it that tell what lines are to be affected.
It is also followed by a line number that tells where the lines are to go.
Thus,
.DS I
line1, line2 m line3
.DE
places all the lines between line1 and line2 after line3.
These lines may be expressed as patterns between slashes, dollar signs,
or any other specification.
If the current line is the first line of the paragraph, then 
.DS I
\&.,/^\e\.P/-m$
.DE
will append the paragraph to the end of the file.
.P
Another frequently used line moving operation
is reversing the order of two adjacent lines
by moving the first one to a position after the second.
Positioned at the first of the two lines, use
.DS I
m+
.DE
It moves the current line, the location of dot, to the next line.
If you are positioned on the second line, typing
.DS I
m--
.DE
does the interchange.
The
.B m
command is more efficient than
writing, deleting and rereading.
.HU "Marks"
.br
.B Ed
provides a facility for marking a line with a particular name, 
so that it can be referenced by name, rather than by actual line number.
This is handy for keeping track of lines as they move.
The mark command is 
.B k .
The command
.DS I
kx
.DE
marks the current line with the name \*`x\*'.
If a line number precedes the 
.B k ,
that line is marked.
The mark name must be a single lowercase letter.
The marked line has the address:
.DS I
\&'x
.DE
.P
Marks are most useful for moving things around.
For example,
find the first line of the block to be moved, and mark it with:
.DS I
\&'ka.
.DE
Then find the last line and mark it with:
.DS I
\&'kb.
.DE
Positioned at the place where the lines are to be inserted, use:
.DS I
\&'a,'bm.
.DE
.P
Only one line can have a particular mark name associated with it at any 
given time.
.HU "Copying Lines"
.br
The command 
.B t
for \*`transfer\*',
makes a copy of a group of one or more lines at any point.
This is often easier than writing and reading.
The 
.B t
command is identical to the
.B m 
command, except instead of moving lines
it simply duplicates them at the place named.
Thus
.DS I
1,$t$
.DE
duplicates the entire contents being edited.
A more common use for
.B t 
is to create a series of lines that differ only slightly.
For example: 
.DS I
a
..........  x  ......... (long line)
.
t.	(make a copy)
s/x/y/	(change it a bit)
t.	(make third copy)
s/y/z/	(change it a bit)
.DE
.HU "The Temporary Escape (!)"
.br
Sometimes it is convenient to temporarily escape from the editor to do
some other \*(x1 command without leaving the editor.
The \*`escape\*' command 
.B !
provides a way to do this:
.DS I
!command
.DE
suspends the current editing state, and executes the \*(x1 command.
When the command finishes,
.B ed
prints another 
.B ! 
At that point, editing can be resumed.
Any \*(x1 command can be executed in this way, including the invocation of
another 
.B ed. 
.TC
