.\     chapter 5
.nr H1 4
.H 1 "Using the ms Macro Package with Nroff and Troff"
This chapter provides a simple introduction to 
.B ms,
a macro package which you can use on \*(x1 with
the \*(x1 formatting programs,
.B nroff
or
.B troff
to produce formatted text for the lineprinter or typesetter, respectively.
You can use
.B ms
commands to define the format of your text
without having to learn the more complicated commands of the 
.B nroff
or
.B troff
formatting programs.
The
.B ms
program reads the commands you have inserted in your text and \*`translates\*'
them into 
.B nroff/troff 
commands at the time your text file is processed.
Just like
.B nroff 
or
.B troff, 
.B ms
allows you to specify the style of paragraphs, section headers (with optional
automatic numbering), page titles, footnotes, and cover pages.
You can also control font changes and multicolumn output,
and, if you are using
.B ms
in conjunction with 
.B troff 
to output your text to a phototypesetter,
you can specify variable spacing and the size of your type.
.P
Although using 
.B nroff/troff
directly offers you a much wider range of commands and options, 
it is definitely recommended that you learn and use 
.B ms
for most of your formatting needs.
.H 2 "Getting Started"
To use
.B ms,
type in your text normally, except that instead of indenting for paragraphs,
place a line reading \fB.PP\fR before each paragraph, to 
produce indenting and extra space.
Alternatively, the command \fB.LP\fR can be used to produce 
a left-aligned (block) paragraph.
.P
If you wish to begin a document, such as a formal paper with a cover sheet,
the input should start as follows:
.DS I
[optional overall format (e.g., \fB.RP\fR)]
\&.TL
Title of document (one or more lines)
\&.AU
Author(s) (may also be several lines)
\&.AI
Author's institution(s)
\&.AB
Abstract; to be placed on the cover sheet of a paper.
The default line length is 5/6 of normal.
\&.AE  (abstract end)
\&.LP
The text begins here...
.DE
To omit some of the standard headings (e.g., no abstract, or no author's 
institution) just omit the corresponding text and macros.
The word \*`abstract\*' can be suppressed by writing 
.B
\&.AB no
.R
instead of \fB.AB\fR.
Several interspersed \fB.AU\fR and \fB.AI\fR lines can be used for multiple 
authors.
Headings are not necessary, but you must begin a document with an   
.B ms 
macro, rather than an ordinary line of text.
You can start with an \fB.LP\fR command, for example, and begin your 
document with an ordinary paragraph.
When in doubt, use \fB.LP\fR to get proper initialization, although any of
the commands \fB.PP\fR, \fB.LP\fR, \fB.TL\fR, \fB.SH\fR, or \fB.NH\fR will work.
.H 2 "Cover Sheets and First Pages"
The first line of a document should be a macro indicating the general format 
of the first page.
For example, if it is \fB.RP\fR, released paper style, a cover sheet with 
title and abstract is prepared.
The default format is useful for scanning drafts.
In general 
.B ms 
is arranged so that only one form of a document need be stored, containing all
information.  
The first command gives the format, and unnecessary items for that format 
are ignored.
Never put extraneous material between the \fB.TL\fR and \fB.AE\fR commands.  
Processing of the titling items is special, 
and other data placed in them may not behave as you expect.
.H 2 "Page Headings"
By default, the 
.B ms 
macros print a page heading containing a page number, if greater than 1.
A default page footer is provided only in
.B nroff ,
where the date is used as the page footer.
You can make minor adjustments to the page headings and footers
by redefining the strings \*`LH\*', \*`CH\*', and \*`RH\*'
which are the left, center and right portions of the page headings,
respectively; and the strings \*`LF\*', \*`CF\*', and \*`RF\*',
which represent the left, center and right portions of the page footer.
For more complex formats, you can redefine \*`PT\*' and \*`BT\*',
which are invoked respectively at the top and bottom of each page.
The margins taken from registers \*`HM\*' and \*`FM\*' for the top and bottom
margin are normally 1 inch; the page headers or footers are
in the middle of that space.
If you choose to redefine these macros, you should 
remember to reset them back to their default values.
.H 2 "Multicolumn Formats"
If you place the command \fB.2C\fR in your document, the document will
be printed in double column format beginning at that point.  
This feature is generally not accommodated by ordinary lineprinter
facilities, but is often desirable on the typesetter.
The command \fB.1C\fR will default the text
back to one-column format and also skip to a new page.
The \fB.2C\fR command is actually a special case of the command
.DS I 
\&.MC [column width] [gutter width]
.DE
which makes multiple columns with the specified column
and gutter width; as many columns as will fit across the page
are used.
Thus triple, quadruple, or more column pages can be printed.
Whenever the number of columns is changed, except going from
full width to some larger number of columns, a new page is started.
.H 2 "Headings"
There are two commands for producing a special heading.
If you type
.DS I 
\&.NH
type section heading here which
may be several lines
.DE
you will get automatically numbered section headings (1, 2, 3, ...),
in \fBboldface\fR.
For example,
.DS I 
\&.NH
Using XENIX 
.DE
produces:
.DS I
\fB\Using XENIX\fR
.DE
Alternatively,
.DS I
\&.SH
XENIX Text Processing	
.DE
will print the heading with no number added:
.DS I
\fB XENIX Text Processing\fR
.DE
.P
Every section heading should be followed
by a paragraph beginning with \fB.PP\fR or \fB.LP\fR, indicating the end of 
the heading.
Headings may contain more than one line of text.
The \fB.NH\fR command also allows more complex numbering schemes.
If a numerical argument is given, it is taken to be a
\*`level\*' number and an appropriate sub-section number is generated.
Larger level numbers indicate deeper sub-sections, as in this example:
.DS I 
\&.NH
Incan Archaeological Sites
\&.NH 2
Peru 
\&.NH 3
Macchu Picchu
\&.NH 3
Pisac
\&.NH 2
Ecuador
.DE
produces:
.DS I
\fB2. Incan Archaeological Sites\fR
.sp
\fB2.1. Peru\fR
.sp
\fB2.1.1. Macchu Picchu\fR
.sp
\fB2.1.2. Pisac\fR
.sp
\fB2.2. Ecuador\fR
.DE
.P
If you explicitly designate \fB.NH 0\fR the numbering of level 1
will be reset to one, as in the following:
.DS I 
\&.NH 0
Urubamba River Valley
.DE
to:
.DS I
\fB1. Urubamba River Valley\fR
.DE
.H 2 "Indented Paragraphs"
The sequence
.DS I 
\&.IP [1]
Text for first paragraph, typed normally for as long 
as you would like on as many lines as needed.
\&.IP [2]
Text for second paragraph, ...
.DE
produces:
.AL 1
.LI 
Text for first paragraph, typed normally for as long
as you would like on as many lines as needed.
.LI 
Text for second paragraph, ...
.LE 
.sp
A series of indented paragraphs may be followed by an ordinary paragraph
beginning with \fB.PP\fR or \fB.LP\fR, depending on whether or not you 
want indenting.
.P
There are some other uses of the \fB.IP\fR macro.
If the label is omitted, for example, a plain block indent is produced:
.DS I 
\&.IP
This material will
be turned into a
block indent suitable for quotations or
such matter.
\&.LP
.DE
will produce:
.DS I
This material
will be turned
into a block indent
suitable for
quotations or such matter.
.DE 
If a non-standard amount of indenting is required,
it may be specified after the label in character positions
and will remain in effect until the next \fB.PP\fR or \fB.LP\fR macro.
Thus, the general form of the \fB.IP\fR command
contains two additional fields: the label and the indenting length.  
.P
It is also possible to produce multiple nested indents;
the command \fB.RS\fR indicates that the next \fB.IP\fR starts from the
current indentation level.
Each \fB.RE\fR will use up one level of indenting,
so you should balance \fB.RS\fR and \fB.RE\fR commands.
Think of the \fB.RS\fR command as \*`move right\*' and
the \fB.RE\fR command as \*`move left\*'.	 
For example,
.DS I 
\&.IP 1.
Bolivian Tourist Attractions
\&.RS
\&.IP 1.1
La Paz
\&.IP 1.2
Cochabamba
\&.IP 1.3
Yungas Region
\&.RS
\&.IP 1.3.1
Chulimani
\&.RE
\&.IP 1.4
Potosi
\&.RE
\&.LP
.DE
will result in:
.DS I
.nf
1. Bolivian Tourist Attractions
.sp
   1.1 La Paz
.sp
   1.2 Cochabamba
.sp
   1.3 Yungas Region
.sp
       1.3.1 Chulimani
.sp
   1.4 Potosi
.DE
.P
All of these variations on \fB.LP\fR leave the right margin untouched.  
Sometimes, such as for setting off a quotation, 
a paragraph indented on both right and left is required.
Use \fB.QP\fR for single paragraphs.
More complicated material should be bracketed with \fB.QS\fR and \fB.QE\fR.
.H 2 "Font Changes and Underlining"
To produce italics on the typesetter use: 
.DS I 
\&\fIas much text as you want
can be typed here\&\fR
.DE
Italics are represented on the lineprinter by underlining,
as in \fIthese three words\fR.
The \fB.R\fR command restores the normal, usually Roman, font.
If only one word is to be italicized, it
may be just typed alone on the line after the \fB.I\fR command,
.DS I
\&.I word
.DE
and in this case no \fB.R\fR is needed to restore the previous font.
The default font is automatically restored on the next line.
Boldface can be produced by typing:
.DS I 
\&.B
Text to be set in boldface
goes here
\&.R
.DE
As with the \fB.I\fR macro, a single word can be placed in boldface
by placing it alone on the same line as the \fB.B\fR command.
.P
A few size changes can be specified with
the commands \fB.LG\fR (make larger), \fB.SM\fR (make smaller), and \fB.NL\fR
(return to normal size).
The size change is two points; the commands may be repeated for
increased effect.
If actual underlining, as opposed to italicizing, is required on the typesetter,
the command
.DS I
\&.UL word
.DE
will underline a word.  
There is no way to underline multiple words on the typesetter.
.H 2 "Footnotes"
Material placed between lines with the commands \fB.FS\fR
(footnote) and \fB.FE\fR (footnote end) will be collected, remembered, and 
placed at the bottom of the current page.
By default, footnotes are 11/12th the length of normal text,
This can be changed using the \*`FL\*' register. 
.H 2 "Displays and Tables"
To prepare displays of lines, such as tables, in which
the lines should not be re-arranged, enclose them in the commands 
\fB\&.DS\fR and \fB\&.DE\fR.
.DS I
\&.DS
table lines, like the
examples here, are placed
between \fB.DS\fR and \fB.DE\fR
\&.DE
.DE
By default, lines between \fB.DS\fR and \fB.DE\fR are indented and 
left-adjusted.
You can also center lines, or retain the left margin.
Lines between the \fB.DS C\fR and \fB.DE\fR commands are
centered, but not re-arranged. 
Lines between \fB.DS L\fR and \fB.DE\fR are left-adjusted, not indented, 
and not re-arranged.
A plain \fB.DS\fR is equivalent to \fB.DS I\fR, which indents and 
left-adjusts.  
Thus,
.DS C
these lines were preceded
by \&.DS C and followed by
a \&.DE command;
.DE
whereas
.DS L
these lines were preceded
by \&.DS L and followed by
a \&.DE command.
.DE
Note that the \fB\&.DS C\fR macro centers each line; there is a variant 
\fB\&.DS B\fR
that makes the display into a left-adjusted block of text, and
then centers that entire block.
Normally a display is kept together on one page.
If you wish to create a long display which may be split across page
boundaries, use the \fB.CD\fR, \fB.LD\fR, or \fB.ID\fR in place of
the commands \fB.DS C\fR, \fB.DS L\fR, or \fB.DS I\fR respectively.
An extra argument to the \fB.DS I\fR or \fB.DS\fR command is taken
as an amount to indent.
.H 2 "Blocks of Text"
If you wish to keep a table or other block of lines
together on a page, there are \*`keep-release\*' commands.
If you use the \fB.KS\fR and \fB.KE\fR macros 
a block of text which 
does not fit on the remainder of the current page will begin
on a new page.
Lines between \fB.DS\fR and \fB.DE\fR commands are automatically
kept together this way.
There is also a \*`keep floating\*' command: if the
block to be kept together is preceded by \fB.KF\fR instead of \fB.KS\fR
and does not fit on the current page, it will be moved down through the text
until the top of the next page.  
This prevents the introduction of a large blank space, but should only be 
used if the display does not need to be immediately surrounded
with explanatory text.
.H 2 "Using nroff/troff Commands"
If you are attempting to format text using 
.B ms 
without learning the other formatting programs, you should learn at least the 
following common 
.B nroff/troff
commands, which you will probably need to supplement 
.B ms.
These all work with both typesetter and line printer or terminal output:
.DS I
.nf
\&.bp - begin new page.
\&.br - \*`break\*', stop running text from line to line.
\&.sp n - insert n blank lines.
\&.na - don't adjust right margins.
.DE
.H 2 "Date"
By default, documents produced on lineprinters have the
date at the bottom of each page; documents produced on
the typesetter do not.
To force the inclusion of a date in a paper style which does not ordinarily
print it, use \fB.DA\fR.  
To force no date, use \fB.ND\fR.
To print a specific date other than the current one, use \fB.DA\fR followed 
by a date, such as 
\*`July 4, 1776\*'.
It will appear at the bottom of each page.
The command
.DS I 
\&.ND May 8, 1945
.DE
in \fB.RP\fR, or \*`released paper\*', format
places the specified date on the cover sheet and nowhere else.
Place this line before the title.
.H 2 "Signature Line"
A signature line can be created by placing the command \fB.SG\fR in the 
document.
The authors' names will be output in place of the \fB.SG\fR line.
An argument to \fB.SG\fR is used as a typing identification line, and
placed after the signatures.
The \fB.SG\fR command is ignored in released paper format.
.H 2 "Registers"
Certain of the number registers used by 
.B ms 
can be altered to change default settings.
They should be changed with \fB.nr\fR, number register, commands, as with
.DS I
\&.nr PS 9
.DE
to change the default point size to 9.
If the effect is needed immediately, the normal
.B troff
command should be used in addition to changing the number register.
The following table indicates the behavior of number registers:
.br
.TS
c0 c c c
c c c c
a l l l.
Register	Defines	Takes	Default
		effect
PS	point size	next para.	10
VS	line spacing	next para.	12 pts
LL	line length	next para.	6\(fm\(fm
LT	title length	next para.	6\(fm\(fm
PD	para. spacing	next para.	0.3 VS
PI	para. indent	next para.	5 ens
FL	footnote length	next FS	11/12 LL
CW	column width	next 2C	7/15 LL
GW	intercolumn gap	next 2C	1/15 LL
PO	page offset	next page	26/27\(fm\(fm
HM	top margin	next page	1\(fm\(fm
FM	bottom margin	next page	1\(fm\(fm
.TE
.P
The strings \*`LH\*', \*`CH\*', and \*`RH\*' which are the left, center, 
and right headings respectively,
may be altered, as well as \*`LF\*', \*`CF\*', and \*`RF\*' the page footer 
strings.
The page number on the output is taken from the register \*`PN\*'; this can 
be altered to change output style.
For more complicated headers and footers the macros 
.B PT
and 
.B BT
can be redefined. 
.H 2 "Simplified Tables and Equations"
If you have relatively complex tables or equations in
your text, you will need to use the
.B tbl
and
.B eqn
programs, discussed in detail in the last chapter of this volume.
.B Ms
does, however, provide simple definitions of \fB.EQ\fR and \fB.EN\fR,
equation macros.
By default, the equation is centered and slightly set off.
An argument to \fB.EQ\fR is taken to be an equation
number and placed in the right margin near the equation.
The three possible arguments to \fB.EQ\fR are 
the letter \*`C\*', for the default, or centered format,
the letter \*`I\*' for indented equations, and the letter \*`L\*' for 
left-adjusted equations. 
If there is both a format argument and an equation number,
give the format argument first, as in
.DS I
\&.EQ L (1.3a)
.DE
for a left-adjusted equation numbered (1.3a).
.P
Similarly,
.B ms
defines the macros \fB.TS\fR and \fB.TE\fR to separate tables from text with 
some space.
A very long table with a heading may be broken
across pages by beginning it with \fB.TS H\fR instead of \fB.TS\fR,
and placing the line \fB.TH\fR in the table data after the heading.  
If the table has no heading repeated from page to page,
use the ordinary \fB.TS\fR and \fB.TE\fR macros.
.H 2 "How to Use ms"
After your document is prepared and stored on a file,
you output it to a terminal or lineprinter with the command:
.DS I
$ nroff -ms filename
.DE
and you can print it on the typesetter with the command:
.DS I
$ troff -ms filename
.DE
If you have specified any two-column text with \fB.2C\fR, 
or used the \fB.TS\fR and \fB.TE\fR with multicolumn tabular material,
then you must remember to pipe the
.B nroff/troff
output through the preprocessor 
.B col.
If you have used
.B tbl
or
.B eqn
macros, you must also process the files through these programs first, using
.B tbl 
before 
.B eqn , 
as in the following:
.DS I
$ nroff -col tbl eqn ms filename
.DE
In each of these cases you can either list all the filenames to be processed,
or use the \*`*\*' for wildcard names such as \*`chap*.s\*'.
.H 2 "Summary of Commands"
Here is a summary of the most commonly used
.B ms
commands.
.VL 10
.LI "\fB.1C\fR"	
Return to single column format.	
.LI "\fB.2C\fR"	
Start double column format.	
.LI "\fB.AB\fR"	
Begin abstract.	
.LI "\fB.AE\fR"	
End abstract.	
.LI "\fB.AI\fR"	
Specify author's institution.	
.LI "\fB.AU\fR"	
Specify author.	                
.LI "\fB.B\fR"	
Begin boldface.	                
.LI "\fB.DA\fR"	
Provide the date on each page.	
.LI "\fB.DE\fR"	
End display.
.LI "\fB.DS\fR"	
Start display (also \fB.CD\fR, \fB.LD\fR, \fB.ID\fR).	
.LI "\fB.EN\fR"	
End equation.	
.LI "\fB.EQ\fR"	
Begin equation.	
.LI "\fB.FE\fR"	
End footnote.	
.LI "\fB.FS\fR"	
Begin footnote.	
.LI "\fB.I\fR"	
Begin italics.	
.LI "\fB.IP\fR"	
Begin indented paragraph.	
.LI "\fB.KE\fR"	
Release keep.	
.LI "\fB.KF\fR"	
Begin floating keep.	
.LI "\fB.KS\fR"	
Start keep.	
.LI "\fB.LG\fR"	
Increase type size.
.LI "\fB.LP\fR"	
Left aligned block paragraph.
.LI "\fB.ND\fR"	
Change or cancel date.
.LI "\fB.NH\fR"	
Specify numbered heading.
.LI "\fB.NL\fR"	
Return to normal type size.
.LI "\fB.PP\fR"
Begin paragraph.
.LI "\fB.R\fR"               	
Return to regular font (usually Roman).
.LI "\fB.RE\fR"	
End one level of relative indenting.
.LI "\fB.RP\fR"	
Use released paper format.
.LI "\fB.RS\fR"	
Relative indent increased one level.
.LI "\fB.SG\fR"	
Insert signature line.
.LI "\fB.SH\fR"	
Specify section heading.
.LI "\fB.SM\fR"	
Change to smaller type size.
.LI "\fB.TL\fR"	
Specify title.
.LI "\fB.UL\fR"	
Underline one word.
.LE
.TC
