/* SCCS_ID @(#)local.h    	5.3	 12:41:07 - 83/03/16 */

/* Wollongong Perkin ELMER */
#undef  DEC             /* DEC-specific code in vanilla kernel */
#undef  V6              /* V6 compatible system */
#define M3240           /* undefined for 3220 8/32 7/32  */
#define SVC6
#define MONITORING      /* I/O monitoring used by A.E.S. */
#define DISKMON 1       /* v7 disk monitoring */

#ifdef  KERNEL
#define SCCS_ID sccs_id
#endif  KERNEL

#define UCB_NKB         /* 1 Kbyte file system  28jan81 */
#define CGL_NFREE       /* maintain total free inode & blk counts  6feb81 */

#define UCB_TTHIWAT     /* tty hi & lo watermarks as function of speed */
#define CGL_CBLK        /* move chars in blocks for tty writes  12oct79 */

#define UCB_BHASH       /* hash buffer headers for faster search  28jan81 */
#define UCB_IHASH       /* hash inode list for faster search  28jan81 */
#define CGL_ISRCH       /* circular inode searches  18jan81 */
#define UCB_FSNAM       /* file system device names  5jun81 */

/*#define CGL_AGE          dmr-approved buffer aging (was not ifdeffed) */

/* UCSF Computer Graphics Lab */
/*      CGL_LOCAL       /* local to ucsfcgl  21jun79 */
/*      CGL_RTP         /* real-time process support  21jun79 */
/*      CGL_SUID        /* fix suid protection hole  21jun79 */
/*      CGL_ORPHAN      /* prevent "orphaned" files  21jun79 */
/*      CGL_ECS         /* don't cache ecs blocks  21jun79 */
/*      CGL_AUTOB       /* automatic reboots  21jun79 */
/*      CGL_MEMIO       /* speed up memory reads  21jun79 */
/*      CGL_CBLK        /* move chars in blocks for tty writes  12oct79 */
/*      CGL_NAMI        /* nami mods  2feb80 */
/*      CGL_LOPRI       /* don't swap sleep procs for lo pri ones  5mar80 */
/*      CGL_EEOF        /* prevent endless EOF's after ioctl calls  22sep79 */
/*      CGL_ISRCH       /* circular inode searches  18jan81 */
/*      CGL_NFREE       /* maintain total free inode & blk counts  6feb81 */
/*      CGL_ACCT        /* more process accounting data  25jun80 */
/*      CGL_XACCT       /* expanded accounting structure  25jan81 */
		/* (don't use this - makes acct struct not be power of 2!!!) */
/*      CGL_MTOP        /* ioctl call for manipulating mag tape  17mar81 */
/*      CGL_DEVTIMO     /* watch for lost device interrupts  19mar81 */
/*      CGL_FASTPDP     /* wnj's fast unix code for the pdp-11  8jun81 */

#ifdef	CGL_FASTPDP
#define ISSIG(p)        ((p)->p_sig && issig())
#else
#define ISSIG(p)        issig()
#endif

/* these came from ucsf but weren't ifdefed there */
/*      CGL_CLRBUF      /* faster clrbuf in bio.c */

/***************/

/* UC Berkeley */
/*      UCB_NODUPS      /* avoid dups in filesystem, costs 10%  28jan81 */
/*      UCB_BHASH       /* hash buffer headers for faster search  28jan81 */
/*      UCB_IHASH       /* hash inode list for faster search  28jan81 */
/*      UCB_NKB         /* 1 Kbyte file system  28jan81 */
/*      UCB_MOUNT       /* multiple super blks per large buffer  28jan81 */
/*      UCB_FRCSWAP     /* force swaps on expands & forks  28jan81 */
/*      UCB_METER       /* so vmstat works  8apr81 */
/*      UCB_FSNAM       /* file system device names  5jun81 */
/*      UCB_DEVERR      /* wnj's mnemonic device registers  8jun81 */
/*      UCB_SCHED       /* new swap algorithm (longest sleeper)  18aug81 */

#ifdef UCB_NKB
#define UCB_SMINO       /* small inodes, in conjuction with NKB  28jan81 */
#endif

/* ALWAYS define this: */
#define LOCALS_INCLUDED

#define TWG_BD          /* Let's try an in core file system GWW 23mar82 */
